/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppEnv;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.i18n.AI18n;
import com.sigrity.acl.ui.AActionGroup;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class OrbitGuiI18n {
    private static final String MENU_SEPATATOR = "|";
    public static final String ACTION_NO_TRANSLATE = "OrbitIOI18n.Disable";
    public static final String ACTION_TRANSLATED = "OrbitIOI18n.Transfer";

    public OrbitGuiI18n() {
        if (AApp.getApp().hasEnv(AAppEnv.UI_I18N)) {
            this.loadLangPacks();
            String locale = (String)Settings.getSettingOfClass((String)"GUI", (String)"AppLanguage", String.class);
            if (locale != null) {
                AI18n.setLocale((String[])new String[]{locale, "en"});
            }
        }
    }

    private static File getI18nDir() {
        return Settings.getConfFile((String)"i18n");
    }

    private void loadLangPacks() {
        if (!AApp.getApp().hasEnv(AAppEnv.UI_I18N)) {
            return;
        }
        File dir = OrbitGuiI18n.getI18nDir();
        if (!dir.exists()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(".json")) continue;
            this.loadLangPack(f);
        }
    }

    private void loadLangPack(File langPackFile) {
        if (!AApp.getApp().hasEnv(AAppEnv.UI_I18N)) {
            return;
        }
        String name = langPackFile.getName();
        String langName = name.substring(0, name.length() - 5);
        AI18n.registerLangPack((String)langName, (File)langPackFile);
    }

    public void save() {
        if (!AApp.getApp().hasEnv(AAppEnv.UI_I18N)) {
            return;
        }
        AI18n.saveAll();
    }

    public static Action getAction() {
        if (!AApp.getApp().hasEnv(AAppEnv.UI_I18N)) {
            return null;
        }
        AActionGroup menuAction = new AActionGroup("Language");
        List langs = AI18n.getLangPacks();
        menuAction.addAction(new ActionSetLanguage(null));
        for (AI18n.LangPack lang : langs) {
            menuAction.addAction(new ActionSetLanguage(lang));
        }
        return menuAction;
    }

    public static void translate(String context, JMenuBar menuBar) {
        if (!AApp.getApp().hasEnv(AAppEnv.UI_I18N)) {
            return;
        }
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (menu == null) continue;
            OrbitGuiI18n.translate(context, "", menu);
        }
    }

    public static void translate(String context, String prefixKey, JMenu menu) {
        if (!AApp.getApp().hasEnv(AAppEnv.UI_I18N)) {
            return;
        }
        if (OrbitGuiI18n.isTranslated(menu)) {
            return;
        }
        String menuTxt = menu.getText();
        if (!((String)prefixKey).isEmpty()) {
            prefixKey = (String)prefixKey + MENU_SEPATATOR;
        }
        prefixKey = (String)prefixKey + menuTxt;
        menu.setText(AI18n.t((String)context, (String)menuTxt));
        OrbitGuiI18n.markTranslated(menu);
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            Component c = menu.getMenuComponent(i);
            if (c instanceof JMenuItem) {
                JMenuItem mi = (JMenuItem)c;
                OrbitGuiI18n.translate(context, (String)prefixKey + MENU_SEPATATOR, mi);
                continue;
            }
            if (!(c instanceof JMenu)) continue;
            JMenu m = (JMenu)c;
            OrbitGuiI18n.translate(context, (String)prefixKey, m);
        }
    }

    public static void translate(String context, String prefixKey, JMenuItem mi) {
        if (!AApp.getApp().hasEnv(AAppEnv.UI_I18N)) {
            return;
        }
        if (OrbitGuiI18n.isTranslated(mi)) {
            return;
        }
        String v = mi.getText();
        mi.setText(AI18n.t((String)context, (String)(prefixKey + v), (String)v));
        OrbitGuiI18n.markTranslated(mi);
    }

    private static boolean isTranslated(AbstractButton btn) {
        return btn.getAction() != null && (btn.getAction().getValue(ACTION_NO_TRANSLATE) != null || btn.getAction().getValue(ACTION_TRANSLATED) != null);
    }

    private static void markTranslated(AbstractButton btn) {
        if (btn.getAction() != null) {
            btn.getAction().putValue(ACTION_TRANSLATED, true);
        }
    }

    private static class ActionSetLanguage
    extends AbstractAction {
        private final AI18n.LangPack pack;

        public ActionSetLanguage(AI18n.LangPack pack) {
            super(pack == null ? "English" : pack.getUserName());
            this.pack = pack;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.pack == null) {
                Settings.remove((String)"GUI", (String)"AppLanguage", null);
                ALog.logInfo((String)"Please restart application to apply 'English'");
            } else {
                Settings.set((String)"GUI", (String)"AppLanguage", (Object)this.pack.getName());
                ALog.logInfo((String)"Please restart application to apply '%s'", (Object[])new Object[]{this.pack.getUserName()});
            }
        }
    }
}

