/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.ToolbarDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.toolbar.CToolbarContentArea;
import bibliothek.gui.dock.toolbar.CToolbarItem;
import bibliothek.gui.dock.toolbar.expand.DefaultExpandableToolbarItemStrategy;
import bibliothek.gui.dock.toolbar.location.CToolbarAreaLocation;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.util.Filter;
import com.cadence.plaf.InnovusLookAndFeel;
import com.google.common.collect.Maps;
import com.sigrity.acl.ABoolean;
import com.sigrity.acl.AColor;
import com.sigrity.acl.AFile;
import com.sigrity.acl.AFileExplorer;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APlatformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppGuiWS;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.app.StatusChangeListener;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.ui.AActionGroup;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADynamicMenu;
import com.sigrity.acl.ui.ADynamicMenuItem;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.AImageIcon;
import com.sigrity.acl.ui.ALogPanel;
import com.sigrity.acl.ui.AQueryUser;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.ATabbedPane;
import com.sigrity.acl.ui.About;
import com.sigrity.acl.ui.AclResources;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.flowman.FlowStepRegistry;
import com.sigrity.flowman.FlowWS;
import com.sigrity.flowman.step.ActionBasedStep;
import com.sigrity.orbit.BusView;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitDbReader;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOEnv;
import com.sigrity.orbit.spd2000.Spd2000;
import com.sigrity.orbit.spd2000.SpdImportOptionsPanel;
import com.sigrity.orbit.ui.DesignCanvasInfoDisplay;
import com.sigrity.orbit.ui.DesignStartPanel;
import com.sigrity.orbit.ui.ImportDbUI;
import com.sigrity.orbit.ui.LefDefUI;
import com.sigrity.orbit.ui.NetLengthExportOptionsPanel;
import com.sigrity.orbit.ui.NetMappingExportOptionsPanel;
import com.sigrity.orbit.ui.OrbitGuiObjectActionRegistry;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_modes.InteractiveSelectionUI;
import com.sigrity.orbit.ui.core.CadenceMenuBar;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.DesignView3D;
import com.sigrity.orbit.ui.core.GuiCommandLine;
import com.sigrity.orbit.ui.core.OrbitContextMenuWS;
import com.sigrity.orbit.ui.core.OrbitGuiI18n;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.core.OrbitMainFrame;
import com.sigrity.orbit.ui.core.OrbitStatusBar;
import com.sigrity.orbit.ui.core.OrbitToolBarWS;
import com.sigrity.orbit.ui.core.OrbitViewToolBar;
import com.sigrity.orbit.ui.docking.CommandDockUI;
import com.sigrity.orbit.ui.docking.DbExplorerDockUI;
import com.sigrity.orbit.ui.docking.DbResourceDockUI;
import com.sigrity.orbit.ui.docking.DesignDockUI;
import com.sigrity.orbit.ui.docking.DockingUtil;
import com.sigrity.orbit.ui.docking.OrbitDockingToolBar;
import com.sigrity.orbit.ui.side_panels.CurDbDeviceHierarchyPanel;
import com.sigrity.orbit.ui.side_panels.CurDbExplorerPanel;
import com.sigrity.orbit.ui.side_panels.CurDbHistoryPanel;
import com.sigrity.orbit.ui.side_panels.CurDbNetExplorerPanel;
import com.sigrity.orbit.ui.side_panels.CurDbSelectionPanel;
import com.sigrity.orbit.ui.side_panels.CurModeOptionPanel;
import com.sigrity.orbit.ui.side_panels.EditAttributePanel;
import com.sigrity.orbit.ui.side_panels.FlowManPanel;
import com.sigrity.orbit.ui.side_panels.ResourceManPanel;
import com.sigrity.orbit.ui.side_panels.ViewOptionsPanel;
import com.sigrity.orbit.ui.side_panels.sel_option.InteractiveSelModePnl;
import com.sigrity.orbit.updio.UPDImportOptionsPanel;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class OrbitGuiWS
extends AAppGuiWS {
    public static final String DOCK_ID_CMD_MSG;
    public static final String ACTIONPROPKEY_NAME;
    public static final String ACTIONPROPKEY_PREPEND;
    private static final String ENABLE_EXTENDED_UI = "com.sigrity.orbit.extendedui";
    public static final String BUTTONTEXT = "ButtonText";
    public static final String BUTTONPOPUPMENU = "ButtonPopupMenu";
    public static final String ISSELECTED = "IsSelected";
    public static final String GROUP = "Group";
    public static final String FLOWSTEPGRP;
    public static final String ENVVAR_CONFIG = "config";
    public static final String XML_DOCKING_LAYOUT = "DockingLayout.xml";
    protected OrbitIO mApp;
    protected OrbitMainFrame mMainFrame;
    protected OrbitGuiI18n mI18n = new OrbitGuiI18n();
    protected CControl mToolBarDockControl;
    protected CControl mDockControl;
    protected LinkedHashMap<String, JToolBar> mToolBars = new LinkedHashMap();
    protected JMenuBar mMainMenuBar = new CadenceMenuBar();
    protected JPanel mCmdMsgPnl;
    protected GuiCommandLine mCmdLine;
    protected ALogPanel mMsgPnl = new ALogPanel(ALog.getDefaultLogger());
    protected ASplitPane mSideBarSplitter;
    protected OrbitViewMgr mViewMgr = new OrbitViewMgr();
    protected OrbitGuiObjectActionRegistry mGuiActionRegistry;
    protected OrbitToolBarWS mToolbarWS;
    protected OrbitViewToolBar mViewToolBar;
    protected OrbitDockingToolBar mDockToolBar;
    protected OrbitStatusBar mStatusBar;
    protected AAppView mStatusCurView;
    private List<VisibleWindowConfig> mWindowConfigs = new ArrayList<VisibleWindowConfig>();
    private CurDbExplorerPanel mCurDbExplorer = null;
    private CurDbDeviceHierarchyPanel mCurDbDeviceHierarchy = null;
    private CurDbNetExplorerPanel mCurDbNetExplorer = null;
    private CurDbHistoryPanel mCurDbHistoryPanel = null;
    private CurDbSelectionPanel mCurDbSelectionPanel = null;
    private FlowManPanel mFlowManPanel = null;
    private ResourceManPanel mCurDbResourcePanel = null;
    private CurModeOptionPanel mCurModeOptionPanel = null;
    private EditAttributePanel mEditAttributePanel = null;
    protected List<RecentDesignFile> mRecentDesigns = new ArrayList<RecentDesignFile>();
    protected OrbitContextMenuWS mContextMenuWS = null;
    protected FlowWS mFlowWS = null;
    protected Map<SingleCDockable, OnDockClosed> mSingleDockToCloseListener = Maps.newHashMap();
    DbExplorerPanel.ExploreNetListener mExploreNetListener = new DbExplorerPanel.ExploreNetListener(){

        @Override
        public void exploreNet(DevicePath devicePath, Net net) {
            OrbitGuiWS.this.setCurDbNetExplorerVisible(true);
            OrbitGuiWS.this.mCurDbNetExplorer.gotoNet(devicePath, net);
        }
    };
    protected OrbitApp.CurrentDbListener mDbListener = newDb -> {
        if (newDb == null) {
            return;
        }
        if (this.mStatusCurView != null) {
            if (this.mStatusCurView.getDb() == newDb) {
                return;
            }
            if (this.mStatusCurView.getDb().getFile() != null && newDb.getFile() != null && this.mApp.getDbId(this.mStatusCurView.getDb()).equals(this.mApp.getDbId(newDb))) {
                return;
            }
        }
        for (AAppView v : this.mViewMgr.getViews()) {
            if (v.getDb() != newDb) continue;
            this.mViewMgr.activateView(v);
            return;
        }
        ALog.logWarn((String)"There is no view of the active database ('%s').", (Object[])new Object[]{this.mApp.getDbId(newDb)});
    };
    protected Cp.Listener mCpListener = new Cp.Listener(){

        public void cmdStart(String cmd, boolean record) {
        }

        public void cmdEnd(String cmd, boolean record) {
            OrbitGuiWS.this.updateEnabledStates();
            OrbitGuiWS.this.refreshTitles();
        }
    };
    protected boolean mRefreshTitlesQueued = false;
    protected WeakHashMap<JMenu, List<Component>> mMenu2DynViewItems = new WeakHashMap();
    protected ViewListener mViewListener = new ViewAdapter(){

        public void activeViewChanged(AAppView oldView, AAppView newView) {
            if (newView == OrbitGuiWS.this.mStatusCurView) {
                return;
            }
            OrbitGuiWS.this.designViewChanged(newView);
        }

        public boolean viewClosing(AAppView v) {
            block15: {
                Integer res;
                String msg;
                boolean qrySave;
                Db db;
                Db db2 = db = v == null ? null : v.getDb();
                if (db == null || AUtil.moreThanOne(OrbitGuiWS.this.getViews(db))) {
                    return true;
                }
                if (!db.getDirty()) {
                    return true;
                }
                String strQrySave = System.getProperty(OrbitGuiWS.class.getName() + ".queryUserToSaveOnExit");
                boolean bl = qrySave = strQrySave == null || ABoolean.fromString((String)strQrySave);
                if (!qrySave) {
                    return true;
                }
                File curFile = db.getFile();
                Design design = Design.getDesign((Db)db, (boolean)false);
                if (curFile != null) {
                    msg = String.format("The file %s has not been saved since it was last modified.\nDo you want to save the changes before closing?", curFile.getAbsolutePath());
                } else if (design != null) {
                    String title = v.getTitle();
                    if (title.startsWith("*")) {
                        title = title.substring(1);
                    }
                    msg = String.format("The design '%s' has not been saved. Do you want to save it before closing?", title);
                } else {
                    msg = String.format("The database has been modified. Do you want to save it before closing?", new Object[0]);
                }
                do {
                    if ((res = AQueryUser.ask((Boolean)true, (String)"Save Design", (String)msg, (int)3, (String[])new String[]{"Yes", "No", "Cancel"}, (int)-1, (Component)OrbitGuiWS.this.mApp.getMainWin())) == null || res == 2) {
                        return false;
                    }
                    if (res != 1) continue;
                    return true;
                } while (res != 0);
                if (curFile != null) {
                    try {
                        if (!OrbitGuiWS.this.mApp.saveCurrentDesignAs(curFile.getCanonicalPath())) {
                            return false;
                        }
                        break block15;
                    }
                    catch (IOException e) {
                        ALog.logError((Throwable)e, (String)"Error saving design.", (Object[])new Object[0]);
                        return false;
                    }
                }
                if (!OrbitGuiWS.this.saveDesignAs()) {
                    return false;
                }
            }
            return true;
        }
    };
    private StatusChangeListener mStatusListener = text -> this.mStatusBar.setStatusText(text);
    private ActionListener mBusViewShowAction = e -> BusView.showBusView();
    private ActionListener mBusViewCloseAction = e -> BusView.unShowBusView();
    private Action mViewCloser = new AbstractAction("Close Current View"){

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Close View");){
                Cp.exec((String)"OrbitIO.closeCurrentView();", (Object[])new Object[0]);
            }
        }
    };
    private Action mCreate3dView = new AbstractAction("3D Viewer"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitGuiWS.this.mApp.getCurrentDb();
            if (db != null) {
                OrbitGuiWS.this.openView3d(db);
            }
        }
    };
    private AbstractAction mResetSettingAction = new AbstractAction("Reset UI to Cadence Default"){

        @Override
        public void actionPerformed(ActionEvent e) {
            String message = "Do you want to reset UI? The stored configruation will be removed.";
            if (JOptionPane.showConfirmDialog(OrbitIO.getMainWindow(), message, (String)this.getValue("Name"), 0, 2) == 0) {
                OrbitGuiWS.this.resetGuiSettings();
            }
        }
    };
    private AbstractAction mLoadSettingAction = new AbstractAction("Load Settings"){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setFileFilter((FileFilter)new AFileFilter("ogui", "Orbit GUI Settings"));
            if (fc.showOpenDialog((Component)OrbitGuiWS.this.getMainFrame()) != 0) {
                return;
            }
            OrbitGuiWS.this.resetGuiSettings();
            OrbitGuiWS.this.loadGuiSettings(fc.getSelectedFile());
        }
    };
    private AbstractAction mSaveSettingAction = new AbstractAction("Save Settings"){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setFileFilter((FileFilter)new AFileFilter("ogui", "Orbit GUI Settings"));
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            OrbitGuiWS.this.saveGuiSettings(fc.getSelectedFile());
        }
    };
    protected static final int MAX_RECENT_SCRIPTS = 16;
    private LinkedList<String> mRecentScripts = new LinkedList();
    private Action mPlayScript = new AbstractAction("Play Script...", OrbitIcons.RUN_SCRIPT){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            if (AUtil.getAclDebugMode()) {
                fc.setFileFilter((FileFilter)AclResources.ALL_SCRIPT_FILE_FILTER);
            } else {
                fc.setFileFilter((FileFilter)OrbitIO.SCRIPT_FILE_FILTER);
            }
            if (fc.showOpenDialog((Component)OrbitGuiWS.this.getMainFrame()) != 0) {
                return;
            }
            String script = fc.getSelectedFile().getAbsolutePath();
            OrbitGuiWS.this.sourceScript(script);
        }
    };
    private Action mRecordScript = ALogPanel.getRecordScriptAction();
    private Action mAbout = new AbstractAction("About OrbitIO"){
        final Map<String, AboutImageSetting> setting;
        {
            this.setting = Map.of("17.2", new AboutImageSetting("res/img/OIOAboutHeader.png", 0), "17.4", new AboutImageSetting("res/img/OrbitIO_174.jpg", 12));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String release = OrbitGuiWS.this.mApp.getVersion();
            AboutImageSetting ais = this.setting.get(release);
            if (ais == null) {
                ais = this.setting.get("17.4");
            }
            File fileHead = new File(AApp.getInstallDir(), ais.imgPath);
            AImageIcon imgHead = null;
            try {
                imgHead = new AImageIcon(fileHead.toURI().toURL());
            }
            catch (MalformedURLException ee) {
                ALog.logWarn((Throwable)ee, (String)"Error loading about screen image.", (Object[])new Object[0]);
                imgHead = (AImageIcon)UIUtil.ICON_ERR;
            }
            About about = new About((Frame)OrbitIO.getMainWindow(), OrbitGuiWS.this.mApp.getName(true), "", "version " + release, release.equals("17.4") ? "" : OrbitIO.getApp().getCopyright(), "Inspecting system...", imgHead.getImage(), null, null, Color.WHITE, ais.borderThickness);
            about.setVisible(true);
            EventQueue.invokeLater(() -> OrbitGuiWS.this.updateSystemText(about));
        }

        class AboutImageSetting {
            String imgPath;
            int borderThickness;

            AboutImageSetting(String imgPath, int borderThickness) {
                this.imgPath = imgPath;
                this.borderThickness = borderThickness;
            }
        }
    };
    protected LinkedList<WeakReference<AbstractDesignAction>> mDesignActions = new LinkedList();
    protected LinkedList<WeakReference<AbstractDesignAction>> mDeadDesignActions = new LinkedList();
    protected DbHistory.Listener mHistoryListener = new DbHistory.ListenerAdapter(){

        public void coalesceChange(boolean newCoalesceState) {
            try {
                if (newCoalesceState) {
                    Db db = OrbitIO.getCurDb();
                    DbHistory history = db == null ? null : db.getHistory();
                    String transName = history == null ? null : history.getCurTransactionName();
                    OrbitGuiWS.this.mStatusBar.setStatusText(transName);
                } else {
                    SwingUtilities.invokeLater(() -> OrbitGuiWS.this.mStatusBar.setStatusText("Idle"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    protected WindowListener mMainFrameWindowListener = new WindowAdapter(){

        @Override
        public void windowOpened(WindowEvent e) {
            OrbitGuiWS.this.mApp.getCp().setInterpreterValue("OrbitWS", (Object)OrbitGuiWS.this);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Settings s = Settings.getSettings((String)"UserPreferences");
            boolean confirm = (Boolean)s.getSetting("ConfirmAppClose", (Object)true);
            if (confirm && !OrbitGuiWS.this.confirmExit()) {
                return;
            }
            for (AAppView v : AUtil.linkedList(OrbitGuiWS.this.mViewMgr.getViews())) {
                if (OrbitGuiWS.this.closeView(v)) continue;
                return;
            }
            OrbitGuiWS.this.saveSettings();
            OrbitGuiWS.this.mApp.getCp().unsetInterpreterValue("OrbitWS");
            OrbitGuiWS.this.mMainFrame.dispose();
            OrbitGuiWS.this.mMainFrame = null;
        }
    };
    protected WSActionMap mActions = new WSActionMap();
    private Action mFocusGuiCmdLine = new AbstractAction("Focus GUI Command Line"){

        @Override
        public void actionPerformed(ActionEvent e) {
            OrbitGuiWS.this.mCmdLine.requestFocusInWindow();
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void fireViewOpened(AAppView view) {
        for (ViewListener l : AUtil.linkedList((Collection)this.mViewListeners)) {
            l.viewOpened(view);
        }
    }

    protected boolean fireViewClosing(AAppView view) {
        for (ViewListener l : AUtil.linkedList((Collection)this.mViewListeners)) {
            if (l.viewClosing(view)) continue;
            return false;
        }
        return true;
    }

    protected void fireViewClosed(AAppView view) {
        for (ViewListener l : AUtil.linkedList((Collection)this.mViewListeners)) {
            l.viewClosed(view);
        }
    }

    protected void fireActiveViewChanged(AAppView oldView, AAppView newView) {
        for (ViewListener l : AUtil.linkedList((Collection)this.mViewListeners)) {
            l.activeViewChanged(oldView, newView);
        }
    }

    public OrbitGuiWS(OrbitIO app) {
        this.mApp = app;
        this.mContextMenuWS = new OrbitContextMenuWS(app);
        this.mFlowWS = new FlowWS(this);
        this.addViewListener((ViewListener)new ViewAdapter(){

            public void activeViewChanged(AAppView oldView, AAppView newView) {
                OrbitGuiWS.this.updateEnabledStates();
                OrbitGuiWS.this.setupStatusListeners(oldView, newView);
            }
        });
    }

    public void init() {
        if (OrbitApp.getApp().hasEnv(OrbitIOEnv.UI_THEME_DARK)) {
            OrbitContextMenuWS.blackOcean();
        }
        boolean heavyPopups = ABoolean.fromString((String)AUtil.getEnv((String)(((Object)((Object)this)).getClass().getName() + ".heavyWeightPopups")));
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        ttm.setDismissDelay(ttm.getDismissDelay() * 2);
        if (heavyPopups && !AApp.isOSX()) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ttm.setLightWeightPopupEnabled(false);
        }
        ADialog.setSettingsSection((String)"GUI");
        ADialog.setSettingsPrefix((String)"DLG_");
        Settings prefs = Settings.getSettings((String)"UserPreferences");
        AFloatWindow.setPinByDefault((Boolean)prefs.getSetting("FloatWindowsDefaultPinned", (Object)true));
        Cp cp = this.mApp.getCp();
        cp.setInterpreterValue("OrbitWS", (Object)this);
        cp.addListener(this.mCpListener);
        this.initWindowConfig();
        this.initStandardActions();
        this.mViewToolBar = new OrbitViewToolBar("View", 0);
        this.mToolBars.put(this.mViewToolBar.getName(), this.mViewToolBar);
        this.mDockToolBar = new OrbitDockingToolBar("Docking", 1);
        this.mMainFrame = new OrbitMainFrame(this.mApp.getName(true) + " " + this.mApp.getVersion());
        this.mMainFrame.setLayout(new BorderLayout());
        this.mMainFrame.setDefaultCloseOperation(0);
        this.mCmdLine = new GuiCommandLine(this.mApp.getCp());
        this.mCmdMsgPnl = new JPanel();
        this.mCmdMsgPnl.setLayout(new BorderLayout(0, 2));
        this.mCmdMsgPnl.add((Component)this.mCmdLine, "North");
        this.mCmdMsgPnl.add((Component)this.mMsgPnl, "Center");
        this.initDockingUI();
        this.loadToolBarConfig();
        this.enableShortcutKeys();
        File iconPath = new File(AApp.getInstallDir(), "res/img/icon32.png");
        AImageIcon icon = new AImageIcon(iconPath.getPath());
        this.mMainFrame.setIconImage(icon.getImage());
        this.mMainFrame.setJMenuBar(this.mMainMenuBar);
        this.mMainMenuBar.getInputMap().setParent(null);
        this.setupDockingToolBar();
        this.mMainFrame.add((Component)this.mDockToolBar, "West");
        this.mStatusBar = new OrbitStatusBar();
        this.mMainFrame.add((Component)this.mStatusBar, "South");
        this.addViewListener(this.mViewListener);
        this.mApp.addCurrentDbListener(this.mDbListener);
        this.mGuiActionRegistry = new OrbitGuiObjectActionRegistry(this);
        this.mApp.registerFileHandler("Open", Spd2000.FileHandler);
        this.restoreSettings();
        this.mMainFrame.addNotify();
        UIUtil.verifyWindowOnScreen((Window)this.mMainFrame);
        this.mMainFrame.addWindowListener(this.mMainFrameWindowListener);
        if (APlatformUtil.isMacPlatform()) {
            Rectangle desiredBounds = this.mMainFrame.getBounds();
            EventQueue.invokeLater(() -> {
                if (desiredBounds != null && !AUtil.equals((Object)desiredBounds, (Object)this.mMainFrame.getBounds())) {
                    this.mMainFrame.setBounds(desiredBounds);
                }
            });
        }
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> ALog.logDebug((Throwable)e, (String)"Error '%s' in thread %s", (Object[])new Object[]{e.getMessage(), t.getName()}));
        if (OrbitApp.getApp().hasEnv(OrbitIOEnv.UI_THEME_DARK)) {
            SwingUtilities.updateComponentTreeUI(this.mMainFrame);
        }
        if (this.getFlowManVisible()) {
            this.initFlowManager();
        }
        if (OrbitApp.getApp().hasEnv(OrbitIOEnv.UI_THEME_INNOVUS)) {
            Cp.exec((String)"com.sigrity.orbit.ui.core.ViewColorizer.setDefaultViewColorizer(\"Innovus\");", (Object[])new Object[0]);
        }
    }

    private void setupDockingToolBar() {
        this.mToolBarDockControl = new CControl((JFrame)this.mMainFrame);
        this.mToolBarDockControl.putProperty(ExpandableToolbarItemStrategy.STRATEGY, (Object)new DefaultExpandableToolbarItemStrategy());
        CToolbarContentArea area = new CToolbarContentArea(this.mToolBarDockControl, "center");
        this.mToolBarDockControl.addStationContainer((CStationContainer)area);
        this.mMainFrame.add((Component)area, "North");
        CToolbarAreaLocation location = area.getNorthToolbar().getStationLocation();
        this.mToolbarWS = new OrbitToolBarWS(this);
        this.mToolBarDockControl.putProperty(ToolbarDockStation.SIDE_GAP, (Object)0);
        CToolbarItem fileItem = new CToolbarItem("File");
        this.mToolBarDockControl.addDockable((SingleCDockable)fileItem);
        fileItem.setLocation((CLocation)location.group(0).toolbar(0, 0).item(0));
        this.mToolbarWS.setupFileToolBar(fileItem);
        CToolbarItem editItem = new CToolbarItem("Edit");
        this.mToolBarDockControl.addDockable((SingleCDockable)editItem);
        editItem.setLocation((CLocation)location.group(0).toolbar(0, 1).item(0));
        this.mToolbarWS.setupEditToolBar(editItem);
        CToolbarItem viewItem = new CToolbarItem("View");
        this.mToolBarDockControl.addDockable((SingleCDockable)viewItem);
        viewItem.setLocation((CLocation)location.group(0).toolbar(0, 1).item(2));
        this.mViewToolBar.placeOnDockable(viewItem);
    }

    private void initFlowManager() {
        this.mFlowWS.initFlowManager();
    }

    private void initWindowConfig() {
        this.mWindowConfigs.add(new VisibleWindowConfig("CurDbExplorerVisible", null, "ToggleDesignExplorerDisplay", "Toggle Design Explorer Display", this::getCurDbExplorerVisible, this::setCurDbExplorerVisible, b -> this.setCurDbExplorerVisible((boolean)b, true)));
        this.mWindowConfigs.add(new VisibleWindowConfig("CurDbDeviceHierarchyVisible", true, "ToggleDeviceHierarchyDisplay", "Toggle Device Hierarchy Display", this::getCurDbDeviceHierarchyVisible, this::setCurDbDeviceHierarchyVisible, b -> this.setCurDbDeviceHierarchyVisible((boolean)b, true)));
        this.mWindowConfigs.add(new VisibleWindowConfig("CurDbNetExplorerVisible", false, "ToggleNetExplorerDisplay", "Toggle Net Explorer Display", this::getCurDbNetExplorerVisible, this::setCurDbNetExplorerVisible, b -> this.setCurDbNetExplorerVisible((boolean)b, true)));
        this.mWindowConfigs.add(new VisibleWindowConfig("CurDbHistoryVisible", false, "ToggleUndoHistoryDisplay", "Toggle Undo History Display", this::getCurDbHistoryVisible, this::setCurDbHistoryVisible, b -> this.setCurDbHistoryVisible((boolean)b, true)));
        this.mWindowConfigs.add(new VisibleWindowConfig("CurDbSelectStatusVisible", true, "ToggleSelectionStatusDisplay", "Toggle Selection Status Display", this::getCurDbSelectionVisible, this::setCurDbSelectionVisible, b -> this.setCurDbSelectionVisible((boolean)b, true)));
        this.mWindowConfigs.add(new VisibleWindowConfig("SelectionStatusWidgetVisible", true, "ToggleSelectionStatusWidget", "Toggle Selection Status Widget", this::getSelStatWidgetVisible, this::setSelStatWidgetVisible, this::setSelStatWidgetVisible));
        this.mWindowConfigs.add(new VisibleWindowConfig("MemoryStatusVisible", true, "ToggleMemStatDisplay", "Toggle Mem Stat Display", this::getMemStatVisible, this::setMemStatVisible, this::setMemStatVisible));
        this.mWindowConfigs.add(new VisibleWindowConfig("FlowManagerVisible", true, "ToggleFlowManDisplay", "Toggle Flow Man Display", this::getFlowManVisible, this::setFlowManVisible, b -> this.setFlowManVisible((boolean)b, true)));
        this.mWindowConfigs.add(new VisibleWindowConfig("CurDbResourceVisible", false, "ToggleResourceManagerDisplay", "Toggle Resource Manager Display", this::getCurDbResourceVisible, this::setCurDbResourceVisible, b -> this.setCurDbResourceVisible((boolean)b, true)));
        this.mWindowConfigs.add(new VisibleWindowConfig("CurModeOptionVisible", true, "ToggleModeOptionDisplay", "Toggle Mode Option Display", this::getCurModeOptionVisible, this::setCurModeOptionVisible, b -> this.setCurModeOptionVisible((boolean)b, true)));
        this.mWindowConfigs.add(new VisibleWindowConfig("AttrEditorVisible", true, "ToggleAttrEditorDisplay", "Toggle Attribute Editor Display", this::getEditAttributeVisible, this::setEditAttributeVisible, b -> this.setEditAttributeVisible((boolean)b, true)));
    }

    private void initDockingUI() {
        this.mDockControl = new CControl((JFrame)this.mMainFrame);
        IconManager icons = this.mDockControl.getController().getIcons();
        icons.setIconClient("locationmanager.normalize", OrbitIcons.WIN_NORMALIZE);
        icons.setIconClient("locationmanager.maximize", OrbitIcons.WIN_MAXIMIZE);
        icons.setIconClient("locationmanager.minimize", OrbitIcons.WIN_MINIMIZE);
        icons.setIconClient("locationmanager.externalize", OrbitIcons.WIN_EXTERNALIZE);
        icons.setIconClient("locationmanager.unexternalize", OrbitIcons.WIN_UNEXTERNALIZE);
        icons.setIconClient("close", OrbitIcons.WIN_CLOSE);
        if (OrbitApp.getApp().hasEnv(OrbitIOEnv.UI_THEME_INNOVUS)) {
            InnovusLookAndFeel.initDockTheme((DockController)this.mDockControl.getController());
        }
        this.mDockControl.putProperty(FlapDockStation.MINIMUM_SIZE, (Object)new Dimension(0, 0));
        this.mDockControl.addSingleDockableFactory((Filter)new OrbitSingleDockableFactory(), (SingleCDockableFactory)new OrbitSingleDockableFactory());
        this.mDockControl.setGroupBehavior(CGroupBehavior.TOPMOST);
        this.mMainFrame.add((Component)this.mDockControl.getContentArea(), "Center");
        this.mDockToolBar.reset();
        this.deployDockingUI();
        InteractiveSelModePnl.registerDockingUI();
        InteractiveSelectionUI.registerDockingUI();
        ViewOptionsPanel.registerDockingUI();
        CurDbExplorerPanel.registerDockingUI();
        CurDbDeviceHierarchyPanel.registerDockingUI();
        CurDbNetExplorerPanel.registerDockingUI();
        CurDbHistoryPanel.registerDockingUI();
        CurDbSelectionPanel.registerDockingUI();
        FlowManPanel.registerDockingUI();
        ResourceManPanel.registerDockingUI();
        CurModeOptionPanel.registerDockingUI();
        EditAttributePanel.registerDockingUI();
    }

    private void deployDockingUI() {
        this.mDockToolBar.reset();
        DefaultSingleCDockable viewDock = new DefaultSingleCDockable(OrbitViewMgr.class.getName(), "Designs", new CAction[0]);
        viewDock.getContentPane().add(this.mViewMgr.getComponent());
        viewDock.setCloseable(false);
        viewDock.setExternalizable(false);
        viewDock.setMinimizable(false);
        viewDock.setTitleIcon(DBEResources.ICON_DESIGN);
        DesignDockUI.installToolBar(viewDock);
        this.mDockControl.addDockable((SingleCDockable)viewDock);
        this.mDockToolBar.addDockable(viewDock);
        DefaultSingleCDockable msgDock = new DefaultSingleCDockable(DOCK_ID_CMD_MSG, "Commands and Messages", new CAction[0]);
        CommandDockUI.initCommandsAndMessage(msgDock, this.mCmdMsgPnl);
        this.mDockControl.addDockable((SingleCDockable)msgDock);
        this.mDockToolBar.addDockable(msgDock);
        SingleCDockable viewDockable = this.mDockControl.getSingleDockable(OrbitViewMgr.class.getName());
        viewDockable.setVisible(true);
        SingleCDockable msgDockable = this.mDockControl.getSingleDockable(OrbitGuiWS.class.getName() + ".MessagePanel");
        msgDockable.setLocation((CLocation)CLocation.base().normalSouth(0.2));
        msgDockable.setVisible(true);
    }

    public boolean close() {
        if (this.mMainFrame == null) {
            return true;
        }
        UIUtil.closeWindow((Window)this.mMainFrame);
        return this.mMainFrame == null;
    }

    public ObjectActionRegistry getObjectActionRegistry() {
        return this.mGuiActionRegistry;
    }

    public OrbitGuiShortcutActionRegistry getObjectShortcutActionRegistry() {
        return OrbitGuiShortcutActionRegistry.get();
    }

    public String getStatus() {
        return this.mStatusBar.getStatusText();
    }

    public void setStatus(String text) {
        this.mStatusBar.setStatusText(text);
    }

    public void setStatus(float percent) {
        this.mStatusBar.setStatusPercent(percent);
    }

    public void openView(Db db) {
        DesignView2D v = new DesignView2D(db);
        this.trackView(v);
    }

    public void openView3d(Db db) {
        DesignView3D v;
        if (this.getCurrentView() != null && this.getCurrentView().getDb() == db) {
            v = DesignView3D.show3D(this.getCurrentView(), db);
            if (v == null) {
                return;
            }
        } else {
            v = new DesignView3D(db);
            v.resetContent();
        }
        this.trackView(v);
        v.requestFocus();
    }

    protected void trackView(AAppView v) {
        File f;
        this.mViewMgr.addView(v);
        Db db = v.getDb();
        if (db != null && (f = db.getFile()) != null) {
            this.addMRU(f);
        }
    }

    public void addMRU(File f) {
        int curIdx = -1;
        RecentDesignFile rf = new RecentDesignFile(f.getAbsoluteFile());
        curIdx = this.mRecentDesigns.indexOf(rf);
        if (curIdx != -1) {
            rf = this.mRecentDesigns.get(curIdx);
            this.mRecentDesigns.remove(curIdx);
        }
        this.mRecentDesigns.add(0, rf);
        while (this.mRecentDesigns.size() > 16) {
            this.mRecentDesigns.remove(this.mRecentDesigns.size() - 1);
        }
        this.saveMRU();
    }

    public void removeMRU(File f) {
        this.mRecentDesigns.remove(new RecentDesignFile(f.getAbsoluteFile()));
        this.saveMRU();
    }

    private void saveMRU() {
        String k;
        int i;
        Settings s = Settings.getSettings((String)"MRU");
        for (i = 0; i < Integer.MAX_VALUE && s.getSettingOfClass(k = "File" + i, String.class) != null; ++i) {
            s.removeSetting(k);
            s.removeSetting("DesignSnapshot" + i);
        }
        for (i = 0; i < this.mRecentDesigns.size(); ++i) {
            RecentDesignFile rf = this.mRecentDesigns.get(i);
            s.putSetting("File" + i, (Object)rf.file.getAbsolutePath());
            if (rf.image == null) continue;
            s.putSetting("DesignSnapshot" + i, (Object)rf.image);
        }
        s.save();
    }

    public void clearMRU() {
        this.mRecentDesigns.clear();
    }

    public List<File> getMostRecentUsedDesign() {
        LinkedList<File> list = new LinkedList<File>();
        for (RecentDesignFile rf : this.mRecentDesigns) {
            list.add(rf.file);
        }
        return list;
    }

    public String getMostRecentUsedDesignSnapshot(File f) {
        for (RecentDesignFile rf : this.mRecentDesigns) {
            if (!AUtil.equals((Object)rf.file, (Object)f)) continue;
            return rf.image;
        }
        return null;
    }

    public void activateView(AAppView v) {
        this.mViewMgr.activateView(v);
    }

    public boolean closeView(AAppView v) {
        return this.mViewMgr.close(v);
    }

    public int closeViews(Db db) {
        int closed = 0;
        for (AAppView v : this.mViewMgr.getViews()) {
            if (v.getDb() != db || !this.mApp.closeView(v)) continue;
            ++closed;
        }
        return closed;
    }

    public boolean closeCurrentView() {
        return this.closeView(this.mViewMgr.getCurrentView());
    }

    public AAppView getCurrentView() {
        return this.mViewMgr.getCurrentView();
    }

    public void refreshCurrentView(boolean now) {
        AAppView v = this.getCurrentView();
        if (v == null) {
            return;
        }
        ActionMap am = v.getActions();
        Action refresh = now ? am.get("Refresh Now") : am.get("Refresh");
        if (refresh == null) {
            ALog.logError((Throwable)new Exception("Lost Action"), (String)"Please setup refresh action in canvas.", (Object[])new Object[0]);
            return;
        }
        refresh.actionPerformed(null);
    }

    public void zoomFitCurrentView() {
        AAppView v = this.getCurrentView();
        if (v == null) {
            return;
        }
        Action a = v.getActions().get("Zoom Fit");
        if (a == null) {
            return;
        }
        a.actionPerformed(null);
    }

    public void snapShotCurrentView() {
        AAppView v = this.getCurrentView();
        if (v == null) {
            return;
        }
        Action a = v.getActions().get("SnapShot");
        if (a == null) {
            return;
        }
        a.actionPerformed(null);
    }

    public void refreshViewToolbar() {
        this.mViewToolBar.resetViewActions(this.getCurrentView());
        this.mViewToolBar.validate();
    }

    public AAppView getView(Db db) {
        for (AAppView v : this.mViewMgr.getViews()) {
            if (!v.getDb().equals(db)) continue;
            return v;
        }
        return null;
    }

    public IterableIterator<AAppView> getViews(Db db) {
        return this.mViewMgr.getViews().filter(v -> v.getDb() == db);
    }

    public JFrame getMainFrame() {
        return this.mMainFrame;
    }

    public CControl getDockingController() {
        return this.mDockControl;
    }

    public ALogPanel getMessagePanel() {
        return this.mMsgPnl;
    }

    public DefaultSingleCDockable getSingleDockable(String dockId) {
        String id = dockId;
        SingleCDockable dockable = this.mDockControl.getSingleDockable(id);
        if (dockable == null) {
            SingleCDockableFactory f = this.mDockControl.getSingleDockableFactory(id);
            if (f != null) {
                dockable = f.createBackup(id);
            }
            if (dockable == null) {
                OrbitSingleDockableFactory mOrbitSingleDockableFactory = new OrbitSingleDockableFactory();
                dockable = mOrbitSingleDockableFactory.createBackup(id);
            }
            if (dockable == null) {
                ALog.logError((String)"Unable to get a single dockable for '%s'.", (Object[])new Object[]{id});
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
            this.mDockControl.addDockable(dockable);
        }
        if (!(dockable instanceof DefaultSingleCDockable)) {
            ALog.logError((String)"Single dockable for '%s' is not a DefaultSingleCDockable, unable to show or hide content.", (Object[])new Object[]{id});
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        this.mDockToolBar.addDockable((DefaultSingleCDockable)dockable);
        return (DefaultSingleCDockable)dockable;
    }

    public DefaultSingleCDockable setSingleDockableVisible(JComponent comp, boolean show, final OnDockClosed closed) {
        if (comp == null) {
            return null;
        }
        String id = comp.getClass().getName();
        DefaultSingleCDockable dockable = this.getSingleDockable(id);
        if (!this.mSingleDockToCloseListener.containsKey(dockable) && closed != null) {
            CVetoClosingListener vcl = new CVetoClosingListener(){

                public void closing(CVetoClosingEvent event) {
                }

                public void closed(CVetoClosingEvent event) {
                    for (int i = 0; i < event.getDockableCount(); ++i) {
                        DefaultSingleCDockable d = (DefaultSingleCDockable)event.getDockable(i);
                        d.getContentPane().removeAll();
                    }
                    closed.closed();
                }
            };
            dockable.addVetoClosingListener(vcl);
            this.mSingleDockToCloseListener.put((SingleCDockable)dockable, closed);
        }
        DefaultSingleCDockable d = dockable;
        if (show) {
            d.getContentPane().add(comp);
            d.setTitleText(comp.getName());
            d.setVisible(true);
        } else {
            d.setVisible(false);
            d.getContentPane().removeAll();
        }
        return d;
    }

    public void setCurDbExplorerVisible(boolean show) {
        this.setCurDbExplorerVisible(show, false);
    }

    private void setCurDbExplorerVisible(boolean show, boolean fromXML) {
        if (show && this.mCurDbExplorer == null) {
            this.mCurDbExplorer = new CurDbExplorerPanel(this.mApp, this.mExploreNetListener);
        }
        DefaultSingleCDockable dock = null;
        if (!fromXML) {
            dock = this.setSingleDockableVisible(this.mCurDbExplorer, show, null);
        } else if (this.mCurDbExplorer != null) {
            dock = this.getSingleDockable(this.mCurDbExplorer.getClass().getName());
        }
        if (dock != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(this.mCurDbExplorer);
            if (this.mCurDbExplorer != null) {
                dock.setTitleText(this.mCurDbExplorer.getName());
            }
            DbExplorerDockUI.installToolBar(dock, this.mCurDbExplorer);
        }
        if (!show && this.mCurDbExplorer != null) {
            this.mCurDbExplorer = null;
        }
    }

    public boolean getCurDbExplorerVisible() {
        return this.mCurDbExplorer != null;
    }

    public void setCurDbDeviceHierarchyVisible(boolean show) {
        this.setCurDbDeviceHierarchyVisible(show, false);
    }

    private void setCurDbDeviceHierarchyVisible(boolean show, boolean fromXML) {
        if (show && this.mCurDbDeviceHierarchy == null) {
            this.mCurDbDeviceHierarchy = new CurDbDeviceHierarchyPanel(this.mApp, this.mExploreNetListener);
        }
        DefaultSingleCDockable dock = null;
        if (!fromXML) {
            dock = this.setSingleDockableVisible(this.mCurDbDeviceHierarchy, show, null);
        } else if (this.mCurDbDeviceHierarchy != null) {
            dock = this.getSingleDockable(this.mCurDbDeviceHierarchy.getClass().getName());
        }
        if (dock != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(this.mCurDbDeviceHierarchy);
            if (this.mCurDbDeviceHierarchy != null) {
                dock.setTitleText(this.mCurDbDeviceHierarchy.getName());
            }
            DbExplorerDockUI.installToolBar(dock, this.mCurDbDeviceHierarchy);
        }
        if (!show && this.mCurDbDeviceHierarchy != null) {
            this.mCurDbDeviceHierarchy = null;
        }
    }

    public boolean getCurDbDeviceHierarchyVisible() {
        return this.mCurDbDeviceHierarchy != null;
    }

    public void setCurDbNetExplorerVisible(boolean show) {
        this.setCurDbNetExplorerVisible(show, false);
    }

    private void setCurDbNetExplorerVisible(boolean show, boolean fromXML) {
        if (show && this.mCurDbNetExplorer == null) {
            this.mCurDbNetExplorer = new CurDbNetExplorerPanel(this.mApp, this.mExploreNetListener);
        }
        DefaultSingleCDockable dock = null;
        if (!fromXML) {
            dock = this.setSingleDockableVisible(this.mCurDbNetExplorer, show, null);
        } else if (this.mCurDbNetExplorer != null) {
            dock = this.getSingleDockable(this.mCurDbNetExplorer.getClass().getName());
        }
        if (dock != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(this.mCurDbNetExplorer);
            if (this.mCurDbNetExplorer != null) {
                dock.setTitleText(this.mCurDbNetExplorer.getName());
            }
        }
        if (!show && this.mCurDbNetExplorer != null) {
            this.mCurDbNetExplorer = null;
        }
    }

    public boolean getCurDbNetExplorerVisible() {
        return this.mCurDbNetExplorer != null;
    }

    public void setCurDbSelectionVisible(boolean show) {
        this.setCurDbSelectionVisible(show, false);
    }

    private void setCurDbSelectionVisible(boolean show, boolean fromXML) {
        if (show && this.mCurDbSelectionPanel == null) {
            this.mCurDbSelectionPanel = new CurDbSelectionPanel(this.mApp);
        }
        DefaultSingleCDockable dock = null;
        if (!fromXML) {
            dock = this.setSingleDockableVisible(this.mCurDbSelectionPanel, show, null);
        } else if (this.mCurDbSelectionPanel != null) {
            dock = this.getSingleDockable(this.mCurDbSelectionPanel.getClass().getName());
        }
        if (dock != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(this.mCurDbSelectionPanel);
            if (this.mCurDbSelectionPanel != null) {
                dock.setTitleText(this.mCurDbSelectionPanel.getName());
            }
        }
        if (!show && this.mCurDbSelectionPanel != null) {
            this.mCurDbSelectionPanel = null;
        }
    }

    public boolean getCurDbSelectionVisible() {
        return this.mCurDbSelectionPanel != null;
    }

    public void setCurDbHistoryVisible(boolean show) {
        this.setCurDbHistoryVisible(show, false);
    }

    private void setCurDbHistoryVisible(boolean show, boolean fromXML) {
        if (show && this.mCurDbHistoryPanel == null) {
            this.mCurDbHistoryPanel = new CurDbHistoryPanel(this.mApp);
        }
        DefaultSingleCDockable dock = null;
        if (!fromXML) {
            dock = this.setSingleDockableVisible(this.mCurDbHistoryPanel, show, null);
        } else if (this.mCurDbHistoryPanel != null) {
            dock = this.getSingleDockable(this.mCurDbHistoryPanel.getClass().getName());
        }
        if (dock != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(this.mCurDbHistoryPanel);
            if (this.mCurDbHistoryPanel != null) {
                dock.setTitleText(this.mCurDbHistoryPanel.getName());
            }
        }
        if (!show && this.mCurDbHistoryPanel != null) {
            this.mCurDbHistoryPanel = null;
        }
    }

    public boolean getCurDbHistoryVisible() {
        return this.mCurDbHistoryPanel != null;
    }

    public void setCurDbResourceVisible(boolean show) {
        this.setCurDbResourceVisible(show, false);
    }

    private void setCurDbResourceVisible(boolean show, boolean fromXML) {
        if (show && this.mCurDbResourcePanel == null) {
            this.mCurDbResourcePanel = new ResourceManPanel(this.mApp);
        }
        DefaultSingleCDockable dock = null;
        if (!fromXML) {
            dock = this.setSingleDockableVisible(this.mCurDbResourcePanel, show, null);
        } else if (this.mCurDbResourcePanel != null) {
            dock = this.getSingleDockable(this.mCurDbResourcePanel.getClass().getName());
        }
        if (dock != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(this.mCurDbResourcePanel);
            if (this.mCurDbResourcePanel != null) {
                dock.setTitleText(this.mCurDbResourcePanel.getName());
            }
            DockingUtil.clearActions(dock);
            dock.addAction((CAction)new DbResourceDockUI.RefreshNodeAction(this.mCurDbResourcePanel));
        }
        if (!show && this.mCurDbResourcePanel != null) {
            this.mCurDbResourcePanel = null;
        }
    }

    public boolean getCurDbResourceVisible() {
        return this.mCurDbResourcePanel != null;
    }

    public void setCurModeOptionVisible(boolean show) {
        this.setCurModeOptionVisible(show, false);
    }

    private void setCurModeOptionVisible(boolean show, boolean fromXML) {
        if (show && this.mCurModeOptionPanel == null) {
            this.mCurModeOptionPanel = new CurModeOptionPanel(this.mApp);
        }
        DefaultSingleCDockable dock = null;
        if (!fromXML) {
            dock = this.setSingleDockableVisible(this.mCurModeOptionPanel, show, null);
        } else if (this.mCurModeOptionPanel != null) {
            dock = this.getSingleDockable(this.mCurModeOptionPanel.getClass().getName());
        }
        if (dock != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(this.mCurModeOptionPanel);
            if (this.mCurModeOptionPanel != null) {
                dock.setTitleText(this.mCurModeOptionPanel.getName());
            }
            DockingUtil.clearActions(dock);
        }
        if (!show && this.mCurModeOptionPanel != null) {
            this.mCurModeOptionPanel = null;
        }
    }

    public boolean getCurModeOptionVisible() {
        return this.mCurModeOptionPanel != null;
    }

    public void setEditAttributeVisible(boolean show) {
        this.setEditAttributeVisible(show, false);
    }

    private void setEditAttributeVisible(boolean show, boolean fromXML) {
        if (show && this.mEditAttributePanel == null) {
            this.mEditAttributePanel = new EditAttributePanel();
        }
        DefaultSingleCDockable dock = null;
        if (!fromXML) {
            dock = this.setSingleDockableVisible((JComponent)((Object)this.mEditAttributePanel), show, null);
        } else if (this.mEditAttributePanel != null) {
            dock = this.getSingleDockable(((Object)((Object)this.mEditAttributePanel)).getClass().getName());
        }
        if (dock != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add((Component)((Object)this.mEditAttributePanel));
            if (this.mEditAttributePanel != null) {
                dock.setTitleText(this.mEditAttributePanel.getName());
                this.mEditAttributePanel.getInputMap().setParent(null);
            }
            DockingUtil.clearActions(dock);
        }
        if (!show && this.mCurModeOptionPanel != null) {
            this.mCurModeOptionPanel = null;
        }
    }

    public boolean getEditAttributeVisible() {
        return this.mEditAttributePanel != null;
    }

    public EditAttributePanel getEditAttributePanel() {
        return this.mEditAttributePanel;
    }

    public void setSelStatWidgetVisible(boolean visible) {
        if (this.mStatusBar != null) {
            this.mStatusBar.setSelStatWidgetVisible(visible);
        }
    }

    public boolean getSelStatWidgetVisible() {
        return this.mStatusBar != null && this.mStatusBar.isVisible() && this.mStatusBar.getSelStatWidgetVisible();
    }

    public void setMemStatVisible(boolean visible) {
        if (this.mStatusBar != null) {
            this.mStatusBar.setMemStatusVisible(visible);
        }
    }

    public boolean getMemStatVisible() {
        return this.mStatusBar != null && this.mStatusBar.isVisible() && this.mStatusBar.getMemStatusVisible();
    }

    public void setFlowManVisible(boolean show) {
        this.setFlowManVisible(show, false);
    }

    public void setFlowManVisible(boolean show, boolean fromXML) {
        if (show && this.mFlowManPanel == null) {
            this.mFlowManPanel = new FlowManPanel(this.mApp);
        }
        DefaultSingleCDockable dock = null;
        if (!fromXML) {
            dock = this.setSingleDockableVisible(this.mFlowManPanel, show, null);
        } else if (this.mFlowManPanel != null) {
            dock = this.getSingleDockable(this.mFlowManPanel.getClass().getName());
        }
        if (dock != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(this.mFlowManPanel);
            if (this.mFlowManPanel != null) {
                dock.setTitleText(this.mFlowManPanel.getName());
            }
        }
        if (!show && this.mFlowManPanel != null) {
            this.mFlowManPanel = null;
        }
    }

    public boolean getFlowManVisible() {
        return this.mFlowManPanel != null;
    }

    public FlowManPanel getFlowManPanel() {
        return this.mFlowManPanel;
    }

    public FlowWS getFlowWS() {
        return this.mFlowWS;
    }

    public void saveSettings() {
        Settings s = Settings.getSettings((String)"GUI");
        s.putSetting("MainFrameBounds", (Object)this.mMainFrame.getBounds());
        for (VisibleWindowConfig wc : this.mWindowConfigs) {
            s.putSetting(wc.settingKey, (Object)wc.visibleGetter.getAsBoolean());
        }
        s.save();
        File file = Settings.getConfigFileLoc((String)XML_DOCKING_LAYOUT, (Settings.Type)Settings.Type.User);
        if (file != null) {
            try {
                CDockFrontend frontend = this.mDockControl.intern();
                ArrayList<CDockable> noSave = new ArrayList<CDockable>();
                for (int i = 0; i < this.mDockControl.getCDockableCount(); ++i) {
                    CDockable d = this.mDockControl.getCDockable(i);
                    if (!frontend.isHidden((Dockable)d.intern())) continue;
                    noSave.add(d);
                }
                for (CDockable d : noSave) {
                    this.mDockControl.intern().remove((Dockable)d.intern());
                }
                this.mDockControl.writeXML(file);
            }
            catch (IOException e) {
                ALog.logError((Throwable)e, (String)"Error saving docking layout.", (Object[])new Object[0]);
            }
        }
        this.mI18n.save();
    }

    protected void resetGuiSettings() {
        File guiSetting;
        File configDir = Settings.getUserConfDir();
        Settings s = Settings.getSettings((String)"GUI");
        s.removeAll(Settings.Type.User);
        File dockSetting = new File(configDir, XML_DOCKING_LAYOUT);
        if (dockSetting.isFile() && !dockSetting.delete()) {
            ALog.logWarn((String)"Unable to delete GUI settings file '%s'.", (Object[])new Object[]{dockSetting.getAbsolutePath()});
        }
        if ((guiSetting = new File(configDir, s.getSettingsFileName())).isFile() && !guiSetting.delete()) {
            ALog.logWarn((String)"Unable to delete GUI settings file '%s'.", (Object[])new Object[]{guiSetting.getAbsolutePath()});
        }
        ArrayList<CDockable> docks = new ArrayList<CDockable>();
        for (int i = 0; i < this.mDockControl.getCDockableCount(); ++i) {
            docks.add(this.mDockControl.getCDockable(i));
        }
        for (CDockable delete : docks) {
            this.mDockControl.removeSingleDockable(((DefaultSingleCDockable)delete).getUniqueId());
        }
        this.deployDockingUI();
        this.restoreSettings();
    }

    protected void saveGuiSettings(File path) {
        Settings s = Settings.getSettings((String)"GUI");
        s.putSetting("MainFrameBounds", (Object)this.mMainFrame.getBounds());
        for (VisibleWindowConfig wc : this.mWindowConfigs) {
            s.putSetting(wc.settingKey, (Object)wc.visibleGetter.getAsBoolean());
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path.getAbsolutePath()));){
            ZipEntry ze = new ZipEntry(XML_DOCKING_LAYOUT);
            File dockFile = File.createTempFile("OrbitDocking", ".xml");
            zos.putNextEntry(ze);
            this.mDockControl.writeXML(dockFile);
            zos.write(Files.readAllBytes(dockFile.toPath()));
            zos.closeEntry();
            ze = new ZipEntry(s.getSettingsFileName());
            zos.putNextEntry(ze);
            s.save(Settings.Type.User, (OutputStream)zos);
            zos.closeEntry();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Cannot save GUI settings to '%s'", (Object[])new Object[]{path});
        }
    }

    protected void loadGuiSettings(File path) {
        File guiSetting;
        File configDir = Settings.getUserConfDir();
        Settings s = Settings.getSettings((String)"GUI");
        File dockSetting = new File(configDir, XML_DOCKING_LAYOUT);
        if (dockSetting.isFile() && !dockSetting.delete()) {
            ALog.logWarn((String)"Unable to delete GUI settings file '%s'.", (Object[])new Object[]{dockSetting.getAbsolutePath()});
        }
        if ((guiSetting = new File(configDir, s.getSettingsFileName())).isFile() && !guiSetting.delete()) {
            ALog.logWarn((String)"Unable to delete GUI settings file '%s'.", (Object[])new Object[]{guiSetting.getAbsolutePath()});
        }
        try (ZipFile zf = new ZipFile(path.getAbsolutePath());){
            ZipEntry dockFile = zf.getEntry(XML_DOCKING_LAYOUT);
            try (InputStream in = zf.getInputStream(dockFile);){
                Files.copy(in, dockSetting.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            ZipEntry guiFile = zf.getEntry(s.getSettingsFileName());
            try (InputStream in = zf.getInputStream(guiFile);){
                s.read(Settings.Type.User, in);
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Cannot save GUI settings to '%s'", (Object[])new Object[]{path});
        }
        ArrayList<CDockable> docks = new ArrayList<CDockable>();
        for (int i = 0; i < this.mDockControl.getCDockableCount(); ++i) {
            docks.add(this.mDockControl.getCDockable(i));
        }
        for (CDockable delete : docks) {
            this.mDockControl.removeSingleDockable(((DefaultSingleCDockable)delete).getUniqueId());
        }
        this.deployDockingUI();
        this.restoreSettings();
    }

    private void restoreVisibleWindowSetting(boolean fromXML) {
        Settings s = Settings.getSettings((String)"GUI");
        for (VisibleWindowConfig wc : this.mWindowConfigs) {
            Boolean b = wc.defaultVisible != null ? (Boolean)s.getSetting(wc.settingKey, (Object)wc.defaultVisible) : (Boolean)s.getSettingOfClass(wc.settingKey, Boolean.class);
            if (b == null) continue;
            wc.setVisible(b, fromXML);
        }
        ViewOptionsPanel.setPanelVisible(Boolean.parseBoolean((String)s.getSetting(ViewOptionsPanel.SettingNameVisible, (Object)"true")), fromXML);
        InteractiveSelectionUI.setPanelVisible(Boolean.parseBoolean((String)s.getSetting("SelectDockPanelVisible", (Object)"true")), fromXML);
    }

    public void restoreSettings() {
        String scriptPath;
        String f;
        Settings s;
        Rectangle r;
        File file = Settings.getConfigFileLoc((String)XML_DOCKING_LAYOUT, (Settings.Type)Settings.Type.User);
        boolean fromXML = false;
        if (file != null && file.exists()) {
            fromXML = true;
        } else {
            file = Settings.findConfigFile((String)"DefaultDockingLayout.xml");
        }
        if (file != null && file.exists()) {
            try {
                this.mDockControl.readXML(file);
            }
            catch (Throwable e) {
                ALog.logWarn((Throwable)e, (String)"Error loading docking layout.", (Object[])new Object[0]);
                this.initDockingUI();
            }
        }
        if ((r = (Rectangle)(s = Settings.getSettings((String)"GUI")).getSettingOfClass("MainFrameBounds", Rectangle.class)) == null) {
            r = new Rectangle(600, 500);
        }
        this.mMainFrame.setBounds(r);
        this.restoreVisibleWindowSetting(fromXML);
        this.mRecentDesigns.clear();
        Settings mruSettings = Settings.getSettings((String)"MRU");
        int i = 0;
        while ((f = (String)mruSettings.getSettingOfClass("File" + i, String.class)) != null) {
            String base64 = (String)mruSettings.getSettingOfClass("DesignSnapshot" + i, String.class);
            RecentDesignFile rf = new RecentDesignFile(new File(f).getAbsoluteFile());
            if (AFile.isFileReadable((File)rf.file)) {
                rf.image = base64;
                this.mRecentDesigns.add(rf);
            }
            ++i;
        }
        this.mRecentScripts.clear();
        Settings mruScriptSettings = Settings.getSettings((String)"MRUScripts");
        int i2 = 0;
        while ((scriptPath = (String)mruScriptSettings.getSettingOfClass("File" + i2, String.class)) != null) {
            if (AFile.isFileReadable((String)scriptPath)) {
                this.mRecentScripts.add(scriptPath);
            }
            ++i2;
        }
        FlowWS.restoreSettings();
        if (this.mViewMgr.mStartPage != null) {
            this.mViewMgr.mStartPage.reload();
        }
    }

    protected File getCustomConfig() {
        String customConfig = AUtil.getEnv((String)(OrbitGuiWS.class.getName() + ".config"));
        if (customConfig == null) {
            return null;
        }
        File f = new File(customConfig);
        if (f.isAbsolute()) {
            return f;
        }
        return Settings.findConfigFile((String)customConfig);
    }

    protected void loadToolBarConfig() {
        File file;
        String fn;
        String ACTIONS = "Actions";
        String MAINMENUBAR = "MainMenuBar";
        String TOOLBARS = "ToolBars";
        String mFileName = "OrbitGuiWS.xml";
        String cfgName = this.mApp.getProduct().getConfigName();
        if (cfgName != null && cfgName.length() > 0 && Settings.findConfigFile((String)(fn = String.format("%sWS.xml", cfgName))) != null) {
            mFileName = fn;
        }
        if ((file = this.getCustomConfig()) == null) {
            file = Settings.findConfigFile((String)mFileName);
        } else {
            ALog.logInfo((String)"Using custom Orbit GUI configuration from '%s'.", (Object[])new Object[]{file.getPath()});
        }
        if (file == null) {
            return;
        }
        Element elDoc = AXDomUtil.getDocumentElement((File)file);
        if (elDoc == null) {
            return;
        }
        for (Element elAction : AXDomUtil.getElements((Element)elDoc, (String)"Actions/*")) {
            String tag = elAction.getTagName();
            if (tag.equals("CmdAction")) {
                String context = String.format("'%s' section '%s'", mFileName, "Actions");
                this.addCmdAction(elAction, context, "config.");
                continue;
            }
            ALog.logWarn((String)"Unknown element '%s' in '%s' section '%s', it is being ignored.", (Object[])new Object[]{tag, mFileName, "Actions"});
        }
        this.mMainMenuBar.addContainerListener(new OrbitContextMenuWS.DynamicBeautifyAdapter(this.mMainMenuBar));
        for (Element elTopMenu : AXDomUtil.getElements((Element)elDoc, (String)"MainMenuBar/Menu")) {
            String context = "the main menu bar";
            JMenuItem mi = this.loadMenuItem(elTopMenu, context);
            this.mMainMenuBar.add(mi);
            UIUtil.setUniqueMnemonic((JMenuBar)this.mMainMenuBar, (AbstractButton)mi);
        }
        for (Element elToolBar : AXDomUtil.getElements((Element)elDoc, (String)"ToolBars/ToolBar")) {
            this.loadToolBar(elToolBar);
        }
    }

    protected JToolBar loadToolBar(Element elToolBar) {
        String name = elToolBar.getAttribute("name");
        if (name == null) {
            ALog.logError((String)"Error loading ToolBar from configuration file, no 'name' attribute was specified.");
            return null;
        }
        JToolBar tb = this.mToolBars.get(name);
        if (tb == null) {
            tb = new JToolBar(name, 0);
            this.mToolBars.put(tb.getName(), tb);
        }
        for (Element el : AXDomUtil.getChildElems((Node)elToolBar)) {
            Action a;
            String type = el.getTagName();
            if (type.equals("Separator")) {
                if (ABoolean.fromString((String)el.getAttribute("prepend"))) {
                    tb.add(new TBSepPrepend());
                    continue;
                }
                tb.addSeparator();
                continue;
            }
            if (!type.equals("Action") || (a = this.loadToolBarAction(el, "Toolbar " + name)) == null) continue;
            JButton b = tb.add(a);
            UIUtil.makeToolBarButton((AbstractButton)b);
            String text = (String)a.getValue("Name");
            if (text == null) continue;
            b.setToolTipText(text);
        }
        return tb;
    }

    protected Action loadToolBarAction(Element el, String context) {
        String strAction = el.getAttribute("action");
        Action action = null;
        if (strAction != null && strAction.length() > 0) {
            Object o = Cp.getCp().eval(strAction);
            if (!(o instanceof Action)) {
                String failok = el.getAttribute("failok");
                if (!ABoolean.fromString((String)failok)) {
                    ALog.logError((String)"Error loading an Action for %s as the statement '%s' does not evaluate to an Action object.", (Object[])new Object[]{context, strAction});
                }
                return null;
            }
            action = (Action)o;
        }
        if (action == null) {
            return null;
        }
        this.readActionProps(action, el, "a ToolBar Action");
        return action;
    }

    protected void loadMenuItems(JMenu mParentMenu, Element elItemsParent, String context) {
        HashMap<Integer, JMenuItem> mnemonics = new HashMap<Integer, JMenuItem>();
        LinkedList<JMenuItem> needMnemoic = new LinkedList<JMenuItem>();
        for (Element elItem : AXDomUtil.getChildElems((Node)elItemsParent)) {
            String tag = elItem.getTagName();
            if (tag.equals("Separator")) {
                Component prev;
                int count = mParentMenu.getMenuComponentCount();
                if (count < 1 || (prev = mParentMenu.getMenuComponent(count - 1)) instanceof JSeparator) continue;
                mParentMenu.add(new JSeparator());
                continue;
            }
            JMenuItem mi = this.loadMenuItem(elItem, context);
            if (mi == null) continue;
            mParentMenu.add(mi);
            int mnemonic = mi.getMnemonic();
            if (mnemonic != 0) {
                mnemonics.put(mnemonic, mi);
                continue;
            }
            needMnemoic.add(mi);
        }
        for (JMenuItem mi : needMnemoic) {
            UIUtil.setUniqueMnemonic((JMenu)mParentMenu, (AbstractButton)mi);
        }
    }

    public JMenuItem loadMenuItem(Element elMenuItem, String context) {
        String tag = elMenuItem.getTagName();
        if (!tag.equals("Menu") && !tag.equals("MenuItem")) {
            return null;
        }
        String name = elMenuItem.getAttribute("name");
        String strAction = elMenuItem.getAttribute("action");
        Action action = null;
        if (strAction != null && strAction.length() > 0) {
            Object o = null;
            try {
                o = Cp.getCp().eval(strAction);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(o instanceof Action)) {
                String failok = elMenuItem.getAttribute("failok");
                if (!ABoolean.fromString((String)failok)) {
                    ALog.logError((String)"Error loading a '%s' in %s as the statement '%s' does not evaluate to an Action object.", (Object[])new Object[]{tag, context, strAction});
                    ALog.flogWarn((String)"Please check the application configuration. (Tools > Preferences > General > Configuration File > (Fill Empty as Default))", (Object[])new Object[0]);
                }
                return null;
            }
            action = (Action)o;
        }
        if (action == null) {
            action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
        }
        this.readActionProps(action, elMenuItem, context);
        JMenuItem menuItem = null;
        if (tag.equals("Menu")) {
            JMenu m = null;
            String dynCmd = elMenuItem.getAttribute("dynCmd");
            m = action instanceof AActionGroup ? ((AActionGroup)action).getJMenu() : (dynCmd == null || dynCmd.length() == 0 ? new ADynamicMenu(action) : new ScriptedDynamicMenu(action, dynCmd));
            String c2 = String.format("a menu named '%s' in %s", name, context);
            this.loadMenuItems(m, elMenuItem, c2);
            menuItem = m;
        } else {
            String type = elMenuItem.getAttribute("type");
            menuItem = type.equals("checkbox") ? new JCheckBoxMenuItem(action) : new JMenuItem(action);
        }
        menuItem.setIcon(UIUtil.getScaledIcon((Icon)menuItem.getIcon(), (int)16, (int)16));
        UIUtil.disableActionMapToParent((JMenuItem)menuItem);
        return menuItem;
    }

    public boolean installMenuItem(JMenuItem mi, String menuPath, boolean before) {
        JMenuBar menuBar;
        JFrame f = this.getMainFrame();
        JMenuBar jMenuBar = menuBar = f == null ? null : f.getJMenuBar();
        if (menuBar == null) {
            ALog.logError((String)"Unable to install menu item '%s', there is no main menu bar.", (Object[])new Object[]{mi.getText()});
            return false;
        }
        if (menuPath.equals("/")) {
            int idx = before ? 0 : menuBar.getMenuCount();
            menuBar.add((Component)mi, idx);
        } else {
            JMenu curMenu = null;
            AbstractButton menuItem = null;
            int menuItemIdx = -1;
            String[] path = menuPath.split("/");
            for (int curPathIdx = 0; curPathIdx < path.length; ++curPathIdx) {
                int i;
                boolean lastPathEnt;
                String curPathEnt = path[curPathIdx];
                if (curPathEnt.isEmpty()) continue;
                boolean bl = lastPathEnt = curPathIdx == path.length - 1;
                if (menuItem != null) {
                    ALog.logError((String)"Unable to install menu item '%s', the menu path '%s' is invalid for the main menu bar (menu item '%s' followed by additional path elements).", (Object[])new Object[]{mi.getText(), menuPath, menuItem.getText()});
                    return false;
                }
                boolean found = false;
                if (curMenu == null) {
                    for (i = 0; i < menuBar.getMenuCount(); ++i) {
                        JMenu menu = menuBar.getMenu(i);
                        if (menu == null || !curPathEnt.equals(menu.getText())) continue;
                        curMenu = menu;
                        found = true;
                        break;
                    }
                } else {
                    for (i = 0; i < curMenu.getItemCount(); ++i) {
                        JMenuItem curItem = curMenu.getItem(i);
                        if (curItem == null || !curPathEnt.equals(curItem.getText())) continue;
                        if (!lastPathEnt || menuPath.endsWith("/")) {
                            if (!(curItem instanceof JMenu)) {
                                ALog.logError((String)"Unable to install menu item '%s', the final entry '%s' in menu path '%s' is not a Menu entry as specified in the path.", (Object[])new Object[]{mi.getText(), curPathEnt, menuPath});
                                return false;
                            }
                            curMenu = (JMenu)curItem;
                        } else {
                            menuItem = curItem;
                            menuItemIdx = i;
                        }
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                ALog.logError((String)"Unable to install menu item '%s', the menu path '%s' does not exist in the main menu bar.", (Object[])new Object[]{mi.getText(), menuPath});
                return false;
            }
            if (curMenu == null) {
                ALog.logError((String)"Cannot find menu '%s' to insert menu item", (Object[])new Object[]{menuPath});
                return false;
            }
            if (menuItem == null) {
                if (before) {
                    curMenu.insert(mi, 0);
                } else {
                    curMenu.add((JMenuItem)menuItem);
                }
            } else if (before) {
                curMenu.insert(mi, menuItemIdx);
            } else {
                curMenu.insert(mi, menuItemIdx + 1);
            }
        }
        menuBar.revalidate();
        return true;
    }

    public void refreshTitles() {
        if (!this.mRefreshTitlesQueued) {
            this.mRefreshTitlesQueued = true;
            SwingUtilities.invokeLater(() -> {
                this.mRefreshTitlesQueued = false;
                this.mViewMgr.refreshTitles();
            });
        }
    }

    private void loadDefaultPrefixViewMenuItems(JMenu viewMenu) {
        List<Component> initViewItems = this.mMenu2DynViewItems.get(viewMenu);
        if (initViewItems == null) {
            initViewItems = new LinkedList<Component>();
            for (Component c : viewMenu.getMenuComponents()) {
                initViewItems.add(c);
            }
            this.mMenu2DynViewItems.put(viewMenu, initViewItems);
        }
        viewMenu.removeAll();
        for (Component c : initViewItems) {
            viewMenu.add(c);
        }
    }

    public void updateCurrentViewActions(JMenu viewMenu) {
        this.loadDefaultPrefixViewMenuItems(viewMenu);
        AAppView v = this.getCurrentView();
        if (v == null) {
            return;
        }
        if (viewMenu.getMenuComponentCount() > 0) {
            viewMenu.addSeparator();
        }
        for (JMenuItem item : v.getViewMenu()) {
            if (item == null) {
                viewMenu.addSeparator();
                continue;
            }
            UIUtil.disableActionMapToParent((JMenuItem)item);
            viewMenu.add(item);
        }
        this.getContextMenuWorkspace().beautify(viewMenu);
        viewMenu.addSeparator();
        if (!(v instanceof DesignView2D)) {
            return;
        }
        final DesignView2D v2d = (DesignView2D)v;
        JMenu infoViewMenu = new JMenu("Info View");
        final DesignCanvasInfoDisplay.Implementation curInfoView = DesignCanvasInfoDisplay.getManager().getInstalled(v2d);
        JRadioButtonMenuItem miNoInfoDisplay = new JRadioButtonMenuItem(new AbstractAction("None"){
            {
                super(arg0);
                if (curInfoView == null) {
                    this.putValue("SwingSelectedKey", true);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OrbitGuiWS.this.setCanvasInfoDisplay(v2d, null);
            }
        });
        infoViewMenu.add(miNoInfoDisplay);
        UIUtil.setUniqueMnemonic((JMenu)infoViewMenu, (AbstractButton)miNoInfoDisplay);
        for (final DesignCanvasInfoDisplay.Factory infoDisplayFactory : DesignCanvasInfoDisplay.getRegistry().getFactories()) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(new AbstractAction(){
                {
                    this.putValue("Name", infoDisplayFactory.getName());
                    if (curInfoView != null && curInfoView.getFactory() != null && curInfoView.getFactory().getClass().equals(infoDisplayFactory.getClass())) {
                        this.putValue("SwingSelectedKey", true);
                    }
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrbitGuiWS.this.setCanvasInfoDisplay(v2d, infoDisplayFactory);
                }
            });
            infoViewMenu.add(mi);
            UIUtil.setUniqueMnemonic((JMenu)infoViewMenu, (AbstractButton)mi);
        }
        if (infoViewMenu.getMenuComponentCount() > 1) {
            viewMenu.add(infoViewMenu);
            UIUtil.setUniqueMnemonic((JMenu)viewMenu, (AbstractButton)infoViewMenu);
        }
        if (OrbitGuiWS.extendedUIEnabled()) {
            JMenuItem m1;
            JMenu busView = new JMenu("Bus View");
            viewMenu.add(busView);
            UIUtil.setUniqueMnemonic((JMenu)viewMenu, (AbstractButton)busView);
            if (BusView.isActive()) {
                m1 = new JMenuItem("ReCalculate for Selected Devices");
                JMenuItem m2 = new JMenuItem("Close");
                m1.addActionListener(this.mBusViewShowAction);
                m2.addActionListener(this.mBusViewCloseAction);
                busView.add(m1);
                busView.add(m2);
                UIUtil.setUniqueMnemonic((JMenu)busView, (AbstractButton)m1);
                UIUtil.setUniqueMnemonic((JMenu)busView, (AbstractButton)m2);
            } else {
                m1 = new JMenuItem("Calculate for Selected Devices");
                m1.addActionListener(this.mBusViewShowAction);
                busView.add(m1);
                UIUtil.setUniqueMnemonic((JMenu)busView, (AbstractButton)m1);
            }
        }
        final DesignCanvas2D canvas = ((DesignView2D)v).getCanvas();
        final DesignCanvas2D.ViewDrawer curDrawer = canvas.getCurDrawer();
        JMenu viewSelector = new JMenu("View Type");
        for (final DesignCanvas2D.ViewDrawerFactory vdf : DesignCanvas2D.getViewDrawerRegistry().getAll()) {
            if (!vdf.isAvailable(canvas)) continue;
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(new AbstractAction(){
                {
                    this.putValue("Name", vdf.getName());
                    if (curDrawer.getName().equals(vdf.getName())) {
                        this.putValue("SwingSelectedKey", true);
                    }
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    canvas.setDrawer(vdf.create(canvas));
                }
            });
            viewSelector.add(mi);
            UIUtil.setUniqueMnemonic((JMenu)viewSelector, (AbstractButton)mi);
        }
        if (viewSelector.getMenuComponentCount() > 1) {
            viewMenu.add(viewSelector);
            UIUtil.setUniqueMnemonic((JMenu)viewMenu, (AbstractButton)viewSelector);
        }
        if (OrbitGuiWS.extendedUIEnabled()) {
            DesignMenuItem mi = new DesignMenuItem(this.mCreate3dView);
            viewMenu.add(mi);
            UIUtil.setUniqueMnemonic((JMenu)viewMenu, (AbstractButton)mi);
        }
    }

    public void updateRecentScripts(JMenu jmenu, String hint) {
        if ("prepareContents".equals(hint)) {
            jmenu.removeAll();
            for (int i = 0; i < this.mRecentScripts.size(); ++i) {
                String label = Integer.toHexString(i + 1).toUpperCase() + ":";
                JMenuItem mi = jmenu.add(new PlayScriptAction(label, this.mRecentScripts.get(i)));
                UIUtil.setUniqueMnemonic((JMenu)jmenu, (AbstractButton)mi);
            }
        } else if ("prepareItem".equals(hint)) {
            jmenu.setEnabled(!this.mRecentScripts.isEmpty());
        }
    }

    public void updateRecentFlows(JMenu jmenu, String hint) {
        this.mFlowWS.updateRecentFlows(jmenu, hint);
    }

    public void updateSnapshot(File f, String base64Image) {
        for (RecentDesignFile rf : this.mRecentDesigns) {
            if (!AUtil.equals((Object)rf.file, (Object)f)) continue;
            rf.image = base64Image;
            this.saveMRU();
        }
    }

    public void updateMRU(JMenu jmenu) {
        while (true) {
            int last;
            JMenuItem mi;
            if ((mi = jmenu.getItem(last = jmenu.getItemCount() - 1)) == null) {
                jmenu.remove(last);
                continue;
            }
            if (!(mi.getAction() instanceof OpenFileAction)) break;
            jmenu.remove(last);
        }
        if (!this.mRecentDesigns.isEmpty()) {
            jmenu.addSeparator();
        }
        int i = 1;
        for (RecentDesignFile rf : this.mRecentDesigns) {
            File f = rf.file;
            String prefix = Integer.toString(i);
            ++i;
            JMenuItem mi = jmenu.add(new OpenFileAction(prefix, f.getAbsolutePath()));
            mi.setToolTipText(f.getAbsolutePath());
            UIUtil.setUniqueMnemonic((JMenu)jmenu, (AbstractButton)mi);
        }
    }

    public void openDesign() {
        AFileChooser fc = new AFileChooser();
        fc.setFileFilter((FileFilter)OrbitIO.OIO_FILE_FILTER);
        if (fc.showOpenDialog((Component)this.mMainFrame) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        Cp.exec((String)"OrbitIO.openDesign(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)f)});
    }

    public boolean saveDesignAs() {
        return this.saveDesignAs(null);
    }

    public boolean saveDesignAs(MutableInteger userResponse) {
        Object o;
        int response;
        String userName;
        final Db db = OrbitIO.getCurDb();
        File curFile = db == null ? null : db.getFile();
        AFileChooser fc = new AFileChooser(){

            public void approveSelection() {
                this.addDefaultExtIfApplicable();
                File selectedFile = this.getSelectedFile();
                for (AAppView v : OrbitGuiWS.this.mViewMgr.getViews()) {
                    File viewFile;
                    File curSavedFile;
                    Db viewDb = v.getDb();
                    if (viewDb == db || (curSavedFile = db.getFile()) != null && curSavedFile.equals(selectedFile) || (viewFile = viewDb == null ? null : viewDb.getFile()) == null || !viewFile.equals(selectedFile)) continue;
                    String msg = String.format("Unable to overwrite file:\n  %s\nas another design in this %s session is already using it. Please choose a different file.", selectedFile, OrbitGuiWS.this.mApp.getName());
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, "File in Use", 0);
                    return;
                }
                super.approveSelection();
            }
        };
        fc.setFileFilter((FileFilter)OrbitIO.OIO_FILE_FILTER);
        if (curFile != null) {
            fc.setSelectedFile(curFile);
        }
        String string = userName = db == null ? null : db.getUserName();
        if (userName != null && userName.length() > 0) {
            fc.setDialogTitle(String.format("Save %s As", userName));
        }
        if ((response = fc.showSaveDialog((Component)this.mMainFrame)) != 0) {
            if (userResponse != null) {
                userResponse.setValue(response);
            }
            return false;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == OrbitIO.OIO_FILE_FILTER && !f.getName().contains(".")) {
            path = (String)path + ".oio";
        }
        if (Boolean.TRUE.equals(o = Cp.exec((String)"OrbitIO.saveCurrentDesignAs(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)path)}))) {
            this.addMRU(new File((String)path));
            this.refreshTitles();
            return true;
        }
        return false;
    }

    public void importOIO(DeviceTemplate.Type tx) {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = AclResources.OIO_FILE_FILTER;
        fc.setFileFilter((FileFilter)filter);
        if (fc.showOpenDialog((Component)this.mMainFrame) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.canRead()) {
            ALog.logError((String)"Unable to read '%s'.", (Object[])new Object[]{file.getAbsolutePath()});
            return;
        }
        OrbitDbReader.Scope scope = null;
        try (OrbitApp.ChangeWarningSilencer c = OrbitApp.suppressDbChangeMonitorWarnings();){
            scope = OrbitDbReader.readScope((String)file.getPath());
        }
        String scopeStr = scope == null ? null : scope.getScope();
        boolean res = false;
        if (scopeStr == null || scopeStr.length() == 0 || scopeStr.equalsIgnoreCase("Design")) {
            ALog.logInfo((String)"Importing complete Orbit design...");
            Object o = Cp.exec((String)"new OrbitDbReaderImport(curDb()).read(%s)", (Object[])new Object[]{Cp.getFileAsArgument((File)file)});
            if (!Boolean.TRUE.equals(o)) {
                ALog.logError((String)"Import failed.");
                return;
            }
            ALog.logInfo((String)"Import complete");
            res = true;
        } else {
            res = ImportDbUI.importOIO(file, scope, scopeStr);
        }
        if (!res) {
            return;
        }
        this.zoomFitCurrentView();
        DbExplorerPanel.refreshAll();
    }

    public void importUPD(DeviceTemplate.Type t) {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = new AFileFilter("upd", "UPD Files");
        fc.setFileFilter((FileFilter)filter);
        UPDImportOptionsPanel options = new UPDImportOptionsPanel(true, t);
        fc.setAccessory((JComponent)options);
        if (fc.showOpenDialog((Component)this.mMainFrame) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        Cp.exec((String)"OrbitIO.importUpd(%s, \"%s\", \"%s\", %s.%s)", (Object[])new Object[]{Cp.getFileAsArgument((File)f), options.getRootDeviceName(), options.getDeviceTemplatePrefix(), options.getTemplateType().getClass().getCanonicalName(), options.getTemplateType().name()});
        this.zoomFitCurrentView();
        DbExplorerPanel.refreshAll();
    }

    public void exportNetLengths() {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = AFileFilter.CSV;
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        NetLengthExportOptionsPanel options = new NetLengthExportOptionsPanel();
        fc.setAccessory((JComponent)options);
        if (fc.showSaveDialog((Component)this.mMainFrame) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
            path = (String)path + ".csv";
        }
        Cp.exec((String)"OrbitIO.exportNetLength(%s, %s, %s);", (Object[])new Object[]{Cp.getFileAsArgument((String)path), options.getJustSelected(), options.getOpenWhenFinished()});
    }

    public void exportNetMapping() {
        DevicePath pathExport;
        AFileChooser fc = new AFileChooser();
        NetMappingExportOptionsPanel options = new NetMappingExportOptionsPanel();
        fc.setAccessory((JComponent)options);
        if (fc.showSaveDialog((Component)this.mMainFrame) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (!f.getName().contains(".")) {
            path = options.isSelectedHTML() ? (String)path + ".html" : (String)path + ".csv";
        }
        if ((pathExport = options.getSelectedDevicePath()) == null) {
            return;
        }
        String childParam = OrbitGuiWS.toStringArrayParam(options.getSelectedChildDevices().iterator());
        Cp.exec((String)"OrbitIO.exportNetMapping(%s, \"%s\", %s, %s, %s, %b);", (Object[])new Object[]{Cp.getFileAsArgument((String)path), pathExport.toString(), childParam, options.isProducePicture(), options.isOpenHtmlImmediately(), options.isSelectedHTML()});
    }

    protected static String toStringArrayParam(Iterator<?> i) {
        StringBuilder param = new StringBuilder("new String[] {");
        boolean firstItem = true;
        while (i.hasNext()) {
            if (!firstItem) {
                param.append(",");
            } else {
                firstItem = false;
            }
            param.append("\"" + i.next().toString() + "\"");
        }
        param.append("}");
        return param.toString();
    }

    public void importSpeed(DeviceTemplate.Type t) {
        this.importSpeed(t, null);
    }

    public void importSpeed(DeviceTemplate.Type t, File initialFile) {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = new AFileFilter("spd", "Speed Files");
        fc.setFileFilter((FileFilter)filter);
        SpdImportOptionsPanel options = new SpdImportOptionsPanel(t);
        fc.setAccessory((JComponent)options);
        fc.setMinimumSize(fc.getPreferredSize());
        if (initialFile != null) {
            fc.setSelectedFile(initialFile);
        }
        if (fc.showOpenDialog((Component)this.mMainFrame) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        Cp.exec((String)"OrbitIO.importSpd(%s, \"%s\", \"%s\", %s.%s, \"%s\", \"%s\", \"%s\") ", (Object[])new Object[]{Cp.getFileAsArgument((File)f), options.getRootDeviceName(), options.getDeviceTemplatePrefix(), options.getTemplateType().getClass().getCanonicalName(), options.getTemplateType().name(), options.getSubstrateKeyStr(), Boolean.toString(options.isIgnoreLayerPrefix()), Boolean.toString(options.isIgnoreDielectric())});
        this.zoomFitCurrentView();
    }

    public void importAif(DeviceTemplate.Type t) {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = new AFileFilter("aif", "AIF Files");
        fc.setFileFilter((FileFilter)filter);
        if (fc.showOpenDialog((Component)this.mMainFrame) != 0) {
            return;
        }
        Cp.exec((String)"OrbitIO.importAIF(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)fc.getSelectedFile())});
        this.zoomFitCurrentView();
        DbExplorerPanel.refreshAll();
    }

    public void importLefDef() {
        LefDefUI.showDialog(OrbitIO.getMainWindow());
    }

    public static Action getCreateDesignAction() {
        AbstractAction a = new AbstractAction("New", UIUtil.getScaledIcon((Icon)OrbitIcons.NEW_FILE, (int)16, (int)16)){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrbitIO.getApp().createDesign();
            }
        };
        a.putValue("ShortDescription", "Create a new design");
        return a;
    }

    public static Action getOpenDesignAction() {
        AbstractAction a = new AbstractAction("Open", UIUtil.getScaledIcon((Icon)OrbitIcons.FILE_OPEN, (int)16, (int)16)){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrbitIO.getApp().getWorkspace().openDesign();
            }
        };
        a.putValue("ShortDescription", "Open a design");
        return a;
    }

    public static Action getSaveDesignAction() {
        AbstractAction a = new AbstractAction("Save", UIUtil.getScaledIcon((Icon)OrbitIcons.FILE_SAVE, (int)16, (int)16)){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"OrbitIO.saveCurrentDesign();", (Object[])new Object[0]);
            }
        };
        a.putValue("ShortDescription", "Save the current design");
        a.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Save Design"));
        return a;
    }

    public static Action getInteractiveSelectionModeAction() {
        return new AbstractAction("Interactive Select Mode", OrbitIcons.SELECT){

            @Override
            public void actionPerformed(ActionEvent e) {
                AAppView view = OrbitIO.getOrbitIO().getCurrentView();
                if (view == null) {
                    ALog.logWarn((String)"No current view, unable to switch to Interactive Select Mode.");
                    return;
                }
                Action a = view.getActions().get("InteractiveSelectMode");
                a.actionPerformed(e);
            }

            @Override
            public boolean isEnabled() {
                AAppView v = OrbitIO.getOrbitIO().getCurrentView();
                if (v == null) {
                    return false;
                }
                Action a = v.getActions().get("InteractiveSelectMode");
                if (a == null) {
                    return false;
                }
                return a.isEnabled();
            }
        };
    }

    public List<String> getRecentScripts() {
        return this.mRecentScripts;
    }

    public void addRecentScript(String script) {
        this.mRecentScripts.remove(script);
        this.mRecentScripts.push(script);
        while (this.mRecentScripts.size() > 16) {
            this.mRecentScripts.removeLast();
        }
        this.saveRecentScriptList();
    }

    protected void saveRecentScriptList() {
        Settings s = Settings.getSettings((String)"MRUScripts");
        s.removeAll(Settings.Type.User);
        for (int i = 0; i < this.mRecentScripts.size(); ++i) {
            s.putSetting("File" + i, (Object)this.mRecentScripts.get(i));
        }
        s.save();
    }

    public void sourceScript(String script) {
        this.addRecentScript(script);
        ALog.logDebug((String)"Starting script '%s'.", (Object[])new Object[]{script});
        Cp.exec((String)"Cp.source(\"%s\")", (Object[])new Object[]{script});
    }

    protected void updateSystemText(About about) {
        String text = this.mApp.getAppInfo();
        about.setScrollText(text);
    }

    protected void updateEnabledStates() {
        for (WeakReference weakReference : this.mDesignActions) {
            AbstractDesignAction da = (AbstractDesignAction)weakReference.get();
            if (da == null) {
                this.mDeadDesignActions.add(weakReference);
                continue;
            }
            boolean curEnabled = da.currentlyEnabled();
            if (da.isEnabled() == curEnabled) continue;
            da.setEnabled(curEnabled);
        }
        if (!this.mDeadDesignActions.isEmpty()) {
            for (WeakReference weakReference : this.mDeadDesignActions) {
                this.mDesignActions.remove(weakReference);
            }
            this.mDeadDesignActions.clear();
        }
    }

    protected void setupStatusListeners(AAppView oldView, AAppView newView) {
        DbHistory newHistory;
        DbHistory oldHistory;
        if (oldView != null && oldView.getDb() != null && (oldHistory = oldView.getDb().getHistory()) != null) {
            oldHistory.removeListener(this.mHistoryListener);
        }
        if (newView != null && newView.getDb() != null && (newHistory = newView.getDb().getHistory()) != null) {
            newHistory.addListener(this.mHistoryListener);
        }
    }

    protected void designViewChanged(AAppView newView) {
        this.mViewToolBar.resetViewActions(newView);
        this.mToolbarWS.resetView(newView);
        if (newView == null) {
            this.mViewToolBar.setVisible(false);
        } else if (!this.mViewToolBar.isVisible()) {
            this.mViewToolBar.setVisible(true);
        }
        this.mStatusBar.setStatusText("");
        if (this.mStatusCurView != null) {
            this.mStatusCurView.registerStatusListener(this.mStatusListener, false);
        }
        this.mStatusBar.removeViewStatusComponent();
        this.mStatusCurView = newView;
        if (newView == null) {
            Cp.exec((String)"OrbitIO.setCurrentDb(null)", (Object[])new Object[0]);
        } else {
            AAppView.ViewStatus viewStat;
            if (this.mApp.getCurrentDb() != newView.getDb()) {
                Cp.exec((String)"OrbitIO.setCurrentDb(\"%s\")", (Object[])new Object[]{this.mApp.getDbId(newView.getDb())});
            }
            if ((viewStat = newView.registerStatusListener(this.mStatusListener, true)) != null) {
                this.mStatusBar.setViewStatusComponent(viewStat);
            }
        }
        this.refreshAppTitle();
        if (newView instanceof DesignView2D) {
            DesignView2D.ViewMode newMode = ((DesignView2D)newView).getCurMode();
            if (newMode != null && this.mCurModeOptionPanel != null) {
                this.mCurModeOptionPanel.load(newMode.getOptionPanel());
            }
        } else if (this.mCurModeOptionPanel != null) {
            this.mCurModeOptionPanel.clear();
        }
    }

    public void refreshAppTitle() {
        String newAppTitle;
        if (this.mMainFrame == null) {
            return;
        }
        AAppView view = this.getCurrentView();
        String curAppTitle = this.mMainFrame.getTitle();
        String string = newAppTitle = view == null ? String.format("%s %s (%s)", this.mApp.getName(true), this.mApp.getVersion(), new SimpleDateFormat("M/d/yyyy").format(this.mApp.getBuildTimestamp())) : String.format("%s - %s", this.mApp.getName(true), view.getTitle());
        if (!curAppTitle.equals(newAppTitle)) {
            this.mMainFrame.setTitle(newAppTitle);
        }
    }

    public void refreshStartPage() {
        if (this.mViewMgr.mStartPage != null) {
            this.mViewMgr.mStartPage.reload();
        }
    }

    public static boolean extendedUIEnabled() {
        return System.getProperty(ENABLE_EXTENDED_UI) != null || AApp.getApp() != null && AApp.getApp().hasEnv(OrbitIOEnv.UI_EXTENDED);
    }

    protected void initStandardActions() {
        this.mActions.put("Undo", new UndoAction());
        this.mActions.put("Redo", new RedoAction());
        for (VisibleWindowConfig wc : this.mWindowConfigs) {
            this.mActions.put(wc.actionMapKey, wc);
        }
        this.mActions.put("StartInteractiveSelectMode", OrbitGuiWS.getInteractiveSelectionModeAction());
        this.mActions.put("PlayScript", this.mPlayScript);
        this.mActions.put("RecordScript", this.mRecordScript);
        this.mActions.put("OpenFlow", this.mFlowWS.getActionOpenFlow());
        this.mActions.put("ShowAbout", this.mAbout);
        this.mActions.put("ResetGuiSetting", this.mResetSettingAction);
        this.mActions.put("LoadGuiSetting", this.mLoadSettingAction);
        this.mActions.put("SaveGuiSetting", this.mSaveSettingAction);
    }

    public Action getAction(String name) {
        return (Action)this.mActions.get(name);
    }

    protected void readActionProps(Action a, Element e, String context) {
        Icon i;
        String s = e.getAttribute("name");
        if (s != null && s.length() > 0) {
            a.putValue("Name", s);
            a.putValue(ACTIONPROPKEY_NAME, s);
        }
        if ((s = e.getAttribute("text")) != null && s.length() > 0) {
            a.putValue("Name", s);
        }
        if ((s = e.getAttribute("desc")) != null && s.length() > 0) {
            a.putValue("ShortDescription", s);
        }
        if ((s = e.getAttribute("iconSmall")) != null && s.length() > 0) {
            i = UIUtil.getIcon(OrbitIO.class, (String)s);
            if (i != null) {
                a.putValue("SmallIcon", i);
            } else {
                ALog.logWarn((String)"The small icon '%s' specified for an Action definition for %s could not be found, no small icon is being used.", (Object[])new Object[]{s, context});
            }
        }
        if ((s = e.getAttribute("iconLarge")) != null && s.length() > 0) {
            i = UIUtil.getIcon(OrbitIO.class, (String)s);
            if (i != null) {
                a.putValue("SwingLargeIconKey", i);
            } else {
                ALog.logWarn((String)"The large icon '%s' specified for an Action definition for %s could not be found, no large icon is being used.", (Object[])new Object[]{s, context});
            }
        }
        if ((s = e.getAttribute("mnemonic")) != null && s.length() > 0) {
            Object o = Cp.getCp().eval(s);
            if (o != null && Integer.class.isAssignableFrom(o.getClass())) {
                a.putValue("MnemonicKey", o);
            } else {
                ALog.logWarn((String)"The mnemonic '%s' specified for an Action definition for %s does not evaluate to a KeyCode (integer).", (Object[])new Object[]{s, context});
            }
        }
        if ((s = e.getAttribute("prepend")) != null && ABoolean.fromString((String)s)) {
            a.putValue(ACTIONPROPKEY_PREPEND, true);
        }
    }

    public void addCmdAction(Element elCmdAction, String context, String prefix) {
        String iconKey;
        String record;
        Object o;
        Object name = elCmdAction.getAttribute("name");
        if (name == null || ((String)name).length() == 0) {
            ALog.logWarn((String)"The following CmdAction action definition in '%s' has no name, it is being ignored: \n%s", (Object[])new Object[]{context, AXDomUtil.serialize((Node)elCmdAction)});
            return;
        }
        String prereq = elCmdAction.getAttribute("prereq");
        if (!(prereq == null || prereq.isEmpty() || (o = Cp.getCp().eval(prereq)) instanceof Boolean && Boolean.TRUE.equals(o))) {
            return;
        }
        if (prefix != null && prefix.length() > 0) {
            name = prefix + (String)name;
        }
        if (this.mActions.containsKey(name)) {
            ALog.logWarn((String)"An Action named '%s' is defined in '%s', however an Action with that name is already defined, the new Action is being ignored.", (Object[])new Object[]{name, context});
            return;
        }
        String cmd = elCmdAction.getAttribute("cmd");
        if (cmd == null || cmd.length() == 0) {
            ALog.logWarn((String)"The CmdAction action definition '%s' in '%s' has no cmd specified, it is being ignored.", (Object[])new Object[]{name, context});
            return;
        }
        CpCmdAction a = new CpCmdAction((String)name, cmd);
        a.setText(elCmdAction.getAttribute("text"));
        String context2 = String.format("'%s' in '%s'", name, context);
        this.readActionProps(a, elCmdAction, context2);
        String dnd = elCmdAction.getAttribute("dnd");
        if (ABoolean.fromString((String)dnd)) {
            a.setDisableIfNoDesign(true);
        }
        if (ABoolean.fromString((String)(record = elCmdAction.getAttribute("record")))) {
            a.setRecord(true);
        }
        if (UIManager.getIcon(iconKey = elCmdAction.getAttribute("iconKey")) != null) {
            a.putValue("SmallIcon", UIUtil.getScaledIcon((Icon)UIManager.getIcon(iconKey), (int)16, (int)16));
        }
        this.mActions.put((String)name, a);
    }

    protected void enableShortcutKeys() {
        JComponent contentPane = (JComponent)this.mMainFrame.getContentPane();
        contentPane.registerKeyboardAction(this.mFocusGuiCmdLine, "" + this.mFocusGuiCmdLine.getValue("Name"), KeyStroke.getKeyStroke(192, 512), 1);
        ActionMap am = contentPane.getActionMap();
        InputMap im = contentPane.getInputMap(1);
        am.put(this.mViewCloser.getValue("Name"), this.mViewCloser);
        im.put(OrbitHotkey.getKeyStroke((String)this.mViewCloser.getValue("Name")), this.mViewCloser.getValue("Name"));
        am.put("Next View", new ViewSwitcher(1));
        im.put(OrbitHotkey.getKeyStroke("Next View"), "Next View");
        am.put("Previous View", new ViewSwitcher(-1));
        im.put(OrbitHotkey.getKeyStroke("Previous View"), "Previous View");
    }

    protected boolean confirmExit() {
        MutableBoolean result = new MutableBoolean(false);
        String msg = String.format("Exit %s?", this.mApp.getName());
        Object qio = UIManager.getDefaults().get("OptionPane.questionIcon");
        Icon icon = qio instanceof Icon ? (Icon)qio : null;
        final JButton btnOk = new JButton("Yes");
        btnOk.setMnemonic('y');
        JButton btnCancel = new JButton("No");
        btnCancel.setMnemonic('n');
        JDialog dlg = new JDialog(this.mMainFrame, Dialog.ModalityType.APPLICATION_MODAL){

            @Override
            public void addNotify() {
                super.addNotify();
                btnOk.requestFocus();
            }
        };
        dlg.setDefaultCloseOperation(2);
        dlg.setTitle("Confirm Exit");
        GridBagManager l = GridBagManager.layout((JDialog)dlg);
        if (icon != null) {
            l.add((Component)new JLabel(icon));
        }
        l.addNl(msg);
        JCheckBox cbNoPrompt = (JCheckBox)l.addNl((Component)new JCheckBox("Always exit without prompt"), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        l.pushFillXRemainX();
        l.addFillX();
        l.add((Component)btnOk);
        l.add((Component)btnCancel);
        l.pop();
        btnOk.addActionListener(e -> {
            result.setValue(true);
            if (cbNoPrompt.isSelected()) {
                Settings s = Settings.getSettings((String)"UserPreferences");
                s.putSetting("ConfirmAppClose", (Object)false);
                s.save();
            }
            UIUtil.closeWindow((Window)dlg);
        });
        btnCancel.addActionListener(e -> UIUtil.closeWindow((Window)dlg));
        dlg.pack();
        dlg.setResizable(false);
        UIUtil.center((Component)dlg, (boolean)true);
        UIUtil.enableEscapeClose((Window)dlg, (AbstractButton)btnCancel);
        dlg.setVisible(true);
        return result.getValue();
    }

    protected void setCanvasInfoDisplay(DesignView2D v2d, DesignCanvasInfoDisplay.Factory infoDisplayFactory) {
        if (infoDisplayFactory == null) {
            DesignCanvasInfoDisplay.getManager().uninstall(v2d);
        } else {
            DesignCanvasInfoDisplay.getManager().install(v2d, infoDisplayFactory);
        }
    }

    public static boolean shouldPrepend(Action a) {
        Object o = a.getValue(ACTIONPROPKEY_PREPEND);
        return o instanceof Boolean && (Boolean)o != false;
    }

    public static boolean shouldPrepend(AbstractButton b) {
        return OrbitGuiWS.shouldPrepend(b.getAction());
    }

    public void beautify(JComponent m) {
        this.mContextMenuWS.beautify(m);
    }

    public OrbitContextMenuWS getContextMenuWorkspace() {
        return this.mContextMenuWS;
    }

    public OrbitDockingToolBar getDockToolBar() {
        return this.mDockToolBar;
    }

    public void startGuiI18n() {
        JMenuBar menuBar = this.mMainFrame.getJMenuBar();
        OrbitGuiI18n.translate("workspace", menuBar);
    }

    static {
        boolean bl = $assertionsDisabled = !OrbitGuiWS.class.desiredAssertionStatus();
        if (OrbitApp.getApp().hasEnv(OrbitIOEnv.UI_THEME_INNOVUS)) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new InnovusLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException e) {
                ALog.logError((Throwable)e);
            }
        }
        DOCK_ID_CMD_MSG = OrbitGuiWS.class.getName() + ".MessagePanel";
        ACTIONPROPKEY_NAME = OrbitGuiWS.class.getName() + ".name";
        ACTIONPROPKEY_PREPEND = OrbitGuiWS.class.getName() + ".prepend";
        FLOWSTEPGRP = OrbitGuiWS.class.getName();
    }

    protected class ViewSwitcher
    extends AbstractAction {
        protected int mDir;

        public ViewSwitcher(int dir) {
            this.mDir = dir < 0 ? -1 : 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OrbitGuiWS.this.mViewMgr.switchView(this.mDir);
        }
    }

    public static class CpCmdAction
    extends AbstractAction {
        protected final String mCmd;
        protected boolean mDisableIfNoDesign = false;
        protected boolean mRecord = false;
        private String mUserText = "Cp Action";

        public CpCmdAction(String name, Icon icon, String cmd) {
            super(name, icon);
            this.mCmd = cmd;
        }

        public CpCmdAction(String name, String cmd) {
            this(name, null, cmd);
        }

        public CpCmdAction(String cmd) {
            this(null, null, cmd);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)this.mUserText);){
                Cp.exec((boolean)this.mRecord, (String)this.mCmd, (Object[])new Object[0]);
            }
        }

        public String getCmd() {
            return this.mCmd;
        }

        public void setDisableIfNoDesign(boolean f) {
            this.mDisableIfNoDesign = f;
        }

        public void setRecord(boolean f) {
            this.mRecord = f;
        }

        @Override
        public boolean isEnabled() {
            boolean b;
            if (!this.mDisableIfNoDesign) {
                return super.isEnabled();
            }
            boolean bl = b = Design.getDesign((Db)OrbitIO.getCurDb(), (boolean)false) != null;
            if (super.isEnabled() != b) {
                super.setEnabled(b);
            }
            return b;
        }

        public void setText(String text) {
            if (text != null) {
                this.mUserText = text;
            }
        }
    }

    public static class WSActionMap
    extends HashMap<String, Action> {
        @Override
        public Action put(String key, Action value) {
            Action old = super.put(key, value);
            if (old != null) {
                FlowStepRegistry.unregisterStep(FLOWSTEPGRP, key);
            }
            String getActionCmd = String.format("com.sigrity.orbit.OrbitIO.getApp().getWorkspace().getAction(\"%s\")", key);
            ActionBasedStep step = new ActionBasedStep();
            step.setGetActionScript(getActionCmd);
            FlowStepRegistry.registerStep(FLOWSTEPGRP, key, step);
            return old;
        }

        @Override
        public Action remove(Object key) {
            FlowStepRegistry.unregisterStep(FLOWSTEPGRP, (String)key);
            return (Action)super.remove(key);
        }

        @Override
        public void clear() {
            for (String name : this.keySet()) {
                this.remove(name);
            }
        }
    }

    protected class RedoAction
    extends AbstractDesignAction {
        public static final String BASENAME = "Redo";

        public RedoAction() {
            super(BASENAME, OrbitIcons.REDO);
        }

        @Override
        public boolean isEnabled() {
            DbHistory history;
            boolean enabled = super.currentlyEnabled();
            String name = BASENAME;
            AAppView v = OrbitGuiWS.this.getCurrentView();
            DbHistory dbHistory = history = v == null ? null : v.getDb().getHistory();
            if (history != null && history.canRedo()) {
                String txnName = history.getNextRedoName();
                if (txnName != null && txnName.length() > 0) {
                    name = String.format("%s %s", BASENAME, txnName);
                }
            } else {
                enabled = false;
            }
            this.putValue("Name", name);
            return enabled;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OrbitIO.getCurDb() == null) {
                return;
            }
            Cp.exec((String)"curDb().getHistory().redo()", (Object[])new Object[0]);
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }
    }

    protected class UndoAction
    extends AbstractDesignAction {
        public static final String BASENAME = "Undo";

        public UndoAction() {
            super(BASENAME, OrbitIcons.UNDO);
        }

        @Override
        public boolean isEnabled() {
            DbHistory history;
            boolean enabled = super.currentlyEnabled();
            String name = BASENAME;
            AAppView v = OrbitGuiWS.this.getCurrentView();
            DbHistory dbHistory = history = v == null ? null : v.getDb().getHistory();
            if (history != null && history.canUndo()) {
                String txnName = history.getNextUndoName();
                if (txnName != null && txnName.length() > 0) {
                    name = String.format("%s %s", BASENAME, txnName);
                }
            } else {
                enabled = false;
            }
            this.putValue("Name", name);
            return enabled;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OrbitIO.getCurDb() == null) {
                return;
            }
            Cp.exec((String)"curDb().getHistory().undo()", (Object[])new Object[0]);
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }
    }

    protected abstract class AbstractDesignAction
    extends AbstractAction {
        public AbstractDesignAction() {
            OrbitGuiWS.this.mDesignActions.add(new WeakReference<AbstractDesignAction>(this));
            this.setEnabled(this.isEnabled());
        }

        public AbstractDesignAction(String name, Icon icon) {
            super(name, icon);
            OrbitGuiWS.this.mDesignActions.add(new WeakReference<AbstractDesignAction>(this));
            this.setEnabled(this.isEnabled());
        }

        public AbstractDesignAction(String name) {
            super(name);
            OrbitGuiWS.this.mDesignActions.add(new WeakReference<AbstractDesignAction>(this));
            this.setEnabled(this.isEnabled());
        }

        public boolean currentlyEnabled() {
            return OrbitGuiWS.this.getCurrentView() != null;
        }
    }

    protected class DesignMenuItem
    extends JMenuItem
    implements ADynamicMenuItem {
        public DesignMenuItem() {
        }

        public DesignMenuItem(Action a) {
            super(a);
        }

        public DesignMenuItem(Icon icon) {
            super(icon);
        }

        public DesignMenuItem(String text, Icon icon) {
            super(text, icon);
        }

        public DesignMenuItem(String text, int mnemonic) {
            super(text, mnemonic);
        }

        public DesignMenuItem(String text) {
            super(text);
        }

        @Override
        public void prepareToDisplay() {
            this.setEnabled(OrbitGuiWS.this.getCurrentView() != null);
        }
    }

    static class VisibleWindowConfig
    extends AbstractAction {
        final String settingKey;
        final Boolean defaultVisible;
        final String actionMapKey;
        final String actionName;
        final BooleanSupplier visibleGetter;
        final Consumer<Boolean> visibleFromXMLSetter;
        final Consumer<Boolean> visibleSetter;

        VisibleWindowConfig(String settingKey, Boolean defaultVisible, String actionMapKey, String actionName, BooleanSupplier visibleGetter, Consumer<Boolean> visibleSetter, Consumer<Boolean> visibleFromXMLSetter) {
            super(actionName);
            this.settingKey = settingKey;
            this.defaultVisible = defaultVisible;
            this.actionMapKey = actionMapKey;
            this.actionName = actionName;
            this.visibleGetter = visibleGetter;
            this.visibleSetter = visibleSetter;
            this.visibleFromXMLSetter = visibleFromXMLSetter;
        }

        public void setVisible(boolean visible, boolean fromXML) {
            if (fromXML) {
                this.visibleFromXMLSetter.accept(visible);
            } else {
                this.visibleSetter.accept(visible);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.visibleSetter.accept(!this.visibleGetter.getAsBoolean());
        }

        @Override
        public boolean isEnabled() {
            this.putValue("SwingSelectedKey", this.visibleGetter.getAsBoolean());
            return true;
        }
    }

    protected class ScriptedDynamicMenu
    extends ADynamicMenu {
        protected String mCmdFmt;

        public ScriptedDynamicMenu(Action a, String cmdFmt) {
            super(a);
            this.mCmdFmt = cmdFmt;
        }

        @Override
        public void prepareToDisplay() {
            this.callScript("prepareItem");
        }

        @Override
        public void prepareToDisplayContents() {
            this.callScript("prepareContents");
        }

        protected void callScript(String hint) {
            hint = String.format("\"%s\"", hint);
            String var = "__jmenu";
            Cp cp = Cp.getCp();
            cp.setInterpreterValue("__jmenu", (Object)this);
            String cmd = MessageFormat.format(this.mCmdFmt, "__jmenu", hint);
            cp.eval(cmd);
            OrbitGuiWS.this.mContextMenuWS.light(this);
            cp.unsetInterpreterValue("__jmenu");
        }
    }

    private static class TBSepPrepend
    extends JToolBar.Separator {
        private TBSepPrepend() {
        }
    }

    protected class PlayScriptAction
    extends AbstractAction {
        protected String mScript;

        public PlayScriptAction(String prefix, String scriptPath) {
            this.mScript = scriptPath;
            String name = prefix + " " + scriptPath;
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = new File(this.mScript);
            if (!f.exists()) {
                ALog.logError((String)"The script '%s' does not exist.", (Object[])new Object[]{this.mScript});
                OrbitGuiWS.this.mRecentScripts.remove(this.mScript);
                return;
            }
            if (!f.canRead()) {
                ALog.logError((String)"The script '%s' cannot be read.", (Object[])new Object[]{this.mScript});
                OrbitGuiWS.this.mRecentScripts.remove(this.mScript);
                return;
            }
            OrbitGuiWS.this.addRecentScript(this.mScript);
            ALog.logDebug((String)"Starting script '%s'.", (Object[])new Object[]{f});
            Cp.exec((String)"Cp.source(%s)", (Object[])new Object[]{Cp.getFileAsArgument((String)this.mScript)});
        }
    }

    protected static class OpenFileAction
    extends AbstractAction {
        public static final int DISPLAY_MAXPATH_LEN = 80;
        protected String mPath;

        public OpenFileAction(String prefix, String path) {
            this.mPath = path;
            String displayPath = path;
            if (path.length() > 80) {
                displayPath = String.format("%s...%s", path.substring(0, 40), path.substring(path.length() - 40 + 1));
            }
            String name = prefix + " " + displayPath;
            this.putValue("Name", name);
            this.putValue("OrbitIOI18n.Disable", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"OrbitIO.openDesign(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)this.mPath)});
        }
    }

    public static interface OnDockClosed {
        public void closed();
    }

    protected static class OrbitSingleDockableFactory
    implements SingleCDockableFactory,
    Filter<String> {
        protected OrbitSingleDockableFactory() {
        }

        public boolean includes(String item) {
            return true;
        }

        public SingleCDockable createBackup(String id) {
            DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
            dockable.setLocation((CLocation)CLocation.base().normalWest(0.25));
            dockable.setCloseable(true);
            dockable.setMinimizable(false);
            dockable.setTitleIcon((Icon)new AColorIcon(0, 16, AColor.CLEAR, AColor.CLEAR));
            return dockable;
        }
    }

    public class OrbitViewMgr {
        protected DesignStartPanel mStartPage;
        protected ATabbedPane mTabs;
        protected HashMap<Component, AAppView> mComp2View = new HashMap();
        protected AAppView mCurView = null;
        protected AAppView mOpening = null;
        protected ChangeListener mChangeListener = this::processChangeEvent;
        protected ContainerListener mContainterListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                OrbitViewMgr.this.processChangeEvent(new ChangeEvent(e));
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                OrbitViewMgr.this.processChangeEvent(new ChangeEvent(e));
            }
        };

        public OrbitViewMgr() {
            this.mTabs = new ATabbedPane(){

                @Override
                public boolean closeTab(Component c) {
                    AAppView v = OrbitViewMgr.this.mComp2View.get(c);
                    if (v == null) {
                        return super.closeTab(c);
                    }
                    Boolean b = (Boolean)Cp.exec((String)"OrbitIO.closeDesign(\"%s\")", (Object[])new Object[]{OrbitGuiWS.this.mApp.getDbId(v.getDb())});
                    return Boolean.TRUE.equals(b);
                }
            };
            this.mTabs.setOpaque(false);
            this.mTabs.setPreferredSize(new Dimension(500, 400));
            this.mTabs.setTabLayoutPolicy(1);
            this.mTabs.getModel().addChangeListener(this.mChangeListener);
            this.mTabs.addContainerListener(this.mContainterListener);
            this.mTabs.setDefaultToClosable(true);
            DesignTabAdapter tabAdapter = new DesignTabAdapter(this.mTabs, this);
            this.mTabs.addMouseListener(tabAdapter);
            this.mTabs.addChangeListener(e -> this.setFocusToView());
            this.mTabs.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    OrbitViewMgr.this.setFocusToView();
                }
            });
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", evt -> {
                if (!(evt.getNewValue() instanceof Component)) {
                    return;
                }
                Component c = (Component)evt.getNewValue();
                if (c.getParent() == null || c.getParent().getParent() == null) {
                    return;
                }
                if (!((c = c.getParent().getParent()) instanceof Container)) {
                    return;
                }
                Container cn = (Container)c;
                if (cn.getComponentCount() < 1) {
                    return;
                }
                c = cn.getComponent(0);
                if (!(c instanceof Container)) {
                    return;
                }
                cn = (Container)c;
                if (cn.getComponentCount() < 1) {
                    return;
                }
                c = cn.getComponent(0);
                if (c.equals(this.mTabs)) {
                    EventQueue.invokeLater(() -> this.setFocusToView());
                }
            });
            if (AApp.getApp() != null && !AApp.getApp().hasEnv(OrbitIOEnv.UI_DISABLE_START_PAGE)) {
                this.mStartPage = new DesignStartPanel();
                this.mTabs.setDefaultToClosable(false);
                this.mTabs.addTab("Start Page", this.mStartPage);
                this.mTabs.setDefaultToClosable(true);
            }
        }

        protected void setFocusToView() {
            Component c = this.mTabs.getSelectedComponent();
            if (c instanceof DesignView2D) {
                ((DesignView2D)c).getCanvas().requestFocusInWindow();
            }
        }

        public void addView(AAppView v) {
            this.mOpening = v;
            this.mComp2View.put(v.getComponent(), v);
            this.mTabs.addTab(v.getTitle(), null, v.getComponent(), v.getDescription());
            int idx = this.mTabs.getTabCount() - 1;
            this.mTabs.getModel().setSelectedIndex(idx);
            if (v instanceof DesignView2D) {
                ((DesignView2D)v).addModeListener(new DesignView2D.ViewModeListener(){

                    @Override
                    public boolean settingMode(DesignView2D.ViewMode newMode) {
                        return true;
                    }

                    @Override
                    public void setMode(DesignView2D.ViewMode newMode) {
                        if (newMode != null && OrbitGuiWS.this.mCurModeOptionPanel != null) {
                            OrbitGuiWS.this.mCurModeOptionPanel.load(newMode.getOptionPanel());
                        }
                    }
                });
            }
        }

        public boolean activateView(AAppView v) {
            if (v == null) {
                return false;
            }
            for (int i = 0; i < this.mTabs.getTabCount(); ++i) {
                if (this.mComp2View.get(this.mTabs.getComponentAt(i)) != v) continue;
                this.mTabs.setSelectedIndex(i);
                return true;
            }
            return false;
        }

        public IterableIterator<AAppView> getViews() {
            return new IterableIterator<AAppView>(){
                int mCurTab;
                {
                    this.mCurTab = OrbitViewMgr.this.mStartPage == null ? 0 : 1;
                }

                public boolean hasNext() {
                    return OrbitViewMgr.this.mTabs.getTabCount() > this.mCurTab;
                }

                public AAppView next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return OrbitViewMgr.this.mComp2View.get(OrbitViewMgr.this.mTabs.getComponentAt(this.mCurTab++));
                }

                public void remove() {
                    try {
                        OrbitViewMgr.this.mTabs.remove(this.mCurTab - 1);
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IllegalStateException("Invalid view iterator state", e);
                    }
                }

                public Iterator<AAppView> iterator() {
                    return this;
                }
            };
        }

        public boolean close(AAppView v) {
            if (v == null) {
                return false;
            }
            IterableIterator<AAppView> itr = this.getViews();
            while (itr.hasNext()) {
                if (!((AAppView)itr.next()).equals(v)) continue;
                if (!OrbitGuiWS.this.fireViewClosing(v)) {
                    return false;
                }
                itr.remove();
                this.mComp2View.remove(v.getComponent());
                if (this.mStartPage != null) {
                    this.mStartPage.reload();
                }
                OrbitGuiWS.this.fireViewClosed(v);
                return true;
            }
            return false;
        }

        public AAppView getCurrentView() {
            int idx = this.mTabs.getModel().getSelectedIndex();
            if (idx < 0) {
                return null;
            }
            if (idx >= this.mTabs.getComponentCount()) {
                return null;
            }
            return this.mComp2View.get(this.mTabs.getComponentAt(idx));
        }

        public void refreshTitles() {
            for (int i = 0; i < this.mTabs.getTabCount(); ++i) {
                String newDesc;
                String oldDesc;
                String newTitle;
                AAppView view = this.mComp2View.get(this.mTabs.getComponentAt(i));
                if (view == null) continue;
                String oldTitle = this.mTabs.getTitleAt(i);
                if (!oldTitle.equals(newTitle = view.getTitle())) {
                    this.mTabs.setTitleAt(i, newTitle);
                    if (this.mTabs.getSelectedIndex() == i) {
                        this.processChangeEvent(new ChangeEvent(this.mTabs.getComponentAt(i)));
                    }
                }
                if (AUtil.equals((Object)(oldDesc = this.mTabs.getToolTipTextAt(i)), (Object)(newDesc = view.getDescription()))) continue;
                this.mTabs.setToolTipTextAt(i, newDesc);
            }
            OrbitGuiWS.this.refreshAppTitle();
        }

        public void switchView(int dir) {
            AAppView v;
            dir = dir >= 0 ? 1 : -1;
            int curIdx = this.mTabs.getSelectedIndex();
            if (curIdx < 0) {
                return;
            }
            int newIdx = curIdx + dir;
            if (newIdx >= this.mTabs.getTabCount()) {
                newIdx = 0;
            }
            if (newIdx < 0) {
                newIdx = this.mTabs.getTabCount() - 1;
            }
            if (newIdx != curIdx && (v = this.mComp2View.get(this.mTabs.getComponentAt(newIdx))) != null) {
                this.activateView(v);
            }
        }

        protected JComponent getComponent() {
            return this.mTabs;
        }

        protected void processChangeEvent(ChangeEvent e) {
            AAppView newView = this.getCurrentView();
            if (this.mOpening != null && this.mOpening == newView) {
                OrbitGuiWS.this.fireViewOpened(newView);
                this.mOpening = null;
            }
            if (newView == this.mCurView) {
                return;
            }
            AAppView oldView = this.mCurView;
            this.mCurView = this.getCurrentView();
            OrbitGuiWS.this.fireActiveViewChanged(oldView, this.mCurView);
        }
    }

    static class DesignTabAdapter
    extends MouseAdapter {
        private ATabbedPane tabbedPane;
        private OrbitViewMgr viewMgr;

        public DesignTabAdapter(ATabbedPane tabbedPane, OrbitViewMgr viewMgr) {
            this.tabbedPane = tabbedPane;
            this.viewMgr = viewMgr;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showContextMenu(e);
        }

        void showContextMenu(MouseEvent e) {
            boolean hasStartPanel;
            if (!e.isPopupTrigger()) {
                return;
            }
            int index = this.tabbedPane.getUI().tabForCoordinate(this.tabbedPane, e.getX(), e.getY());
            boolean bl = hasStartPanel = this.viewMgr.mStartPage != null;
            AAppView curView = hasStartPanel ? (index >= 1 ? (AAppView)this.viewMgr.getViews().skip((long)(index - 1)).findFirst().orElse(null) : null) : (AAppView)this.viewMgr.getViews().skip((long)index).findFirst().orElse(null);
            JPopupMenu menu = new JPopupMenu();
            if (curView != null) {
                JMenuItem close = new JMenuItem("Close");
                close.addActionListener(ae -> this.tabbedPane.removeTabAt(index));
                menu.add(close);
                JMenuItem closeAll = new JMenuItem("Close All");
                closeAll.addActionListener(ae -> {
                    ArrayList views = AUtil.arrayList(this.viewMgr.getViews());
                    for (AAppView v : views) {
                        OrbitIO.getApp().closeDesign(v.getDb());
                    }
                });
                menu.add(closeAll);
                JMenuItem closeOther = new JMenuItem("Close Other");
                closeOther.addActionListener(ae -> {
                    ArrayList views = AUtil.arrayList(this.viewMgr.getViews());
                    for (AAppView v : views) {
                        if (v == curView) continue;
                        OrbitIO.getApp().closeDesign(v.getDb());
                    }
                });
                menu.add(closeOther);
                menu.addSeparator();
                JMenuItem openContaining = new JMenuItem("Open Containing Folder");
                if (curView.getDb().getFile() != null) {
                    openContaining.addActionListener(ae -> AFileExplorer.browseFileDirectory((File)curView.getDb().getFile()));
                } else {
                    openContaining.setEnabled(false);
                }
                menu.add(openContaining);
            } else if (hasStartPanel) {
                JMenuItem refresh = new JMenuItem("Refresh Start Page");
                refresh.addActionListener(ae -> this.viewMgr.mStartPage.reload());
                menu.add(refresh);
            }
            Rectangle tabBounds = this.tabbedPane.getBoundsAt(index);
            OrbitIO.getGuiWorkspace().beautify(menu);
            menu.show(this.tabbedPane, tabBounds.x, tabBounds.y + tabBounds.height);
        }
    }

    private static class RecentDesignFile {
        final File file;
        String image;

        RecentDesignFile(File file) {
            this.file = file;
        }

        public int hashCode() {
            return Objects.hashCode(this.file);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecentDesignFile)) {
                return false;
            }
            RecentDesignFile rf = (RecentDesignFile)o;
            return AUtil.equals((Object)this.file, (Object)rf.file);
        }
    }
}

