/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppEnv;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;

public class OrbitHotkey {
    public static final String CMD_ZOOM_IN = "Zoom In";
    public static final String CMD_ZOOM_OUT = "Zoom Out";
    public static final String CMD_ZOOM_FIT = "Zoom Fit";
    public static final String CMD_ZOOM_SELECTED = "Zoom Selected";
    public static final String CMD_ZOOM_PREVIOUS = "Zoom Previous";
    public static final String CMD_ZOOM_NEXT = "Zoom Next";
    public static final String CMD_PAN_UP = "Pan Up";
    public static final String CMD_PAN_DOWN = "Pan Down";
    public static final String CMD_PAN_LEFT = "Pan Left";
    public static final String CMD_PAN_RIGHT = "Pan Right";
    public static final String CMD_CANVAS_FOCUS = "Focus Canvas";
    public static final String CMD_CANVAS_REFRESH = "Refresh";
    public static final String CMD_CANVAS_REFRESH_CACHE = "Force Refresh Cache";
    public static final String CMD_CANVAS_REFRESH_NOW = "Refresh Now";
    public static final String CMD_CANVAS_TOGGLE_SCROLLBARS = "Toggle ScrollBars";
    public static final String CMD_MODE_RULER = "RulerMode";
    public static final String CMD_MODE_INSPECT = "InspectMode";
    public static final String CMD_MODE_NAV = "NavigateMode";
    public static final String CMD_MODE_SELECT = "InteractiveSelectMode";
    public static final String CMD_MODE_EDITWIRE = "EditWireMode";
    public static final String CMD_MODE_MAKE_CONNECTIONS = "MakeConnectionsMode";
    public static final String CMD_MODE_PARTITION_CANCEL = "Partition Tool Mode Action Cancel";
    public static final String CMD_MODE_PARTITION_COMMIT = "Partition Tool Mode Action Commit";
    public static final String CMD_MODE_PARTITION_DELETE = "Partition Tool Mode Action Delete Segment";
    public static final String CMD_MODE_PARTITION_TOGGLE = "Partition Tool Mode Action Toggle Angle";
    public static final String CMD_MODE_GLOBBER_COMMIT = "Globber Mode Action Commit";
    public static final String CMD_MODE_GLOBBER_CANCEL = "Globber Mode Action Cancel";
    public static final String CMD_MODE_GLOBBER_DIFF = "Globber Mode Action Diff";
    public static final String CMD_MODE_GLOBBER_SQUISH = "Globber Mode Action Squish";
    public static final String CMD_MODE_GLOBBER_NEW = "Globber Mode Action New";
    public static final String CMD_MODE_MOVE_PLACEABLE_CANCEL = "Move Placeable Mode Action Cancel";
    public static final String CMD_EDIT_VIEWSETTINGS = "View Settings";
    public static final String CMD_CONNECTION_VISION = "Connection Vision";
    public static final String CMD_CLEAR_SELECTION = "Clear Selection";
    public static final String CMD_CLEAR_HIGHLIGHT = "Clear Highlight";
    public static final String CMD_CLEAR_SHOWME = "Clear ShowMe";
    public static final String CMD_CLEAR_RULER = "Clear Ruler";
    public static final String CMD_BUS_VIEW = "Bus View";
    public static final String CMD_SHOWME_SELECTED_DEVICES = "Show Me Selected Devices";
    public static final String CMD_SHOWME_SELECTED_PORTS = "Show Me Selected Ports";
    public static final String CMD_SNAPSHOT_TO_CLIPBOARD = "Snapshot To Clipboard";
    public static final String CMD_SPIT_H = "Split View Horiz";
    public static final String CMD_SPIT_V = "Split View Vert";
    public static final String CMD_SHOW_ACTIVE_KEYBINDINGS = "Show Active Key Bindings";
    public static final String CMD_SWAP_SELECTED_PINS = "SwapSelectedPins";
    public static final String CMD_MOVE_SELECTED_PINS = "Move Selected Pins";
    public static final String CMD_SWAP_SELECTED_DEVICES = "Swap Selected Devices";
    public static final String CMD_MOVE_SELECTED_DEVICES = "Move Selected Devices";
    public static final String CMD_SELECTION_DELETE = "Delete Selections";
    public static final String CMD_SAVE_DESIGN = "Save Design";
    public static final String CMD_CLOSE_CURRENT_VIEW = "Close Current View";
    public static final String CMD_NEXT_VIEW = "Next View";
    public static final String CMD_PREV_VIEW = "Previous View";
    public static final String CMD_UI_REFRESH = "UI Refresh";
    public static final String CMD_UI_SEARCH = "UI Search";
    public static final String CMD_UI_DETAIL = "UI Detail";
    public static final String CMD_UI_SELECTED = "UI Selected";
    public static final String CMD_UI_ZOOM = "UI Zoom";
    static OrbitHotkey sHotKey;
    private Map<String, String> mBindingMap = new HashMap<String, String>();
    private static final String COL_COMMAND = "Command";
    private static final String COL_BINDKEY = "BindingKey";

    private static OrbitHotkey getHotKey() {
        if (sHotKey == null) {
            sHotKey = new OrbitHotkey();
        }
        return sHotKey;
    }

    public static KeyStroke getKeyStroke(String action) {
        return OrbitHotkey.getHotKey().findBindingKey(action);
    }

    public static String getKeyStrokeStr(String cmdKey) {
        return OrbitHotkey.getHotKey().findBindingKeyStr(cmdKey);
    }

    private OrbitHotkey() {
        this.load();
    }

    private static String getConfigFileName() {
        if (AApp.getApp() != null && AApp.getApp().hasEnv(AAppEnv.UI_THEME_INNOVUS)) {
            return "InnovusHotkey.csv";
        }
        return "OrbitHotkey.csv";
    }

    private void load() {
        File hotkeyCsv = Settings.findConfigFile((String)new File("hotkey", OrbitHotkey.getConfigFileName()).getPath());
        if (hotkeyCsv == null || !hotkeyCsv.canRead()) {
            ALog.flogWarn((String)"Missing hotkey configuration", (Object[])new Object[0]);
            return;
        }
        try {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            CSVDocument csvDoc = parser2.parse(hotkeyCsv.getPath());
            for (int i = 0; i != csvDoc.getItemCount(); ++i) {
                this.loadItem(csvDoc, i);
            }
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logWarn((String)"Problems reading %s", (Object[])new Object[]{hotkeyCsv});
        }
    }

    private void loadItem(CSVDocument csvDoc, int index) {
        String cmdKey = csvDoc.getItemValue(index, COL_COMMAND);
        if (cmdKey == null || cmdKey.isBlank()) {
            return;
        }
        String bindPrefix = COL_BINDKEY.toLowerCase();
        for (String attr : csvDoc.getAttributeNames()) {
            String bindKey;
            if (!attr.startsWith(bindPrefix) || (bindKey = csvDoc.getItemValue(index, attr)) == null || bindKey.isBlank()) continue;
            KeyStroke stroke = KeyStroke.getKeyStroke(bindKey);
            if (stroke == null) {
                ALog.logWarn((String)"Unrecognizable bind hotkey '%s' to action '%s' in %s", (Object[])new Object[]{bindKey, cmdKey, csvDoc.getPath()});
                continue;
            }
            this.mBindingMap.put(cmdKey, bindKey);
        }
    }

    private KeyStroke findBindingKey(String cmdKey) {
        String key = this.mBindingMap.get(cmdKey);
        if (key == null) {
            return null;
        }
        return KeyStroke.getKeyStroke(key);
    }

    private String findBindingKeyStr(String cmdKey) {
        return this.mBindingMap.get(cmdKey);
    }
}

