/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.AFile;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DeviceRegionMap;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitDbReader;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.BgaDieTxtIO;
import com.sigrity.orbit.ui.ImportDbUI;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.DbObjectTransferable;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class OrbitMainFrame
extends JFrame {
    public OrbitMainFrame(String title) {
        super(title);
        this.setDropTarget(new DropTarget(this, new OMFDropTargetListener()));
    }

    public static List<File> textURIListToFileList(String data) {
        LinkedList<File> files = new LinkedList<File>();
        StringTokenizer t = new StringTokenizer(data, "\r\n");
        while (t.hasMoreTokens()) {
            String s = t.nextToken().trim();
            if (s.startsWith("#") || s.length() == 0) continue;
            try {
                URI uri = new URI(s);
                if (!uri.getScheme().equals("file")) continue;
                File file = new File(uri);
                files.add(file);
            }
            catch (Exception e) {
                ALog.logWarn((Throwable)e, (String)"Unexpected error while converting URIS to FileS during drag processing.", (Object[])new Object[0]);
            }
        }
        return files;
    }

    public boolean open(File file, boolean checkOnly) {
        if (!(file.isFile() && file.canRead() || file.isDirectory())) {
            return false;
        }
        String ext = AFile.getExtension((File)file);
        if (ext == null) {
            return false;
        }
        if (ext.equalsIgnoreCase("oio")) {
            String scopeStr;
            if (checkOnly) {
                return true;
            }
            OrbitDbReader.Scope scope = null;
            try (OrbitApp.ChangeWarningSilencer c = OrbitIO.suppressDbChangeMonitorWarnings();){
                scope = OrbitDbReader.readScope((String)file.getPath());
            }
            String string = scopeStr = scope == null ? null : scope.getScope();
            if (scopeStr == null || scopeStr.length() == 0 || scopeStr.equalsIgnoreCase("Design")) {
                Object o = Cp.exec((String)"OrbitIO.openDesign(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)file)});
                if (o instanceof Boolean) {
                    return (Boolean)o;
                }
                ALog.logWarn((String)("Unexpected return value from openDesign: " + o));
                return false;
            }
            boolean res = ImportDbUI.importOIO(file, scope, scopeStr);
            if (res) {
                OrbitIO.getApp().getWorkspace().zoomFitCurrentView();
                DbExplorerPanel.refreshAll();
            }
            return res;
        }
        if (ext.equalsIgnoreCase("ojs") || ext.equalsIgnoreCase("bsh") || ext.equalsIgnoreCase("tjs")) {
            if (!checkOnly) {
                OrbitIO.getApp().getWorkspace().sourceScript(file.getPath());
            }
            return true;
        }
        if (ext.equalsIgnoreCase("txt")) {
            if (checkOnly) {
                return true;
            }
            if (OrbitIO.getCurDesign() == null) {
                Cp.exec((String)"OrbitIO.getApp().createDesign()", (Object[])new Object[0]);
            }
            BgaDieTxtIO.showImportUI(null, file.getPath());
            return true;
        }
        if (ext.equalsIgnoreCase("flow")) {
            if (checkOnly) {
                return true;
            }
            ALog.logInfo((String)"Opening flow '%s'.", (Object[])new Object[]{file.getPath()});
            return OrbitIO.getApp().getWorkspace().getFlowWS().openFlow(file);
        }
        if (ext.equalsIgnoreCase("upd")) {
            if (checkOnly) {
                return true;
            }
            Design design = OrbitIO.getApp().createDesign().orElse(null);
            if (design == null) {
                ALog.logError((String)"Error creating a new design.");
                return false;
            }
            String name = file.getName();
            if ((name = name.substring(0, name.length() - ext.length())).endsWith(".")) {
                name = name.substring(0, name.length() - 1);
            }
            return (Boolean)Cp.exec((String)"OrbitIO.importUpd(\"%s\", \"%s\", \"\", null)", (Object[])new Object[]{file.getPath(), name});
        }
        if (ext.equalsIgnoreCase("aif")) {
            if (checkOnly) {
                return true;
            }
            Design design = OrbitIO.getApp().createDesign().orElse(null);
            if (design == null) {
                ALog.logError((String)"Error creating a new design.");
                return false;
            }
            Object res = Cp.exec((String)"OrbitIO.importAIF(\"%s\")", (Object[])new Object[]{file.getPath()});
            if (res instanceof Boolean) {
                return (Boolean)res;
            }
            ALog.logWarn((String)"Unexpected (non-boolean) return from OrbitIO.importAIF.");
            return false;
        }
        OrbitIO oio = OrbitIO.getApp();
        if (oio != null) {
            OrbitIO.FileHandler h = oio.getFileHandler("Open", file);
            if (h == null || !h.canHandle("Open", file)) {
                return false;
            }
            if (checkOnly) {
                return true;
            }
            return h.handle("Open", file);
        }
        return false;
    }

    protected class OMFDropTargetListener
    implements DropTargetListener {
        protected OMFDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.processDrag(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.processDrag(dtde);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.processDrag(dtde);
        }

        @Override
        public void dragExit(DropTargetEvent dtde) {
        }

        private void processNetDrop(DropTargetDropEvent dtde) {
            Transferable xferable = dtde.getTransferable();
            try {
                DbObjectTransferable.NetTransferable netTransferObj = (DbObjectTransferable.NetTransferable)xferable.getTransferData(DbObjectTransferable.NetTransferable.NetFlavor);
                if (netTransferObj != null) {
                    boolean resultDrop = (Boolean)Cp.exec((String)"com.sigrity.orbit.ui.SetPinNetUI.setPinNet(curDb(), \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{netTransferObj.getTargetPinPath(), netTransferObj.getTargetPinTemplate().getName(), netTransferObj.getDevicePath(), netTransferObj.getDbObject().getName()});
                    ALog.logInfo((String)(resultDrop ? " Pin '%s' of device template '%s' successfully assigned to net '%s'." : "Pin '%s' of device template '%s' not successfully assigned to net '%s'."), (Object[])new Object[]{netTransferObj.getTargetPinTemplate().getName(), netTransferObj.getTargetPinTemplate().getDeviceTemplate().getName(), netTransferObj.getDbObject().getName()});
                    DesignView2D mView = (DesignView2D)OrbitIO.getCurView();
                    DesignCanvas2D mCanvas = mView.getCanvas();
                    mCanvas.refreshNow();
                    DbExplorerPanel.refreshAll();
                    dtde.dropComplete(true);
                }
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error setting net on pin template.", (Object[])new Object[0]);
            }
        }

        private void processFileDrop(DropTargetDropEvent dtde) {
            String msg;
            int res;
            dtde.acceptDrop(1);
            List<File> droppedFiles = this.getFiles(dtde.getTransferable());
            if (droppedFiles == null) {
                return;
            }
            LinkedList<File> files = new LinkedList<File>();
            for (File file : droppedFiles) {
                if (OrbitMainFrame.this.open(file, true)) {
                    files.add(file);
                    continue;
                }
                ALog.logWarn((String)"The file '%s' is not recogized as a type that can be opened by dropping onto Orbit, it is being ignored.", (Object[])new Object[]{file.getPath()});
            }
            if (files.isEmpty()) {
                dtde.dropComplete(false);
                return;
            }
            if (files.size() > 1 && (res = JOptionPane.showConfirmDialog(OrbitMainFrame.this, msg = String.format("%d files dropped, do you want to open all of these files?", files.size()), "Open Multiple", 0, 3)) != 0) {
                dtde.dropComplete(true);
                return;
            }
            SwingUtilities.invokeLater(() -> {
                for (File file : files) {
                    OrbitMainFrame.this.open(file, false);
                }
            });
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable xferable = dtde.getTransferable();
            if (xferable.isDataFlavorSupported(DbObjectTransferable.NetTransferable.NetFlavor)) {
                this.processNetDrop(dtde);
            } else {
                this.processFileDrop(dtde);
            }
            dtde.dropComplete(true);
        }

        protected void processDrag(DropTargetDragEvent dtde) {
            Transferable xferable = dtde.getTransferable();
            if (xferable.isDataFlavorSupported(DbObjectTransferable.NetTransferable.NetFlavor)) {
                try {
                    DbObjectTransferable.NetTransferable netTransferObj = (DbObjectTransferable.NetTransferable)xferable.getTransferData(DbObjectTransferable.NetTransferable.NetFlavor);
                    if (netTransferObj != null) {
                        Point dropLocation = dtde.getLocation();
                        DesignView2D mView = (DesignView2D)OrbitIO.getCurView();
                        Db db = mView.getDb();
                        Design design = Design.getDesign((Db)db);
                        DesignCanvas2D mCanvas = mView.getCanvas();
                        Point canvasLoc = SwingUtilities.convertPoint(OrbitMainFrame.this, dropLocation, mCanvas);
                        APoint2D worldPoint = mView.getCanvas().getXForm().getWorldPt(canvasLoc);
                        ViewColorizer colorizer = mView.getColorizer();
                        DeviceRegionMap.ObjectFilter filter = new DeviceRegionMap.ObjectFilter();
                        filter.addDbClass(db.getDbClass(PortTemplate.class));
                        for (HierInst hierInst : design.getObjectsAt(worldPoint, filter)) {
                            DbObject dbo = hierInst.getDbObject();
                            DevicePath pinDevicePath = hierInst.getPath();
                            if (!(dbo instanceof PortTemplate) || !netTransferObj.getDevicePath().contains(pinDevicePath) || !colorizer.isVisible(pinDevicePath, dbo)) continue;
                            netTransferObj.setTargetPinPath(pinDevicePath);
                            netTransferObj.setTargetPinTemplate(((PortTemplate)dbo).getPinTemplate());
                            dtde.acceptDrag(dtde.getDropAction());
                            return;
                        }
                    }
                    dtde.rejectDrag();
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Error getting transfer data.", (Object[])new Object[0]);
                }
            } else {
                if (AApp.isOSX()) {
                    dtde.acceptDrag(1);
                    return;
                }
                List<File> files = this.getFiles(xferable);
                if (files == null || files.isEmpty()) {
                    dtde.rejectDrag();
                    return;
                }
                for (File file : files) {
                    if (OrbitMainFrame.this.open(file, true)) continue;
                    dtde.rejectDrag();
                    return;
                }
                dtde.acceptDrag(1);
            }
        }

        protected List<File> getFiles(Transferable transferable) {
            try {
                Object xferable;
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (xferable = transferable.getTransferData(DataFlavor.javaFileListFlavor)) != null) {
                    List files = (List)xferable;
                    return files;
                }
            }
            catch (Exception e) {
                ALog.logDebug((Throwable)e);
            }
            try {
                Object xferable;
                DataFlavor dfUris = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(dfUris) && (xferable = transferable.getTransferData(dfUris)) != null) {
                    String uris = (String)xferable;
                    return OrbitMainFrame.textURIListToFileList(uris);
                }
            }
            catch (Exception e) {
                ALog.logDebug((Throwable)e);
            }
            return Collections.emptyList();
        }
    }
}

