/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.AColor;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppEnv;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.ui.AMemStatusComponent;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.core.SelectionStatusWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class OrbitStatusBar
extends JToolBar {
    static final Color sStatusForeground = OrbitStatusBar.getForegroundColor();
    static final Color sStatusBackground = OrbitStatusBar.getBackgroundColor();
    static final Border STATUS_BORDER = BorderFactory.createMatteBorder(0, 1, 0, 0, sStatusForeground.darker());
    protected StatusDisplay mStatusDisplay;
    protected SelectionStatusWidget mSelStatWidget;
    protected AMemStatusComponent mMemStatus;
    protected JPanel mStatusHolder;
    protected JPanel mViewStatusHolder;
    protected JPanel mViewLocationHolder;
    protected JPanel mSelStatusHolder;
    protected JPanel mMemStatusHolder;

    private static Color getForegroundColor() {
        if (AApp.getApp() != null && AApp.getApp().hasEnv(AAppEnv.UI_THEME_INNOVUS)) {
            return UIManager.getColor("ToolBar.foreground");
        }
        return UIManager.getColor("ToolBar.background");
    }

    private static Color getBackgroundColor() {
        if (AApp.getApp() != null && AApp.getApp().hasEnv(AAppEnv.UI_THEME_INNOVUS)) {
            return UIManager.getColor("ToolBar.background");
        }
        return AColor.getComplementary((Color)sStatusForeground);
    }

    public OrbitStatusBar() {
        this.setFloatable(false);
        this.setRollover(true);
        this.setBackground(sStatusBackground);
        this.setLayout(new BoxLayout(this, 0));
        this.mStatusDisplay = new StatusDisplay();
        this.mStatusHolder = this.createHolder(300);
        this.mStatusHolder.setLayout(new BorderLayout());
        this.mStatusHolder.add((Component)this.mStatusDisplay, "Center");
        this.add(this.mStatusHolder);
        this.add(Box.createHorizontalGlue());
        this.mViewStatusHolder = this.createHolder(120);
        this.mViewStatusHolder.add(new JLabel(""));
        this.mViewStatusHolder.setToolTipText("Canvas information");
        this.add(this.mViewStatusHolder);
        this.mViewLocationHolder = this.createHolder(120);
        this.mViewLocationHolder.add(new JLabel(""));
        this.mViewLocationHolder.setToolTipText("Canvas location");
        this.add(this.mViewLocationHolder);
        this.mSelStatusHolder = this.createHolder(50);
        this.mSelStatWidget = new SelectionStatusWidget();
        GridBagManager selLayout = new GridBagManager((Container)this.mSelStatusHolder);
        this.mSelStatusHolder.setToolTipText("Show the number of selected objects");
        selLayout.add((Component)this.mSelStatWidget, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        selLayout.addFillX();
        this.add(this.mSelStatusHolder);
        this.mSelStatWidget.setVisible(false);
        this.mMemStatusHolder = this.createHolder(100);
        this.mMemStatus = new AMemStatusComponent();
        OrbitStatusBar.setStatusLook(this.mMemStatus);
        GridBagManager memLayout = new GridBagManager((Container)this.mMemStatusHolder);
        memLayout.add((Component)this.mMemStatus, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        this.add(this.mMemStatusHolder);
        this.mMemStatus.setVisible(false);
    }

    private JPanel createHolder(int width) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setOpaque(false);
        panel.setBorder(STATUS_BORDER);
        Dimension statDim = new Dimension(width, 18);
        panel.setPreferredSize(statDim);
        panel.setMinimumSize(statDim);
        return panel;
    }

    public void setStatusText(String text) {
        if (text == null || text.equals(this.mStatusDisplay.getText())) {
            return;
        }
        this.mStatusDisplay.setText(text);
    }

    public String getStatusText() {
        return this.mStatusDisplay.getText();
    }

    public void setStatusPercent(float percent) {
        this.mStatusDisplay.setStatusPercent(percent);
    }

    public void setViewStatusComponent(AAppView.ViewStatus viewStat) {
        JComponent viewComp = viewStat.getViewComponent();
        viewComp.setForeground(sStatusForeground);
        viewComp.setOpaque(false);
        viewComp.setBorder(BorderFactory.createEmptyBorder());
        this.mViewStatusHolder.setLayout(new BorderLayout());
        this.mViewStatusHolder.add((Component)viewComp, "Center");
        JComponent locComp = viewStat.getLocationComponent();
        locComp.setForeground(sStatusForeground);
        locComp.setOpaque(false);
        locComp.setBorder(BorderFactory.createEmptyBorder());
        this.mViewLocationHolder.setLayout(new BorderLayout());
        this.mViewLocationHolder.add((Component)locComp, "Center");
        this.validate();
        this.repaint();
    }

    public void removeViewStatusComponent() {
        this.mViewStatusHolder.removeAll();
        this.mViewLocationHolder.removeAll();
        this.validate();
        this.repaint();
    }

    public void setSelStatWidgetVisible(boolean visible) {
        this.mSelStatWidget.setVisible(visible);
        this.mSelStatusHolder.setVisible(visible);
        this.mSelStatusHolder.doLayout();
        this.validate();
        this.repaint();
    }

    public boolean getSelStatWidgetVisible() {
        return this.mSelStatWidget.isVisible();
    }

    public void setMemStatusVisible(boolean visible) {
        this.mMemStatus.setVisible(visible);
        this.mMemStatusHolder.setVisible(visible);
    }

    public boolean getMemStatusVisible() {
        return this.mMemStatus.isVisible();
    }

    public static void setStatusLook(JComponent c) {
        c.setBackground(sStatusBackground);
        c.setForeground(sStatusForeground);
        c.setBorder(BorderFactory.createLineBorder(sStatusBackground, 1));
    }

    public static class StatusDisplay
    extends JPanel {
        protected Color mStatusColor = AColor.withAlpha((Color)Color.WHITE, (int)64);
        protected float mPercent = -1.0f;
        protected JLabel mLabel;
        protected JProgressBar mProgress;

        public StatusDisplay() {
            GridBagManager l = new GridBagManager((Container)this);
            this.mLabel = new JLabel();
            this.mProgress = new JProgressBar();
            l.add((Component)this.mLabel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
            l.addFillX();
            l.add((Component)this.mProgress, (GridBagConstraints)GridBagManager.RIGHT.noInsets());
            this.mProgress.setPreferredSize(new Dimension(50, 18));
            this.mProgress.setVisible(false);
            this.mProgress.setStringPainted(true);
            this.setOpaque(false);
            this.setFocusable(false);
            OrbitStatusBar.setStatusLook(this.mLabel);
        }

        public String getText() {
            return this.mLabel.getText();
        }

        public void setText(String text) {
            this.mLabel.setText(text);
            this.validate();
            if (EventQueue.isDispatchThread()) {
                this.task();
            }
        }

        public void setStatusPercent(float percent) {
            float f = this.mPercent = this.isValidPercent(percent) ? percent : -1.0f;
            if (this.mPercent > 0.0f) {
                this.mProgress.setVisible(true);
                this.mProgress.setValue((int)(this.mPercent * 100.0f));
            } else {
                this.mProgress.setVisible(false);
            }
            this.validate();
            if (EventQueue.isDispatchThread()) {
                this.task();
            }
        }

        protected boolean isValidPercent(float f) {
            return f >= 0.0f && f <= 1.0f;
        }

        protected void task() {
            Runnable r = () -> this.paintImmediately(this.getVisibleRect());
            if (EventQueue.isDispatchThread()) {
                boolean isPainting = UIUtil.isPainting((JComponent)this);
                if (!isPainting) {
                    r.run();
                } else {
                    EventQueue.invokeLater(r);
                }
            } else {
                EventQueue.invokeLater(r);
            }
        }
    }
}

