/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import bibliothek.gui.dock.toolbar.CToolbarItem;
import com.sigrity.acl.AFileExplorer;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.ui.ADropDownAction;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class OrbitToolBarWS {
    private OrbitGuiWS mGuiWS;
    private JButton mBtnUndo;
    private JButton mBtnRedo;

    public OrbitToolBarWS(OrbitGuiWS ws) {
        this.mGuiWS = ws;
    }

    public void setupFileToolBar(CToolbarItem fileItem) {
        JToolBar bar = new JToolBar("File");
        bar.setOpaque(false);
        bar.setFloatable(false);
        bar.setBorderPainted(false);
        bar.setMargin(new Insets(0, 0, 0, 0));
        bar.setBorder(BorderFactory.createEmptyBorder());
        JButton btnOpen = new JButton(OrbitGuiWS.getOpenDesignAction());
        btnOpen.setIcon(OrbitIcons.FILE_OPEN);
        btnOpen.setText("");
        btnOpen.setToolTipText("Open");
        UIUtil.makeToolBarButton((AbstractButton)btnOpen);
        JButton btnNew = new JButton(OrbitGuiWS.getCreateDesignAction());
        btnNew.setIcon(OrbitIcons.NEW_FILE);
        btnNew.setText("");
        btnNew.setToolTipText("New");
        UIUtil.makeToolBarButton((AbstractButton)btnNew);
        JButton btnSave = new JButton(OrbitGuiWS.getSaveDesignAction());
        btnSave.setIcon(OrbitIcons.FILE_SAVE);
        btnSave.setText("");
        btnSave.setToolTipText("Save");
        UIUtil.makeToolBarButton((AbstractButton)btnSave);
        bar.add(btnNew);
        bar.add(btnOpen);
        JButton btnOpenRecent = ADropDownAction.makeButton((Action)new ActionShowRecentFileMenu(btnOpen), (AbstractButton)btnOpen);
        bar.add(btnOpenRecent);
        bar.add(btnSave);
        fileItem.setItem((Component)bar);
        fileItem.setVisible(true);
    }

    void setupEditToolBar(CToolbarItem editItem) {
        JToolBar bar = new JToolBar("Edit");
        bar.setOpaque(false);
        bar.setFloatable(false);
        bar.setBorderPainted(false);
        bar.setMargin(new Insets(0, 0, 0, 0));
        bar.setBorder(BorderFactory.createEmptyBorder());
        this.mBtnUndo = new JButton(OrbitIcons.UNDO);
        this.mBtnUndo.setEnabled(false);
        this.mBtnUndo.addActionListener(this.mGuiWS.getAction("Undo"));
        this.mBtnUndo.setText("");
        this.mBtnUndo.setToolTipText("Undo");
        UIUtil.makeToolBarButton((AbstractButton)this.mBtnUndo);
        this.mBtnRedo = new JButton(OrbitIcons.REDO);
        this.mBtnRedo.setEnabled(false);
        this.mBtnRedo.addActionListener(this.mGuiWS.getAction("Redo"));
        this.mBtnRedo.setToolTipText("Redo");
        this.mBtnRedo.setText("");
        UIUtil.makeToolBarButton((AbstractButton)this.mBtnRedo);
        bar.add(this.mBtnUndo);
        bar.add(this.mBtnRedo);
        editItem.setItem((Component)bar);
        editItem.setVisible(true);
    }

    void resetView(AAppView newView) {
        this.mBtnRedo.setEnabled(newView != null);
        this.mBtnUndo.setEnabled(newView != null);
    }

    static class ActionOpenContainingFolder
    extends AbstractAction {
        private final File file;

        ActionOpenContainingFolder(File f) {
            this.putValue("SmallIcon", UIUtil.getSystemIcon((File)f));
            this.file = f;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileExplorer.browseFileDirectory((File)this.file);
        }
    }

    private static class ActionShowRecentFileMenu
    extends AbstractAction {
        private AbstractButton mOri;

        public ActionShowRecentFileMenu(AbstractButton button) {
            super("", UIManager.getIcon("Table.decendingSortIcon"));
            if (UIManager.getIcon("Table.decendingSortIcon") == null) {
                this.putValue("Name", "\u25bc");
            }
            this.mOri = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu menu = new JPopupMenu();
            OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
            List<File> files = ws.getMostRecentUsedDesign();
            int index = 0;
            for (File f : files) {
                JMenuItem item = new JMenuItem(new OrbitGuiWS.OpenFileAction("", f.getAbsolutePath()));
                Object shortPath = f.getAbsolutePath();
                if (((String)shortPath).length() > 30) {
                    shortPath = ((String)shortPath).substring(0, 30) + "...";
                }
                item.setText(String.format("%d: %s [%s]", ++index, f.getName(), shortPath));
                item.setToolTipText(f.getAbsolutePath());
                menu.add(item);
            }
            ws.beautify(menu);
            menu.show(this.mOri, 0, this.mOri.getHeight());
        }
    }

    public static class SeparatorToolItem
    extends JButton {
        public SeparatorToolItem() {
            UIUtil.makeToolBarButton((AbstractButton)this);
            this.setText("\u22ee");
            Color c = UIManager.getColor("ToolBar.background");
            this.setForeground(c.darker());
            this.setRolloverEnabled(false);
            this.setEnabled(false);
        }
    }
}

