/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AAppView;
import com.sigrity.flowman.AbstractActionBasedStep;
import com.sigrity.flowman.Flow;
import com.sigrity.orbit.OrbitIO;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.w3c.dom.Element;

public class OrbitViewFlowStep
extends AbstractActionBasedStep {
    private static final String XATR_ACTIONKEY = "actionKey";
    protected String mActionKey = null;

    public OrbitViewFlowStep() {
    }

    public OrbitViewFlowStep(String actionKey) {
        this.mActionKey = actionKey;
    }

    public OrbitViewFlowStep(Flow flow, OrbitViewFlowStep src) {
        super(flow, src);
        this.mActionKey = src.mActionKey;
    }

    @Override
    public OrbitViewFlowStep copy(Flow toFlow) {
        return new OrbitViewFlowStep(toFlow, this);
    }

    @Override
    public boolean read(Element xe) {
        if (!super.read(xe)) {
            return false;
        }
        this.mActionKey = xe.getAttribute(XATR_ACTIONKEY);
        if (this.mActionKey == null || this.mActionKey.length() == 0) {
            ALog.logWarn((String)"No '%s' attribute is defined for the flow step '%s':\n%s", (Object[])new Object[]{XATR_ACTIONKEY, this.getName()});
            return false;
        }
        return true;
    }

    @Override
    public boolean write(Element xe) {
        if (!super.write(xe)) {
            return false;
        }
        xe.setAttribute(XATR_ACTIONKEY, this.mActionKey);
        return true;
    }

    @Override
    public Object getValue(String key) {
        Object val = super.getValue(key);
        if (val == null && key.equals("Name")) {
            return this.mActionKey;
        }
        return val;
    }

    @Override
    public Action getBaseAction() {
        if (this.mActionKey == null) {
            return null;
        }
        AAppView v = OrbitIO.getCurView();
        if (v == null) {
            return null;
        }
        ActionMap am = v.getActions();
        if (am == null) {
            return null;
        }
        return am.get(this.mActionKey);
    }
}

