/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import bibliothek.gui.dock.toolbar.CToolbarItem;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.ui.ADropDownAction;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitToolBarWS;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class OrbitViewToolBar
extends JToolBar {
    private static final AAppView VIRTUAL_VIEW = OrbitViewToolBar.createVirtualView();
    protected CToolbarItem mToolBarItem;

    private static DesignView2D createVirtualView() {
        Db db = new Db(new Db.Version(0, 0));
        Db.setNextDbId((long)db.getId());
        return new DesignView2D(db);
    }

    public OrbitViewToolBar(String name, int orientation) {
        super(name, orientation);
        this.setRollover(true);
        this.setFloatable(false);
    }

    void resetViewActions(AAppView v) {
        Action[] actions;
        this.removeAll();
        if (v == null) {
            v = VIRTUAL_VIEW;
        }
        Action[] actionArray = actions = v == null ? null : v.getToolBarActions().toArray(new Action[0]);
        if (actions == null || actions.length == 0) {
            return;
        }
        if (v != VIRTUAL_VIEW) {
            EventQueue.invokeLater(() -> {
                for (Component c : this.getComponents()) {
                    Action a;
                    if (!(c instanceof AbstractButton) || (a = ((AbstractButton)c).getAction()) == null) continue;
                    a.isEnabled();
                }
            });
        }
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            if (a == null) {
                OrbitToolBarWS.SeparatorToolItem sep = new OrbitToolBarWS.SeparatorToolItem();
                this.add(sep);
                continue;
            }
            String text = (String)a.getValue("Name");
            String buttonText = (String)a.getValue("ButtonText");
            if (buttonText == null) {
                buttonText = text;
            }
            JButton b = a instanceof DesignView2D.ViewModeAction && v instanceof DesignView2D ? this.createToggleActionComponent((DesignView2D.ViewModeAction)a, (DesignView2D)v) : this.createActionComponent(a);
            b.setAction(a);
            b.setToolTipText(buttonText);
            UIUtil.makeToolBarButton((AbstractButton)b);
            b.setEnabled(v != VIRTUAL_VIEW);
            this.add(b);
            JPopupMenu menu = (JPopupMenu)a.getValue("ButtonPopupMenu");
            if (menu == null) continue;
            JButton dropBtn = ADropDownAction.makeButton((JPopupMenu)menu, (AbstractButton)b);
            b.setEnabled(v != VIRTUAL_VIEW);
            this.add(dropBtn);
        }
        if (v instanceof DesignView2D) {
            OrbitToolBarWS.SeparatorToolItem sep = new OrbitToolBarWS.SeparatorToolItem();
            this.add(sep);
            DesignView2D.HighlightSlider s = ((DesignView2D)v).getHighlightSlider();
            s.setEnabled(v != VIRTUAL_VIEW);
            this.add(s);
            s.repaint();
        }
    }

    protected JToggleButton createToggleActionComponent(final DesignView2D.ViewModeAction a, final DesignView2D v) {
        JToggleButton b = new JToggleButton(){
            DesignView2D.ViewModeListener mViewModeListener = new DesignView2D.ViewModeListener(){

                @Override
                public boolean settingMode(DesignView2D.ViewMode newMode) {
                    return true;
                }

                @Override
                public void setMode(DesignView2D.ViewMode newMode) {
                    this.updateSelected(newMode);
                }
            };

            void updateSelected(DesignView2D.ViewMode curMode) {
                this.setSelected(a.isCurrentMode(curMode));
            }

            @Override
            public void addNotify() {
                super.addNotify();
                v.addModeListener(this.mViewModeListener);
                this.updateSelected(v.getCurMode());
            }

            @Override
            public void removeNotify() {
                v.removeModeListener(this.mViewModeListener);
                super.removeNotify();
            }
        };
        if (a != null && (a.getValue("SmallIcon") != null || a.getValue("SwingLargeIconKey") != null)) {
            b.setHideActionText(true);
        }
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        return b;
    }

    @Override
    public void setVisible(boolean e) {
        super.setVisible(true);
    }

    public void placeOnDockable(CToolbarItem viewItem) {
        this.mToolBarItem = viewItem;
        viewItem.setItem((Component)this);
        viewItem.setVisible(true);
        this.setOpaque(false);
        this.setFloatable(false);
        this.setBorderPainted(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.resetViewActions(null);
    }
}

