/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.geom.AArc;
import com.sigrity.acl.geom.ABezierCurve;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomWithCutouts;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOutlineGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.APolyline;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ShapeFactory;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class RegionShapeFactory {
    public static Rectangle2D getBufferView(DesignCanvas2D.XForm screenXform) {
        AAppView curView = OrbitIO.getCurView();
        if (curView instanceof DesignView2D) {
            DesignCanvas2D c2d = ((DesignView2D)curView).getCanvas();
            return c2d.getBufferBounds();
        }
        return screenXform.getScreen();
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, AGeom geom, AffineTransform xform, boolean outlineOnly) {
        if (geom == null) {
            return null;
        }
        Shape ans = null;
        if (geom instanceof ACircle) {
            ans = RegionShapeFactory.getShape(screenXform, (ACircle)geom, xform, outlineOnly);
        } else if (geom instanceof ARect) {
            ans = xform != null && 0 != (xform.getType() & 0x10) ? RegionShapeFactory.getShape(screenXform, geom.toPoly(), xform, outlineOnly) : RegionShapeFactory.getShape(screenXform, (ARect)geom, xform, outlineOnly);
        } else if (geom instanceof ALine) {
            ans = RegionShapeFactory.getShape(screenXform, (ALine)geom, xform);
        } else if (geom instanceof APolyline) {
            ans = RegionShapeFactory.getShape(screenXform, (APolyline)geom, xform);
        } else if (geom instanceof AArc) {
            ans = RegionShapeFactory.getShape(screenXform, (AArc)geom, xform);
        } else if (geom instanceof APath) {
            ans = RegionShapeFactory.getShape(screenXform, (APath)geom, xform);
        } else if (geom instanceof APolygon) {
            ans = RegionShapeFactory.getShape(screenXform, (APolygon)geom, xform, outlineOnly);
        } else if (geom instanceof AOutlineGeom) {
            ans = RegionShapeFactory.getShape(screenXform, (AOutlineGeom)geom, xform, outlineOnly);
        } else if (geom instanceof ACompositeGeom) {
            ans = RegionShapeFactory.getShape(screenXform, (ACompositeGeom)geom, xform, outlineOnly);
        } else if (geom instanceof AGeomWithCutouts) {
            ans = RegionShapeFactory.getShape(screenXform, (AGeomWithCutouts)geom, xform, outlineOnly);
        } else {
            ALog.logWarn((Throwable)new Exception(), (String)"Something draw failed at %s\n", (Object[])new Object[]{geom});
        }
        if (ans != null && !RegionShapeFactory.getBufferView(screenXform).intersects(ans.getBounds())) {
            return null;
        }
        return ans;
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, ACircle geom, AffineTransform xform, boolean outlineOnly) {
        if (screenXform.getScreenLength(geom.getR()) < 1) {
            APoint2D c = geom.getC().transform(xform);
            Point scrPoint = screenXform.getScreenPt(c);
            return new Rectangle2D.Double(scrPoint.x, scrPoint.y, 1.0, 1.0);
        }
        if (screenXform.getScreenLength(geom.getR()) < 2) {
            return RegionShapeFactory.getShape(screenXform, geom.getBounds(), xform, outlineOnly);
        }
        geom = geom.transform(xform);
        ARect bounds = geom.getBounds();
        int scrDiameter = screenXform.toScreenDist(geom.getD());
        Point scrPoint = screenXform.getScreenPt(bounds.getUL());
        return new Ellipse2D.Double(scrPoint.getX(), scrPoint.getY(), scrDiameter, scrDiameter);
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, APolygon geom, AffineTransform xform, boolean outlineOnly) {
        if (outlineOnly) {
            Area area = new Area();
            for (ALine line : geom.getSegments()) {
                Polygon shape = ShapeFactory.getShapeAsPolygon(screenXform, line, xform);
                area.add(new Area(shape));
            }
            return area;
        }
        return screenXform.getScreenPolygon(geom.transform(xform));
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, ARect geom, AffineTransform xform, boolean outlineOnly) {
        long d = Math.min(geom.width(), geom.height());
        if (screenXform.getScreenLength(d) <= 1) {
            geom = geom.transform(xform).getBounds();
            Point scrPoint = screenXform.getScreenPt(geom.getUL());
            return new Rectangle2D.Double(scrPoint.x, scrPoint.y, Math.max(1, screenXform.getScreenLength(geom.width())), Math.max(1, screenXform.getScreenLength(geom.height())));
        }
        return ShapeFactory.getShape(screenXform, geom, xform, outlineOnly);
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, ALine geom, AffineTransform xform) {
        return screenXform.getScreenLine(geom.transform(xform));
    }

    public static GeneralPath getShape(DesignCanvas2D.XForm screenXform, APolyline geom, AffineTransform xform) {
        return ShapeFactory.getShape(screenXform, geom, xform);
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, AArc geom, AffineTransform xform) {
        return screenXform.getScreenArc(geom.transformArc(xform));
    }

    public static GeneralPath getShape(DesignCanvas2D.XForm screenXform, APath geom, AffineTransform xform) {
        return ShapeFactory.getShape(screenXform, geom, xform);
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, AOutlineGeom geom, AffineTransform xform, boolean outlineOnly) {
        geom = geom.transform(xform);
        Path2D.Double screenPath = new Path2D.Double(1, (int)geom.getChildCount() * 4);
        boolean first = true;
        for (AGeom g : geom.getChildren()) {
            if (g instanceof ALine) {
                ShapeFactory.addToPath2D(screenPath, screenXform, (ALine)g, first);
                first = false;
                continue;
            }
            if (g instanceof APolyline) {
                ShapeFactory.addToPath2D(screenPath, screenXform, (APolyline)g, first);
                first = false;
                continue;
            }
            if (g instanceof AArc) {
                AArc[] arcs = ((AArc)g).breakInto90s();
                for (int i = 0; i < arcs.length; ++i) {
                    AGeom curve = arcs[i].approximateAsABezierCurve();
                    if (curve == null) continue;
                    if (curve instanceof ABezierCurve) {
                        ShapeFactory.addToPath2D(screenPath, screenXform, (ABezierCurve)curve, first);
                    } else {
                        ShapeFactory.addToPath2D(screenPath, screenXform, (ALine)curve, first);
                    }
                    first = false;
                }
                continue;
            }
            if (!(g instanceof ABezierCurve)) continue;
            ShapeFactory.addToPath2D(screenPath, screenXform, (ABezierCurve)g, first);
            first = false;
        }
        return screenPath;
    }

    public static Area getShape(DesignCanvas2D.XForm screenXform, ACompositeGeom geom, AffineTransform xform, boolean outlineOnly) {
        ACompositeGeom cg = geom;
        Rectangle2D rect = RegionShapeFactory.getBufferView(screenXform);
        if (!screenXform.getScreenRect(geom.getBounds().transform(xform).getBounds()).intersects(rect)) {
            return new Area();
        }
        Path2D.Float path = new Path2D.Float(1, 0x100000);
        assert (rect != null);
        for (AGeom child : cg.getChildren()) {
            Shape shape = RegionShapeFactory.getShape(screenXform, child, xform, outlineOnly);
            if (shape == null || !rect.intersects(shape.getBounds2D())) continue;
            path.append(shape, false);
        }
        return new Area(path);
    }

    public static Area getShape(DesignCanvas2D.XForm screenXform, AGeomWithCutouts geom, AffineTransform xform, boolean outlineOnly) {
        Shape inner;
        Shape outer = RegionShapeFactory.getShape(screenXform, geom.getOuter(), xform, outlineOnly);
        if (outer == null) {
            return new Area();
        }
        Area ans = new Area(outer);
        if (geom.getCutout() != null && (inner = RegionShapeFactory.getShape(screenXform, geom.getCutout(), xform, outlineOnly)) != null) {
            ans.subtract(new Area(inner));
        }
        return ans;
    }
}

