/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AclResources;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitStatusBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class SelectionStatusWidget
extends JTextField {
    private static final String NO_SELECT_TEXT = "No Selected Object";
    protected OrbitIO mListeningTo = null;
    protected Db mCurDb = null;
    protected Selection mCurSelection = null;
    protected boolean mSelectionUpdatePending = false;
    protected MouseListener mMouseHandler = new MouseHandler();
    protected OrbitApp.CurrentDbListener mCurDbListener = newDb -> {
        if (this.mCurDb == newDb) {
            return;
        }
        this.curDbChanged();
    };
    protected Selection.SelectionListener mSelectionListener = set -> this.updateCurSelStatus();

    public SelectionStatusWidget() {
        super("");
        this.setText(NO_SELECT_TEXT);
        this.setEditable(false);
        this.setFocusable(false);
        OrbitStatusBar.setStatusLook(this);
        this.addMouseListener(this.mMouseHandler);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isVisible()) {
            this.startListening();
        }
    }

    @Override
    public void removeNotify() {
        this.stopListening();
        super.removeNotify();
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            this.startListening();
        } else {
            this.stopListening();
        }
    }

    protected void startListening() {
        OrbitIO oio = OrbitIO.getApp();
        if (oio != null && oio != this.mListeningTo) {
            if (this.mListeningTo != null) {
                this.mListeningTo.removeCurrentDbListener(this.mCurDbListener);
            }
            oio.addCurrentDbListener(this.mCurDbListener);
            this.mListeningTo = oio;
            this.mCurDb = null;
        }
        this.curDbChanged();
    }

    protected void stopListening() {
        if (this.mListeningTo == null) {
            return;
        }
        this.mListeningTo.removeCurrentDbListener(this.mCurDbListener);
        this.mListeningTo = null;
        if (this.mCurSelection != null) {
            this.mCurSelection.removeSelectionListener(this.mSelectionListener);
            this.mCurSelection = null;
        }
        this.mCurDb = null;
        this.updateCurSelStatus();
    }

    protected void curDbChanged() {
        Db newDb;
        if (this.mListeningTo != null && (newDb = OrbitIO.getCurDb()) != this.mCurDb) {
            if (this.mCurDb != null) {
                if (this.mCurSelection != null) {
                    this.mCurSelection.removeSelectionListener(this.mSelectionListener);
                    this.mCurSelection = null;
                }
                this.mCurDb = null;
            }
            if (newDb != null) {
                this.mCurSelection = Selection.getCurrentSelectionForDb((Db)newDb, (boolean)false);
                if (this.mCurSelection == null) {
                    return;
                }
                this.mCurSelection.addSelectionListener(this.mSelectionListener);
                this.mCurDb = newDb;
            }
        }
        this.updateCurSelStatus();
    }

    protected void updateCurSelStatus() {
        if (this.mSelectionUpdatePending) {
            return;
        }
        this.mSelectionUpdatePending = true;
        EventQueue.invokeLater(() -> {
            this.mSelectionUpdatePending = false;
            Object newText = NO_SELECT_TEXT;
            if (this.mCurSelection == null) {
                this.setEnabled(false);
                this.setToolTipText(null);
            } else {
                this.setEnabled(true);
                long total = this.mCurSelection.getCountInst();
                newText = String.format("%d selected", total);
                this.setToolTipText(String.format("%d object%s selected", total, total == 1L ? "" : "s"));
            }
            newText = " " + (String)newText;
            if (!((String)newText).equals(this.getText())) {
                this.setText((String)newText);
                Container parent = this.getParent();
                if (parent != null) {
                    parent.validate();
                    parent.repaint();
                }
            }
        });
    }

    private static class ActionExportSelection
    extends AbstractAction {
        ActionExportSelection() {
            super("Export Selection", UIUtil.getScaledIcon((Icon)OrbitIcons.EXPORT, (int)16, (int)16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setDialogTitle("Export Selection");
            fc.setFileFilter((FileFilter)AclResources.SCRIPT_FILE_FILTER);
            fc.setSelectedFile(new File("selection.ojs"));
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            Cp.exec((String)"com.sigrity.orbit.cmd.SelectionCmds.exportSelection(%s)", (Object[])new Object[]{Cp.getFileAsArgument((File)f)});
        }
    }

    private static class ActionImportSelection
    extends AbstractAction {
        ActionImportSelection() {
            super("Import Selection", UIUtil.getScaledIcon((Icon)OrbitIcons.IMPORT, (int)16, (int)16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setDialogTitle("Import Selection");
            fc.setFileFilter((FileFilter)AclResources.SCRIPT_FILE_FILTER);
            fc.setSelectedFile(new File("selection.ojs"));
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            if (f != null) {
                Cp.exec((String)"com.sigrity.orbit.cmd.SelectionCmds.importSelection(%s)", (Object[])new Object[]{Cp.getFileAsArgument((File)f)});
            }
        }
    }

    protected class MouseHandler
    implements MouseListener {
        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleContextMenu(e);
        }

        protected void handleContextMenu(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            JPopupMenu menu = new JPopupMenu();
            menu.add(new ActionImportSelection());
            menu.add(new ActionExportSelection());
            menu.show(SelectionStatusWidget.this, e.getX(), e.getY());
        }
    }
}

