/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.geom.AArc;
import com.sigrity.acl.geom.ABezierCurve;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomWithCutouts;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOutlineGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.APolyline;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class ShapeFactory {
    private ShapeFactory() {
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, AGeom geom, AffineTransform xform, boolean outlineOnly) {
        Shape ans = null;
        if (geom instanceof ACircle) {
            ans = ShapeFactory.getShape(screenXform, (ACircle)geom, xform, outlineOnly);
        } else if (geom instanceof ARect) {
            ans = 0 != (xform.getType() & 0x10) ? ShapeFactory.getShape(screenXform, geom.toPoly(), xform, outlineOnly) : ShapeFactory.getShape(screenXform, (ARect)geom, xform, outlineOnly);
        } else if (geom instanceof ALine) {
            ans = ShapeFactory.getShape(screenXform, (ALine)geom, xform);
        } else if (geom instanceof APolyline) {
            ans = ShapeFactory.getShape(screenXform, (APolyline)geom, xform);
        } else if (geom instanceof AArc) {
            ans = ShapeFactory.getShape(screenXform, (AArc)geom, xform);
        } else if (geom instanceof APath) {
            ans = ShapeFactory.getShape(screenXform, (APath)geom, xform);
        } else if (geom instanceof APolygon) {
            ans = ShapeFactory.getShape(screenXform, (APolygon)geom, xform, outlineOnly);
        } else if (geom instanceof AOutlineGeom) {
            ans = ShapeFactory.getShape(screenXform, (AOutlineGeom)geom, xform, outlineOnly);
        } else if (geom instanceof ACompositeGeom) {
            ans = ShapeFactory.getShape(screenXform, (ACompositeGeom)geom, xform, outlineOnly);
        } else if (geom instanceof AGeomWithCutouts) {
            ans = ShapeFactory.getShape(screenXform, (AGeomWithCutouts)geom, xform, outlineOnly);
        }
        return ans;
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, ACircle geom, AffineTransform xform, boolean outlineOnly) {
        geom = geom.transform(xform);
        if (outlineOnly) {
            AffineTransform identity = new AffineTransform();
            Area area = new Area();
            AArc arc = new AArc(geom.getC(), geom.getR(), 0.0, 180.0);
            Shape shape = ShapeFactory.getShape(screenXform, arc, identity);
            area.add(new Area(shape));
            arc = new AArc(geom.getC(), geom.getR(), 180.0, 360.0);
            shape = ShapeFactory.getShape(screenXform, arc, identity);
            area.add(new Area(shape));
            return area;
        }
        ARect bounds = geom.getBounds();
        int scrDiameter = screenXform.toScreenDist(geom.getD());
        Point scrPoint = screenXform.getScreenPt(bounds.getUL());
        return new Ellipse2D.Double(scrPoint.getX(), scrPoint.getY(), scrDiameter, scrDiameter);
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, APolygon geom, AffineTransform xform, boolean outlineOnly) {
        if (outlineOnly) {
            geom = geom.transform(xform);
            AffineTransform identity = new AffineTransform();
            Area area = new Area();
            APoint2D pt_prev = null;
            for (APoint2D pt : geom.getPoints()) {
                if (pt_prev != null) {
                    ALine line = new ALine(pt_prev, pt);
                    Polygon shape = ShapeFactory.getShapeAsPolygon(screenXform, line, identity);
                    area.add(new Area(shape));
                }
                pt_prev = pt;
            }
            return area;
        }
        return screenXform.getScreenPolygon(geom.transform(xform));
    }

    public static Polygon getShapeAsPolygon(DesignCanvas2D.XForm screenXform, ALine geom, AffineTransform xform) {
        return screenXform.getScreenPolygon(geom.toPoly().transform(xform));
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, ARect geom, AffineTransform xform, boolean outlineOnly) {
        geom = geom.transform(xform).getBounds();
        int scrW = screenXform.toScreenDist(geom.width());
        int scrH = screenXform.toScreenDist(geom.height());
        Point scrPoint = screenXform.getScreenPt(geom.getUL());
        if (outlineOnly && scrW > 0 && scrH > 0) {
            Area area = new Area();
            Rectangle2D.Double line = new Rectangle2D.Double(scrPoint.getX(), scrPoint.getY(), scrW, 1.0);
            area.add(new Area(line));
            line = new Rectangle2D.Double(scrPoint.getX(), scrPoint.getY(), 1.0, scrH);
            area.add(new Area(line));
            scrPoint = screenXform.getScreenPt(geom.getLL());
            line = new Rectangle2D.Double(scrPoint.getX(), scrPoint.getY(), scrW, 1.0);
            area.add(new Area(line));
            scrPoint = screenXform.getScreenPt(geom.getUR());
            line = new Rectangle2D.Double(scrPoint.getX(), scrPoint.getY(), 1.0, scrH);
            area.add(new Area(line));
            return area;
        }
        return new Rectangle2D.Double(scrPoint.getX(), scrPoint.getY(), scrW, scrH);
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, ALine geom, AffineTransform xform) {
        return screenXform.getScreenLine(geom.transform(xform));
    }

    public static GeneralPath getShape(DesignCanvas2D.XForm screenXform, APolyline geom, AffineTransform xform) {
        GeneralPath ans = new GeneralPath();
        geom = geom.transform(xform);
        Point scrPoint = screenXform.getScreenPt(geom.getPoint(0));
        ans.moveTo(scrPoint.getX(), scrPoint.getY());
        APoint2D pt_first = null;
        for (APoint2D pt : geom.getPoints()) {
            if (pt_first != null) {
                scrPoint = screenXform.getScreenPt(pt);
                ans.lineTo(scrPoint.getX(), scrPoint.getY());
                continue;
            }
            pt_first = pt;
        }
        return ans;
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, AArc geom, AffineTransform xform) {
        return screenXform.getScreenArc(geom.transformArc(xform));
    }

    public static GeneralPath getShape(DesignCanvas2D.XForm screenXform, APath geom, AffineTransform xform) {
        GeneralPath ans = new GeneralPath();
        geom = geom.transform(xform);
        Point scrPoint = screenXform.getScreenPt(geom.getPoint(0));
        ans.moveTo(scrPoint.getX(), scrPoint.getY());
        APoint2D pt_first = null;
        for (APoint2D pt : geom.getPoints()) {
            if (pt_first != null) {
                scrPoint = screenXform.getScreenPt(pt);
                ans.lineTo(scrPoint.getX(), scrPoint.getY());
                continue;
            }
            pt_first = pt;
        }
        return ans;
    }

    public static Shape getShape(DesignCanvas2D.XForm screenXform, AOutlineGeom geom, AffineTransform xform, boolean outlineOnly) {
        geom = geom.transform(xform);
        Path2D.Double screenPath = new Path2D.Double(1, (int)geom.getChildCount() * 4);
        boolean first = true;
        for (AGeom g : geom.getChildren()) {
            if (g instanceof ALine) {
                ShapeFactory.addToPath2D(screenPath, screenXform, (ALine)g, first);
                first = false;
                continue;
            }
            if (g instanceof APolyline) {
                ShapeFactory.addToPath2D(screenPath, screenXform, (APolyline)g, first);
                first = false;
                continue;
            }
            if (g instanceof AArc) {
                AArc[] arcs = ((AArc)g).breakInto90s();
                for (int i = 0; i < arcs.length; ++i) {
                    AGeom curve = arcs[i].approximateAsABezierCurve();
                    if (curve == null) continue;
                    if (curve instanceof ABezierCurve) {
                        ShapeFactory.addToPath2D(screenPath, screenXform, (ABezierCurve)curve, first);
                    } else {
                        ShapeFactory.addToPath2D(screenPath, screenXform, (ALine)curve, first);
                    }
                    first = false;
                }
                continue;
            }
            if (!(g instanceof ABezierCurve)) continue;
            ShapeFactory.addToPath2D(screenPath, screenXform, (ABezierCurve)g, first);
            first = false;
        }
        return screenPath;
    }

    static void addToPath2D(Path2D.Double screenPath, DesignCanvas2D.XForm screenXform, ALine g, boolean first) {
        Point scrPoint;
        if (first) {
            scrPoint = screenXform.getScreenPt(g.getP0());
            screenPath.moveTo(scrPoint.getX(), scrPoint.getY());
        }
        scrPoint = screenXform.getScreenPt(g.getP1());
        screenPath.lineTo(scrPoint.getX(), scrPoint.getY());
    }

    static void addToPath2D(Path2D.Double screenPath, DesignCanvas2D.XForm screenXform, APolyline g, boolean first) {
        Point scrPoint;
        if (first) {
            scrPoint = screenXform.getScreenPt(g.getPoint(0));
            screenPath.moveTo(scrPoint.getX(), scrPoint.getY());
        }
        APoint2D pt_first = null;
        for (APoint2D pt : g.getPoints()) {
            if (pt_first != null) {
                scrPoint = screenXform.getScreenPt(pt);
                if (screenPath.getCurrentPoint().equals(scrPoint)) continue;
                screenPath.lineTo(scrPoint.getX(), scrPoint.getY());
                continue;
            }
            pt_first = pt;
        }
    }

    static void addToPath2D(Path2D.Double screenPath, DesignCanvas2D.XForm screenXform, ABezierCurve g, boolean first) {
        Point scrPoint = screenXform.getScreenPt(g.getStart());
        if (first) {
            screenPath.moveTo(scrPoint.getX(), scrPoint.getY());
        } else if (!screenPath.getCurrentPoint().equals(scrPoint)) {
            screenPath.lineTo(scrPoint.getX(), scrPoint.getY());
        }
        scrPoint = screenXform.getScreenPt(g.getEnd());
        Point c1 = screenXform.getScreenPt(g.getC1());
        Point c2 = screenXform.getScreenPt(g.getC2());
        screenPath.curveTo(c1.getX(), c1.getY(), c2.getX(), c2.getY(), scrPoint.getX(), scrPoint.getY());
    }

    public static Area getShape(DesignCanvas2D.XForm screenXform, ACompositeGeom geom, AffineTransform xform, boolean outlineOnly) {
        ACompositeGeom cg = geom;
        Path2D.Float path = new Path2D.Float(1, 0x100000);
        for (AGeom child : cg.getChildren()) {
            Shape shape = ShapeFactory.getShape(screenXform, child, xform, outlineOnly);
            path.append(shape, false);
        }
        return new Area(path);
    }

    public static Area getShape(DesignCanvas2D.XForm screenXform, AGeomWithCutouts geom, AffineTransform xform, boolean outlineOnly) {
        Area ans = new Area(ShapeFactory.getShape(screenXform, geom.getOuter(), xform, outlineOnly));
        if (geom.getCutout() != null) {
            ans.subtract(new Area(ShapeFactory.getShape(screenXform, geom.getCutout(), xform, outlineOnly)));
        }
        return ans;
    }
}

