/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.cphelper;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public class CpHelper {
    public static <T extends DbObject> String getObjCmdStr(T dbObj) {
        if (dbObj == null) {
            return "null";
        }
        if (!dbObj.getDbClass().hasKeyFields()) {
            ALog.logDebug((String)"WARNING: this object '%s' does not key fields, it may not be reproduced.", (Object[])new Object[]{dbObj});
        }
        return String.format("curDb().getByKeyStr(%s.class, \"%s\")", dbObj.getClass().getSimpleName(), dbObj.getKeyStr());
    }

    public static <T extends DbObject> String getDbClassCmdStr(Db db, Class<T> c) {
        DbClass dbClass = db.getDbClass(c);
        if (dbClass == null) {
            ALog.flogWarn((String)"DbClass '%s' not exist in database.", (Object[])new Object[]{c});
            return "null";
        }
        return String.format("curDb().getDbClass(%s.class)", c.getSimpleName());
    }

    public static String getCmdStr(DevicePath path) {
        return String.format("DevicePath.fromEscapedString(curDb(), \"%s\")", path.escapedString());
    }

    public static void cpDbObjectDelete(DbObject dbObj) {
        Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(dbObj)});
    }

    public static void cpDeleteSelected() {
        Cp.exec((String)"com.sigrity.orbit.cmd.DbObjectCmd.deleteSelected(curDb())", (Object[])new Object[0]);
    }

    public static void cpDeleteSelected(Class<? extends DbObject> c) {
        Cp.exec((String)"com.sigrity.orbit.cmd.DbObjectCmd.deleteSelected(curDb(), %s.class)", (Object[])new Object[]{c.getSimpleName()});
    }

    public static void cpClearSelection() {
        Cp.exec((String)"curSelection().clearSelection();", (Object[])new Object[0]);
    }

    public static <T extends HierInst<? extends DbObject>> void cpHierSelect(Stream<? extends T> hierDbObjs) {
        CpHelper.cpHierSelect(hierDbObjs.iterator());
    }

    public static <T extends HierInst<? extends DbObject>> void cpHierSelect(Collection<? extends T> hierDbObjs) {
        CpHelper.cpHierSelect(hierDbObjs.iterator());
    }

    public static <T extends HierInst<? extends DbObject>> void cpHierSelect(Iterator<? extends T> hierDbObjItr) {
        StringBuilder sb = new StringBuilder();
        while (hierDbObjItr.hasNext()) {
            HierInst hi = (HierInst)hierDbObjItr.next();
            sb.append(String.format("curSelection().add(%s, %s);", CpHelper.getCmdStr(hi.getPath()), CpHelper.getObjCmdStr(hi.getDbObject())));
        }
        Cp.exec((String)sb.toString(), (Object[])new Object[0]);
    }

    public static void cpSelect(Collection<? extends DbObject> dbObjs) {
        CpHelper.cpSelect(dbObjs.iterator());
    }

    public static void cpSelect(Iterator<? extends DbObject> dbObjItr) {
        StringBuilder sb = new StringBuilder();
        while (dbObjItr.hasNext()) {
            sb.append(String.format("curSelection().add(%s);", CpHelper.getObjCmdStr(dbObjItr.next())));
        }
        Cp.exec((String)sb.toString(), (Object[])new Object[0]);
    }

    public static void cpSelect(DevicePath devPath, Collection<? extends DbObject> dbObjs) {
        CpHelper.cpSelect(devPath, dbObjs.iterator());
    }

    public static void cpSelect(DevicePath devPath, Iterator<? extends DbObject> dbObjItr) {
        String devPathStr = CpHelper.getCmdStr(devPath);
        StringBuilder sb = new StringBuilder();
        while (dbObjItr.hasNext()) {
            sb.append(String.format("curSelection().add(%s, %s);", devPathStr, CpHelper.getObjCmdStr(dbObjItr.next())));
        }
        Cp.exec((String)sb.toString(), (Object[])new Object[0]);
    }

    private CpHelper() {
    }
}

