/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.docking;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import com.sigrity.acl.AFileExplorer;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ui.ALogPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JPanel;

public class CommandDockUI {
    private CommandDockUI() {
    }

    public static void initCommandsAndMessage(DefaultSingleCDockable msgDock, JPanel cmdMsgPnl) {
        msgDock.getContentPane().add(cmdMsgPnl);
        msgDock.setCloseable(false);
        msgDock.setExternalizable(false);
        msgDock.setTitleIcon(OrbitIcons.CONSOLE);
        msgDock.addAction((CAction)new RunScriptFileAction());
        msgDock.addAction((CAction)new RecordScriptAction());
        msgDock.addSeparator();
        msgDock.addAction((CAction)new ClearConsoleAction());
        msgDock.addSeparator();
        msgDock.addAction((CAction)new OpenScriptFileAction());
        msgDock.addAction((CAction)new OpenLogFileAction());
    }

    static class RecordScriptAction
    extends CButton {
        public RecordScriptAction() {
            this.setText("Record Script");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.RECORD_SCRIPT, (int)16, (int)16));
            ALogPanel.getRecordScriptAction().register(this::setIsRecording);
            this.addActionListener(e -> ALogPanel.getRecordScriptAction().actionPerformed(null));
        }

        public void setIsRecording(boolean isRecording) {
            if (isRecording) {
                this.setText("Stop Recording Script");
                this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.RECORDING, (int)16, (int)16));
            } else {
                this.setText("Record Script");
                this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.RECORD_SCRIPT, (int)16, (int)16));
            }
        }
    }

    static class RunScriptFileAction
    extends CButton {
        public RunScriptFileAction() {
            this.setText("Run Script File");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.RUN_SCRIPT, (int)16, (int)16));
            this.addActionListener(e -> OrbitIO.getApp().getWorkspace().getAction("PlayScript").actionPerformed(e));
        }
    }

    static class OpenLogFileAction
    extends CButton {
        public OpenLogFileAction() {
            this.setText("Open Log File");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.LOG_FILE, (int)16, (int)16));
            ALog.ALogFile logFile = OrbitIO.getApp().getDefaultLogFile();
            File file = logFile == null ? null : logFile.getFile();
            this.addActionListener(e -> AFileExplorer.browseFileDirectory((File)file));
        }
    }

    static class OpenScriptFileAction
    extends CButton {
        public OpenScriptFileAction() {
            this.setText("Open Recorded Script File");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.SCRIPT_FILE, (int)16, (int)16));
            File cmdFile = OrbitIO.getApp().getCmdLogFile();
            this.addActionListener(e -> AFileExplorer.browseFileDirectory((File)cmdFile));
        }
    }

    static class ClearConsoleAction
    extends CButton {
        public ClearConsoleAction() {
            this.setText("Clear Messages");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.DOCUMENT_DEL, (int)16, (int)16));
            this.addActionListener(e -> OrbitIO.getApp().getWorkspace().getMessagePanel().clearMessages());
        }
    }
}

