/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.docking;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import com.sigrity.acl.ui.AclResources;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.docking.DockingUtil;
import com.sigrity.orbit.ui.side_panels.DbExplorerConfigDialog;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import javax.swing.Icon;

public class DbExplorerDockUI {
    private DbExplorerDockUI() {
    }

    public static void installToolBar(DefaultSingleCDockable dock, DbExplorerPanel explorer) {
        DockingUtil.clearActions(dock);
        dock.addAction((CAction)new CollapseNodeAction(explorer));
        dock.addAction((CAction)new RefreshNodeAction(explorer));
        dock.addAction((CAction)new SearchNodeAction(explorer));
        dock.addAction((CAction)new SearchSelectedNodeAction(explorer));
        dock.addAction((CAction)new ExplorerPropertyAction(explorer));
    }

    public static class ExplorerPropertyAction
    extends CButton {
        public ExplorerPropertyAction(DbExplorerPanel explorer) {
            this.setText("Properties...");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.COG, (int)16, (int)16));
            this.addActionListener(e -> DbExplorerConfigDialog.show(explorer));
        }
    }

    public static class SearchNodeAction
    extends CButton {
        public SearchNodeAction(DbExplorerPanel explorer) {
            this.setText("Search");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.SRCH, (int)16, (int)16));
            this.addActionListener(e -> explorer.showSearchPanel());
        }
    }

    public static class SearchSelectedNodeAction
    extends CButton {
        public SearchSelectedNodeAction(DbExplorerPanel explorer) {
            this.setText("Search Selected");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.SELECT, (int)16, (int)16));
            this.addActionListener(e -> explorer.showSearchSelectedPanel());
        }
    }

    public static class RefreshNodeAction
    extends CButton {
        public RefreshNodeAction(DbExplorerPanel explorer) {
            this.setText("Refresh All Nodes");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.REFRESH, (int)16, (int)16));
            this.addActionListener(e -> explorer.refresh());
        }
    }

    public static class CollapseNodeAction
    extends CButton {
        public CollapseNodeAction(DbExplorerPanel explorer) {
            this.setText("Collapse Nodes");
            this.setIcon(UIUtil.getScaledIcon((Icon)AclResources.ICON_COLLAPSE, (int)16, (int)16));
            this.addActionListener(e -> explorer.collapseNodes());
        }
    }
}

