/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.docking;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import bibliothek.gui.dock.common.action.CDropDownButton;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.DesignCanvasInfoDisplay;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.docking.DockingUtil;
import java.awt.Color;
import javax.swing.Icon;

public class DesignDockUI {
    private DesignDockUI() {
    }

    public static void installToolBar(DefaultSingleCDockable dock) {
        DockingUtil.clearActions(dock);
        dock.addAction((CAction)new CanvasThemeAction());
        dock.addAction((CAction)new CanvasInfoAction());
    }

    public static class CanvasThemeAction
    extends CDropDownButton {
        public CanvasThemeAction() {
            this.setText("Theme");
            this.setTooltip("Change the canvas theme");
            this.setIcon(OrbitIcons.PAINT_PALETTE);
            CButton emptyBtn = new CButton();
            CButton darkBtn = new CButton();
            CButton whiteBtn = new CButton();
            CButton innovusBtn = new CButton();
            darkBtn.addActionListener(e -> {
                Cp.exec((String)"com.sigrity.orbit.ui.core.DesignCanvas2D.applyClassicTheme()", (Object[])new Object[0]);
                this.setSelection((CAction)emptyBtn);
            });
            AColorIcon blackIcon = new AColorIcon(16, 16, Color.BLACK);
            blackIcon.setWhiteBackground(false);
            darkBtn.setIcon((Icon)blackIcon);
            darkBtn.setText("Classic Dark");
            whiteBtn.addActionListener(e -> {
                Cp.exec((String)"com.sigrity.orbit.ui.core.DesignCanvas2D.applyDefaultTheme()", (Object[])new Object[0]);
                this.setSelection((CAction)emptyBtn);
            });
            AColorIcon whiteIcon = new AColorIcon(16, 16, Color.WHITE);
            whiteIcon.setWhiteBackground(false);
            whiteBtn.setIcon((Icon)whiteIcon);
            whiteBtn.setText("Classic White");
            innovusBtn.addActionListener(e -> {
                Cp.exec((String)"com.sigrity.orbit.ui.core.DesignCanvas2D.applyInnovusTheme()", (Object[])new Object[0]);
                this.setSelection((CAction)emptyBtn);
            });
            innovusBtn.setIcon(null);
            innovusBtn.setText("Innovus");
            this.add((CAction)darkBtn);
            this.add((CAction)whiteBtn);
            this.add((CAction)innovusBtn);
        }
    }

    public static class CanvasInfoAction
    extends CDropDownButton {
        private static void setCanvasInfoDisplay(DesignView2D v2d, DesignCanvasInfoDisplay.Factory infoDisplayFactory) {
            if (infoDisplayFactory == null) {
                DesignCanvasInfoDisplay.getManager().uninstall(v2d);
            } else {
                DesignCanvasInfoDisplay.getManager().install(v2d, infoDisplayFactory);
            }
        }

        public CanvasInfoAction() {
            this.setText("Info View");
            this.setTooltip("The style of information display on hover object");
            this.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.COMMENT, (int)16, (int)16));
            CButton emptyBtn = new CButton();
            CButton noneBtn = new CButton();
            noneBtn.setText("None");
            noneBtn.setIcon(OrbitIcons.EMPTY16x16);
            noneBtn.addActionListener(e -> {
                AAppView view = OrbitIO.getCurView();
                if (view instanceof DesignView2D) {
                    DesignView2D v2d = (DesignView2D)view;
                    CanvasInfoAction.setCanvasInfoDisplay(v2d, null);
                }
                this.setSelection((CAction)emptyBtn);
            });
            this.add((CAction)noneBtn);
            for (DesignCanvasInfoDisplay.Factory infoDisplayFactory : DesignCanvasInfoDisplay.getRegistry().getFactories()) {
                CButton optionBtn = new CButton();
                optionBtn.setText(infoDisplayFactory.getName());
                optionBtn.setIcon(OrbitIcons.EMPTY16x16);
                optionBtn.addActionListener(e -> {
                    AAppView view = OrbitIO.getCurView();
                    if (view instanceof DesignView2D) {
                        DesignView2D v2d = (DesignView2D)view;
                        CanvasInfoAction.setCanvasInfoDisplay(v2d, infoDisplayFactory);
                    }
                    this.setSelection((CAction)emptyBtn);
                });
                this.add((CAction)optionBtn);
            }
        }
    }
}

