/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.docking;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.orbit.OrbitIO;

public class DesignDockable
extends DefaultSingleCDockable {
    protected Db mDb;
    protected boolean mDbClosed = false;
    protected boolean mHideWhenDbInactive = true;
    protected boolean mHidden = false;
    protected CVetoClosingListener mDockableCloseListener = new CVetoClosingListener(){

        public void closing(CVetoClosingEvent event) {
        }

        public void closed(CVetoClosingEvent event) {
            if (!DesignDockable.this.getHidden()) {
                Db.removeDbListener((Db.DbListener)DesignDockable.this.mDbListener);
                OrbitIO.getApp().getWorkspace().removeViewListener(DesignDockable.this.mViewChangeListener);
                DesignDockable.this.removeVetoClosingListener(this);
            }
        }
    };
    protected Db.DbListener mDbListener = new Db.DbListenerAdapter(){

        public void dbClosing(Db db) {
            if (db != DesignDockable.this.mDb) {
                return;
            }
            DesignDockable.this.mDbClosed = true;
            if (DesignDockable.this.isVisible()) {
                DesignDockable.this.setVisible(false);
            }
        }
    };
    protected ViewListener mViewChangeListener = new ViewAdapter(){

        public void activeViewChanged(AAppView oldView, AAppView newView) {
            if (DesignDockable.this.mHideWhenDbInactive) {
                boolean designActive;
                AAppView view = newView;
                boolean bl = designActive = view != null && view.getDb() == DesignDockable.this.mDb;
                if (!designActive && DesignDockable.this.isVisible()) {
                    DesignDockable.this.mHidden = true;
                    DesignDockable.this.setVisible(false);
                } else if (designActive && !DesignDockable.this.isVisible()) {
                    DesignDockable.this.setVisible(true);
                    DesignDockable.this.mHidden = false;
                }
            }
        }
    };

    public DesignDockable(Db db, String id) {
        super(id, new CAction[0]);
        this.mDb = db;
        this.addVetoClosingListener(this.mDockableCloseListener);
        OrbitIO.getApp().getWorkspace().addViewListener(this.mViewChangeListener);
        Db.addDbListener((Db.DbListener)this.mDbListener);
    }

    public Db getDb() {
        return this.mDb;
    }

    public Design getDesign() {
        return Design.getDesign((Db)this.mDb);
    }

    public Unit getUnitDist() {
        Design d = this.getDesign();
        if (d == null) {
            return Design.getDefaultUnitDist();
        }
        return d.getUnit();
    }

    public boolean getDbClosed() {
        return this.mDbClosed;
    }

    public void setHideWhenDbInactive(boolean b) {
        this.mHideWhenDbInactive = b;
    }

    public boolean getHideDbInactive() {
        return this.mHideWhenDbInactive;
    }

    public boolean getHidden() {
        return this.mHidden;
    }
}

