/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.docking;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.AIterableItr;
import java.util.ArrayList;
import java.util.stream.Stream;

public class DockingUtil {
    private DockingUtil() {
    }

    public static void clearActions(DefaultSingleCDockable dock) {
        ArrayList<CAction> list = new ArrayList<CAction>();
        for (int i = 0; i < dock.getActionCount(); ++i) {
            list.add(dock.getAction(i));
        }
        for (CAction a : list) {
            dock.removeAction(a);
        }
    }

    public static Stream<Dockable> getDockableDescendants(DockStation ds) {
        return DockingUtil.getDockableChildren(ds).flatMap(d -> {
            DockStation s = d.asDockStation();
            if (s != null) {
                return Stream.concat(Stream.of(d), DockingUtil.getDockableDescendants(s));
            }
            return Stream.of(d);
        });
    }

    public static Stream<CStation<?>> getCStations(CContentArea ca) {
        return AIterableItr.itr((Object[])ca.getStations()).stream();
    }

    public static Stream<Dockable> getDockableChildren(DockStation ds) {
        return AIterableItr.itr((int)ds.getDockableCount(), arg_0 -> ((DockStation)ds).getDockable(arg_0)).stream();
    }
}

