/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.docking;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.focus.FocusRequest;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;

public class OrbitDockingToolBar
extends JToolBar {
    private List<DefaultSingleCDockable> mDocks = new ArrayList<DefaultSingleCDockable>();
    private Map<DefaultSingleCDockable, JButton> mDockMap = new HashMap<DefaultSingleCDockable, JButton>();

    public OrbitDockingToolBar(String name, int horizontal) {
        super(name, horizontal);
        this.setVisible(true);
        this.setRollover(true);
        this.setFloatable(false);
    }

    public boolean addDockable(DefaultSingleCDockable dockable) {
        for (int i = 0; i < this.mDocks.size(); ++i) {
            DefaultSingleCDockable d = this.mDocks.get(i);
            if (!d.getUniqueId().equals(dockable.getUniqueId())) continue;
            return false;
        }
        this.mDocks.add(dockable);
        if (dockable.getTitleIcon() != null && dockable.getTitleIcon().getIconWidth() > 0) {
            JButton btn = this.addButton(dockable);
            this.mDockMap.put(dockable, btn);
        }
        return true;
    }

    private JButton addButton(final DefaultSingleCDockable dockable) {
        Icon titleIcon = dockable.getTitleIcon();
        String uniqueId = dockable.getUniqueId();
        JButton btn = new JButton(new ToggleDockAction(uniqueId)){

            @Override
            public String getToolTipText() {
                return dockable.getTitleText();
            }
        };
        btn.setIcon(titleIcon);
        UIUtil.makeToolBarButton((AbstractButton)btn);
        ToolTipManager.sharedInstance().registerComponent(btn);
        this.add(btn);
        return btn;
    }

    public void updateTitleIcon(DefaultSingleCDockable d, Icon newIcon) {
        JButton btn = this.mDockMap.get(d);
        if (btn == null) {
            return;
        }
        btn.setIcon(newIcon);
    }

    public void reset() {
        this.mDocks.clear();
        this.mDockMap.clear();
        this.removeAll();
    }

    private static class ToggleDockAction
    extends AbstractAction {
        private final String mDockId;

        public ToggleDockAction(String uniqueId) {
            this.mDockId = uniqueId;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
            DefaultSingleCDockable dockable = ws.getSingleDockable(this.mDockId);
            DockController control = ws.getDockingController().getController();
            CDockFrontend frontend = ws.getDockingController().intern();
            if (frontend.isHidden((Dockable)dockable.intern())) {
                control.setFocusedDockable((FocusRequest)new DefaultFocusRequest((DockElementRepresentative)dockable.intern(), null, false));
                frontend.show((Dockable)dockable.intern());
            } else {
                frontend.hide((Dockable)dockable.intern());
            }
        }
    }
}

