/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.help;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AOptional;
import com.sigrity.acl.APair;
import com.sigrity.acl.AStream;
import com.sigrity.acl.AString;
import com.sigrity.acl.AUrlUtil;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;

public class HelpToolTips {
    protected static boolean gShowTipKeys = false;
    protected static HashMap<String, APair<String, String>> gOverriddenTips = new HashMap();
    protected static AWTEventListener TipKeyCopier = event -> {
        if (event.getID() != 402) {
            return;
        }
        KeyEvent ke = (KeyEvent)event;
        if (ke.isConsumed() || ke.getKeyCode() != 192 || !ke.isControlDown() || !ke.isAltDown()) {
            return;
        }
        Object[] selMenuPath = MenuSelectionManager.defaultManager().getSelectedPath();
        if (selMenuPath == null || selMenuPath.length == 0) {
            return;
        }
        Optional<JMenuItem> lastMenuItem = AStream.of((Object[])selMenuPath).filter(menuElem -> menuElem instanceof JMenuItem).reduce((a, b) -> b).map(menuElem -> (JMenuItem)menuElem);
        lastMenuItem.ifPresent(mi -> {
            String key = HelpToolTips.getTipKey(mi);
            key = key.replace("=", "\\=");
            StringSelection stringSelection = new StringSelection(key);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
            ALog.logInfo((String)"Copied '%s' to clipboard.", (Object[])new Object[]{key});
        });
    };
    protected static final AWTEventListener sHierarchyEventListener = event -> {
        if (event.getID() != 1400) {
            return;
        }
        HierarchyEvent he = (HierarchyEvent)event;
        if ((he.getChangeFlags() & 2L) == 0L) {
            return;
        }
        Component c = he.getComponent();
        if (!(c instanceof JMenuItem)) {
            return;
        }
        if (!c.isDisplayable()) {
            return;
        }
        JMenuItem mi = (JMenuItem)c;
        String key = HelpToolTips.getTipKey(mi);
        AOptional.consume(HelpToolTips.getTipForMenuItem(key)).ifPresent(tip -> HelpToolTips.updateTip(key, mi, Optional.of(tip))).orElse(() -> HelpToolTips.updateTip(key, mi, Optional.empty()));
    };
    protected static ClassLoader gResourceLoader = null;
    protected static ResourceBundle gResourceBundleMenuTips = null;

    public static void setShowTipKeys(boolean b) {
        if (b == gShowTipKeys) {
            return;
        }
        gShowTipKeys = b;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (b) {
            toolkit.addAWTEventListener(TipKeyCopier, 8L);
        } else {
            toolkit.removeAWTEventListener(TipKeyCopier);
        }
    }

    public static void setMenuTipsEnabled(boolean enabled) {
        long eventMask = 32768L;
        if (enabled) {
            Toolkit.getDefaultToolkit().addAWTEventListener(sHierarchyEventListener, eventMask);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(sHierarchyEventListener);
        }
    }

    protected static void updateTip(String key, JMenuItem menuItem, Optional<String> tip) {
        if (tip == null && !gShowTipKeys) {
            return;
        }
        String curTip = menuItem.getToolTipText();
        if (curTip == null) {
            curTip = "";
        }
        String origTip = curTip;
        if (curTip.isEmpty()) {
            gOverriddenTips.remove(key);
        } else {
            APair<String, String> origAndOverride = gOverriddenTips.get(key);
            if (origAndOverride != null && origTip.equals(origAndOverride.second)) {
                origTip = (String)origAndOverride.first;
            }
        }
        Object newTip = tip.orElse(origTip);
        if (gShowTipKeys) {
            String htmlPrefix = "<html>";
            if (!((String)newTip).isEmpty()) {
                newTip = (String)newTip + "<br/>";
            }
            if (!AString.startsWithIgnoreCase((String)newTip, (String)"<html>")) {
                newTip = "<html>" + (String)newTip;
            }
            String keyInfo = String.format("Tip key: %s<br/><i>Ctrl-Alt-` to copy</i>", key);
            newTip = (String)newTip + keyInfo;
        }
        if (((String)newTip).equals(curTip)) {
            return;
        }
        menuItem.setToolTipText((String)newTip);
        gOverriddenTips.put(key, (APair<String, String>)APair.create((Object)origTip, (Object)newTip));
    }

    public static String getTipKey(JMenuItem mi) {
        String type = mi.getClass().getSimpleName();
        Object path = "";
        Object props = "";
        if (mi instanceof JMenu) {
            JMenu m = (JMenu)mi;
            while (m != null) {
                path = AUrlUtil.encode((String)HelpToolTips.getMenuText(m)) + (((String)path).isEmpty() ? "" : "/") + (String)path;
                m = HelpToolTips.getParentMenu(m);
            }
        } else if (mi.getAction() != null) {
            Action action = mi.getAction();
            type = HelpToolTips.getActionType(action);
            path = AUrlUtil.encode((String)HelpToolTips.stripTrailingDots("" + action.getValue("Name")));
            if (action instanceof OrbitGuiWS.CpCmdAction) {
                OrbitGuiWS.CpCmdAction cpca = (OrbitGuiWS.CpCmdAction)action;
                String cmd = cpca.getCmd();
                props = "cmd=" + AUrlUtil.encode((String)cmd);
            }
        } else {
            path = AUrlUtil.encode((String)HelpToolTips.getMenuText(mi));
            props = String.format("name=%s&actionCommand=%s", AUrlUtil.encode((String)mi.getName()), AUrlUtil.encode((String)mi.getActionCommand()));
            JMenu m = HelpToolTips.getParentMenu(mi);
            Object menuPath = "";
            while (m != null) {
                menuPath = AUrlUtil.encode((String)HelpToolTips.getMenuText(m)) + (((String)menuPath).isEmpty() ? "" : "/") + (String)menuPath;
                m = HelpToolTips.getParentMenu(m);
            }
            props = (String)props + "&path=" + (String)menuPath;
        }
        return type + "/" + (String)path + (String)(((String)props).isEmpty() ? "" : "?" + (String)props);
    }

    public static String getActionType(Action action) {
        if (action == null) {
            return "";
        }
        Class<?> cls = action.getClass();
        if (!cls.isAnonymousClass()) {
            return action.getClass().getName();
        }
        Object at = cls.getName();
        at = ((String)at).substring(((String)at).lastIndexOf(46) + 1, ((String)at).lastIndexOf(36)) + ".anonymous";
        return at;
    }

    public static String getMenuText(JMenuItem mi) {
        String text = mi.getText();
        text = HelpToolTips.stripTrailingDots(text);
        return text;
    }

    public static String stripTrailingDots(String text) {
        while (text != null && text.endsWith(".")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static JMenu getParentMenu(JMenuItem mi) {
        JPopupMenu pm = (JPopupMenu)UIUtil.getAncestorOfType((Component)mi, JPopupMenu.class);
        if (pm == null) {
            return null;
        }
        Component c = pm.getInvoker();
        if (!(c instanceof JMenu)) {
            return null;
        }
        return (JMenu)c;
    }

    public static ClassLoader getResourceLoader() {
        File appInstDir;
        if (gResourceLoader == null && (appInstDir = AApp.getInstallDir()) != null) {
            File resDir = new File(appInstDir, "res");
            if (!resDir.isDirectory()) {
                ALog.logWarn((String)"Resource directory '%s' not found, resources may not load correctly.", (Object[])new Object[]{resDir.getAbsolutePath()});
            }
            try {
                URL[] resDirURL = new URL[]{resDir.toURI().toURL()};
                gResourceLoader = new URLClassLoader(resDirURL);
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error setting up resource loader, resources may not load correctly.", (Object[])new Object[0]);
                gResourceLoader = ClassLoader.getSystemClassLoader();
            }
        }
        return gResourceLoader;
    }

    public static String getShorterKey(String key) {
        return AStream.of((Object[])new Integer[]{key.lastIndexOf(63), key.lastIndexOf(47), key.lastIndexOf(43), key.lastIndexOf(38)}).filter(i -> i > 0).min((a, b) -> Integer.compare(b, a)).map(i -> key.substring(0, (int)i)).orElse(null);
    }

    public static Optional<String> getTipForMenuItem(String key) {
        String tip = null;
        while (tip == null && key != null) {
            tip = HelpToolTips.getMenuTip(key);
            if (tip != null) continue;
            key = HelpToolTips.getShorterKey(key);
        }
        return Optional.ofNullable(tip);
    }

    public static void reload() {
        gResourceLoader = null;
        gResourceBundleMenuTips = null;
    }

    protected static String getMenuTip(String key) {
        if (gResourceBundleMenuTips == null) {
            try {
                gResourceBundleMenuTips = ResourceBundle.getBundle("MenuTips", Locale.getDefault(), HelpToolTips.getResourceLoader());
            }
            catch (Exception e) {
                ALog.logWarn((Throwable)e, (String)"Error loading menu tips. %s", (Object[])new Object[]{e.getMessage()});
                gResourceBundleMenuTips = new ListResourceBundle(){

                    @Override
                    protected Object[][] getContents() {
                        return new Object[0][];
                    }
                };
            }
        }
        try {
            return gResourceBundleMenuTips.getString(key);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }
}

