/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.intf;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.orbit.ui.InterfaceTreeUI;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class IntfTreeNode
extends DefaultMutableTreeNode
implements Comparable<Object> {
    protected String mCacheText = null;

    public IntfTreeNode(Object editedNode) {
        super(editedNode);
    }

    public IntfTreeNode() {
    }

    public void sort() {
        for (TreeNode e : this.children) {
            if (!(e instanceof IntfTreeNode)) continue;
            IntfTreeNode node = (IntfTreeNode)e;
            node.mCacheText = node.toString();
        }
        this.children.sort((a, b) -> {
            assert (a instanceof IntfTreeNode);
            return ((IntfTreeNode)a).compareTo(b);
        });
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.sort();
    }

    @Override
    public int compareTo(Object o) {
        if (this.getUserObject() instanceof Floorplan && o instanceof IntfTreeNode && ((IntfTreeNode)o).getUserObject() instanceof Interface) {
            return -1;
        }
        if (this.getUserObject() instanceof Interface && o instanceof IntfTreeNode && ((IntfTreeNode)o).getUserObject() instanceof Floorplan) {
            return 1;
        }
        if (o instanceof IntfTreeNode) {
            AAlphaNumComp c = AAlphaNumComp.get();
            return c.compare((Object)this.mCacheText, (Object)((IntfTreeNode)o).mCacheText);
        }
        AAlphaNumComp c = AAlphaNumComp.get();
        return c.compare((Object)this.toString(), (Object)o.toString());
    }

    public String getText() {
        Object obj = this.getUserObject();
        if (obj instanceof Interface) {
            return ((Interface)obj).getName();
        }
        if (obj instanceof Floorplan) {
            return ((Floorplan)obj).getDeviceTemplate().getName();
        }
        return "[Invalid]";
    }

    public Icon getIcon() {
        Object obj = this.getUserObject();
        if (obj instanceof Interface) {
            Interface intf = (Interface)obj;
            if (intf.getVisible()) {
                return new AColorIcon(16, 16, intf.getColor());
            }
            return new AColorIcon(16, 16, 10, intf.getColor(), Color.white);
        }
        if (obj instanceof Floorplan) {
            return InterfaceTreeUI.ICON_FLOORPLAN;
        }
        return null;
    }

    public String getComment() {
        Object obj = this.getUserObject();
        if (obj instanceof Interface) {
            Interface intf = (Interface)obj;
            return "--/" + intf.getExpectedIOCount();
        }
        if (obj instanceof Floorplan) {
            Floorplan fp = (Floorplan)obj;
            return fp.getIOCountStr() + "/" + fp.getMyInterface().getExpectedIOCount();
        }
        return null;
    }
}

