/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.netlist_editor;

import com.sigrity.acl.db.std.Device;
import com.sigrity.orbit.jfxui.ItemSelectMenuItem;
import com.sigrity.orbit.ui.netlist_editor.ItemFilters;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class FilterMenuItems {
    public static List<MenuItem> getBumpFilterMenuItems() {
        return FilterMenuItems.getBumpFilterMenuItems(null);
    }

    public static List<MenuItem> getBumpFilterMenuItems(Runnable refreshAction) {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        ItemGroup signalPGfilterGroup = FilterMenuItems.getItemGroup(refreshAction, ItemFilters.IsSignalBumpFilter.get(), ItemFilters.IsPGBumpFilter.get());
        list.addAll(signalPGfilterGroup.getFilterMenuItems());
        list.add((MenuItem)new SeparatorMenuItem());
        ItemGroup withNetfilterGroup = FilterMenuItems.getItemGroup(refreshAction, ItemFilters.WithNetBumpFilter.get(), ItemFilters.WithoutNetBumpFilter.get());
        list.addAll(withNetfilterGroup.getFilterMenuItems());
        list.add((MenuItem)new SeparatorMenuItem());
        ItemGroup withTermfilterGroup = FilterMenuItems.getItemGroup(refreshAction, ItemFilters.WithTermBumpFitler.get(), ItemFilters.WithoutTermBumpFitler.get());
        list.addAll(withTermfilterGroup.getFilterMenuItems());
        return list;
    }

    public static List<MenuItem> getChildTermFilterMenuItems(Device childDev) {
        return FilterMenuItems.getChildTermFilterMenuItems(null, childDev);
    }

    public static List<MenuItem> getChildTermFilterMenuItems(Runnable refreshAction, Device childDev) {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        ItemGroup mappedfilterGroup = FilterMenuItems.getItemGroup(refreshAction, ItemFilters.IsMappedTermFilter.get(childDev), ItemFilters.IsUmappedTermFilter.get(childDev));
        list.addAll(mappedfilterGroup.getFilterMenuItems());
        return list;
    }

    public static List<MenuItem> getTermFilterMenuItems() {
        return FilterMenuItems.getTermFilterMenuItems(null);
    }

    public static List<MenuItem> getTermFilterMenuItems(Runnable refreshAction) {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        ItemGroup signalPGfilterGroup = FilterMenuItems.getItemGroup(refreshAction, ItemFilters.IsSignalTermFilter.get(), ItemFilters.IsPGTermFilter.get());
        list.addAll(signalPGfilterGroup.getFilterMenuItems());
        return list;
    }

    public static List<MenuItem> getNetFilterMenuItems() {
        return FilterMenuItems.getNetFilterMenuItems(null);
    }

    public static List<MenuItem> getNetFilterMenuItems(Runnable refreshAction) {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        ItemGroup signalPGfilterGroup = FilterMenuItems.getItemGroup(refreshAction, ItemFilters.IsSignalNetFitler.get(), ItemFilters.IsPGNetFitler.get());
        list.addAll(signalPGfilterGroup.getFilterMenuItems());
        list.add((MenuItem)new SeparatorMenuItem());
        ItemGroup mappedfilterGroup = FilterMenuItems.getItemGroup(refreshAction, ItemFilters.IsMappedNetFilter.get(), ItemFilters.IsUnmappedNetFilter.get());
        list.addAll(mappedfilterGroup.getFilterMenuItems());
        list.add((MenuItem)new SeparatorMenuItem());
        ItemGroup withTermfilterGroup = FilterMenuItems.getItemGroup(refreshAction, ItemFilters.WithTermNetFitler.get(), ItemFilters.WithoutTermNetFilter.get());
        list.addAll(withTermfilterGroup.getFilterMenuItems());
        return list;
    }

    @SafeVarargs
    public static <T> ItemGroup<T> getItemGroup(Runnable refreshAction, ItemFilters.ItemFilter<T> ... filters) {
        ItemGroup<T> filterGroup = new ItemGroup<T>();
        for (ItemFilters.ItemFilter<T> filter : filters) {
            FilterMenuItem<T> filterMenuGroup = new FilterMenuItem<T>(filter, refreshAction);
            filterGroup.add(filterMenuGroup);
        }
        return filterGroup;
    }

    public static <T> boolean isVisibleItem(List<MenuItem> filterMenuItems, T item) {
        if (item == null) {
            return false;
        }
        for (MenuItem menuItem : filterMenuItems) {
            Object f;
            if (menuItem instanceof FilterMenuItem && !((FilterMenuItem)((Object)(f = (FilterMenuItem)menuItem))).include(item)) {
                return false;
            }
            if (!(menuItem instanceof ItemSelectMenuItem) || ((ItemSelectMenuItem)((Object)(f = (ItemSelectMenuItem)menuItem))).getPredicate().test(item)) continue;
            return false;
        }
        return true;
    }

    private FilterMenuItems() {
    }

    private static interface ChangeListener<T> {
        public void actionChanged(FilterMenuItem<T> var1, boolean var2);
    }

    protected static class ItemGroup<T> {
        private List<FilterMenuItem<T>> mFilters = new ArrayList<FilterMenuItem<T>>();

        protected ItemGroup() {
        }

        protected void add(FilterMenuItem<T> filter) {
            this.mFilters.add(filter);
            filter.addListener(this::exclude);
        }

        protected void exclude(FilterMenuItem<T> source, boolean e) {
            if (!e) {
                return;
            }
            for (FilterMenuItem<T> f : this.mFilters) {
                if (f == source) continue;
                f.setSelected(false);
            }
        }

        public List<FilterMenuItem<T>> getFilterMenuItems() {
            return this.mFilters;
        }
    }

    public static class FilterMenuItem<T>
    extends CheckMenuItem {
        private final ItemFilters.ItemFilter<T> mFilter;
        private final Runnable changeAction;
        private final LinkedHashSet<ChangeListener<T>> changeListeners = new LinkedHashSet();

        FilterMenuItem(ItemFilters.ItemFilter<T> filter) {
            this(filter, null);
        }

        FilterMenuItem(ItemFilters.ItemFilter<T> filter, Runnable action) {
            super(filter.getUserText());
            this.mFilter = filter;
            this.changeAction = action;
            this.setOnAction(e -> this.setEnable(this.isSelected()));
        }

        public ItemFilters.ItemFilter<T> getFilter() {
            return this.mFilter;
        }

        protected void setEnable(boolean enable) {
            this.setSelected(enable);
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.actionChanged(this, enable);
            }
            if (this.changeAction != null) {
                this.changeAction.run();
            }
        }

        protected boolean include(T item) {
            return !this.isSelected() || this.mFilter.include(item);
        }

        protected void addListener(ChangeListener<T> changeListener) {
            this.changeListeners.add(changeListener);
        }
    }
}

