/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.netlist_editor;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.DevicePath;
import java.util.List;
import java.util.function.Predicate;

public class ItemFilters {
    private static final String IS_MATCHED_STRING = "is matched";
    private static final String WITH_NET_STRING = "with net";
    private static final String WITHOUT_NET_STRING = "without net";
    private static final String WITH_TERM_STRING = "with term";
    private static final String WITHOUT_TERM_STRING = "without term";
    private static final String IS_SIGNAL_STRING = "is signal";
    private static final String IS_PG_STRING = "is power/ground";

    public static <T> boolean isInclude(List<ItemFilter<T>> mItemFilters, T item) {
        for (ItemFilter<T> filter : mItemFilters) {
            if (filter.include(item)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPGBump(Device item) {
        for (TermMap tm : TermMap.getTermMaps((Device)item)) {
            Net parentNet = tm.getParentNet();
            if (!Net.isPowerNet((Net)parentNet)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasChildTermMapped(Net parentNet) {
        return parentNet != null && TermMap.getTermMaps((Net)parentNet).hasNext();
    }

    protected static boolean hasParentNetMapped(Device childDev, Term childTerm) {
        return childTerm != null && TermMap.getTermMap((Device)childDev, (Term)childTerm) != null;
    }

    private ItemFilters() {
    }

    protected static class MatchedFilter<T>
    implements ItemFilter<T> {
        private final Predicate<T> mIsHighLight;

        MatchedFilter(Predicate<T> isHightLight) {
            this.mIsHighLight = isHightLight;
        }

        @Override
        public boolean include(T item) {
            return item != null && this.mIsHighLight.test(item);
        }

        @Override
        public String getUserText() {
            return ItemFilters.IS_MATCHED_STRING;
        }
    }

    public static class IsPGBumpFilter
    implements ItemFilter<Device> {
        private static final IsPGBumpFilter FILTER = new IsPGBumpFilter();

        public static IsPGBumpFilter get() {
            return FILTER;
        }

        private IsPGBumpFilter() {
        }

        @Override
        public boolean include(Device item) {
            return ItemFilters.isPGBump(item);
        }

        @Override
        public String getUserText() {
            return ItemFilters.IS_PG_STRING;
        }
    }

    public static class IsSignalBumpFilter
    implements ItemFilter<Device> {
        private static final IsSignalBumpFilter FILTER = new IsSignalBumpFilter();

        public static IsSignalBumpFilter get() {
            return FILTER;
        }

        @Override
        public boolean include(Device item) {
            return !ItemFilters.isPGBump(item);
        }

        @Override
        public String getUserText() {
            return ItemFilters.IS_SIGNAL_STRING;
        }

        private IsSignalBumpFilter() {
        }
    }

    public static class IsPGTermFilter
    implements ItemFilter<Term> {
        private static final IsPGTermFilter FILTER = new IsPGTermFilter();

        public static IsPGTermFilter get() {
            return FILTER;
        }

        @Override
        public boolean include(Term item) {
            return item.isPowerGound();
        }

        @Override
        public String getUserText() {
            return ItemFilters.IS_PG_STRING;
        }

        private IsPGTermFilter() {
        }
    }

    public static class IsSignalTermFilter
    implements ItemFilter<Term> {
        private static final IsSignalTermFilter FILTER = new IsSignalTermFilter();

        public static IsSignalTermFilter get() {
            return FILTER;
        }

        @Override
        public boolean include(Term item) {
            return !item.isPowerGound();
        }

        @Override
        public String getUserText() {
            return ItemFilters.IS_SIGNAL_STRING;
        }

        private IsSignalTermFilter() {
        }
    }

    public static class IsPGNetFitler
    implements ItemFilter<Net> {
        private static final IsPGNetFitler FILTER = new IsPGNetFitler();

        public static IsPGNetFitler get() {
            return FILTER;
        }

        @Override
        public boolean include(Net item) {
            return Net.isPowerNet((Net)item);
        }

        @Override
        public String getUserText() {
            return ItemFilters.IS_PG_STRING;
        }

        private IsPGNetFitler() {
        }
    }

    public static class IsSignalNetFitler
    implements ItemFilter<Net> {
        private static final IsSignalNetFitler FILTER = new IsSignalNetFitler();

        public static IsSignalNetFitler get() {
            return FILTER;
        }

        @Override
        public boolean include(Net item) {
            return !Net.isPowerNet((Net)item);
        }

        @Override
        public String getUserText() {
            return ItemFilters.IS_SIGNAL_STRING;
        }

        private IsSignalNetFitler() {
        }
    }

    public static class WithoutNetBumpFilter
    implements ItemFilter<Device> {
        private static final WithoutNetBumpFilter FILTER = new WithoutNetBumpFilter();

        public static WithoutNetBumpFilter get() {
            return FILTER;
        }

        @Override
        public boolean include(Device item) {
            return !TermMap.getTermMaps((Device)item).hasNext();
        }

        @Override
        public String getUserText() {
            return ItemFilters.WITHOUT_NET_STRING;
        }

        private WithoutNetBumpFilter() {
        }
    }

    public static class WithNetBumpFilter
    implements ItemFilter<Device> {
        private static final WithNetBumpFilter FILTER = new WithNetBumpFilter();

        public static WithNetBumpFilter get() {
            return FILTER;
        }

        @Override
        public boolean include(Device item) {
            return TermMap.getTermMaps((Device)item).hasNext();
        }

        @Override
        public String getUserText() {
            return ItemFilters.WITH_NET_STRING;
        }

        private WithNetBumpFilter() {
        }
    }

    public static class WithoutTermBumpFitler
    implements ItemFilter<Device> {
        private static final WithoutTermBumpFitler FILTER = new WithoutTermBumpFitler();

        public static WithoutTermBumpFitler get() {
            return FILTER;
        }

        @Override
        public boolean include(Device item) {
            PinLabel pinLabel = PinLabel.get((DevicePath)new DevicePath(item), (PinTemplate)item.getPin().getPinTemplate(), (boolean)false);
            return pinLabel == null || pinLabel.getTerm() == null;
        }

        @Override
        public String getUserText() {
            return ItemFilters.WITHOUT_TERM_STRING;
        }

        private WithoutTermBumpFitler() {
        }
    }

    public static class WithTermBumpFitler
    implements ItemFilter<Device> {
        private static final WithTermBumpFitler FILTER = new WithTermBumpFitler();

        public static WithTermBumpFitler get() {
            return FILTER;
        }

        @Override
        public boolean include(Device item) {
            PinLabel pinLabel = PinLabel.get((DevicePath)new DevicePath(item), (PinTemplate)item.getPin().getPinTemplate(), (boolean)false);
            return pinLabel != null && pinLabel.getTerm() != null;
        }

        @Override
        public String getUserText() {
            return ItemFilters.WITH_TERM_STRING;
        }

        private WithTermBumpFitler() {
        }
    }

    public static class WithoutTermNetFilter
    implements ItemFilter<Net> {
        private static final WithoutTermNetFilter FILTER = new WithoutTermNetFilter();

        public static WithoutTermNetFilter get() {
            return FILTER;
        }

        @Override
        public boolean include(Net item) {
            return !item.getTerms().hasNext();
        }

        @Override
        public String getUserText() {
            return ItemFilters.WITHOUT_TERM_STRING;
        }

        private WithoutTermNetFilter() {
        }
    }

    public static class WithTermNetFitler
    implements ItemFilter<Net> {
        private static final WithTermNetFitler FILTER = new WithTermNetFitler();

        public static WithTermNetFitler get() {
            return FILTER;
        }

        @Override
        public boolean include(Net item) {
            return item.getTerms().hasNext();
        }

        @Override
        public String getUserText() {
            return ItemFilters.WITH_TERM_STRING;
        }

        private WithTermNetFitler() {
        }
    }

    private static class UnmappedFilter<T>
    implements ItemFilter<T> {
        private final Predicate<T> mIsUnmap;

        UnmappedFilter(Predicate<T> isUnmap) {
            this.mIsUnmap = isUnmap;
        }

        @Override
        public boolean include(T item) {
            return this.mIsUnmap.test(item);
        }

        @Override
        public String getUserText() {
            return "is unmapped";
        }
    }

    public static class IsUmappedTermFilter
    extends UnmappedFilter<Term> {
        public static IsUmappedTermFilter get(Device ownerDev) {
            return new IsUmappedTermFilter(ownerDev);
        }

        private IsUmappedTermFilter(Device ownerDev) {
            super((T term) -> !ItemFilters.hasParentNetMapped(ownerDev, term));
        }
    }

    public static class IsUnmappedNetFilter
    extends UnmappedFilter<Net> {
        private static final IsUnmappedNetFilter FILTER = new IsUnmappedNetFilter();

        public static IsUnmappedNetFilter get() {
            return FILTER;
        }

        private IsUnmappedNetFilter() {
            super(net -> !ItemFilters.hasChildTermMapped(net));
        }
    }

    private static class MappedFilter<T>
    implements ItemFilter<T> {
        private final Predicate<T> mIsMap;

        MappedFilter(Predicate<T> isMap) {
            this.mIsMap = isMap;
        }

        @Override
        public boolean include(T item) {
            return this.mIsMap.test(item);
        }

        @Override
        public String getUserText() {
            return "is mapped";
        }
    }

    public static class IsMappedTermFilter
    extends MappedFilter<Term> {
        public static IsMappedTermFilter get(Device ownerDev) {
            return new IsMappedTermFilter(ownerDev);
        }

        private IsMappedTermFilter(Device ownerDev) {
            super((T term) -> ItemFilters.hasParentNetMapped(ownerDev, term));
        }
    }

    public static class IsMappedNetFilter
    extends MappedFilter<Net> {
        private static final IsMappedNetFilter FILTER = new IsMappedNetFilter();

        public static IsMappedNetFilter get() {
            return FILTER;
        }

        private IsMappedNetFilter() {
            super(ItemFilters::hasChildTermMapped);
        }
    }

    public static interface ItemFilter<T> {
        public boolean include(T var1);

        public String getUserText();
    }
}

