/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.netlist_editor;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXMenuButton;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.AListView;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.acl.jfxui.SlowOperationAlert;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.NetGraphPanel;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.bump.BumpContentsChooserDlg;
import com.sigrity.orbit.bump.BumpSelectedInfo;
import com.sigrity.orbit.jfxui.DevicePathTextBox;
import com.sigrity.orbit.jfxui.ItemSelectMenuItem;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.term.ui.TermCreateUI;
import com.sigrity.orbit.term.ui.TermRenameUI;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.NetUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.bulk.BulkMapNetTermUI;
import com.sigrity.orbit.ui.bulk.BulkMapTermTermUI;
import com.sigrity.orbit.ui.bulk.BulkRenameNetUI;
import com.sigrity.orbit.ui.bulk.BulkRenameTermUI;
import com.sigrity.orbit.ui.bulk.Bump2TermBulkCreateUI;
import com.sigrity.orbit.ui.bulk.ChildTerm2ParentNetBulkCreateUI;
import com.sigrity.orbit.ui.bulk.ChildTerm2ParentTermBulkCreateUI;
import com.sigrity.orbit.ui.bulk.Net2TermBulkCreateUI;
import com.sigrity.orbit.ui.bulk.ParentNet2ChildTermBulkCreateUI;
import com.sigrity.orbit.ui.bulk.ParentTerm2ChildTermBulkCreateUI;
import com.sigrity.orbit.ui.bulk.Term2NetBulkCreateUI;
import com.sigrity.orbit.ui.bulk.UserBulkRenameNetUI;
import com.sigrity.orbit.ui.bulk.UserBulkRenameTermUI;
import com.sigrity.orbit.ui.bulk.UserBump2TermBulkCreateUI;
import com.sigrity.orbit.ui.bulk.UserNet2TermBulkCreateUI;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.netlist_editor.FilterMenuItems;
import com.sigrity.orbit.ui.netlist_editor.ItemFilters;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Callback;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class NetListEditorUI
extends AJFXDesignDialog {
    private static final String TITLE = "Netlist Editor";
    private DevicePath mInitDevPath;

    public static Action getAction(final DevicePath devPath) {
        return new AbstractAction("Netlist..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetListEditorUI.createDialog(OrbitIO.getMainWindow(), devPath);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static NetListEditorUI createDialog(Window owner, Db db) {
        if (db == null) {
            return null;
        }
        DevicePath designPath = Design.getDesignPath((Db)db);
        return NetListEditorUI.createDialog(owner, designPath);
    }

    public static NetListEditorUI createDialog(Window owner, Db db, String initDevPathStr) {
        if (db == null) {
            return null;
        }
        DevicePath initDevPath = DevicePath.fromString((Db)db, (String)initDevPathStr);
        return NetListEditorUI.createDialog(owner, initDevPath);
    }

    public static NetListEditorUI createDialog(Window owner, DevicePath initDevPath) {
        if (initDevPath == null || initDevPath.getDb() == null || !initDevPath.isValid() || !initDevPath.getIsAbsolute()) {
            assert (false);
            return null;
        }
        NetListEditorUI dlg = new NetListEditorUI(owner, initDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected NetListEditorUI(Window owner, DevicePath initDevPath) {
        super(initDevPath.getDb(), owner, TITLE);
        this.mInitDevPath = initDevPath;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new NetListManagementPanel();
    }

    private static void cpTermSetNet(Term term, Net net) {
        Cp.exec((String)"%s.setNet(%s);", (Object[])new Object[]{CpHelper.getObjCmdStr(term), CpHelper.getObjCmdStr(net)});
    }

    private static void cpPinSetTerm(PinTemplate pin, Term term) {
        Cp.exec((String)"%s.setTerm(%s);", (Object[])new Object[]{CpHelper.getObjCmdStr(pin), CpHelper.getObjCmdStr(term)});
    }

    private static void cpPinSetNet(PinTemplate pin, Net net) {
        Cp.exec((String)"%s.setNet(%s);", (Object[])new Object[]{CpHelper.getObjCmdStr(pin), CpHelper.getObjCmdStr(net)});
    }

    private static void cpMapChildTerm(Device childDev, Term childTerm, Net parentNet) {
        Cp.exec((String)"TermMap.mapChildTerm(%s, %s, %s);", (Object[])new Object[]{CpHelper.getObjCmdStr(childDev), CpHelper.getObjCmdStr(childTerm), CpHelper.getObjCmdStr(parentNet)});
    }

    private static void cpTermMapUnmapAll(Device dev) {
        Cp.exec((String)"com.sigrity.acl.db.std.TermMap.unmapAll(%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(dev)});
    }

    private static void cpUnmapChildernOfSelectedNets() {
        Cp.exec((String)"com.sigrity.orbit.cmd.NetCmd.upmapChildrenOfSelected(curDb())", (Object[])new Object[0]);
    }

    private static void cpUnmapParentNetOfSelectedTerms() {
        Cp.exec((String)"com.sigrity.orbit.cmd.TermCmd.upmapParentNetOfSelected(curDb())", (Object[])new Object[0]);
    }

    private class NetListManagementPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 530;
        private DevicePathTextBox mDevicePathTextBox;
        private TargetDevTPanel mTargetDevTPane;
        private CollapsedTargetBox mCollapsedTargetBox;

        public NetListManagementPanel() {
            this.setPreferredSize(new Dimension(600, 530));
        }

        protected Parent initSceneGraph() {
            BorderPane mainPane = new BorderPane();
            this.mDevicePathTextBox = new DevicePathTextBox((Window)((Object)NetListEditorUI.this), NetListEditorUI.this.mInitDevPath){

                @Override
                protected void refreshAssociateNodes() {
                    NetListManagementPanel.this.mTargetDevTPane.clearTracedNet();
                    NetListManagementPanel.this.mTargetDevTPane.reloadItems();
                    NetListManagementPanel.this.mTargetDevTPane.closeInvisibleBox();
                    NetListManagementPanel.this.mCollapsedTargetBox.reloadItems();
                    NetListManagementPanel.this.mCollapsedTargetBox.refreshBtns();
                }
            };
            mainPane.setTop((Node)this.mDevicePathTextBox);
            this.mCollapsedTargetBox = new CollapsedTargetBox();
            mainPane.setLeft((Node)this.mCollapsedTargetBox);
            this.mTargetDevTPane = new TargetDevTPanel();
            mainPane.setCenter((Node)this.mTargetDevTPane);
            CloseHBox closeBox = new CloseHBox((Window)((Object)NetListEditorUI.this));
            closeBox.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
            mainPane.setBottom((Node)closeBox);
            return mainPane;
        }

        private DevicePath getTargetDevPath() {
            return this.mDevicePathTextBox.getDevicePath();
        }

        private DeviceTemplate getTargetDevT() {
            return this.getTargetDevPath().getDeviceTemplate();
        }

        private Device getTargetDev() {
            return this.getTargetDevPath().getDevice();
        }

        private class TargetDevTPanel
        extends SplitPane {
            private static final String HIGHLIGHT_STYLE = "-fx-background-color: gold; -fx-text-fill: black;";
            private static final String SELECTED_HIGHLIGHT_STYLE = "-fx-background-color: goldenrod; -fx-text-fill: black;";
            private ParentTermBox mTermsBox;
            private NetsBox mNetsBox;
            private PinsBox mPinsBox;
            private BumpsBox mBumpsBox;
            private PadsBox mPadsBox;
            private ChildrenBox mChildrenChildBox;
            private Set<Net> mTracedNets = new HashSet<Net>();
            private DbObject mDragedObj;
            private Device mDragedObjOwner;
            private final List<Class<? extends ItemsBox<? extends DbObject>>> mItemBoxOrder = AUtil.arrayList((Object[])new Class[]{ParentTermBox.class, NetsBox.class, PinsBox.class, BumpsBox.class, PadsBox.class, ChildrenBox.class});
            private final Comparator<Node> mItemBoxComparator = (nodeA, nodeB) -> {
                if (!(nodeA instanceof ItemsBox) || !(nodeB instanceof ItemsBox)) {
                    assert (false);
                    return 1;
                }
                int indexOfA = this.mItemBoxOrder.indexOf(nodeA.getClass());
                int indexOfB = this.mItemBoxOrder.indexOf(nodeB.getClass());
                return Integer.compare(indexOfA, indexOfB);
            };

            public TargetDevTPanel() {
                this.getItems().add((Object)this.getTermsBox());
                this.getItems().add((Object)this.getNetsBox());
                this.getItems().add((Object)this.getChildrenBox());
                this.sortItemBox();
            }

            public ParentTermBox getTermsBox() {
                if (this.mTermsBox == null) {
                    this.mTermsBox = new ParentTermBox();
                    HBox.setHgrow((Node)this.mTermsBox, (Priority)Priority.ALWAYS);
                }
                return this.mTermsBox;
            }

            public NetsBox getNetsBox() {
                if (this.mNetsBox == null) {
                    this.mNetsBox = new NetsBox();
                    HBox.setHgrow((Node)this.mNetsBox, (Priority)Priority.ALWAYS);
                }
                return this.mNetsBox;
            }

            public PinsBox getPinsBox() {
                if (this.mPinsBox == null) {
                    this.mPinsBox = new PinsBox();
                    HBox.setHgrow((Node)this.mPinsBox, (Priority)Priority.ALWAYS);
                }
                return this.mPinsBox;
            }

            public BumpsBox getBumpsBox() {
                if (this.mBumpsBox == null) {
                    this.mBumpsBox = new BumpsBox();
                    HBox.setHgrow((Node)this.mBumpsBox, (Priority)Priority.ALWAYS);
                }
                return this.mBumpsBox;
            }

            public PadsBox getPadsBox() {
                if (this.mPadsBox == null) {
                    this.mPadsBox = new PadsBox();
                    HBox.setHgrow((Node)this.mPadsBox, (Priority)Priority.ALWAYS);
                }
                return this.mPadsBox;
            }

            public ChildrenBox getChildrenBox() {
                if (this.mChildrenChildBox == null) {
                    this.mChildrenChildBox = new ChildrenBox();
                    HBox.setHgrow((Node)this.mChildrenChildBox, (Priority)Priority.ALWAYS);
                }
                return this.mChildrenChildBox;
            }

            public void clearTracedNet() {
                this.mTracedNets.clear();
            }

            public void refresh() {
                for (Node node : this.getItems()) {
                    if (!(node instanceof ItemsBox)) continue;
                    ((ItemsBox)node).refresh();
                }
            }

            public void reloadItems() {
                for (Node node : this.getItems()) {
                    if (!(node instanceof ItemsBox)) continue;
                    ((ItemsBox)node).reloadItems();
                }
            }

            public void closeInvisibleBox() {
                for (Node node : AUtil.arrayList((Collection)this.getItems())) {
                    TargetBoxExpandBtn expandBtn;
                    AJFXButton btn;
                    if (!(node instanceof ItemsBox) || !((btn = ((ItemsBox)node).getCollapseBtn()) instanceof BoxCollapseBtn) || (expandBtn = ((BoxCollapseBtn)btn).getExpandBtn()).isBtnVisible()) continue;
                    this.getItems().remove((Object)node);
                    NetListManagementPanel.this.mCollapsedTargetBox.add(expandBtn);
                }
            }

            public void scrollToTraced() {
                for (Node node : this.getItems()) {
                    if (!(node instanceof ItemsBox)) continue;
                    ((ItemsBox)node).scrollToTraced();
                }
            }

            public void addItemBox(Node itemBox) {
                this.getItems().add((Object)itemBox);
                this.sortItemBox();
            }

            private void sortItemBox() {
                ObservableList boxes = FXCollections.observableArrayList((Collection)this.getItems());
                Collections.sort(boxes, this.mItemBoxComparator);
                this.getItems().setAll((Collection)boxes);
            }

            protected abstract class ItemsBox<T extends DbObject>
            extends VBox {
                private final Image titleImage;
                private final String title;
                private Label mInfoLabel;
                private AJFXMenuButton mTiltleMenuBtn;
                private AJFXButton mCollapseBtn;
                private Menu mFiltersMenu;
                private Menu mConditionFiltersMenu;
                private Menu mValueFiltersMenu;
                protected ItemSelectMenuItem<T> mItemSelectMenuItem;

                public ItemsBox(String title, Image titleImage) {
                    super(2.0);
                    this.titleImage = titleImage;
                    this.title = title;
                }

                public abstract List<T> getItems();

                public abstract void reloadItems();

                public abstract void refresh();

                public abstract void scrollToTraced();

                protected abstract TargetBoxExpandBtn getExpandBtn();

                protected abstract Node getItemsPaneNode();

                protected abstract T getSelectedItem();

                protected abstract List<T> getSelectedItems();

                protected abstract Set<Net> getSelectedItemConnectNet();

                protected abstract boolean isHighLight(T var1);

                protected abstract String getShowedStr(T var1);

                protected abstract Image getShowedImage(T var1);

                protected abstract Device getBoxOwner();

                protected abstract DeviceTemplate getBoxOwnerTemplate();

                protected abstract int getNumMatches();

                protected abstract int getNumItems();

                protected abstract void refreshItemFilter();

                protected AJFXButton newCollapseBtn() {
                    TargetBoxExpandBtn expandBtn = this.getExpandBtn();
                    if (expandBtn == null) {
                        assert (false);
                        return null;
                    }
                    return new BoxCollapseBtn((Pane)this, expandBtn);
                }

                protected final AJFXButton getCollapseBtn() {
                    return this.mCollapseBtn;
                }

                protected final ObservableList<T> getItemsObservableList() {
                    return FXCollections.observableArrayList(this.getItems());
                }

                protected final void init() {
                    VBox boxTitlePane = new VBox();
                    HBox topBox = new HBox();
                    HBox leftBox = new HBox();
                    this.mTiltleMenuBtn = new AJFXMenuButton(this.titleImage, this.title, null);
                    this.mTiltleMenuBtn.setPadding(new Insets(2.0));
                    this.mTiltleMenuBtn.transparentBorder();
                    leftBox.getChildren().add((Object)this.mTiltleMenuBtn);
                    this.setTiTleMenu();
                    topBox.getChildren().add((Object)leftBox);
                    this.mCollapseBtn = this.newCollapseBtn();
                    if (this.mCollapseBtn != null) {
                        HBox rightBox = new HBox();
                        rightBox.setAlignment(Pos.TOP_RIGHT);
                        rightBox.getChildren().add((Object)this.mCollapseBtn);
                        HBox.setHgrow((Node)rightBox, (Priority)Priority.ALWAYS);
                        topBox.getChildren().add((Object)rightBox);
                    }
                    boxTitlePane.getChildren().add((Object)topBox);
                    ItemsBox.setVgrow((Node)boxTitlePane, (Priority)Priority.NEVER);
                    this.getChildren().add((Object)boxTitlePane);
                    ItemsBox.setVgrow((Node)this.getItemsPaneNode(), (Priority)Priority.ALWAYS);
                    this.getChildren().add((Object)this.getItemsPaneNode());
                    this.mInfoLabel = new Label(this.getBoxInfo());
                    this.mInfoLabel.setFont(Font.font(null, (FontWeight)FontWeight.EXTRA_LIGHT, (double)11.0));
                    boxTitlePane.getChildren().add((Object)this.mInfoLabel);
                    this.setMinWidth(Double.NEGATIVE_INFINITY);
                    this.setPrefWidth(100.0);
                }

                protected void setTiTleMenu() {
                    this.loadFiltersMenu();
                }

                protected void loadFiltersMenu() {
                    this.mFiltersMenu = new Menu("Filters");
                    this.mConditionFiltersMenu = new Menu("By condition");
                    this.mValueFiltersMenu = new Menu("By values");
                    this.mItemSelectMenuItem = new ItemSelectMenuItem<DbObject>(this::getShowedStr);
                    this.mItemSelectMenuItem.refreshItems(this.getItemsObservableList());
                    this.mItemSelectMenuItem.setOnAction(e -> this.refreshItemFilter());
                    this.mItemSelectMenuItem.addKeyPressedListener(key -> {
                        if (key == KeyCode.ENTER) {
                            this.mTiltleMenuBtn.hide();
                        }
                    });
                    this.addValueFilterMenuItem((MenuItem)this.mItemSelectMenuItem);
                    ItemFilters.MatchedFilter<DbObject> filter = new ItemFilters.MatchedFilter<DbObject>(this::isHighLight);
                    FilterMenuItems.FilterMenuItem<DbObject> matchedFilter = new FilterMenuItems.FilterMenuItem<DbObject>(filter, this::refreshItemFilter);
                    this.addConditionFilterMenuItem((MenuItem)matchedFilter);
                    this.addFilterMenuItem(AUtil.arrayList((Object[])new MenuItem[]{this.mValueFiltersMenu, this.mConditionFiltersMenu}));
                    this.addTitleMenuItem((MenuItem)this.mFiltersMenu);
                }

                protected void addTitleMenuItem(List<MenuItem> menuItems) {
                    this.mTiltleMenuBtn.getItems().addAll(menuItems);
                }

                protected void addTitleMenuItem(MenuItem menuItem) {
                    this.mTiltleMenuBtn.getItems().add((Object)menuItem);
                }

                protected void addFilterMenuItem(List<MenuItem> menuItems) {
                    this.mFiltersMenu.getItems().addAll(menuItems);
                }

                protected void addFilterMenuItem(MenuItem menuItem) {
                    this.mFiltersMenu.getItems().add((Object)menuItem);
                }

                protected void addConditionFilterMenuItem(List<MenuItem> menuItems) {
                    this.mConditionFiltersMenu.getItems().addAll(menuItems);
                }

                protected void addConditionFilterMenuItem(MenuItem menuItem) {
                    this.mConditionFiltersMenu.getItems().add((Object)menuItem);
                }

                protected void addValueFilterMenuItem(List<MenuItem> menuItems) {
                    this.mValueFiltersMenu.getItems().addAll(menuItems);
                }

                protected void addValueFilterMenuItem(MenuItem menuItem) {
                    this.mValueFiltersMenu.getItems().add((Object)menuItem);
                }

                protected boolean isVisibleItem(T item) {
                    ArrayList<MenuItem> filters = new ArrayList<MenuItem>();
                    filters.addAll((Collection<MenuItem>)this.mValueFiltersMenu.getItems());
                    filters.addAll((Collection<MenuItem>)this.mConditionFiltersMenu.getItems());
                    return FilterMenuItems.isVisibleItem(filters, item);
                }

                protected void refreshInfo() {
                    this.mInfoLabel.setText(this.getBoxInfo());
                }

                private String getBoxInfo() {
                    if (TargetDevTPanel.this.mTracedNets.isEmpty()) {
                        return String.format(" %d items", this.getNumItems());
                    }
                    return String.format(" %d items, %d matches", this.getNumItems(), this.getNumMatches());
                }

                protected ContextMenu getCellContextMenu(T item) {
                    return null;
                }

                protected MenuItem getMenuDelete() {
                    MenuItem menuItemDelete = new MenuItem("Delete");
                    List<T> selectedItems = this.getSelectedItems();
                    menuItemDelete.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        CpHelper.cpClearSelection();
                        CpHelper.cpSelect(selectedItems);
                        CpHelper.cpDeleteSelected();
                        Platform.runLater(TargetDevTPanel.this::reloadItems);
                    }));
                    return menuItemDelete;
                }

                protected Callback<ListView<T>, ListCell<T>> getItemListCellFactory() {
                    return list -> new ItemListCell();
                }

                protected EventHandler<MouseEvent> getItemListViewEventHandler() {
                    return new EventHandler<MouseEvent>(){

                        public void handle(MouseEvent click) {
                            Set<Net> selectedItemConnectNet;
                            if (click.getButton() == MouseButton.PRIMARY && click.getClickCount() == 2 && (selectedItemConnectNet = ItemsBox.this.getSelectedItemConnectNet()) != null) {
                                TargetDevTPanel.this.mTracedNets.clear();
                                TargetDevTPanel.this.mTracedNets.addAll(selectedItemConnectNet);
                                TargetDevTPanel.this.scrollToTraced();
                                TargetDevTPanel.this.refresh();
                            }
                        }
                    };
                }

                protected void connectDragItem(T dbObj) {
                    if (dbObj == null || TargetDevTPanel.this.mDragedObj == null) {
                        return;
                    }
                    if (TargetDevTPanel.this.mDragedObjOwner == NetListManagementPanel.this.getTargetDev()) {
                        Device dragedDev;
                        if (TargetDevTPanel.this.mDragedObj instanceof Term) {
                            this.connectParentTerm(dbObj);
                        } else if (TargetDevTPanel.this.mDragedObj instanceof Net) {
                            this.connectParentNet(dbObj);
                        } else if (TargetDevTPanel.this.mDragedObj instanceof PinTemplate) {
                            this.connectParentPin(dbObj);
                        } else if (TargetDevTPanel.this.mDragedObj instanceof Device && (dragedDev = (Device)TargetDevTPanel.this.mDragedObj).isPin()) {
                            this.connectParentDevPin(dbObj);
                        }
                    } else if (TargetDevTPanel.this.mDragedObjOwner.getParent() == NetListManagementPanel.this.getTargetDevT() && TargetDevTPanel.this.mDragedObj instanceof Term) {
                        this.connectChildTerm(dbObj);
                    }
                }

                protected void connectParentTerm(T dbObj) {
                    this.preConnectAssert(dbObj);
                    assert (TargetDevTPanel.this.mDragedObjOwner == NetListManagementPanel.this.getTargetDev() && TargetDevTPanel.this.mDragedObj instanceof Term);
                }

                protected void connectParentNet(T dbObj) {
                    this.preConnectAssert(dbObj);
                    assert (TargetDevTPanel.this.mDragedObjOwner == NetListManagementPanel.this.getTargetDev() && TargetDevTPanel.this.mDragedObj instanceof Net);
                }

                protected void connectParentPin(T dbObj) {
                    this.preConnectAssert(dbObj);
                    assert (TargetDevTPanel.this.mDragedObjOwner == NetListManagementPanel.this.getTargetDev() && TargetDevTPanel.this.mDragedObj instanceof PinTemplate);
                }

                protected void connectParentDevPin(T dbObj) {
                    this.preConnectAssert(dbObj);
                    assert (TargetDevTPanel.this.mDragedObjOwner == NetListManagementPanel.this.getTargetDev() && TargetDevTPanel.this.mDragedObj instanceof Device);
                }

                protected void connectChildTerm(T dbObj) {
                    this.preConnectAssert(dbObj);
                    assert (TargetDevTPanel.this.mDragedObjOwner != null && TargetDevTPanel.this.mDragedObjOwner.getParent() == NetListManagementPanel.this.getTargetDevT() && TargetDevTPanel.this.mDragedObj instanceof Term);
                }

                private void preConnectAssert(T dbObj) {
                    assert (dbObj != null && TargetDevTPanel.this.mDragedObj != null);
                }

                protected class ItemListCell
                extends ListCell<T> {
                    protected ItemListCell() {
                    }

                    protected void updateItem(T item, boolean empty) {
                        super.updateItem(item, empty);
                        this.setContextMenu(ItemsBox.this.getCellContextMenu(item));
                        if (item == null || empty) {
                            this.setText(null);
                            this.setGraphic(null);
                            this.setStyle(ItemsBox.this.getStyle());
                            return;
                        }
                        if (ItemsBox.this.isHighLight(item)) {
                            if (this.isSelected()) {
                                this.setStyle(TargetDevTPanel.SELECTED_HIGHLIGHT_STYLE);
                            } else {
                                this.setStyle(TargetDevTPanel.HIGHLIGHT_STYLE);
                            }
                        } else {
                            this.setStyle(ItemsBox.this.getStyle());
                        }
                        this.setGraphic((Node)new ImageView(ItemsBox.this.getShowedImage(item)));
                        this.setText(ItemsBox.this.getShowedStr(item));
                        this.setDragHandler(item, empty);
                    }

                    private void setDragHandler(T item, boolean empty) {
                        this.setOnDragDetected(this.getDragDetectedHandler(item));
                        this.setOnDragEntered(this.getDragEnteredHandler(empty));
                        this.setOnDragExited(this.getDragExitedHandler());
                        this.setOnDragOver(this.getDragOverHandler());
                        this.setOnDragDropped(this.getDragDroppedHandler(item));
                    }

                    private EventHandler<MouseEvent> getDragDetectedHandler(T item) {
                        return event -> {
                            if (item != null) {
                                this.getListView().getSelectionModel().clearSelection();
                                this.getListView().getSelectionModel().select(item);
                                TargetDevTPanel.this.mDragedObj = item;
                                TargetDevTPanel.this.mDragedObjOwner = ItemsBox.this.getBoxOwner();
                                Dragboard db = this.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                                ClipboardContent content = new ClipboardContent();
                                content.putString(TargetDevTPanel.this.mDragedObj.getKeyStr());
                                db.setContent((Map)content);
                            }
                            event.consume();
                        };
                    }

                    private EventHandler<DragEvent> getDragEnteredHandler(boolean empty) {
                        return event -> {
                            if (!empty) {
                                Border border = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)});
                                this.setBorder(border);
                            }
                        };
                    }

                    private EventHandler<DragEvent> getDragExitedHandler() {
                        return event -> this.setBorder(null);
                    }

                    private EventHandler<DragEvent> getDragOverHandler() {
                        return event -> {
                            Dragboard db = event.getDragboard();
                            if (db.hasString()) {
                                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                            }
                            event.consume();
                        };
                    }

                    private EventHandler<DragEvent> getDragDroppedHandler(T item) {
                        return event -> {
                            if (item != null) {
                                SwingUtilities.invokeLater(() -> {
                                    ItemsBox.this.connectDragItem(item);
                                    TargetDevTPanel.this.mDragedObj = null;
                                    TargetDevTPanel.this.mDragedObjOwner = null;
                                    Platform.runLater(TargetDevTPanel.this::refresh);
                                });
                            }
                            event.setDropCompleted(true);
                            event.consume();
                        };
                    }
                }
            }

            private abstract class DeviceBox
            extends ItemsBox<Device> {
                private FilteredList<Device> mFilteredList;
                private AListView<Device> mDevListView;
                private Map<Device, ChildTermBox> dev2TermBox;
                protected SplitPane mMainPane;
                protected List<Device> childDevs;

                public DeviceBox(String title, Image titleImage) {
                    super(title, titleImage);
                }

                @Override
                public void refresh() {
                    this.refreshInfo();
                    this.refreshItemFilter();
                    this.mDevListView.refresh();
                    this.dev2TermBox.forEach((dev, termBox) -> termBox.refresh());
                }

                @Override
                public void reloadItems() {
                    this.childDevs = null;
                    for (Map.Entry entry : AUtil.arrayList(this.dev2TermBox.entrySet())) {
                        Device dev = (Device)entry.getKey();
                        ChildTermBox box = (ChildTermBox)((Object)entry.getValue());
                        if (dev.getParent() != NetListManagementPanel.this.getTargetDevT()) {
                            this.mMainPane.getItems().remove((Object)box);
                            this.dev2TermBox.remove(dev);
                            continue;
                        }
                        box.reloadItems();
                    }
                    this.mFilteredList = new FilteredList(this.getItemsObservableList());
                    this.mDevListView.setItems(this.mFilteredList);
                    this.mItemSelectMenuItem.refreshItems(this.getItemsObservableList());
                    this.refresh();
                }

                @Override
                protected Node getItemsPaneNode() {
                    if (this.mDevListView == null) {
                        this.mFilteredList = new FilteredList(this.getItemsObservableList(), data -> true);
                        this.mDevListView = new AListView(this.mFilteredList);
                        this.mDevListView.enableSearchByKeyTyped(Device::getName);
                        this.mDevListView.setCachedCellFactory(this.getItemListCellFactory());
                        this.mDevListView.setOnMouseClicked(this.getItemListViewEventHandler());
                        this.mDevListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                    }
                    this.dev2TermBox = new HashMap<Device, ChildTermBox>();
                    this.mMainPane = new SplitPane();
                    VBox.setVgrow(this.mDevListView, (Priority)Priority.ALWAYS);
                    VBox childDevsBox = new VBox(0.0, new Node[]{this.mDevListView});
                    this.mMainPane.getItems().add((Object)childDevsBox);
                    VBox.setVgrow((Node)this.mMainPane, (Priority)Priority.ALWAYS);
                    return this.mMainPane;
                }

                @Override
                protected void refreshItemFilter() {
                    this.mFilteredList.setPredicate(this::isVisibleItem);
                }

                @Override
                protected int getNumItems() {
                    return this.childDevs.size();
                }

                @Override
                protected Device getSelectedItem() {
                    return (Device)this.mDevListView.getSelectionModel().getSelectedItem();
                }

                @Override
                protected List<Device> getSelectedItems() {
                    return this.mDevListView.getSelectionModel().getSelectedItems();
                }

                @Override
                protected Set<Net> getSelectedItemConnectNet() {
                    Device selectedItem = this.getSelectedItem();
                    if (selectedItem == null) {
                        return Collections.emptySet();
                    }
                    return this.getConnectNet(selectedItem);
                }

                protected Set<Net> getConnectNet(Device childDev) {
                    return TermMap.getTermMaps((Device)childDev).stream().map(TermMap::getParentNet).collect(Collectors.toSet());
                }

                @Override
                protected boolean isHighLight(Device item) {
                    return item != null && TargetDevTPanel.this.mTracedNets.stream().anyMatch(net -> TermMap.getTermMaps((Device)item, (Net)net).hasNext());
                }

                @Override
                protected String getShowedStr(Device item) {
                    return item.getName();
                }

                @Override
                protected Image getShowedImage(Device item) {
                    Icon devIcon = DbExplorerPanel.getIconForDevice(item);
                    return JFXUtil.getFxImage((Icon)devIcon);
                }

                @Override
                protected Device getBoxOwner() {
                    return NetListManagementPanel.this.getTargetDev();
                }

                @Override
                protected DeviceTemplate getBoxOwnerTemplate() {
                    return NetListManagementPanel.this.getTargetDevT();
                }

                @Override
                public void scrollToTraced() {
                    HashSet<Device> traceditems = new HashSet<Device>();
                    for (Net net : TargetDevTPanel.this.mTracedNets) {
                        for (Device dev2 : TermMap.getChildDevices((Net)net)) {
                            if (dev2.isPin()) continue;
                            traceditems.add(dev2);
                        }
                    }
                    this.scrollTo(traceditems);
                    this.dev2TermBox.forEach((dev, termBox) -> termBox.scrollToTraced());
                }

                @Override
                protected void setTiTleMenu() {
                    super.setTiTleMenu();
                    this.addTitleMenuItem((MenuItem)new SeparatorMenuItem());
                    this.addTitleMenuItem(this.getExpandAllMenu());
                    this.addTitleMenuItem(this.getCollapseAllMenu());
                }

                private MenuItem getExpandAllMenu() {
                    MenuItem menuItem = new MenuItem("Expand all children");
                    menuItem.setOnAction(e -> {
                        Optional result;
                        int numItems = this.getNumItems();
                        if (numItems > 10 && ((result = SlowOperationAlert.showLargeNumUIAlert((Window)((Object)NetListEditorUI.this), (int)numItems)).isEmpty() || result.get() != ButtonType.OK)) {
                            return;
                        }
                        this.getItems().forEach(this::openChildTermBox);
                    });
                    return menuItem;
                }

                protected void openChildTermBox(Device device) {
                    ChildTermBox childTermBox = this.getChildTermBox(device);
                    if (!this.mMainPane.getItems().contains((Object)childTermBox)) {
                        this.mMainPane.getItems().add((Object)childTermBox);
                    }
                }

                protected ContextMenu getChildDevContextMenu(Device childDev) {
                    ContextMenu contextMenu = new ContextMenu();
                    contextMenu.getItems().addAll(this.getChildDevMenuItems(childDev));
                    return contextMenu;
                }

                private List<MenuItem> getChildDevMenuItems(Device childDev) {
                    if (childDev == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
                    DevicePath childDevPath = new DevicePath(NetListManagementPanel.this.getTargetDevPath(), childDev);
                    MenuItem bulkRenameTermMenu = this.getBulkRenameTermMenu(childDevPath);
                    menuItems.add(bulkRenameTermMenu);
                    Menu menuBulkMap = this.getBulkMapMenu(childDevPath);
                    menuItems.add((MenuItem)menuBulkMap);
                    Menu menuBulkCreate = this.getBulkCreateMenu(childDevPath);
                    menuItems.add((MenuItem)menuBulkCreate);
                    if (TermMap.getTermMaps((Device)childDev).hasNext()) {
                        MenuItem menuUnmapParentNets = this.getMenuUnmapParentNets(childDev);
                        menuItems.add(menuUnmapParentNets);
                    }
                    MenuItem traceConnMenuItem = this.getTraceConnMenuItem(childDev);
                    menuItems.add(traceConnMenuItem);
                    return menuItems;
                }

                private MenuItem getBulkRenameTermMenu(DevicePath childDevPath) {
                    MenuItem menuItem = new MenuItem("Bulk rename terms");
                    menuItem.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        BulkRenameTermUI ui = BulkRenameTermUI.showUI((Window)((Object)NetListEditorUI.this), childDevPath);
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(DeviceBox.this::reloadItems);
                            }
                        });
                    }));
                    return menuItem;
                }

                private Menu getBulkMapMenu(DevicePath childDevPath) {
                    Menu menuBulkMap = new Menu("Bulk map");
                    MenuItem menuBulkMapParentNet = this.getMenuBulkMapParentNet(childDevPath);
                    menuBulkMap.getItems().add((Object)menuBulkMapParentNet);
                    MenuItem menuBulkMapParentTerm = this.getMenuBulkMapParentTerm(childDevPath);
                    menuBulkMap.getItems().add((Object)menuBulkMapParentTerm);
                    return menuBulkMap;
                }

                private Menu getBulkCreateMenu(DevicePath childDevPath) {
                    Menu menuBulkMap = new Menu("Bulk create");
                    MenuItem menuBulkToParentNet = this.getBulkCreateParentNetMenu(childDevPath);
                    menuBulkMap.getItems().add((Object)menuBulkToParentNet);
                    MenuItem menuBulkToParentTerm = this.getBulkCreateParentTermMenu(childDevPath);
                    menuBulkMap.getItems().add((Object)menuBulkToParentTerm);
                    MenuItem menuBulkFromParentNet = this.getBulkCreateFromParentNetMenu(childDevPath);
                    menuBulkMap.getItems().add((Object)menuBulkFromParentNet);
                    MenuItem menuBulkFromParentTerm = this.getBulkCreateFromParentTermMenu(childDevPath);
                    menuBulkMap.getItems().add((Object)menuBulkFromParentTerm);
                    return menuBulkMap;
                }

                private MenuItem getMenuUnmapParentNets(Device childDev) {
                    MenuItem menuUnmapParentNets = new MenuItem("Unmap all parent nets");
                    menuUnmapParentNets.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        NetListEditorUI.cpTermMapUnmapAll(childDev);
                        Platform.runLater(TargetDevTPanel.this::refresh);
                    }));
                    return menuUnmapParentNets;
                }

                private MenuItem getMenuBulkMapParentNet(DevicePath childDevPath) {
                    MenuItem menuItemRename = new MenuItem("To Parent Nets");
                    menuItemRename.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        BulkMapNetTermUI ui = BulkMapNetTermUI.showUI((Window)((Object)NetListEditorUI.this), childDevPath);
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(TargetDevTPanel.this::refresh);
                            }
                        });
                    }));
                    return menuItemRename;
                }

                private MenuItem getMenuBulkMapParentTerm(DevicePath childDevPath) {
                    MenuItem menuItemRename = new MenuItem("To Parent Terms");
                    menuItemRename.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        BulkMapTermTermUI ui = BulkMapTermTermUI.showUI((Window)((Object)NetListEditorUI.this), childDevPath);
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(TargetDevTPanel.this::refresh);
                            }
                        });
                    }));
                    return menuItemRename;
                }

                private MenuItem getBulkCreateParentNetMenu(DevicePath childDevPath) {
                    MenuItem menuItemRename = new MenuItem("To Parent Nets");
                    menuItemRename.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        ChildTerm2ParentNetBulkCreateUI ui = ChildTerm2ParentNetBulkCreateUI.showUI((Window)((Object)NetListEditorUI.this), childDevPath);
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(TargetDevTPanel.this::reloadItems);
                            }
                        });
                    }));
                    return menuItemRename;
                }

                private MenuItem getBulkCreateParentTermMenu(DevicePath childDevPath) {
                    MenuItem menuItemRename = new MenuItem("To Parent Terms");
                    menuItemRename.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        ChildTerm2ParentTermBulkCreateUI ui = ChildTerm2ParentTermBulkCreateUI.showUI((Window)((Object)NetListEditorUI.this), childDevPath);
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(TargetDevTPanel.this::reloadItems);
                            }
                        });
                    }));
                    return menuItemRename;
                }

                private MenuItem getBulkCreateFromParentNetMenu(DevicePath childDevPath) {
                    MenuItem menuItemRename = new MenuItem("From Parent Nets");
                    menuItemRename.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        ParentNet2ChildTermBulkCreateUI ui = ParentNet2ChildTermBulkCreateUI.showUI((Window)((Object)NetListEditorUI.this), childDevPath);
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(TargetDevTPanel.this::reloadItems);
                            }
                        });
                    }));
                    return menuItemRename;
                }

                private MenuItem getBulkCreateFromParentTermMenu(DevicePath childDevPath) {
                    MenuItem menuItemRename = new MenuItem("From Parent Terms");
                    menuItemRename.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        ParentTerm2ChildTermBulkCreateUI ui = ParentTerm2ChildTermBulkCreateUI.showUI((Window)((Object)NetListEditorUI.this), childDevPath);
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(TargetDevTPanel.this::reloadItems);
                            }
                        });
                    }));
                    return menuItemRename;
                }

                private MenuItem getTraceConnMenuItem(Device childDev) {
                    MenuItem menuItemRename = new MenuItem("Trace Connectivity");
                    menuItemRename.setOnAction(e -> {
                        Set<Net> selectedItemConnectNet = this.getConnectNet(childDev);
                        if (selectedItemConnectNet != null) {
                            TargetDevTPanel.this.mTracedNets.clear();
                            TargetDevTPanel.this.mTracedNets.addAll(selectedItemConnectNet);
                            TargetDevTPanel.this.scrollToTraced();
                            TargetDevTPanel.this.refresh();
                        }
                    });
                    return menuItemRename;
                }

                private MenuItem getCollapseAllMenu() {
                    MenuItem menuItem = new MenuItem("Collapse all children");
                    menuItem.setOnAction(e -> this.dev2TermBox.forEach((dev, termBox) -> {
                        if (this.mMainPane.getItems().contains((Object)termBox)) {
                            this.mMainPane.getItems().remove((Object)termBox);
                        }
                    }));
                    return menuItem;
                }

                protected ChildTermBox getChildTermBox(Device dev) {
                    return this.dev2TermBox.computeIfAbsent(dev, d -> new ChildTermBox(dev));
                }

                protected void scrollTo(Set<Device> terms) {
                    this.mDevListView.scrollTo(terms);
                }

                protected class ChildTermBox
                extends TermBox {
                    private Device mChildDev;

                    public ChildTermBox(Device childDev) {
                        super(childDev.getTemplate(), childDev.getName());
                        this.mChildDev = childDev;
                        this.init();
                    }

                    @Override
                    protected Image getShowedImage(Term item) {
                        if (TermMap.getParentNet((Device)this.mChildDev, (Term)item) == null) {
                            return null;
                        }
                        return OrbitJFXImages.NETMAP_UP;
                    }

                    @Override
                    protected int getNumMatches() {
                        return TargetDevTPanel.this.mTracedNets.stream().mapToInt(net -> (int)AUtil.count((Iterator)TermMap.getChildTerms((Device)this.getBoxOwner(), (Net)net))).sum();
                    }

                    @Override
                    public void scrollToTraced() {
                        Set<Term> traceditems = TargetDevTPanel.this.mTracedNets.stream().flatMap(net -> TermMap.getChildTerms((Device)this.mChildDev, (Net)net).stream()).collect(Collectors.toSet());
                        this.scrollTo(traceditems);
                    }

                    @Override
                    protected void setTiTleMenu() {
                        super.setTiTleMenu();
                        this.addTitleMenuItem((MenuItem)new SeparatorMenuItem());
                        this.addTitleMenuItem(DeviceBox.this.getChildDevMenuItems(this.getBoxOwner()));
                    }

                    @Override
                    protected void loadFiltersMenu() {
                        super.loadFiltersMenu();
                        this.addConditionFilterMenuItem((MenuItem)new SeparatorMenuItem());
                        this.addConditionFilterMenuItem(FilterMenuItems.getChildTermFilterMenuItems(this::refreshItemFilter, this.getBoxOwner()));
                    }

                    @Override
                    protected TargetBoxExpandBtn getExpandBtn() {
                        return null;
                    }

                    @Override
                    protected AJFXButton newCollapseBtn() {
                        return new ChildTermCollapseBtn();
                    }

                    @Override
                    protected Set<Net> getSelectedItemConnectNet() {
                        TermMap termMap = TermMap.getTermMap((Device)this.mChildDev, (Term)this.getSelectedItem());
                        return termMap == null ? Collections.emptySet() : AUtil.hashSet((Object[])new Net[]{termMap.getParentNet()});
                    }

                    @Override
                    protected boolean isHighLight(Term item) {
                        TermMap termMap = TermMap.getTermMap((Device)this.mChildDev, (Term)item);
                        return termMap != null && TargetDevTPanel.this.mTracedNets.contains(termMap.getParentNet());
                    }

                    @Override
                    protected void connectParentTerm(Term dbObj) {
                        super.connectParentTerm(dbObj);
                        Term dragedParentTerm = (Term)TargetDevTPanel.this.mDragedObj;
                        Device childDev = this.getBoxOwner();
                        Net connectNet = TermMap.getParentNet((Device)childDev, (Term)dbObj);
                        if (connectNet == null) {
                            connectNet = dragedParentTerm.getNet();
                            if (connectNet == null) {
                                ALog.logWarn((String)"Cannot connect to a term '%s' without net.", (Object[])new Object[]{dragedParentTerm.getName()});
                                return;
                            }
                            NetListEditorUI.cpMapChildTerm(childDev, dbObj, connectNet);
                        } else {
                            NetListEditorUI.cpTermSetNet(dragedParentTerm, connectNet);
                        }
                        ALog.logInfo((String)"Connect term '%s' to '%s' term '%s' with net '%s'.", (Object[])new Object[]{dragedParentTerm.getName(), childDev.getName(), dbObj.getName(), connectNet.getName()});
                    }

                    @Override
                    protected void connectParentNet(Term dbObj) {
                        super.connectParentNet(dbObj);
                        Net dragedParentNet = (Net)TargetDevTPanel.this.mDragedObj;
                        Device childDev = this.getBoxOwner();
                        NetListEditorUI.cpMapChildTerm(childDev, dbObj, dragedParentNet);
                        ALog.logInfo((String)"Connect net '%s' to '%s' term '%s'.", (Object[])new Object[]{dragedParentNet.getName(), childDev.getName(), dbObj.getName()});
                    }

                    @Override
                    protected void connectParentPin(Term dbObj) {
                        super.connectParentPin(dbObj);
                        PinTemplate dragedPin = (PinTemplate)TargetDevTPanel.this.mDragedObj;
                        Device childDev = this.getBoxOwner();
                        Net connectNet = TermMap.getParentNet((Device)childDev, (Term)dbObj);
                        if (connectNet == null) {
                            connectNet = dragedPin.getNet();
                            if (connectNet == null || connectNet.isUnused()) {
                                ALog.logWarn((String)"Cannot connect to a term '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                                return;
                            }
                            NetListEditorUI.cpMapChildTerm(childDev, dbObj, connectNet);
                        } else {
                            NetListEditorUI.cpPinSetNet(dragedPin, connectNet);
                        }
                        ALog.logInfo((String)"Connect pin '%s' to '%s' term '%s' with net '%s'.", (Object[])new Object[]{dragedPin.getName(), childDev.getName(), dbObj.getName(), connectNet.getName()});
                    }

                    @Override
                    protected void connectParentDevPin(Term dbObj) {
                        super.connectParentDevPin(dbObj);
                        Device dragedDevPin = (Device)TargetDevTPanel.this.mDragedObj;
                        Term dragedDevPinTerm = dragedDevPin.getTerm();
                        if (dragedDevPinTerm == null) {
                            ALog.logWarn((String)"The connected device pin '%s' should have one term.", (Object[])new Object[]{dragedDevPin.getName()});
                            return;
                        }
                        Device childDev = this.getBoxOwner();
                        Net connectNet = TermMap.getParentNet((Device)childDev, (Term)dbObj);
                        if (connectNet == null) {
                            connectNet = TermMap.getParentNet((Device)dragedDevPin, (Term)dragedDevPinTerm);
                            if (connectNet == null) {
                                ALog.logWarn((String)"Cannot connect to a term '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                                return;
                            }
                            NetListEditorUI.cpMapChildTerm(childDev, dbObj, connectNet);
                        } else {
                            NetListEditorUI.cpMapChildTerm(dragedDevPin, dragedDevPinTerm, connectNet);
                        }
                        ALog.logInfo((String)"Connect device pin '%s' to '%s' term '%s' with net '%s'.", (Object[])new Object[]{dragedDevPin.getName(), childDev.getName(), dbObj.getName(), connectNet.getName()});
                    }

                    @Override
                    protected void connectChildTerm(Term dbObj) {
                        super.connectChildTerm(dbObj);
                        Term dragedChildTerm = (Term)TargetDevTPanel.this.mDragedObj;
                        Device dragedChildDev = TargetDevTPanel.this.mDragedObjOwner;
                        Device childDev = this.getBoxOwner();
                        Net connectNet = TermMap.getParentNet((Device)childDev, (Term)dbObj);
                        if (connectNet == null) {
                            connectNet = TermMap.getParentNet((Device)dragedChildDev, (Term)dragedChildTerm);
                            if (connectNet == null) {
                                ALog.logWarn((String)"Cannot connect to a term '%s' without net.", (Object[])new Object[]{dragedChildTerm.getName()});
                                return;
                            }
                            NetListEditorUI.cpMapChildTerm(childDev, dbObj, connectNet);
                        } else {
                            NetListEditorUI.cpMapChildTerm(dragedChildDev, dragedChildTerm, connectNet);
                        }
                        ALog.logInfo((String)"Connect '%s' term '%s' to '%s' term '%s' with net '%s'.", (Object[])new Object[]{dragedChildDev.getName(), dragedChildTerm.getName(), childDev.getName(), dbObj.getName(), connectNet.getName()});
                    }

                    @Override
                    protected Device getBoxOwner() {
                        return this.mChildDev;
                    }

                    @Override
                    protected DeviceTemplate getBoxOwnerTemplate() {
                        return this.mChildDev.getTemplate();
                    }

                    @Override
                    protected ContextMenu getCellContextMenu(Term item) {
                        ContextMenu contextMenu = new ContextMenu();
                        if (item != null) {
                            contextMenu.getItems().add((Object)this.getMenuRename(item));
                            contextMenu.getItems().add((Object)this.getMenuUnmap());
                            contextMenu.getItems().add((Object)new SeparatorMenuItem());
                            contextMenu.getItems().add((Object)this.getMenuDelete());
                            contextMenu.getItems().add((Object)new SeparatorMenuItem());
                            contextMenu.getItems().add((Object)this.getMenuGraphTerms(item, new DevicePath(NetListManagementPanel.this.getTargetDevPath(), this.mChildDev)));
                            contextMenu.getItems().add((Object)this.getMenuDetails(item));
                        }
                        return contextMenu;
                    }

                    private MenuItem getMenuUnmap() {
                        MenuItem menuItem = new MenuItem("Unmap parent net");
                        menuItem.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                            List<Term> selectedItems = this.getSelectedItems();
                            CpHelper.cpClearSelection();
                            CpHelper.cpSelect(new DevicePath(NetListManagementPanel.this.getTargetDevPath(), this.getBoxOwner()), selectedItems);
                            NetListEditorUI.cpUnmapParentNetOfSelectedTerms();
                            CpHelper.cpClearSelection();
                            Platform.runLater(TargetDevTPanel.this::refresh);
                        }));
                        return menuItem;
                    }

                    private MenuItem getMenuDetails(Term item) {
                        MenuItem menuItemDetails = new MenuItem("Details");
                        menuItemDetails.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                            AAppView view = OrbitIO.getGuiWorkspace().getView(NetListEditorUI.this.getDb());
                            DevicePath devPath = new DevicePath(NetListManagementPanel.this.getTargetDevPath(), this.getBoxOwner());
                            DbObjectDetailsUI.show((Component)((Object)NetListEditorUI.this), (DbObject)item, devPath, view);
                        }));
                        return menuItemDetails;
                    }

                    private class ChildTermCollapseBtn
                    extends AJFXButton {
                        public ChildTermCollapseBtn() {
                            super(OrbitIcons.WIN_MINIMIZE, "Minimize");
                            this.transparentBorder();
                            this.setPadding(new Insets(0.0));
                            this.setCollapseAction();
                        }

                        protected void setCollapseAction() {
                            this.setOnAction(e -> DeviceBox.this.mMainPane.getItems().remove((Object)ChildTermBox.this));
                        }
                    }
                }
            }

            private abstract class PinDeviceBox
            extends DeviceBox {
                public PinDeviceBox(String title, Image titleImage) {
                    super(title, titleImage);
                    this.init();
                }

                @Override
                protected ContextMenu getCellContextMenu(Device item) {
                    ContextMenu contextMenu = new ContextMenu();
                    if (item != null) {
                        contextMenu.getItems().add((Object)this.getOpenTermBox(item));
                    }
                    return contextMenu;
                }

                private MenuItem getOpenTermBox(Device device) {
                    String menuStr = "Show terms";
                    MenuItem menuItem = new MenuItem(menuStr);
                    menuItem.setOnAction(e -> this.openChildTermBox(device));
                    return menuItem;
                }

                @Override
                protected void connectParentTerm(Device dbObj) {
                    super.connectParentTerm(dbObj);
                    Device devPin = dbObj;
                    Term devPinTerm = devPin.getTerm();
                    if (devPinTerm == null) {
                        ALog.logWarn((String)"The connected device pin '%s' should have one term.", (Object[])new Object[]{devPin.getName()});
                        return;
                    }
                    Term dragedTerm = (Term)TargetDevTPanel.this.mDragedObj;
                    Net connectNet = TermMap.getParentNet((Device)devPin, (Term)devPinTerm);
                    if (connectNet == null) {
                        connectNet = dragedTerm.getNet();
                        if (connectNet == null) {
                            ALog.logWarn((String)"Cannot connect to a device pin '%s' without parent net.", (Object[])new Object[]{devPin.getName()});
                            return;
                        }
                        NetListEditorUI.cpMapChildTerm(devPin, devPinTerm, connectNet);
                    } else {
                        NetListEditorUI.cpTermSetNet(dragedTerm, connectNet);
                    }
                    ALog.logInfo((String)"Connect term '%s' to device pin '%s' with net '%s'.", (Object[])new Object[]{dragedTerm.getName(), devPin.getName(), connectNet.getName()});
                }

                @Override
                protected void connectParentNet(Device dbObj) {
                    super.connectParentNet(dbObj);
                    Device devPin = dbObj;
                    Term devPinTerm = devPin.getTerm();
                    if (devPinTerm == null) {
                        ALog.logWarn((String)"The connected device pin '%s' should have one term.", (Object[])new Object[]{devPin.getName()});
                        return;
                    }
                    Net dragedNet = (Net)TargetDevTPanel.this.mDragedObj;
                    NetListEditorUI.cpMapChildTerm(devPin, devPinTerm, dragedNet);
                    ALog.logInfo((String)"Connect net '%s' to device pin '%s'.", (Object[])new Object[]{dragedNet.getName(), devPin.getName()});
                }

                @Override
                protected void connectParentPin(Device dbObj) {
                    super.connectParentPin(dbObj);
                    Device devPin = dbObj;
                    Term devPinTerm = devPin.getTerm();
                    if (devPinTerm == null) {
                        ALog.logWarn((String)"The connected device pin '%s' should have one term.", (Object[])new Object[]{devPin.getName()});
                        return;
                    }
                    PinTemplate dragedPin = (PinTemplate)TargetDevTPanel.this.mDragedObj;
                    Net connectNet = TermMap.getParentNet((Device)devPin, (Term)devPinTerm);
                    if (connectNet == null) {
                        connectNet = dragedPin.getNet();
                        if (connectNet == null || connectNet.isUnused()) {
                            ALog.logWarn((String)"Cannot connect to a device pin '%s' without parent net.", (Object[])new Object[]{devPin.getName()});
                            return;
                        }
                        NetListEditorUI.cpMapChildTerm(devPin, devPinTerm, connectNet);
                    } else {
                        NetListEditorUI.cpPinSetNet(dragedPin, connectNet);
                    }
                    ALog.logInfo((String)"Connect pin '%s' to device pin '%s' with net %s.", (Object[])new Object[]{dragedPin.getName(), devPin.getName(), connectNet.getName()});
                }

                @Override
                protected void connectParentDevPin(Device dbObj) {
                    super.connectParentDevPin(dbObj);
                    Device devPin = dbObj;
                    Term devPinTerm = devPin.getTerm();
                    if (devPinTerm == null) {
                        ALog.logWarn((String)"The connected device pin '%s' should have one term.", (Object[])new Object[]{devPin.getName()});
                        return;
                    }
                    Device dragedDevPin = (Device)TargetDevTPanel.this.mDragedObj;
                    Term dragedDevPinTerm = dragedDevPin.getTerm();
                    if (dragedDevPinTerm == null) {
                        ALog.logWarn((String)"The connected device pin '%s' should have one term.", (Object[])new Object[]{dragedDevPin.getName()});
                        return;
                    }
                    Net connectNet = TermMap.getParentNet((Device)devPin, (Term)devPinTerm);
                    if (connectNet == null) {
                        connectNet = TermMap.getParentNet((Device)dragedDevPin, (Term)dragedDevPinTerm);
                        if (connectNet == null) {
                            ALog.logWarn((String)"Cannot connect to a device pin '%s' without parent net.", (Object[])new Object[]{dbObj.getName()});
                            return;
                        }
                        NetListEditorUI.cpMapChildTerm(devPin, devPinTerm, connectNet);
                    } else {
                        NetListEditorUI.cpMapChildTerm(dragedDevPin, dragedDevPinTerm, connectNet);
                    }
                    ALog.logInfo((String)"Connect device pin '%s' to device pin '%s' with net '%s'.", (Object[])new Object[]{dragedDevPin.getName(), devPin.getName(), connectNet.getName()});
                }

                @Override
                protected void connectChildTerm(Device dbObj) {
                    super.connectChildTerm(dbObj);
                    Device devPin = dbObj;
                    Term devPinTerm = devPin.getTerm();
                    if (devPinTerm == null) {
                        ALog.logWarn((String)"The connected device pin '%s' should have one term.", (Object[])new Object[]{devPin.getName()});
                        return;
                    }
                    Term dragedChildTerm = (Term)TargetDevTPanel.this.mDragedObj;
                    Device dragedchildDev = TargetDevTPanel.this.mDragedObjOwner;
                    Net connectNet = TermMap.getParentNet((Device)devPin, (Term)devPinTerm);
                    if (connectNet == null) {
                        connectNet = TermMap.getParentNet((Device)dragedchildDev, (Term)dragedChildTerm);
                        if (connectNet == null) {
                            ALog.logWarn((String)"Cannot connect to a device pin '%s' without parent net.", (Object[])new Object[]{devPin.getName()});
                            return;
                        }
                        NetListEditorUI.cpMapChildTerm(devPin, devPinTerm, connectNet);
                    } else {
                        NetListEditorUI.cpMapChildTerm(dragedchildDev, dragedChildTerm, connectNet);
                    }
                    ALog.logInfo((String)"Connect '%s' term '%s' to parent device pin '%s' with net '%s'.", (Object[])new Object[]{dragedchildDev.getName(), dragedChildTerm.getName(), devPin.getName(), connectNet.getName()});
                }
            }

            private abstract class TermBox
            extends ItemsBox<Term> {
                private List<Term> mTerms;
                private FilteredList<Term> mFilteredList;
                private AListView<Term> mTermsListView;

                public TermBox(DeviceTemplate devT, String title) {
                    super(title, OrbitJFXImages.TERMS);
                }

                @Override
                protected int getNumItems() {
                    return this.mTerms.size();
                }

                @Override
                public List<Term> getItems() {
                    if (this.mTerms == null) {
                        this.mTerms = AUtil.arrayList((Iterator)this.getBoxOwnerTemplate().getTerms());
                        Collections.sort(this.mTerms, Term.NAME_COMPARATOR);
                    }
                    return this.mTerms;
                }

                @Override
                public void refresh() {
                    this.refreshInfo();
                    this.refreshItemFilter();
                    this.mTermsListView.refresh();
                }

                @Override
                public void reloadItems() {
                    this.mTerms = null;
                    this.mFilteredList = new FilteredList(this.getItemsObservableList());
                    this.mTermsListView.setItems(this.mFilteredList);
                    this.mItemSelectMenuItem.refreshItems(this.getItemsObservableList());
                    this.refresh();
                }

                @Override
                protected Node getItemsPaneNode() {
                    if (this.mTermsListView == null) {
                        this.mFilteredList = new FilteredList(this.getItemsObservableList(), data -> true);
                        this.mTermsListView = new AListView(this.mFilteredList);
                        this.mTermsListView.enableSearchByKeyTyped(Term::getName);
                        this.mTermsListView.setCachedCellFactory(this.getItemListCellFactory());
                        this.mTermsListView.setOnMouseClicked(this.getItemListViewEventHandler());
                        this.mTermsListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                    }
                    return this.mTermsListView;
                }

                @Override
                protected void refreshItemFilter() {
                    this.mFilteredList.setPredicate(this::isVisibleItem);
                }

                @Override
                protected Term getSelectedItem() {
                    return (Term)this.mTermsListView.getSelectionModel().getSelectedItem();
                }

                @Override
                protected List<Term> getSelectedItems() {
                    return this.mTermsListView.getSelectionModel().getSelectedItems();
                }

                @Override
                protected String getShowedStr(Term item) {
                    return item.getName();
                }

                @Override
                protected void loadFiltersMenu() {
                    super.loadFiltersMenu();
                    this.addConditionFilterMenuItem((MenuItem)new SeparatorMenuItem());
                    this.addConditionFilterMenuItem(FilterMenuItems.getTermFilterMenuItems(this::refreshItemFilter));
                }

                protected void scrollTo(Set<Term> terms) {
                    this.mTermsListView.scrollTo(terms);
                }

                protected MenuItem getMenuRename(Term item) {
                    MenuItem menuItemRename = new MenuItem("Rename");
                    menuItemRename.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        List<Term> selectedItems = this.getSelectedItems();
                        AJFXDesignDialog ui = null;
                        ui = selectedItems.size() > 1 ? UserBulkRenameTermUI.showUI((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath(), selectedItems) : TermRenameUI.showUI((Window)((Object)NetListEditorUI.this), item);
                        ui.addWindowListener((WindowListener)new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                Platform.runLater(TermBox.this::reloadItems);
                            }
                        });
                    }));
                    return menuItemRename;
                }

                protected MenuItem getMenuGraphTerms(Term item, DevicePath devP) {
                    MenuItem menuItemGraphNet = new MenuItem("Graph Term");
                    menuItemGraphNet.setGraphic((Node)new ImageView(OrbitJFXImages.GRAPHNET));
                    menuItemGraphNet.setOnAction(e -> SwingUtilities.invokeLater(() -> NetGraphPanel.showNetGraph(OrbitIO.getMainWindow(), devP, item.getNet(), true, false)));
                    return menuItemGraphNet;
                }
            }

            private class ChildrenBox
            extends DeviceBox {
                public ChildrenBox() {
                    super("Children", OrbitJFXImages.DEVICE);
                    this.init();
                }

                @Override
                protected int getNumMatches() {
                    return (int)TargetDevTPanel.this.mTracedNets.stream().flatMap(net -> TermMap.getChildDevices((Net)net).stream()).distinct().count();
                }

                @Override
                public List<Device> getItems() {
                    if (this.childDevs == null) {
                        this.childDevs = AUtil.sort((IterableIterator)NetListManagementPanel.this.getTargetDevT().getChildren(DeviceFilters.FILTER_NONPIN), (Comparator)Device.CompareTypeAndName);
                    }
                    return this.childDevs;
                }

                @Override
                protected TargetBoxExpandBtn getExpandBtn() {
                    return NetListManagementPanel.this.mCollapsedTargetBox.getChildrenBoxExpandBtn();
                }

                @Override
                protected EventHandler<MouseEvent> getItemListViewEventHandler() {
                    return new EventHandler<MouseEvent>(){

                        public void handle(MouseEvent click) {
                            if (click.getButton() == MouseButton.PRIMARY && click.getClickCount() == 2 && ChildrenBox.this.getSelectedItem() != null) {
                                ChildrenBox.this.openChildTermBox(ChildrenBox.this.getSelectedItem());
                            }
                        }
                    };
                }

                @Override
                protected Callback<ListView<Device>, ListCell<Device>> getItemListCellFactory() {
                    return new Callback<ListView<Device>, ListCell<Device>>(){

                        public ListCell<Device> call(ListView<Device> termList) {
                            return new ListCell<Device>(){

                                protected void updateItem(Device item, boolean empty) {
                                    super.updateItem((Object)item, empty);
                                    this.setContextMenu(ChildrenBox.this.getChildDevContextMenu(item));
                                    if (item == null || empty) {
                                        this.setText(null);
                                        this.setGraphic(null);
                                        this.setStyle(ChildrenBox.this.getStyle());
                                        return;
                                    }
                                    if (ChildrenBox.this.isHighLight(item)) {
                                        if (this.isSelected()) {
                                            this.setStyle(TargetDevTPanel.SELECTED_HIGHLIGHT_STYLE);
                                        } else {
                                            this.setStyle(TargetDevTPanel.HIGHLIGHT_STYLE);
                                        }
                                    } else {
                                        this.setStyle(ChildrenBox.this.getStyle());
                                    }
                                    this.setGraphic((Node)new ImageView(ChildrenBox.this.getShowedImage(item)));
                                    this.setText(ChildrenBox.this.getShowedStr(item));
                                }
                            };
                        }
                    };
                }
            }

            private class PadsBox
            extends PinDeviceBox {
                public PadsBox() {
                    super("Pads", OrbitJFXImages.PAD);
                }

                @Override
                protected int getNumMatches() {
                    return (int)TargetDevTPanel.this.mTracedNets.stream().flatMap(net -> TermMap.getChildDevices((Net)net).stream()).distinct().filter(dev -> dev.getType() == DeviceTemplate.Type.PAD).count();
                }

                @Override
                public void scrollToTraced() {
                    Set<Device> traceditems = TargetDevTPanel.this.mTracedNets.stream().flatMap(net -> TermMap.getChildDevices((Net)net).stream()).filter(dev -> dev.getType() == DeviceTemplate.Type.PAD).collect(Collectors.toSet());
                    this.scrollTo(traceditems);
                }

                @Override
                public List<Device> getItems() {
                    if (this.childDevs == null) {
                        this.childDevs = AUtil.sort((IterableIterator)NetListManagementPanel.this.getTargetDevT().getChildren(DeviceFilters.FILTER_PAD), (Comparator)Device.CompareName);
                    }
                    return this.childDevs;
                }

                @Override
                protected TargetBoxExpandBtn getExpandBtn() {
                    return NetListManagementPanel.this.mCollapsedTargetBox.getPadsBoxExpandBtn();
                }
            }

            private class BumpsBox
            extends PinDeviceBox {
                public BumpsBox() {
                    super("Bumps", OrbitJFXImages.BUMP);
                }

                @Override
                protected int getNumMatches() {
                    return (int)TargetDevTPanel.this.mTracedNets.stream().flatMap(net -> TermMap.getChildDevices((Net)net).stream()).distinct().filter(dev -> dev.getType() == DeviceTemplate.Type.BUMP).count();
                }

                @Override
                public void scrollToTraced() {
                    Set<Device> traceditems = TargetDevTPanel.this.mTracedNets.stream().flatMap(net -> TermMap.getChildDevices((Net)net).stream()).filter(dev -> dev.getType() == DeviceTemplate.Type.BUMP).collect(Collectors.toSet());
                    this.scrollTo(traceditems);
                }

                @Override
                public List<Device> getItems() {
                    if (this.childDevs == null) {
                        this.childDevs = AUtil.sort((IterableIterator)NetListManagementPanel.this.getTargetDevT().getChildren(DeviceFilters.FILTER_BUMP), (Comparator)Device.CompareName);
                    }
                    return this.childDevs;
                }

                @Override
                protected TargetBoxExpandBtn getExpandBtn() {
                    return NetListManagementPanel.this.mCollapsedTargetBox.getBumpsBoxExpandBtn();
                }

                @Override
                protected void setTiTleMenu() {
                    super.setTiTleMenu();
                    this.addTitleMenuItem((MenuItem)new SeparatorMenuItem());
                    this.addTitleMenuItem(this.getBulkCreateTermMenu());
                }

                @Override
                protected void loadFiltersMenu() {
                    super.loadFiltersMenu();
                    this.addConditionFilterMenuItem((MenuItem)new SeparatorMenuItem());
                    this.addConditionFilterMenuItem(FilterMenuItems.getBumpFilterMenuItems(this::refreshItemFilter));
                }

                @Override
                protected ContextMenu getCellContextMenu(Device item) {
                    ContextMenu contextMenu = super.getCellContextMenu(item);
                    if (item != null) {
                        MenuItem menuItemCreateTerm = new MenuItem("Create term");
                        menuItemCreateTerm.setOnAction(e -> {
                            List<Device> selectedItems = this.getSelectedItems();
                            ArrayList bumpDevTs = AUtil.arrayList((Iterator)AIterableItr.itr(selectedItems).filter(devT -> devT.getTerms().ifExactlyOne().isEmpty()).mapAndNonNull(Device::getTemplate).distinct());
                            Optional<Map<DeviceTemplate, BumpSelectedInfo>> infos = BumpContentsChooserDlg.showAndWait((Window)((Object)NetListEditorUI.this), bumpDevTs);
                            if (infos.isEmpty()) {
                                return;
                            }
                            SwingUtilities.invokeLater(() -> {
                                UserBump2TermBulkCreateUI ui = UserBump2TermBulkCreateUI.showUI((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath(), selectedItems, (Map)infos.get());
                                ui.addWindowListener(new WindowAdapter(){

                                    @Override
                                    public void windowClosing(WindowEvent e) {
                                        Platform.runLater(TargetDevTPanel.this::reloadItems);
                                    }
                                });
                            });
                        });
                        contextMenu.getItems().add((Object)menuItemCreateTerm);
                    }
                    return contextMenu;
                }

                private MenuItem getBulkCreateTermMenu() {
                    MenuItem menuItem = new MenuItem("Bulk create terms");
                    menuItem.setOnAction(e -> {
                        Optional<Map<DeviceTemplate, BumpSelectedInfo>> infos = BumpContentsChooserDlg.showAndWait((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath());
                        if (infos.isEmpty()) {
                            return;
                        }
                        SwingUtilities.invokeLater(() -> {
                            Bump2TermBulkCreateUI ui = Bump2TermBulkCreateUI.showUI((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath(), (Map)infos.get());
                            ui.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent e) {
                                    Platform.runLater(TargetDevTPanel.this::reloadItems);
                                }
                            });
                        });
                    });
                    return menuItem;
                }
            }

            private class PinsBox
            extends ItemsBox<PinTemplate> {
                private List<PinTemplate> mPins;
                private FilteredList<PinTemplate> mFilteredList;
                private AListView<PinTemplate> mPinlistView;

                public PinsBox() {
                    super("Pins", OrbitJFXImages.PINS);
                    this.init();
                }

                @Override
                protected int getNumItems() {
                    return this.mPins.size();
                }

                @Override
                protected int getNumMatches() {
                    int i = 0;
                    for (Net n : TargetDevTPanel.this.mTracedNets) {
                        for (PinTemplate p : n.getPins()) {
                            if (p.isVia()) continue;
                            ++i;
                        }
                    }
                    return i;
                }

                @Override
                public void scrollToTraced() {
                    HashSet<PinTemplate> traceditems = new HashSet<PinTemplate>();
                    for (Net n : TargetDevTPanel.this.mTracedNets) {
                        for (PinTemplate p : n.getPins()) {
                            if (p.isVia()) continue;
                            traceditems.add(p);
                        }
                    }
                    this.mPinlistView.scrollTo(traceditems);
                }

                @Override
                public List<PinTemplate> getItems() {
                    if (this.mPins == null) {
                        this.mPins = NetListManagementPanel.this.getTargetDevT().getPins().stream().filter(p -> !p.isVia()).sorted().collect(Collectors.toList());
                    }
                    return this.mPins;
                }

                @Override
                public void reloadItems() {
                    this.mPins = null;
                    this.mFilteredList = new FilteredList(this.getItemsObservableList());
                    this.mPinlistView.setItems(this.mFilteredList);
                    this.mItemSelectMenuItem.refreshItems(this.getItemsObservableList());
                    this.refresh();
                }

                @Override
                public void refresh() {
                    this.refreshInfo();
                    this.refreshItemFilter();
                    this.mPinlistView.refresh();
                }

                @Override
                protected TargetBoxExpandBtn getExpandBtn() {
                    return NetListManagementPanel.this.mCollapsedTargetBox.getPinsBoxExpandBtn();
                }

                @Override
                protected Node getItemsPaneNode() {
                    if (this.mPinlistView == null) {
                        this.mFilteredList = new FilteredList(this.getItemsObservableList(), data -> true);
                        this.mPinlistView = new AListView(this.mFilteredList);
                        this.mPinlistView.setCachedCellFactory(this.getItemListCellFactory());
                        this.mPinlistView.setOnMouseClicked(this.getItemListViewEventHandler());
                        this.mPinlistView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                    }
                    return this.mPinlistView;
                }

                @Override
                protected void refreshItemFilter() {
                    this.mFilteredList.setPredicate(this::isVisibleItem);
                }

                @Override
                protected PinTemplate getSelectedItem() {
                    return (PinTemplate)this.mPinlistView.getSelectionModel().getSelectedItem();
                }

                @Override
                protected List<PinTemplate> getSelectedItems() {
                    return this.mPinlistView.getSelectionModel().getSelectedItems();
                }

                @Override
                protected Set<Net> getSelectedItemConnectNet() {
                    PinTemplate selectedPin = this.getSelectedItem();
                    return selectedPin == null ? Collections.emptySet() : AUtil.hashSet((Object[])new Net[]{selectedPin.getNet()});
                }

                @Override
                protected boolean isHighLight(PinTemplate item) {
                    if (item == null) {
                        return false;
                    }
                    Net net = item.getNet();
                    return !net.isUnused() && TargetDevTPanel.this.mTracedNets.contains(net);
                }

                @Override
                protected String getShowedStr(PinTemplate item) {
                    return item.getName();
                }

                @Override
                protected Image getShowedImage(PinTemplate item) {
                    Icon icon = DbExplorerPanel.getIconForPinTemplate(item);
                    return JFXUtil.getFxImage((Icon)icon);
                }

                @Override
                protected void connectParentTerm(PinTemplate dbObj) {
                    super.connectParentTerm(dbObj);
                    Term dragedTerm = (Term)TargetDevTPanel.this.mDragedObj;
                    Net connectNet = dbObj.getNet();
                    if (connectNet == null) {
                        connectNet = dragedTerm.getNet();
                        if (connectNet == null) {
                            ALog.logWarn((String)"Cannot connect to a pin '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                            return;
                        }
                        NetListEditorUI.cpPinSetNet(dbObj, connectNet);
                    } else {
                        NetListEditorUI.cpTermSetNet(dragedTerm, connectNet);
                    }
                    ALog.logInfo((String)"Connect term '%s' to pin '%s' with net '%s'.", (Object[])new Object[]{dragedTerm.getName(), dbObj.getName(), connectNet.getName()});
                }

                @Override
                protected void connectParentNet(PinTemplate dbObj) {
                    super.connectParentNet(dbObj);
                    Net dragedNet = (Net)TargetDevTPanel.this.mDragedObj;
                    NetListEditorUI.cpPinSetNet(dbObj, dragedNet);
                    ALog.logInfo((String)"Connect net '%s' to pin '%s'.", (Object[])new Object[]{dragedNet.getName(), dbObj.getName()});
                }

                @Override
                protected void connectParentPin(PinTemplate dbObj) {
                    super.connectParentPin(dbObj);
                    PinTemplate dragedPin = (PinTemplate)TargetDevTPanel.this.mDragedObj;
                    Net connectNet = dbObj.getNet();
                    if (connectNet == null || connectNet.isUnused()) {
                        connectNet = dragedPin.getNet();
                        if (connectNet == null || connectNet.isUnused()) {
                            ALog.logWarn((String)"Cannot connect to a term '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                            return;
                        }
                        NetListEditorUI.cpPinSetNet(dbObj, connectNet);
                    } else {
                        NetListEditorUI.cpPinSetNet(dragedPin, connectNet);
                    }
                    ALog.logInfo((String)"Connect pin '%s' to term '%s' with net '%s'.", (Object[])new Object[]{dragedPin.getName(), dbObj.getName(), connectNet.getName()});
                }

                @Override
                protected void connectParentDevPin(PinTemplate dbObj) {
                    super.connectParentDevPin(dbObj);
                    Device dragedDevPin = (Device)TargetDevTPanel.this.mDragedObj;
                    Term dragedDevPinTerm = dragedDevPin.getTerm();
                    if (dragedDevPinTerm == null) {
                        ALog.logWarn((String)"Cannot connect to a device pin '%s' without term.", (Object[])new Object[]{dragedDevPin.getName()});
                        return;
                    }
                    Net connectNet = dbObj.getNet();
                    if (connectNet == null || connectNet.isUnused()) {
                        ALog.logWarn((String)"Cannot connect to a pin '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                        return;
                    }
                    NetListEditorUI.cpMapChildTerm(dragedDevPin, dragedDevPinTerm, connectNet);
                    ALog.logInfo((String)"Connect device pin '%s' to term '%s' with net '%s'.", (Object[])new Object[]{dragedDevPin.getName(), dbObj.getName(), connectNet.getName()});
                }

                @Override
                protected void connectChildTerm(PinTemplate dbObj) {
                    super.connectChildTerm(dbObj);
                    Net connectNet = dbObj.getNet();
                    if (connectNet == null || connectNet.isUnused()) {
                        ALog.logWarn((String)"Cannot connect to a pin '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                        return;
                    }
                    Term dragedChildTerm = (Term)TargetDevTPanel.this.mDragedObj;
                    Device childDev = TargetDevTPanel.this.mDragedObjOwner;
                    NetListEditorUI.cpMapChildTerm(childDev, dragedChildTerm, connectNet);
                    ALog.logInfo((String)"Connect '%s' term '%s' to parent term '%s' with net '%s'.", (Object[])new Object[]{childDev.getName(), dragedChildTerm.getName(), dbObj.getName(), connectNet.getName()});
                }

                @Override
                protected Device getBoxOwner() {
                    return NetListManagementPanel.this.getTargetDev();
                }

                @Override
                protected DeviceTemplate getBoxOwnerTemplate() {
                    return NetListManagementPanel.this.getTargetDevT();
                }
            }

            private class NetsBox
            extends ItemsBox<Net> {
                private List<Net> nets;
                private FilteredList<Net> mFilteredList;
                private AListView<Net> mNetsListView;

                public NetsBox() {
                    super("Nets", OrbitJFXImages.NETS);
                    this.init();
                }

                @Override
                protected int getNumItems() {
                    return this.nets.size();
                }

                @Override
                protected int getNumMatches() {
                    return TargetDevTPanel.this.mTracedNets.size();
                }

                @Override
                public void scrollToTraced() {
                    this.mNetsListView.scrollTo(TargetDevTPanel.this.mTracedNets);
                }

                @Override
                public List<Net> getItems() {
                    if (this.nets == null) {
                        this.nets = AUtil.sort((IterableIterator)NetListManagementPanel.this.getTargetDevT().getNets(false), (Comparator)Net.NameComparator);
                    }
                    return this.nets;
                }

                @Override
                public void reloadItems() {
                    this.nets = null;
                    this.mFilteredList = new FilteredList(this.getItemsObservableList());
                    this.mNetsListView.setItems(this.mFilteredList);
                    this.mItemSelectMenuItem.refreshItems(this.getItemsObservableList());
                    this.refresh();
                }

                @Override
                public void refresh() {
                    this.refreshInfo();
                    this.refreshItemFilter();
                    this.mNetsListView.refresh();
                }

                @Override
                protected TargetBoxExpandBtn getExpandBtn() {
                    return NetListManagementPanel.this.mCollapsedTargetBox.getNetsBoxExpandBtn();
                }

                @Override
                protected Node getItemsPaneNode() {
                    if (this.mNetsListView == null) {
                        this.mFilteredList = new FilteredList(this.getItemsObservableList(), data -> true);
                        this.mNetsListView = new AListView(this.mFilteredList);
                        this.mNetsListView.enableSearchByKeyTyped(Net::getName);
                        this.mNetsListView.setCachedCellFactory(this.getItemListCellFactory());
                        this.mNetsListView.setOnMouseClicked(this.getItemListViewEventHandler());
                        this.mNetsListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                    }
                    return this.mNetsListView;
                }

                @Override
                protected void refreshItemFilter() {
                    this.mFilteredList.setPredicate(this::isVisibleItem);
                }

                @Override
                protected Net getSelectedItem() {
                    return (Net)this.mNetsListView.getSelectionModel().getSelectedItem();
                }

                @Override
                protected List<Net> getSelectedItems() {
                    return this.mNetsListView.getSelectionModel().getSelectedItems();
                }

                @Override
                protected Set<Net> getSelectedItemConnectNet() {
                    Net selectedItem = this.getSelectedItem();
                    return selectedItem == null ? Collections.emptySet() : AUtil.hashSet((Object[])new Net[]{selectedItem});
                }

                @Override
                protected boolean isHighLight(Net item) {
                    return item != null && TargetDevTPanel.this.mTracedNets.contains(item);
                }

                @Override
                protected String getShowedStr(Net item) {
                    return item.getName();
                }

                @Override
                protected Image getShowedImage(Net item) {
                    if (TermMap.getTermMaps((Net)item).hasNext()) {
                        return OrbitJFXImages.NETMAP_DOWN;
                    }
                    return null;
                }

                @Override
                protected void connectParentTerm(Net dbObj) {
                    super.connectParentTerm(dbObj);
                    Term dragedTerm = (Term)TargetDevTPanel.this.mDragedObj;
                    NetListEditorUI.cpTermSetNet(dragedTerm, dbObj);
                    ALog.logInfo((String)"Connect term '%s' to net '%s'.", (Object[])new Object[]{dragedTerm.getName(), dbObj.getName()});
                }

                @Override
                protected void connectParentNet(Net dbObj) {
                    super.connectParentNet(dbObj);
                    ALog.logWarn((String)"Cannot connect nets in the same level.");
                }

                @Override
                protected void connectParentPin(Net dbObj) {
                    super.connectParentPin(dbObj);
                    Net connectNet = dbObj;
                    PinTemplate dragedPin = (PinTemplate)TargetDevTPanel.this.mDragedObj;
                    NetListEditorUI.cpPinSetNet(dragedPin, connectNet);
                    ALog.logInfo((String)"Connect pin '%s' to net '%s'.", (Object[])new Object[]{dragedPin.getName(), connectNet.getName()});
                }

                @Override
                protected void connectParentDevPin(Net dbObj) {
                    super.connectParentDevPin(dbObj);
                    Device dragedDevPin = (Device)TargetDevTPanel.this.mDragedObj;
                    Term dragedDevPinTerm = dragedDevPin.getTerm();
                    if (dragedDevPinTerm == null) {
                        ALog.logWarn((String)"Cannot connect to a device pin '%s' without term.", (Object[])new Object[]{dragedDevPin.getName()});
                        return;
                    }
                    Net connectNet = dbObj;
                    NetListEditorUI.cpMapChildTerm(dragedDevPin, dragedDevPinTerm, connectNet);
                    ALog.logInfo((String)"Connect device pin '%s' to net '%s'.", (Object[])new Object[]{dragedDevPin.getName(), connectNet.getName()});
                }

                @Override
                protected void connectChildTerm(Net dbObj) {
                    super.connectChildTerm(dbObj);
                    Term dragedChildTerm = (Term)TargetDevTPanel.this.mDragedObj;
                    Net connectNet = dbObj;
                    Device childDev = TargetDevTPanel.this.mDragedObjOwner;
                    NetListEditorUI.cpMapChildTerm(childDev, dragedChildTerm, connectNet);
                    ALog.logInfo((String)"Connect '%s' term '%s' to parent net '%s'.", (Object[])new Object[]{childDev.getName(), dragedChildTerm.getName(), connectNet.getName()});
                }

                @Override
                protected Device getBoxOwner() {
                    return NetListManagementPanel.this.getTargetDev();
                }

                @Override
                protected DeviceTemplate getBoxOwnerTemplate() {
                    return NetListManagementPanel.this.getTargetDevT();
                }

                @Override
                protected ContextMenu getCellContextMenu(Net item) {
                    ContextMenu contextMenu = new ContextMenu();
                    if (item != null) {
                        contextMenu.getItems().add((Object)this.getMenuRename(item));
                        contextMenu.getItems().add((Object)this.getMenuUnmap());
                        contextMenu.getItems().add((Object)new SeparatorMenuItem());
                    }
                    contextMenu.getItems().add((Object)this.getMenuCreate(item));
                    if (item != null) {
                        contextMenu.getItems().add((Object)this.getMenuDelete());
                        contextMenu.getItems().add((Object)new SeparatorMenuItem());
                        contextMenu.getItems().add((Object)this.getMenuGraphNets(item));
                        contextMenu.getItems().add((Object)this.getMenuDetails(item));
                    }
                    return contextMenu;
                }

                private Menu getMenuCreate(Net item) {
                    Menu menuCreate = new Menu("Create");
                    if (item != null) {
                        MenuItem menuItemCreateTerm = new MenuItem("Term...");
                        menuItemCreateTerm.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                            List<Net> selectedTerms = this.getSelectedItems();
                            AJFXDesignDialog ui = null;
                            ui = selectedTerms.size() > 1 ? UserNet2TermBulkCreateUI.showUI((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath(), selectedTerms) : TermCreateUI.showUI((Window)((Object)NetListEditorUI.this), item);
                            ui.addWindowListener((WindowListener)new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent e) {
                                    Platform.runLater(TargetDevTPanel.this::reloadItems);
                                }
                            });
                        }));
                        menuCreate.getItems().add((Object)menuItemCreateTerm);
                    }
                    MenuItem menuItemCreateNet = new MenuItem("Net...");
                    menuItemCreateNet.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        Net newNet = NetUI.AddNetUI.addNet((Component)((Object)NetListEditorUI.this), this.getBoxOwnerTemplate());
                        if (newNet == null) {
                            return;
                        }
                        Platform.runLater(TargetDevTPanel.this::reloadItems);
                    }));
                    menuCreate.getItems().add((Object)menuItemCreateNet);
                    return menuCreate;
                }

                @Override
                protected MenuItem getMenuDelete() {
                    MenuItem menuItemDelete = new MenuItem("Delete");
                    List<Net> selectedItems = this.getSelectedItems();
                    TargetDevTPanel.this.mTracedNets.removeAll(selectedItems);
                    menuItemDelete.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        CpHelper.cpClearSelection();
                        CpHelper.cpSelect(selectedItems);
                        CpHelper.cpDeleteSelected();
                        Platform.runLater(TargetDevTPanel.this::reloadItems);
                    }));
                    return menuItemDelete;
                }

                private MenuItem getMenuRename(Net item) {
                    MenuItem menuItemRename = new MenuItem("Rename");
                    menuItemRename.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        List<Net> selectedItems = this.getSelectedItems();
                        if (selectedItems.size() > 1) {
                            UserBulkRenameNetUI ui = UserBulkRenameNetUI.showUI((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath(), selectedItems);
                            ui.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosed(WindowEvent e) {
                                    Platform.runLater(NetsBox.this::reloadItems);
                                }
                            });
                        } else {
                            boolean doneRename = NetUI.RenameNetUI.rename((Component)((Object)NetListEditorUI.this), item);
                            if (doneRename) {
                                Platform.runLater(this::reloadItems);
                            }
                        }
                    }));
                    return menuItemRename;
                }

                private MenuItem getMenuUnmap() {
                    MenuItem menuItemUnMap = new MenuItem("Unmap all children terms");
                    menuItemUnMap.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        List<Net> items = this.getSelectedItems();
                        CpHelper.cpClearSelection();
                        CpHelper.cpSelect(items);
                        NetListEditorUI.cpUnmapChildernOfSelectedNets();
                        CpHelper.cpClearSelection();
                        Platform.runLater(TargetDevTPanel.this::refresh);
                    }));
                    return menuItemUnMap;
                }

                private MenuItem getMenuGraphNets(Net item) {
                    MenuItem menuItemGraphNet = new MenuItem("Graph Net");
                    menuItemGraphNet.setGraphic((Node)new ImageView(OrbitJFXImages.GRAPHNET));
                    menuItemGraphNet.setOnAction(e -> SwingUtilities.invokeLater(() -> NetGraphPanel.showNetGraph(OrbitIO.getMainWindow(), NetListManagementPanel.this.getTargetDevPath(), item, false, false)));
                    return menuItemGraphNet;
                }

                private MenuItem getMenuDetails(Net item) {
                    MenuItem menuItemDetails = new MenuItem("Details");
                    menuItemDetails.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        AAppView view = OrbitIO.getGuiWorkspace().getView(NetListEditorUI.this.getDb());
                        DbObjectDetailsUI.show((Component)((Object)NetListEditorUI.this), (DbObject)item, NetListManagementPanel.this.getTargetDevPath(), view);
                    }));
                    return menuItemDetails;
                }

                @Override
                protected void setTiTleMenu() {
                    super.setTiTleMenu();
                    this.addTitleMenuItem((MenuItem)new SeparatorMenuItem());
                    this.addTitleMenuItem(this.getBulkRenameNetMenu());
                    this.addTitleMenuItem(this.getBulkCreateParentTermMenu());
                }

                @Override
                protected void loadFiltersMenu() {
                    super.loadFiltersMenu();
                    this.addConditionFilterMenuItem((MenuItem)new SeparatorMenuItem());
                    this.addConditionFilterMenuItem(FilterMenuItems.getNetFilterMenuItems(this::refreshItemFilter));
                }

                private MenuItem getBulkCreateParentTermMenu() {
                    MenuItem menuItem = new MenuItem("Bulk create terms");
                    menuItem.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        Net2TermBulkCreateUI ui = Net2TermBulkCreateUI.showUI((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath());
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(TargetDevTPanel.this::reloadItems);
                            }
                        });
                    }));
                    return menuItem;
                }

                private MenuItem getBulkRenameNetMenu() {
                    MenuItem menuItem = new MenuItem("Bulk rename nets");
                    menuItem.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        BulkRenameNetUI ui = BulkRenameNetUI.showUI((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath());
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                Platform.runLater(TargetDevTPanel.this.getNetsBox()::reloadItems);
                            }
                        });
                    }));
                    return menuItem;
                }
            }

            private class ParentTermBox
            extends TermBox {
                public ParentTermBox() {
                    super(NetListManagementPanel.this.getTargetDevT(), "Terms");
                    this.init();
                }

                @Override
                protected Image getShowedImage(Term item) {
                    if (TermMap.getTermMaps((Net)item.getNet()).hasNext()) {
                        return OrbitJFXImages.NETMAP_DOWN;
                    }
                    return null;
                }

                @Override
                protected int getNumMatches() {
                    return TargetDevTPanel.this.mTracedNets.stream().mapToInt(net -> (int)AUtil.count((Iterator)net.getTerms())).sum();
                }

                @Override
                public void scrollToTraced() {
                    Set<Term> traceditems = TargetDevTPanel.this.mTracedNets.stream().flatMap(net -> net.getTerms().stream()).collect(Collectors.toSet());
                    this.scrollTo(traceditems);
                }

                @Override
                protected TargetBoxExpandBtn getExpandBtn() {
                    return NetListManagementPanel.this.mCollapsedTargetBox.getTermsBoxExpandBtn();
                }

                @Override
                protected Set<Net> getSelectedItemConnectNet() {
                    Term selectedTerm = this.getSelectedItem();
                    return selectedTerm == null || selectedTerm.getNet() == null ? Collections.emptySet() : AUtil.hashSet((Object[])new Net[]{selectedTerm.getNet()});
                }

                @Override
                protected boolean isHighLight(Term item) {
                    return item != null && TargetDevTPanel.this.mTracedNets.contains(item.getNet());
                }

                @Override
                protected void connectParentTerm(Term dbObj) {
                    super.connectParentTerm(dbObj);
                    Term dragedTerm = (Term)TargetDevTPanel.this.mDragedObj;
                    Net connectNet = dbObj.getNet();
                    if (connectNet == null) {
                        connectNet = dragedTerm.getNet();
                        if (connectNet == null) {
                            ALog.logWarn((String)"Cannot connect to a term '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                            return;
                        }
                        NetListEditorUI.cpTermSetNet(dbObj, connectNet);
                    } else {
                        NetListEditorUI.cpTermSetNet(dragedTerm, connectNet);
                    }
                    ALog.logInfo((String)"Connect term '%s' to term '%s' with net '%s'.", (Object[])new Object[]{dragedTerm.getName(), dbObj.getName(), connectNet.getName()});
                }

                @Override
                protected void connectParentNet(Term dbObj) {
                    super.connectParentNet(dbObj);
                    Net dragedNet = (Net)TargetDevTPanel.this.mDragedObj;
                    NetListEditorUI.cpTermSetNet(dbObj, dragedNet);
                    ALog.logInfo((String)"Connect net '%s' to term '%s'.", (Object[])new Object[]{dragedNet.getName(), dbObj.getName()});
                }

                @Override
                protected void connectParentPin(Term dbObj) {
                    super.connectParentPin(dbObj);
                    Net connectNet = dbObj.getNet();
                    if (connectNet == null) {
                        ALog.logWarn((String)"Cannot connect to a term '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                        return;
                    }
                    PinTemplate dragedPin = (PinTemplate)TargetDevTPanel.this.mDragedObj;
                    try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)NetListEditorUI.this.getDb(), (String)"Connect pin to term");){
                        NetListEditorUI.cpPinSetNet(dragedPin, connectNet);
                        NetListEditorUI.cpPinSetTerm(dragedPin, dbObj);
                        ALog.logInfo((String)"Connect pin '%s' to term '%s' with net '%s'.", (Object[])new Object[]{dragedPin.getName(), dbObj.getName(), connectNet.getName()});
                    }
                }

                @Override
                protected void connectParentDevPin(Term dbObj) {
                    super.connectParentDevPin(dbObj);
                    Device dragedDevPin = (Device)TargetDevTPanel.this.mDragedObj;
                    Term dragedDevPinTerm = dragedDevPin.getTerm();
                    if (dragedDevPinTerm == null) {
                        ALog.logWarn((String)"The connected device pin '%s' should have one term.", (Object[])new Object[]{dragedDevPin.getName()});
                        return;
                    }
                    Net connectNet = dbObj.getNet();
                    if (connectNet == null) {
                        ALog.logWarn((String)"Cannot connect to a term '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                        return;
                    }
                    NetListEditorUI.cpMapChildTerm(dragedDevPin, dragedDevPinTerm, connectNet);
                    ALog.logInfo((String)"Connect device pin '%s' to term '%s' with net '%s'.", (Object[])new Object[]{dragedDevPin.getName(), dbObj.getName(), connectNet.getName()});
                }

                @Override
                protected void connectChildTerm(Term dbObj) {
                    super.connectChildTerm(dbObj);
                    Term dragedChildTerm = (Term)TargetDevTPanel.this.mDragedObj;
                    Net connectNet = dbObj.getNet();
                    if (connectNet == null) {
                        ALog.logWarn((String)"Cannot connect to a term '%s' without net.", (Object[])new Object[]{dbObj.getName()});
                        return;
                    }
                    Device childDev = TargetDevTPanel.this.mDragedObjOwner;
                    NetListEditorUI.cpMapChildTerm(childDev, dragedChildTerm, connectNet);
                    ALog.logInfo((String)"Connect '%s' term '%s' to parent term '%s' with net '%s'.", (Object[])new Object[]{childDev.getName(), dragedChildTerm.getName(), dbObj.getName(), connectNet.getName()});
                }

                @Override
                protected Device getBoxOwner() {
                    return NetListManagementPanel.this.getTargetDev();
                }

                @Override
                protected DeviceTemplate getBoxOwnerTemplate() {
                    return NetListManagementPanel.this.getTargetDevT();
                }

                @Override
                protected void setTiTleMenu() {
                    super.setTiTleMenu();
                    this.addTitleMenuItem((MenuItem)new SeparatorMenuItem());
                    this.addTitleMenuItem(this.getBulkRenameTermMenu());
                    this.addTitleMenuItem(this.getBulkCreateNetMenu());
                }

                private MenuItem getBulkRenameTermMenu() {
                    MenuItem menuItem = new MenuItem("Bulk rename terms");
                    menuItem.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        BulkRenameTermUI ui = BulkRenameTermUI.showUI((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath());
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(TargetDevTPanel.this.getTermsBox()::reloadItems);
                            }
                        });
                    }));
                    return menuItem;
                }

                private MenuItem getBulkCreateNetMenu() {
                    MenuItem menuItem = new MenuItem("Bulk create nets");
                    menuItem.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        Term2NetBulkCreateUI ui = Term2NetBulkCreateUI.showUI((Window)((Object)NetListEditorUI.this), NetListManagementPanel.this.getTargetDevPath());
                        ui.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(NetListManagementPanel.this.mTargetDevTPane::reloadItems);
                            }
                        });
                    }));
                    return menuItem;
                }

                @Override
                protected ContextMenu getCellContextMenu(Term item) {
                    ContextMenu contextMenu = new ContextMenu();
                    if (item != null) {
                        contextMenu.getItems().add((Object)this.getMenuRename(item));
                        contextMenu.getItems().add((Object)this.getMenuDelete());
                        contextMenu.getItems().add((Object)new SeparatorMenuItem());
                        contextMenu.getItems().add((Object)this.getMenuGraphTerms(item, NetListManagementPanel.this.getTargetDevPath()));
                        contextMenu.getItems().add((Object)this.getMenuDetails(item));
                    }
                    return contextMenu;
                }

                private MenuItem getMenuDetails(Term item) {
                    MenuItem menuItemDetails = new MenuItem("Details");
                    menuItemDetails.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                        AAppView view = OrbitIO.getGuiWorkspace().getView(NetListEditorUI.this.getDb());
                        DbObjectDetailsUI.show((Component)((Object)NetListEditorUI.this), (DbObject)item, NetListManagementPanel.this.getTargetDevPath(), view);
                    }));
                    return menuItemDetails;
                }
            }
        }

        private class BoxCollapseBtn
        extends AJFXButton {
            Pane box;
            TargetBoxExpandBtn expandBtn;
            private EventHandler<javafx.event.ActionEvent> mCollapseTermsBox;

            public BoxCollapseBtn(Pane box, TargetBoxExpandBtn expandBtn) {
                super(OrbitIcons.WIN_MINIMIZE, "Minimize");
                this.mCollapseTermsBox = new EventHandler<javafx.event.ActionEvent>(){

                    public void handle(javafx.event.ActionEvent event) {
                        NetListManagementPanel.this.mTargetDevTPane.getItems().remove((Object)BoxCollapseBtn.this.box);
                        NetListManagementPanel.this.mCollapsedTargetBox.add(BoxCollapseBtn.this.expandBtn);
                        NetListManagementPanel.this.mCollapsedTargetBox.refreshBtns();
                    }
                };
                this.box = box;
                this.expandBtn = expandBtn;
                this.transparentBorder();
                this.setPadding(new Insets(0.0));
                this.setCollapseAction();
            }

            protected void setCollapseAction() {
                this.setOnAction(this.mCollapseTermsBox);
            }

            protected TargetBoxExpandBtn getExpandBtn() {
                return this.expandBtn;
            }
        }

        private abstract class ExpandBtn
        extends AJFXButton {
            public ExpandBtn(Icon icon, String tooltip) {
                super(icon, tooltip);
                this.setOnAction(this.getEventHandler());
                this.transparentBorder();
            }

            protected abstract Pane getPane();

            protected abstract void reloadItems();

            protected abstract EventHandler<javafx.event.ActionEvent> getEventHandler();

            protected boolean isBtnVisible() {
                return true;
            }
        }

        private abstract class TargetBoxExpandBtn
        extends ExpandBtn {
            public TargetBoxExpandBtn(Icon icon, String tooltip) {
                super(icon, tooltip);
            }

            @Override
            public abstract Pane getPane();

            @Override
            protected EventHandler<javafx.event.ActionEvent> getEventHandler() {
                return new EventHandler<javafx.event.ActionEvent>(){

                    public void handle(javafx.event.ActionEvent event) {
                        NetListManagementPanel.this.mCollapsedTargetBox.getChildren().remove((Object)TargetBoxExpandBtn.this);
                        assert (TargetBoxExpandBtn.this.getPane() != null);
                        NetListManagementPanel.this.mTargetDevTPane.addItemBox((Node)TargetBoxExpandBtn.this.getPane());
                    }
                };
            }
        }

        private class CollapsedTargetBox
        extends VBox {
            private final TargetBoxExpandBtn mTermsBoxExpandBtn;
            private final TargetBoxExpandBtn mNetsBoxExpandBtn;
            private final TargetBoxExpandBtn mPinsBoxExpandBtn;
            private final TargetBoxExpandBtn mBumpsBoxExpandBtn;
            private final TargetBoxExpandBtn mPadsBoxExpandBtn;
            private final TargetBoxExpandBtn mChildrenBoxExpandBtn;
            private final List<TargetBoxExpandBtn> mExpendBtnOrder;
            private final Comparator<Node> mExpandBtnComparator;

            public CollapsedTargetBox() {
                super(0.0);
                this.mTermsBoxExpandBtn = new TargetBoxExpandBtn(DBEResources.ICON_TERMS, "Terms"){

                    @Override
                    public Pane getPane() {
                        return NetListManagementPanel.this.mTargetDevTPane.getTermsBox();
                    }

                    @Override
                    protected void reloadItems() {
                        NetListManagementPanel.this.mTargetDevTPane.getTermsBox().reloadItems();
                    }
                };
                this.mNetsBoxExpandBtn = new TargetBoxExpandBtn(DBEResources.ICON_NETS, "Nets"){

                    @Override
                    public Pane getPane() {
                        return NetListManagementPanel.this.mTargetDevTPane.getNetsBox();
                    }

                    @Override
                    protected void reloadItems() {
                        NetListManagementPanel.this.mTargetDevTPane.getNetsBox().reloadItems();
                    }
                };
                this.mPinsBoxExpandBtn = new TargetBoxExpandBtn(DBEResources.ICON_PINS, "Pins"){

                    @Override
                    public Pane getPane() {
                        return NetListManagementPanel.this.mTargetDevTPane.getPinsBox();
                    }

                    @Override
                    protected boolean isBtnVisible() {
                        for (PinTemplate p : NetListManagementPanel.this.getTargetDevT().getPins()) {
                            if (p.isVia()) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected void reloadItems() {
                        NetListManagementPanel.this.mTargetDevTPane.getPinsBox().reloadItems();
                    }
                };
                this.mBumpsBoxExpandBtn = new TargetBoxExpandBtn(DBEResources.ICON_BUMP, "Bumps"){

                    @Override
                    public Pane getPane() {
                        return NetListManagementPanel.this.mTargetDevTPane.getBumpsBox();
                    }

                    @Override
                    protected boolean isBtnVisible() {
                        return NetListManagementPanel.this.getTargetDevT().getChildren().stream().anyMatch(dev -> dev.getType() == DeviceTemplate.Type.BUMP);
                    }

                    @Override
                    protected void reloadItems() {
                        NetListManagementPanel.this.mTargetDevTPane.getBumpsBox().reloadItems();
                    }
                };
                this.mPadsBoxExpandBtn = new TargetBoxExpandBtn(DBEResources.ICON_PAD, "Pads"){

                    @Override
                    public Pane getPane() {
                        return NetListManagementPanel.this.mTargetDevTPane.getPadsBox();
                    }

                    @Override
                    protected boolean isBtnVisible() {
                        return NetListManagementPanel.this.getTargetDevT().getChildren().stream().anyMatch(dev -> dev.getType() == DeviceTemplate.Type.PAD);
                    }

                    @Override
                    protected void reloadItems() {
                        NetListManagementPanel.this.mTargetDevTPane.getPadsBox().reloadItems();
                    }
                };
                this.mChildrenBoxExpandBtn = new TargetBoxExpandBtn(DBEResources.ICON_TEMPLATE, "Children"){

                    @Override
                    public Pane getPane() {
                        return NetListManagementPanel.this.mTargetDevTPane.getChildrenBox();
                    }

                    @Override
                    protected void reloadItems() {
                        NetListManagementPanel.this.mTargetDevTPane.getChildrenBox().reloadItems();
                    }
                };
                this.mExpendBtnOrder = AUtil.arrayList((Object[])new TargetBoxExpandBtn[]{this.mTermsBoxExpandBtn, this.mNetsBoxExpandBtn, this.mPinsBoxExpandBtn, this.mBumpsBoxExpandBtn, this.mPadsBoxExpandBtn, this.mChildrenBoxExpandBtn});
                this.mExpandBtnComparator = (nodeA, nodeB) -> {
                    TargetBoxExpandBtn a = (TargetBoxExpandBtn)((Object)nodeA);
                    TargetBoxExpandBtn b = (TargetBoxExpandBtn)((Object)nodeB);
                    if (!a.isBtnVisible() && b.isBtnVisible()) {
                        return 1;
                    }
                    if (a.isBtnVisible() && !b.isBtnVisible()) {
                        return -1;
                    }
                    if (!a.isBtnVisible() && !b.isBtnVisible()) {
                        return 0;
                    }
                    return Integer.compare(this.mExpendBtnOrder.indexOf((Object)a), this.mExpendBtnOrder.indexOf((Object)b));
                };
                this.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
                this.add(this.mPinsBoxExpandBtn);
                this.add(this.mBumpsBoxExpandBtn);
                this.add(this.mPadsBoxExpandBtn);
                this.refreshBtns();
            }

            public void refreshBtns() {
                this.setBtnVisible();
                ObservableList btns = FXCollections.observableArrayList((Collection)this.getChildren());
                Collections.sort(btns, this.mExpandBtnComparator);
                this.getChildren().setAll((Collection)btns);
            }

            public void setBtnVisible() {
                for (Node node : AUtil.arrayList((Collection)this.getChildren())) {
                    assert (node instanceof TargetBoxExpandBtn);
                    this.setVisible((TargetBoxExpandBtn)node);
                }
            }

            public void reloadItems() {
                for (Node node : this.getChildren()) {
                    assert (node instanceof TargetBoxExpandBtn);
                    ((TargetBoxExpandBtn)node).reloadItems();
                }
            }

            private void setVisible(TargetBoxExpandBtn btn) {
                btn.setVisible(btn.isBtnVisible());
            }

            private void add(TargetBoxExpandBtn btn) {
                this.getChildren().add((Object)btn);
            }

            public TargetBoxExpandBtn getTermsBoxExpandBtn() {
                return this.mTermsBoxExpandBtn;
            }

            public TargetBoxExpandBtn getNetsBoxExpandBtn() {
                return this.mNetsBoxExpandBtn;
            }

            public TargetBoxExpandBtn getPinsBoxExpandBtn() {
                return this.mPinsBoxExpandBtn;
            }

            public TargetBoxExpandBtn getBumpsBoxExpandBtn() {
                return this.mBumpsBoxExpandBtn;
            }

            public TargetBoxExpandBtn getPadsBoxExpandBtn() {
                return this.mPadsBoxExpandBtn;
            }

            public TargetBoxExpandBtn getChildrenBoxExpandBtn() {
                return this.mChildrenBoxExpandBtn;
            }
        }
    }
}

