/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import com.sigrity.orbit.ui.partitionTool.PartitionToolModeOverlayDrawer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

class PTMODCursor
implements PartitionToolModeOverlayDrawer {
    PartitionToolMode mPTM;
    private Point mCursorPoint;

    public static PTMODCursor newInstance(PartitionToolMode ptm) {
        PTMODCursor drawer = new PTMODCursor(ptm);
        return drawer;
    }

    private PTMODCursor(PartitionToolMode ptm) {
        this.mPTM = ptm;
    }

    void setCursorPoint(Point p) {
        this.mCursorPoint = p;
    }

    private boolean isReady() {
        return this.mCursorPoint != null;
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
        if (!this.isReady()) {
            return;
        }
        int minx = (int)bounds.getMinX();
        int maxx = (int)bounds.getMaxX();
        int miny = (int)bounds.getMinY();
        int maxy = (int)bounds.getMaxY();
        BasicStroke stroke1Dash = new BasicStroke(1.0f, 0, 1, 45.0f, new float[]{5.0f, 3.0f}, 0.0f);
        boolean ortho = true;
        Color primary = ortho ? Color.RED : Color.MAGENTA;
        g.setStroke(stroke1Dash);
        g.setColor(primary);
        g.drawLine(minx, (int)this.mCursorPoint.getY(), maxx, (int)this.mCursorPoint.getY());
        g.drawLine((int)this.mCursorPoint.getX(), miny, (int)this.mCursorPoint.getX(), maxy);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.reset();
    }

    private void reset() {
        this.mCursorPoint = null;
    }
}

