/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import com.sigrity.orbit.ui.partitionTool.PartitionToolModeOverlayDrawer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.Timer;

class PTMODCutLine
implements PartitionToolModeOverlayDrawer {
    PartitionToolMode mPTM;
    private boolean mShow = true;
    private PartitionToolMode.CursorLoc mRefA;
    private PartitionToolMode.CursorLoc mRefB;
    private ALine mCutLine;
    Timer mTimer;
    int mDashStart;

    public static PTMODCutLine newInstance(PartitionToolMode ptm) {
        PTMODCutLine drawer = new PTMODCutLine(ptm);
        return drawer;
    }

    private PTMODCutLine(PartitionToolMode ptm) {
        this.mPTM = ptm;
    }

    public void setShow(boolean bShow) {
        this.mShow = bShow;
    }

    public void setReferencePoints(ALine cutLine, PartitionToolMode.CursorLoc a, PartitionToolMode.CursorLoc b) {
        this.mCutLine = cutLine;
        this.mRefA = a;
        this.mRefB = b;
        this.mPTM.repaintOverlay();
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
        if (!this.isReady()) {
            this.mCutLine = null;
            return;
        }
        DesignView2D view = this.mPTM.getView();
        Point start = this.mRefA.getSnapScreen();
        Point end = this.mRefB.getSnapScreen();
        AffineTransform oldTransform = g.getTransform();
        BasicStroke strokeIndicatorLine = new BasicStroke(1.0f, 0, 1);
        BasicStroke strokeThinLine = new BasicStroke(3.0f, 0, 1);
        BasicStroke strokeThickLine = new BasicStroke(5.0f, 0, 1);
        BasicStroke strokeThinDash = new BasicStroke(3.0f, 0, 1, 45.0f, new float[]{3.0f, 3.0f}, this.mDashStart);
        double angle = this.mRefA.getSnap().getAngleRadians(this.mRefB.getSnap());
        Color cutLineBg = Color.blue;
        Color cutLineFg = Color.white;
        Color indicatorLineBg = Color.darkGray;
        Color indicatorLineFg = Color.gray;
        g.setPaintMode();
        g.setStroke(strokeThinLine);
        g.setColor(indicatorLineBg);
        g.drawLine(start.x, start.y, end.x, end.y);
        g.rotate(-angle, start.x, start.y);
        DesignCanvas2D.drawArrow(view, g, start, AGeomUtil.Orient.W, null, g.getColor());
        g.setTransform(oldTransform);
        g.rotate(-angle, end.x, end.y);
        DesignCanvas2D.drawArrow(view, g, end, AGeomUtil.Orient.E, null, g.getColor());
        g.setTransform(oldTransform);
        g.setStroke(strokeIndicatorLine);
        g.setColor(indicatorLineFg);
        g.drawLine(start.x, start.y, end.x, end.y);
        g.rotate(-angle, start.x, start.y);
        DesignCanvas2D.drawArrow(view, g, start, AGeomUtil.Orient.W, null, g.getColor());
        g.setTransform(oldTransform);
        g.rotate(-angle, end.x, end.y);
        DesignCanvas2D.drawArrow(view, g, end, AGeomUtil.Orient.E, null, g.getColor());
        g.setTransform(oldTransform);
        if (this.mCutLine != null) {
            APoint2D p0 = this.mCutLine.getFirstPoint();
            APoint2D p1 = this.mCutLine.getLastPoint();
            Point scrnP0 = this.mPTM.getView().getCanvas().getXForm().getScreenPt(p0);
            Point scrnP1 = this.mPTM.getView().getCanvas().getXForm().getScreenPt(p1);
            int x1 = (int)scrnP0.getX();
            int y1 = (int)scrnP0.getY();
            int x2 = (int)scrnP1.getX();
            int y2 = (int)scrnP1.getY();
            g.setStroke(strokeThickLine);
            g.setColor(cutLineBg);
            g.drawLine(x1, y1, x2, y2);
            g.setStroke(strokeThinDash);
            g.setColor(cutLineFg);
            g.drawLine(x1, y1, x2, y2);
        }
    }

    private boolean isReady() {
        return this.mRefA != null && this.mRefB != null && this.mShow;
    }

    @Override
    public void start() {
        this.startTimer();
    }

    @Override
    public void stop() {
        this.stopTimer();
        this.reset();
    }

    private void reset() {
        this.mRefA = null;
        this.mRefB = null;
        this.mCutLine = null;
    }

    private void startTimer() {
        if (this.mTimer != null) {
            this.mDashStart = 0;
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!PTMODCutLine.this.isReady()) {
                        return;
                    }
                    if (++PTMODCutLine.this.mDashStart > 1) {
                        PTMODCutLine.this.mDashStart = 0;
                    }
                    PTMODCutLine.this.mPTM.repaintOverlay(true);
                }
            };
            this.mTimer = new Timer(300, taskPerformer);
            this.mTimer.start();
        }
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.stop();
            this.mTimer = null;
        }
    }
}

