/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.geom.AGeom;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import com.sigrity.orbit.ui.partitionTool.PartitionToolModeOverlayDrawer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

class PTMODFocus
implements PartitionToolModeOverlayDrawer {
    PartitionToolMode mPTM;
    private PartitionToolMode.CursorLoc mFocus;

    public static PTMODFocus newInstance(PartitionToolMode ptm) {
        PTMODFocus drawer = new PTMODFocus(ptm);
        return drawer;
    }

    private PTMODFocus(PartitionToolMode ptm) {
        this.mPTM = ptm;
    }

    public void setFocus(PartitionToolMode.CursorLoc c) {
        if (this.mFocus == null && c != null || this.mFocus != null && !this.mFocus.equals(c)) {
            this.mFocus = c;
            this.mPTM.repaintOverlay();
        }
    }

    private boolean isReady() {
        return this.mFocus != null;
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
        if (!this.isReady()) {
            return;
        }
        PartitionToolMode.SnapObject snapObj = this.mFocus.getSnappedToObj();
        if (snapObj == null) {
            return;
        }
        AGeom shape = snapObj.getShape();
        if (shape == null) {
            return;
        }
        DevicePath dp = snapObj.getDevicePath();
        AGeom transformedShape = dp == null ? shape : shape.transform(dp.getTransform());
        g.setColor(Color.red);
        g.setXORMode(Color.green);
        this.fillScreenShape(g, transformedShape, this.mPTM);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.reset();
    }

    private void reset() {
        this.mFocus = null;
    }
}

