/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.APair;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import com.sigrity.orbit.ui.partitionTool.PartitionToolModeOverlayDrawer;
import com.sigrity.orbit.ui.partitionTool.Segment;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;

class PTMODMovingSegments
implements PartitionToolModeOverlayDrawer {
    APoint2D mMoveStart;
    APoint2D mMoveCurrent;
    APoint2D mTarget;
    List<Segment> mSegments;
    Segment mLeader;
    long mOffsetXBase;
    long mOffsetYBase;
    PartitionToolMode mPTM;
    boolean mUseAltTarget = false;
    APoint2D mAltTarget;
    APair<Long, Long> mRange;
    Timer mTimer;

    public static PTMODMovingSegments newInstance(PartitionToolMode ptm) {
        PTMODMovingSegments ms = new PTMODMovingSegments(ptm);
        return ms;
    }

    private PTMODMovingSegments(PartitionToolMode ptm) {
        this.mPTM = ptm;
    }

    private Segment findNearestHorizontal(long y) {
        return this.mSegments.stream().min((s1, s2) -> Long.compare(Math.abs(s1.getP0().getY() - y), Math.abs(s2.getP0().getY() - y))).orElse(null);
    }

    private Segment findNearestVertical(long x) {
        return this.mSegments.stream().min((s1, s2) -> Long.compare(Math.abs(s1.getP0().getX() - x), Math.abs(s2.getP0().getX() - x))).orElse(null);
    }

    public void setTarget(Point target) {
        this.mTarget = this.mPTM.getWorldPoint(target);
    }

    public void useAlternateTarget(boolean toUse) {
        this.mUseAltTarget = toUse;
    }

    public void setAlternateTargetByOffset(long offset) {
        if (this.mSegments == null || this.mSegments.isEmpty()) {
            return;
        }
        this.mAltTarget = this.mSegments.get(0).isHorizontal() ? this.mMoveStart.add(0L, offset) : this.mMoveStart.add(offset, 0L);
    }

    public void setSegmentsAndRange(List<Segment> segments, Point start, APair<Long, Long> range) {
        assert (segments != null && !segments.isEmpty());
        this.mRange = range;
        this.mSegments = segments;
        APoint2D startWorld = this.mPTM.getWorldPoint(start);
        this.mLeader = segments.get(0).isHorizontal() ? this.findNearestHorizontal(startWorld.getY()) : this.findNearestVertical(startWorld.getX());
        this.mMoveCurrent = this.mMoveStart = this.mLeader.getP0();
        this.mTarget = startWorld;
        if (this.mLeader.isHorizontal()) {
            this.mOffsetXBase = 0L;
            this.mOffsetYBase = 1L;
        } else {
            this.mOffsetXBase = 1L;
            this.mOffsetYBase = 0L;
        }
    }

    public List<Segment> getSegments() {
        return this.mSegments;
    }

    public APoint2D getOffsetToTargetWorld() {
        long y;
        long x;
        if (this.mUseAltTarget) {
            x = (this.mAltTarget.getX() - this.mMoveStart.getX()) * this.mOffsetXBase;
            y = (this.mAltTarget.getY() - this.mMoveStart.getY()) * this.mOffsetYBase;
        } else {
            x = (this.mTarget.getX() - this.mMoveStart.getX()) * this.mOffsetXBase;
            y = (this.mTarget.getY() - this.mMoveStart.getY()) * this.mOffsetYBase;
        }
        if (x != 0L) {
            x = Math.max(Math.min(x, (Long)this.mRange.second), (Long)this.mRange.first);
        }
        if (y != 0L) {
            y = Math.max(Math.min(y, (Long)this.mRange.second), (Long)this.mRange.first);
        }
        return new APoint2D(x, y);
    }

    @Override
    public void start() {
        this.startTimer();
    }

    @Override
    public void stop() {
        this.stopTimer();
        this.reset();
    }

    private void reset() {
        this.mMoveStart = null;
        this.mMoveCurrent = null;
        this.mTarget = null;
        this.mLeader = null;
        this.mUseAltTarget = false;
        this.mSegments = null;
    }

    private boolean isReady() {
        return this.mSegments != null && !this.mSegments.isEmpty();
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
        if (!this.isReady()) {
            return;
        }
        int offsetX = this.mPTM.getScreenLen(this.mMoveCurrent.getX() - this.mMoveStart.getX());
        int offsetY = -this.mPTM.getScreenLen(this.mMoveCurrent.getY() - this.mMoveStart.getY());
        GradientPaint gph = new GradientPaint(0.0f, 0.0f, Color.green, 5.0f, 50.0f, Color.gray, true);
        GradientPaint gpv = new GradientPaint(0.0f, 0.0f, Color.green, 50.0f, 5.0f, Color.gray, true);
        Paint oldPaint = g.getPaint();
        g.setPaint(gph);
        this.mSegments.stream().filter(s -> s.isHorizontal()).forEach(s -> {
            ALine l = s.mSide;
            Point p0 = this.mPTM.getScreenPoint(l.getP0());
            p0.translate(offsetX, offsetY);
            Point p1 = this.mPTM.getScreenPoint(l.getP1());
            p1.translate(offsetX, offsetY);
            Rectangle rect = new Rectangle(p0);
            rect.add(p1);
            rect.grow(0, 2);
            g.fill(rect);
        });
        g.setPaint(gpv);
        this.mSegments.stream().filter(s -> s.isVertical()).forEach(s -> {
            ALine l = s.mSide;
            Point p0 = this.mPTM.getScreenPoint(l.getP0());
            p0.translate(offsetX, offsetY);
            Point p1 = this.mPTM.getScreenPoint(l.getP1());
            p1.translate(offsetX, offsetY);
            Rectangle rect = new Rectangle(p0);
            rect.add(p1);
            rect.grow(2, 0);
            g.fill(rect);
        });
        g.setPaint(oldPaint);
    }

    private void startTimer() {
        if (this.mTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!PTMODMovingSegments.this.isReady()) {
                        return;
                    }
                    APoint2D potential = PTMODMovingSegments.this.getNextPos();
                    if (potential == null) {
                        return;
                    }
                    PTMODMovingSegments.this.mMoveCurrent = potential;
                    PTMODMovingSegments.this.mPTM.repaintOverlay(true);
                }
            };
            this.mTimer = new Timer(100, taskPerformer);
            this.mTimer.start();
        }
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.stop();
            this.mTimer = null;
        }
    }

    private APoint2D getNextPos() {
        if (this.mUseAltTarget) {
            return this.mAltTarget;
        }
        long xdiff = (this.mTarget.getX() - this.mMoveCurrent.getX()) * this.mOffsetXBase;
        long ydiff = (this.mTarget.getY() - this.mMoveCurrent.getY()) * this.mOffsetYBase;
        if (xdiff != 0L) {
            long dxCurrent2Ref = this.mMoveCurrent.getX() - this.mMoveStart.getX();
            long dxTarget2Current = xdiff / 2L + 1L;
            while (!this.mPTM.getPartition().canMove(this.mSegments, dxTarget2Current + dxCurrent2Ref, 0L) && (dxTarget2Current /= 2L) != 0L) {
            }
            return dxTarget2Current == 0L ? null : new APoint2D(this.mMoveCurrent.getX() + dxTarget2Current, this.mMoveCurrent.getY());
        }
        if (ydiff != 0L) {
            long dyCurrent2Ref = this.mMoveCurrent.getY() - this.mMoveStart.getY();
            long dyTarget2Current = ydiff / 2L + 1L;
            while (!this.mPTM.getPartition().canMove(this.mSegments, 0L, dyTarget2Current + dyCurrent2Ref) && (dyTarget2Current /= 2L) != 0L) {
            }
            return dyTarget2Current == 0L ? null : new APoint2D(this.mMoveCurrent.getX(), this.mMoveCurrent.getY() + dyTarget2Current);
        }
        return null;
    }
}

