/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.geom.ALine;
import com.sigrity.orbit.ui.partitionTool.PartitionTool;
import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import com.sigrity.orbit.ui.partitionTool.PartitionToolModeOverlayDrawer;
import com.sigrity.orbit.ui.partitionTool.Segment;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.Timer;

class PTMODPartition
implements PartitionToolModeOverlayDrawer {
    PartitionToolMode mPTM;
    private PartitionTool mPartition;
    public static boolean _debugPartition = false;
    Timer mTimer;
    boolean mUseColor1;

    public static PTMODPartition newInstance(PartitionToolMode ptm) {
        PTMODPartition drawer = new PTMODPartition(ptm);
        return drawer;
    }

    private PTMODPartition(PartitionToolMode ptm) {
        this.mPTM = ptm;
    }

    public void setPartition(PartitionTool pt) {
        this.mPartition = pt;
        this.mPTM.repaintOverlay();
    }

    private boolean isReady() {
        return this.mPartition != null;
    }

    private void debugPaintOverlay(Graphics2D g, Rectangle bounds) {
        Paint oldPaint = g.getPaint();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.white, 4.0f, 4.0f, Color.black, true);
        Color gps = Color.red;
        List segments = this.mPartition.getSegments().stream().sorted((s1, s2) -> s1.compareTo((Segment)s2)).collect(Collectors.toList());
        IntStream.range(0, this.mPartition.getSegments().size()).forEach(i -> {
            Segment s = (Segment)segments.get(i);
            ALine l = s.mSide;
            Point p0 = this.mPTM.getScreenPoint(l.getP0());
            Point p1 = this.mPTM.getScreenPoint(l.getP1());
            Rectangle rect = new Rectangle(p0);
            rect.add(p1);
            if (s.isHorizontal()) {
                rect.grow(0, 1);
            } else {
                rect.grow(1, 0);
            }
            g.setPaint(gp);
            g.fill(rect);
            g.setPaint(gps);
            g.drawString(String.format("%d", i), (float)(p0.getX() + p1.getX()) / 2.0f, (float)(p0.getY() + p1.getY()) / 2.0f);
        });
        g.setPaint(oldPaint);
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
        if (!this.isReady()) {
            return;
        }
        if (_debugPartition) {
            this.debugPaintOverlay(g, bounds);
            return;
        }
        Paint oldPaint = g.getPaint();
        GradientPaint gph = new GradientPaint(0.0f, 0.0f, Color.white, 4.0f, 4.0f, Color.black, true);
        GradientPaint gpv = new GradientPaint(0.0f, 0.0f, Color.white, 4.0f, 4.0f, Color.black, true);
        g.setPaint(gph);
        this.mPartition.getSegments().stream().filter(s -> s.isHorizontal()).forEach(s -> {
            ALine l = s.mSide;
            Point p0 = this.mPTM.getScreenPoint(l.getP0());
            Point p1 = this.mPTM.getScreenPoint(l.getP1());
            Rectangle rect = new Rectangle(p0);
            rect.add(p1);
            rect.grow(0, 1);
            g.fill(rect);
        });
        g.setPaint(gpv);
        this.mPartition.getSegments().stream().filter(s -> s.isVertical()).forEach(s -> {
            ALine l = s.mSide;
            Point p0 = this.mPTM.getScreenPoint(l.getP0());
            Point p1 = this.mPTM.getScreenPoint(l.getP1());
            Rectangle rect = new Rectangle(p0);
            rect.add(p1);
            rect.grow(1, 0);
            g.fill(rect);
        });
        g.setPaint(oldPaint);
    }

    @Override
    public void start() {
        this.startTimer();
    }

    @Override
    public void stop() {
        this.stopTimer();
        this.reset();
    }

    private void reset() {
        this.mPartition = null;
    }

    private void startTimer() {
        if (this.mTimer == null) {
            this.mUseColor1 = true;
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!PTMODPartition.this.isReady()) {
                        return;
                    }
                    PTMODPartition.this.mUseColor1 = !PTMODPartition.this.mUseColor1;
                    PTMODPartition.this.mPTM.repaintOverlay(true);
                }
            };
            this.mTimer = new Timer(700, taskPerformer);
            this.mTimer.start();
        }
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.stop();
            this.mTimer = null;
        }
    }
}

