/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import com.sigrity.orbit.ui.partitionTool.PartitionToolModeOverlayDrawer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

class PTMODRuler
implements PartitionToolModeOverlayDrawer {
    PartitionToolMode mPTM;
    private boolean mShow = true;
    private PartitionToolMode.CursorLoc mRefA;
    private PartitionToolMode.CursorLoc mRefB;
    Timer mTimer;
    int mDashStart;

    public static PTMODRuler newInstance(PartitionToolMode ptm) {
        PTMODRuler ruler = new PTMODRuler(ptm);
        return ruler;
    }

    private PTMODRuler(PartitionToolMode ptm) {
        this.mPTM = ptm;
    }

    public void setShow(boolean bShow) {
        this.mShow = bShow;
    }

    public void setReferencePoints(PartitionToolMode.CursorLoc a, PartitionToolMode.CursorLoc b) {
        this.mRefA = a;
        this.mRefB = b;
        this.mPTM.repaintOverlay();
    }

    private boolean isReady() {
        return this.mRefA != null && this.mRefB != null && this.mShow;
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
    }

    @Override
    public void start() {
        this.startTimer();
    }

    @Override
    public void stop() {
        this.stopTimer();
        this.reset();
    }

    private void reset() {
        this.mRefA = null;
        this.mRefB = null;
    }

    private void startTimer() {
        if (this.mTimer == null) {
            this.mDashStart = 0;
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!PTMODRuler.this.isReady()) {
                        return;
                    }
                    if (++PTMODRuler.this.mDashStart > 1) {
                        PTMODRuler.this.mDashStart = 0;
                    }
                    PTMODRuler.this.mPTM.repaintOverlay(true);
                }
            };
            this.mTimer = new Timer(300, taskPerformer);
            this.mTimer.start();
        }
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.stop();
            this.mTimer = null;
        }
    }
}

