/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.ALog;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import com.sigrity.orbit.ui.partitionTool.PartitionToolModeOverlayDrawer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;

class PTMODSelection
implements PartitionToolModeOverlayDrawer {
    PartitionToolMode mPTM;
    List<PartitionToolMode.CursorLoc> mSelection;
    Timer mTimer;
    int mCount;
    final int kMaxCount = 4;

    public static PTMODSelection newInstance(PartitionToolMode ptm) {
        PTMODSelection drawer = new PTMODSelection(ptm);
        return drawer;
    }

    private PTMODSelection(PartitionToolMode ptm) {
        this.mPTM = ptm;
    }

    public void setSelection(List<PartitionToolMode.CursorLoc> selection) {
        block3: {
            if (selection != null) {
                try {
                    selection.stream().filter(cl -> cl == null).findAny();
                }
                catch (NullPointerException npe) {
                    ALog.logError((String)"Selection %s has null element!", (Object[])new Object[]{selection});
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        this.mSelection = selection;
        this.mPTM.repaintOverlay();
    }

    private boolean isReady() {
        return this.mSelection != null && !this.mSelection.isEmpty();
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
        if (!this.isReady()) {
            return;
        }
        Paint oldPaint = g.getPaint();
        Color c1 = (this.mCount & 1) == 1 ? Color.red : Color.white;
        Color c2 = (this.mCount & 1) == 1 ? Color.white : Color.red;
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, c1, 2.0f, 2.0f, c2, true);
        g.setPaint(gradient);
        for (PartitionToolMode.CursorLoc cl : this.mSelection) {
            AGeom transformedShape;
            if (cl == null) {
                ALog.logWarn((String)"PTMODSelection should not have null!", (Object[])new Object[]{this.mSelection});
                continue;
            }
            PartitionToolMode.SnapObject snapObj = cl.getSnappedToObj();
            if (snapObj == null) continue;
            AGeom shape = snapObj.getShape();
            if (shape == null) {
                return;
            }
            DevicePath dp = snapObj.getDevicePath();
            AGeom aGeom = transformedShape = dp == null ? shape : shape.transform(dp.getTransform());
            if (transformedShape instanceof ALine) {
                transformedShape = ((ALine)transformedShape).inflate(4L);
            }
            this.drawScreenShape(g, transformedShape, this.mPTM);
        }
        g.setPaint(oldPaint);
    }

    @Override
    public void start() {
        this.startTimer();
    }

    @Override
    public void stop() {
        this.stopTimer();
        this.reset();
    }

    private void reset() {
        this.mSelection = null;
    }

    private void startTimer() {
        if (this.mTimer == null) {
            this.mCount = 0;
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!PTMODSelection.this.isReady()) {
                        return;
                    }
                    if (++PTMODSelection.this.mCount >= 4) {
                        PTMODSelection.this.mCount = 0;
                    }
                    PTMODSelection.this.mPTM.repaintOverlay(true);
                }
            };
            this.mTimer = new Timer(500, taskPerformer);
            this.mTimer.start();
        }
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.stop();
            this.mTimer = null;
        }
    }
}

