/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.GOD;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ui.partitionTool.LineAndIntersectedPoint;
import com.sigrity.orbit.ui.partitionTool.SRPoly;
import com.sigrity.orbit.ui.partitionTool.Segment;
import com.sigrity.orbit.ui.partitionTool.SegmentGroup;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class PartitionTool {
    private Set<Segment> mInitialSegments = new HashSet<Segment>();
    private Set<Segment> mSegments = new HashSet<Segment>();
    private UndoRedoTool mUndoRedoTool = new UndoRedoTool();
    DevicePath mDevicePath;
    Set<DevicePath> mChildDPs;
    private Map<Segment, APair<Long, Long>> mMoveOffsetRange = new HashMap<Segment, APair<Long, Long>>();
    BiConsumer<Boolean, Boolean> mUndoRedoStatusListener = null;
    UndoManager mUndoManager = new UndoManager();
    UndoableEditSupport mUndoSupport = new UndoableEditSupport();
    UndoAction mActionUndo = new UndoAction();
    RedoAction mActionRedo = new RedoAction();

    private List<ALine> getHorizontalThroughCutLines(ALine line) {
        LinkedList<ALine> cuts = new LinkedList<ALine>();
        long y = line.getP0().getY();
        List xlist = this.mSegments.stream().filter(Segment::isVertical).filter(l -> l.mSide.yInOrOn(y)).map(l -> l.getP0().getX()).distinct().sorted().collect(Collectors.toList());
        if (xlist.isEmpty()) {
            return Collections.emptyList();
        }
        Long prevX = (Long)xlist.get(0);
        for (Long x : xlist) {
            cuts.add(new ALine(prevX.longValue(), y, x.longValue(), y));
            prevX = x;
        }
        cuts.remove(0);
        return cuts;
    }

    private List<ALine> getVerticalThroughCutLines(ALine line) {
        LinkedList<ALine> cuts = new LinkedList<ALine>();
        long x = line.getP0().getX();
        List ylist = this.mSegments.stream().filter(Segment::isHorizontal).filter(l -> l.mSide.xInOrOn(x)).map(l -> l.getP0().getY()).distinct().sorted().collect(Collectors.toList());
        if (ylist.isEmpty()) {
            return Collections.emptyList();
        }
        Long prevY = (Long)ylist.get(0);
        for (Long y : ylist) {
            cuts.add(new ALine(x, prevY.longValue(), x, y.longValue()));
            prevY = y;
        }
        cuts.remove(0);
        return cuts;
    }

    public List<ALine> getThroughCutLines(ALine line) {
        if (line.isHorizontal()) {
            return this.getHorizontalThroughCutLines(line);
        }
        if (line.isVertical()) {
            return this.getVerticalThroughCutLines(line);
        }
        throw new IllegalArgumentException("Line can only be either horizontal or vertical!");
    }

    private List<ALine> getVerticalLinesSorted(List<ALine> lines) {
        return lines.stream().filter(ALine::isVertical).sorted((l1, l2) -> Long.compare(l1.getP0().getX(), l2.getP0().getX())).collect(Collectors.toList());
    }

    private List<ALine> getHorizontalLinesSorted(List<ALine> lines) {
        return lines.stream().filter(ALine::isHorizontal).sorted((l1, l2) -> Long.compare(l1.getP0().getY(), l2.getP0().getY())).collect(Collectors.toList());
    }

    public ALine extendsAndGetBoundaryIntersection(ALine line) {
        List<ALine> boundary = this.getBoundary();
        if (line.isHorizontal()) {
            boundary = this.getVerticalLinesSorted(boundary);
            return new ALine(boundary.get(0).getP0().getX(), line.getP0().getY(), boundary.get(boundary.size() - 1).getP0().getX(), line.getP0().getY());
        }
        if (line.isVertical()) {
            boundary = this.getHorizontalLinesSorted(boundary);
            return new ALine(line.getP0().getX(), boundary.get(0).getP0().getY(), line.getP0().getX(), boundary.get(boundary.size() - 1).getP0().getY());
        }
        throw new IllegalArgumentException("Line can only be either horizontal or vertical!");
    }

    public List<ALine> getBoundary() {
        SRPoly boundaryPoly;
        List<SRPoly> uniquePolys = this.getUniquePolys();
        SRPoly sRPoly = boundaryPoly = uniquePolys.size() == 1 ? uniquePolys.get(0) : (SRPoly)uniquePolys.stream().filter(p -> !p.isMinimal(uniquePolys)).findAny().orElse(null);
        if (boundaryPoly != null) {
            return boundaryPoly.getSides();
        }
        List<SRPoly> dbgPolys = this.getPolys();
        dbgPolys.stream().forEach(p -> ALog.logInfo((String)"Poly:%s, clockwise:%s", (Object[])new Object[]{p, p.isClockwise()}));
        ALog.logError((String)"Failed to find boundary. Segments are:%s", (Object[])new Object[]{this.mSegments});
        assert (false);
        return Collections.emptyList();
    }

    public Set<Segment> getSegments() {
        return this.mSegments;
    }

    public DevicePath getDevicePath() {
        return this.mDevicePath;
    }

    public static PartitionTool newInstance(ARect rect) {
        return PartitionTool.newInstance(null, rect);
    }

    public static PartitionTool newInstance(DevicePath dp, ARect rect) {
        PartitionTool pt = new PartitionTool(rect);
        pt.mDevicePath = dp;
        return pt;
    }

    public static PartitionTool newInstance(ALine[] array) {
        return PartitionTool.newInstance(new ArrayList<ALine>(Arrays.asList(array)));
    }

    public static PartitionTool newInstance(List<ALine> segments) {
        return PartitionTool.newInstance(null, segments);
    }

    public static PartitionTool newInstance(DevicePath dp, List<ALine> segments) {
        PartitionTool pt = new PartitionTool(segments.stream().map(s -> new Segment((ALine)s)).collect(Collectors.toList()));
        pt.mDevicePath = dp;
        return pt;
    }

    private PartitionTool(ARect rect) {
        this.mUndoSupport.addUndoableEditListener(new UndoAdapter());
        this.mSegments.add(new Segment(rect.bottomEdge()));
        this.mSegments.add(new Segment(rect.topEdge()));
        this.mSegments.add(new Segment(rect.rightEdge()));
        this.mSegments.add(new Segment(rect.leftEdge()));
        this.mInitialSegments.addAll(this.mSegments);
    }

    private PartitionTool(List<Segment> segments) {
        this.mUndoSupport.addUndoableEditListener(new UndoAdapter());
        this.mSegments.addAll(segments);
        this.mInitialSegments.addAll(segments);
    }

    public void reset() {
        int editHandle = this.mUndoRedoTool.editBegin();
        this.resetStateWithSegments(new HashSet<Segment>(this.mInitialSegments));
        this.mUndoRedoTool.editEnd(editHandle);
    }

    public boolean equals(PartitionTool other) {
        return this.mSegments.equals(other.getSegments());
    }

    public boolean contains(Segment segment) {
        return this.mSegments.contains(segment);
    }

    public String toString() {
        return this.mSegments.stream().map(Segment::toString).collect(Collectors.joining(","));
    }

    public List<Segment> getSegmentsNear(APoint2D world, long range) {
        return this.mSegments.stream().filter(s -> s.mSide.distance(world) <= range).collect(Collectors.toList());
    }

    public Optional<Segment> getNearestSegment(APoint2D world, long range) {
        return this.getSegmentsNear(world, range).stream().min((s1, s2) -> Long.compare(s1.mSide.distance(world), s2.mSide.distance(world)));
    }

    private List<Segment> getBelowHSegmentsSorted(long y) {
        return this.mSegments.stream().filter(Segment::isHorizontal).filter(s -> s.getP0().getY() < y).sorted((s1, s2) -> Long.compare(s1.mSide.getP0().getY(), s2.mSide.getP0().getY())).collect(Collectors.toList());
    }

    private List<Segment> getAboveHSegmentsSorted(long y) {
        return this.mSegments.stream().filter(Segment::isHorizontal).filter(s -> s.getP0().getY() > y).sorted((s1, s2) -> Long.compare(s1.mSide.getP0().getY(), s2.mSide.getP0().getY())).collect(Collectors.toList());
    }

    private List<Segment> getRightVSegmentsSorted(long x) {
        return this.mSegments.stream().filter(Segment::isVertical).filter(s -> s.getP0().getX() > x).sorted((s1, s2) -> Long.compare(s1.mSide.getP0().getX(), s2.mSide.getP0().getX())).collect(Collectors.toList());
    }

    private List<Segment> getLeftVSegmentsSorted(long x) {
        return this.mSegments.stream().filter(Segment::isVertical).filter(s -> s.getP0().getX() < x).sorted((s1, s2) -> Long.compare(s1.mSide.getP0().getX(), s2.mSide.getP0().getX())).collect(Collectors.toList());
    }

    public Segment getNthNearestSegment(int n, APoint2D world, AGeomUtil.Side side) {
        List<Segment> sortedList;
        long x = world.getX();
        long y = world.getY();
        switch (side) {
            case Bottom: {
                sortedList = this.getBelowHSegmentsSorted(y);
                break;
            }
            case Right: {
                sortedList = this.getRightVSegmentsSorted(x);
                break;
            }
            case Top: {
                sortedList = this.getAboveHSegmentsSorted(y);
                break;
            }
            default: {
                sortedList = this.getLeftVSegmentsSorted(x);
            }
        }
        if (n > sortedList.size() - 1) {
            n = sortedList.size() - 1;
        }
        if (n < 0) {
            return null;
        }
        return sortedList.get(n);
    }

    public List<Device> exportToTemplatesAndDevices(AGeomUtil.AboutPt originPosition) {
        if (this.mDevicePath == null) {
            return null;
        }
        if (originPosition != AGeomUtil.AboutPt.CENTER && originPosition != AGeomUtil.AboutPt.LL) {
            throw new IllegalArgumentException("Origin can only be at center or lower left corner!");
        }
        List<SRPoly> uniqueDevicePolys = this.getUniquePolys();
        try {
            SRPoly topDeviceOutline = uniqueDevicePolys.stream().filter(p -> !p.isMinimal(uniqueDevicePolys)).findAny().get();
            uniqueDevicePolys.remove(topDeviceOutline);
        }
        catch (Exception e) {
            ALog.logError((String)"Failed to find boundary from polys:%s", (Object[])new Object[]{uniqueDevicePolys});
        }
        AffineTransform relative2TemplateXform = this.mDevicePath.getInverseTransform();
        LinkedList<Device> generatedDevices = new LinkedList<Device>();
        DeviceTemplate topDeviceTemplate = this.mDevicePath.getDeviceTemplate();
        int i = 0;
        for (SRPoly p2 : uniqueDevicePolys) {
            generatedDevices.add(this.createTemplateDevice(topDeviceTemplate, relative2TemplateXform, p2, originPosition, String.format("d_%d", i++)));
        }
        IdentityTool.savePartitionInfo(this.mDevicePath.getDevice(), generatedDevices);
        return generatedDevices;
    }

    public Device exportToTemplatesAndDevices(DeviceTemplate parent, Substrate substrate, String topTemplateName, String topDeviceName, AGeomUtil.AboutPt originPosition) {
        if (originPosition != AGeomUtil.AboutPt.CENTER && originPosition != AGeomUtil.AboutPt.LL) {
            throw new IllegalArgumentException("Origin can only be at center or lower left corner!");
        }
        if (topTemplateName == null) {
            topTemplateName = this.getClass().getName();
        }
        if (topDeviceName == null) {
            topDeviceName = this.getClass().getName();
        }
        List<SRPoly> uniqueDevicePolys = this.getUniquePolys();
        SRPoly topDeviceOutline = null;
        try {
            topDeviceOutline = uniqueDevicePolys.stream().filter(p -> !p.isMinimal(uniqueDevicePolys)).findAny().get();
            uniqueDevicePolys.remove(topDeviceOutline);
        }
        catch (Exception e) {
            ALog.logError((String)"Failed to find boundary from polys:%s", (Object[])new Object[]{uniqueDevicePolys});
        }
        DeviceTemplate topDeviceTemplate = DeviceTemplate.create((Substrate)substrate, (String)topTemplateName, (boolean)true);
        topDeviceTemplate.setType(DeviceTemplate.Type.COVER);
        APair<APoint2D, SRPoly> op = topDeviceOutline.normalize(originPosition);
        APolygon bounds = ((SRPoly)op.second).toAPolygon();
        topDeviceTemplate.setBounds((AGeom)bounds);
        String instName = Device.getUniqueName((DeviceTemplate)parent, (String)topDeviceName);
        Device topDevice = Device.create((String)instName, (DeviceTemplate)topDeviceTemplate, (DeviceTemplate)parent);
        if (originPosition == AGeomUtil.AboutPt.CENTER) {
            topDevice.setLoc(new APoint2D(0L, 0L));
        } else {
            ARect bbox = bounds.getBounds();
            topDevice.setLoc(new APoint2D(-bbox.width() / 2L, -bbox.height() / 2L));
        }
        LinkedList<Device> generatedDevices = new LinkedList<Device>();
        int i = 0;
        for (SRPoly p2 : uniqueDevicePolys) {
            generatedDevices.add(this.createTemplateDevice(topDeviceTemplate, (APoint2D)op.first, p2, originPosition, String.format("d_%d", i++)));
        }
        IdentityTool.savePartitionInfo(topDevice, generatedDevices);
        return topDevice;
    }

    private Device createTemplateDevice(DeviceTemplate parent, AffineTransform relative2TemplateXform, SRPoly outline, AGeomUtil.AboutPt originPosition, String name) {
        DeviceTemplate template = DeviceTemplate.create((Substrate)parent.getSubstrate(), (String)name, (boolean)true);
        template.setType(DeviceTemplate.Type.COVER);
        APair<APoint2D, SRPoly> op = outline.normalize(relative2TemplateXform, originPosition);
        APolygon bounds = ((SRPoly)op.second).toAPolygon();
        template.setBounds((AGeom)bounds);
        String instName = Device.getUniqueName((DeviceTemplate)parent, (String)name);
        Device d = Device.create((String)instName, (DeviceTemplate)template, (DeviceTemplate)parent);
        d.setLoc((APoint2D)op.first);
        return d;
    }

    private Device createTemplateDevice(DeviceTemplate parent, APoint2D parentOrigin, SRPoly outline, AGeomUtil.AboutPt originPosition, String name) {
        DeviceTemplate template = DeviceTemplate.create((Substrate)parent.getSubstrate(), (String)name, (boolean)true);
        template.setType(DeviceTemplate.Type.COVER);
        APair<APoint2D, SRPoly> op = outline.normalize(originPosition);
        APolygon bounds = ((SRPoly)op.second).toAPolygon();
        template.setBounds((AGeom)bounds);
        String instName = Device.getUniqueName((DeviceTemplate)parent, (String)name);
        Device d = Device.create((String)instName, (DeviceTemplate)template, (DeviceTemplate)parent);
        APoint2D origin = ((APoint2D)op.first).sub(parentOrigin);
        d.setLoc(origin);
        return d;
    }

    public static List<Set<DevicePath>> findFilteredChildren(DevicePath topDevicePath, Set<ChildCondition> filters) {
        Set hierarchyChildren = topDevicePath.getChildren().stream().collect(Collectors.toSet());
        List<Set<DevicePath>> partitionChildren = IdentityTool.getPartitionChildrenSet(topDevicePath);
        List<Object> children = new LinkedList<Set<Object>>();
        if (filters.contains((Object)ChildCondition.IS_PARTITION_CHILD)) {
            children.addAll(partitionChildren);
        }
        if (filters.contains((Object)ChildCondition.IS_HIERARCHY_CHILD)) {
            if (children.isEmpty()) {
                children.add(hierarchyChildren);
            } else {
                children.stream().forEach(s -> s.addAll(hierarchyChildren));
            }
        }
        if (filters.contains((Object)ChildCondition.NOT_HIERARCHY_CHILD)) {
            children.stream().forEach(s -> s.removeAll(hierarchyChildren));
        }
        if (filters.contains((Object)ChildCondition.NOT_PARTITION_CHILD)) {
            Set allPartitionChildren = partitionChildren.stream().flatMap(Collection::stream).collect(Collectors.toSet());
            children.stream().forEach(s -> s.removeAll(allPartitionChildren));
        }
        children = children.stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
        return children;
    }

    public static List<APair<PartitionTool, Set<DevicePath>>> importFromTopDevice(DevicePath topDevicePath, Set<ChildCondition> filters, boolean includeTopDeviceBounds) {
        List<Set<DevicePath>> children = PartitionTool.findFilteredChildren(topDevicePath, filters);
        if (children.isEmpty() && includeTopDeviceBounds) {
            APair<PartitionTool, Set<DevicePath>> topDeviceOnly = PartitionTool.importFromTopDeviceWithChildren(topDevicePath, Collections.emptySet(), includeTopDeviceBounds);
            LinkedList<APair<PartitionTool, Set<DevicePath>>> list = new LinkedList<APair<PartitionTool, Set<DevicePath>>>();
            list.add(topDeviceOnly);
            return list;
        }
        return children.stream().map(s -> PartitionTool.importFromTopDeviceWithChildren(topDevicePath, s, includeTopDeviceBounds)).collect(Collectors.toList());
    }

    public Set<DevicePath> getPartitionChildren() {
        return this.mChildDPs;
    }

    private static APair<PartitionTool, Set<DevicePath>> importFromTopDeviceWithChildren(DevicePath topDevicePath, Set<DevicePath> childrenDevicePath, boolean includeTopDeviceBounds) {
        Set<Object> allDPs = includeTopDeviceBounds ? Stream.concat(childrenDevicePath.stream(), Stream.of(topDevicePath)).collect(Collectors.toSet()) : childrenDevicePath.stream().collect(Collectors.toSet());
        Set<DevicePath> devicesWithInvalidParitionBounds = IdentityTool.findDevicesWithInvalidPartitionBounds(allDPs);
        List<ALine> sides = allDPs.stream().flatMap(dp -> PartitionTool.getTransformedSides(dp).stream()).distinct().collect(Collectors.toList());
        PartitionTool pt = PartitionTool.newInstance(sides);
        pt.mDevicePath = topDevicePath;
        pt.mChildDPs = childrenDevicePath;
        return new APair((Object)pt, devicesWithInvalidParitionBounds);
    }

    public static APair<PartitionTool, Set<DevicePath>> importFromTopDevice(DevicePath topDevicePath) {
        return PartitionTool.importFromTopDevice(topDevicePath, EnumSet.of(ChildCondition.IS_HIERARCHY_CHILD, ChildCondition.IS_PARTITION_CHILD), false).get(0);
    }

    public static PartitionTool importFromDevice(DevicePath devicePath) {
        return (PartitionTool)PartitionTool.importFromTopDevice((DevicePath)devicePath, Collections.emptySet(), (boolean)true).get((int)0).first;
    }

    static List<ALine> getSides(DevicePath dp) {
        DeviceTemplate template = dp.getDeviceTemplate();
        AGeom bounds = template.getBounds();
        assert (bounds != null);
        return template.getBounds().toPoly().getLines();
    }

    static List<ALine> getTransformedSides(DevicePath dp) {
        AffineTransform xform = dp.getTransform();
        List<ALine> sides = PartitionTool.getSides(dp).stream().map(l -> l.transform(xform)).collect(Collectors.toList());
        return sides;
    }

    public APair<APoint2D, PartitionTool> normalize(AGeomUtil.AboutPt originPosition) {
        if (originPosition != AGeomUtil.AboutPt.CENTER && originPosition != AGeomUtil.AboutPt.LL) {
            throw new IllegalArgumentException("Origin can only be at center or lower left corner!");
        }
        List allXs = this.mSegments.stream().flatMap(s -> Stream.of(s.getFirstPoint().getX(), s.getLastPoint().getX())).collect(Collectors.toList());
        List allYs = this.mSegments.stream().flatMap(s -> Stream.of(s.getFirstPoint().getY(), s.getLastPoint().getY())).collect(Collectors.toList());
        long xmin = allXs.stream().mapToLong(Long::longValue).min().getAsLong();
        long xmax = allXs.stream().mapToLong(Long::longValue).max().getAsLong();
        long ymin = allYs.stream().mapToLong(Long::longValue).min().getAsLong();
        long ymax = allYs.stream().mapToLong(Long::longValue).max().getAsLong();
        APoint2D origin = new APoint2D();
        if (originPosition == AGeomUtil.AboutPt.CENTER) {
            origin.setX((xmin + xmax) / 2L);
            origin.setY((ymin + ymax) / 2L);
        } else {
            origin.setX(xmin);
            origin.setY(ymin);
        }
        LinkedList<ALine> offsetSegmentLines = new LinkedList<ALine>();
        for (Segment s2 : this.mSegments) {
            offsetSegmentLines.add(new ALine(s2.getFirstPoint().sub(origin), s2.getLastPoint().sub(origin)));
        }
        return new APair((Object)origin, (Object)PartitionTool.newInstance(offsetSegmentLines));
    }

    public List<Segment> cut(ALine cutLine, boolean throughCut) {
        List<ALine> cuts = throughCut ? this.getThroughCutLines(cutLine) : new ArrayList<ALine>(Arrays.asList(cutLine));
        List<Segment> generatedSegments = this.cut(cuts);
        return generatedSegments;
    }

    private boolean isValidCut(ALine cutLine) {
        return (cutLine.isHorizontal() || cutLine.isVertical()) && this.mSegments.stream().noneMatch(s -> s.contains(cutLine));
    }

    public List<Segment> cut(List<ALine> cutLines) {
        if (cutLines == null || cutLines.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.isAnyLinePartOfBoundary(cutLines)) {
            return Collections.emptyList();
        }
        int editHandle = this.mUndoRedoTool.editBegin();
        LinkedList<Segment> newSegments = new LinkedList<Segment>();
        for (ALine cutLine : cutLines) {
            if (!this.isValidCut(cutLine)) continue;
            List<LineAndIntersectedPoint> intersections = this.intersects(cutLine);
            this.splitSegmentsAtIntersections(intersections);
            List<APoint2D> joints = this.getJointsSorted(intersections);
            newSegments.addAll(Segment.segmentsFromAny2NeighboringPoints(joints));
        }
        this.assimilate(newSegments);
        this.trim();
        if (!this.isValid()) {
            ALog.logError((String)"Cut failed! CutLines:%s", (Object[])new Object[]{cutLines});
            ALog.logError((String)"resulting segments:%s", (Object[])new Object[]{this.mSegments});
            ALog.logError((String)"new segments:%s", (Object[])new Object[]{newSegments});
        }
        this.mUndoRedoTool.editEnd(editHandle);
        return newSegments;
    }

    public void delete(Segment segment) {
        if (this.isAnySegmentPartOfBoundary(Arrays.asList(segment))) {
            return;
        }
        int editHandle = this.mUndoRedoTool.editBegin();
        this.mSegments.remove(segment);
        this.trim();
        this.mUndoRedoTool.editEnd(editHandle);
    }

    public void deleteAll(List<Segment> segments) {
        if (this.isAnySegmentPartOfBoundary(segments)) {
            return;
        }
        int editHandle = this.mUndoRedoTool.editBegin();
        this.mSegments.removeAll(segments);
        this.trim();
        this.mUndoRedoTool.editEnd(editHandle);
    }

    void removeFalseJoints() {
        List<APoint2D> joints = this.mSegments.stream().flatMap(s -> Stream.of(s.getFirstPoint(), s.getLastPoint())).distinct().collect(Collectors.toList());
        this.removeFalseJoints(joints);
    }

    private int removeFalseJoints(List<APoint2D> joints) {
        int n;
        int total = 0;
        do {
            n = this.joinSegmentsAtJoints(joints);
            total += n;
        } while (n != 0);
        return total;
    }

    private void testDebugGod(boolean reset) {
        if (reset) {
            GOD.reset();
        }
        GOD.setAutoClose((boolean)false);
        for (Segment l : this.mSegments) {
            GOD.line((long)l.getFirstPoint().getX(), (long)l.getFirstPoint().getY(), (long)l.getLastPoint().getX(), (long)l.getLastPoint().getY(), (boolean)false);
        }
        GOD.flush();
        GOD.setAutoClose((boolean)true);
    }

    public APair<Long, Long> getGreatestValidMoveRange(List<Segment> movingSegments) {
        if (this.isAnySegmentPartOfBoundary(movingSegments)) {
            return null;
        }
        Map<Segment, APair<Long, Long>> moveRange = this.getMoveRange(movingSegments);
        long minSmaller = moveRange.entrySet().stream().map(e -> (Long)((APair)e.getValue()).first).max(Long::compare).orElse(0L);
        long minLarger = moveRange.entrySet().stream().map(e -> (Long)((APair)e.getValue()).second).min(Long::compare).orElse(0L);
        return new APair((Object)minSmaller, (Object)minLarger);
    }

    private boolean isOffsetRangeDataAvailable(List<Segment> movingSegments) {
        if (this.mMoveOffsetRange.size() != movingSegments.size()) {
            return false;
        }
        return movingSegments.stream().allMatch(s -> this.mMoveOffsetRange.containsKey(s));
    }

    public Map<Segment, APair<Long, Long>> getMoveRange(List<Segment> movingSegments) {
        if (this.isAnySegmentPartOfBoundary(movingSegments)) {
            return Collections.emptyMap();
        }
        if (!this.isOffsetRangeDataAvailable(movingSegments)) {
            this.mMoveOffsetRange.clear();
            long xmin = this.mSegments.stream().flatMap(s -> Stream.of(s.getFirstPoint().getX(), s.getLastPoint().getX())).min(Long::compare).orElse(0L);
            long xmax = this.mSegments.stream().flatMap(s -> Stream.of(s.getFirstPoint().getX(), s.getLastPoint().getX())).max(Long::compare).orElse(0L);
            long ymin = this.mSegments.stream().flatMap(s -> Stream.of(s.getFirstPoint().getY(), s.getLastPoint().getY())).min(Long::compare).orElse(0L);
            long ymax = this.mSegments.stream().flatMap(s -> Stream.of(s.getFirstPoint().getY(), s.getLastPoint().getY())).max(Long::compare).orElse(0L);
            this.mMoveOffsetRange = movingSegments.stream().collect(Collectors.toMap(Function.identity(), s -> this.getMoveRange((Segment)s, xmin, xmax, ymin, ymax), (v1, v2) -> v1));
        }
        return this.mMoveOffsetRange;
    }

    private APair<Long, Long> getMoveRange(Segment segment, long xmin, long xmax, long ymin, long ymax) {
        if (segment.isHorizontal()) {
            ARect possibleMoveRange = this.makeARectByExpandVertically(segment, ymin, ymax);
            List intersected = this.mSegments.stream().filter(s -> !segment.equals(s)).map(s -> s.mSide).filter(l -> l.intersects((AGeom)possibleMoveRange)).collect(Collectors.toList());
            long y = segment.getP0().getY();
            long maxSmaller = intersected.stream().filter(l -> this.isBelow((ALine)l, y)).min((l1, l2) -> Long.compare(this.minVerticalDistance((ALine)l1, y), this.minVerticalDistance((ALine)l2, y))).map(l -> this.minVerticalDistance((ALine)l, y)).orElse(0L);
            long maxLarger = intersected.stream().filter(l -> this.isAbove((ALine)l, y)).min((l1, l2) -> Long.compare(this.minVerticalDistance((ALine)l1, y), this.minVerticalDistance((ALine)l2, y))).map(l -> this.minVerticalDistance((ALine)l, y)).orElse(0L);
            return new APair((Object)(-maxSmaller), (Object)maxLarger);
        }
        ARect possibleMoveRange = this.makeARectByExpandHorizontally(segment, xmin, xmax);
        List intersected = this.mSegments.stream().filter(s -> !segment.equals(s)).map(s -> s.mSide).distinct().filter(l -> l.intersects((AGeom)possibleMoveRange)).collect(Collectors.toList());
        long x = segment.getP0().getX();
        long maxSmaller = intersected.stream().filter(l -> this.isLeft((ALine)l, x)).min((l1, l2) -> Long.compare(this.minHorizontalDistance((ALine)l1, x), this.minHorizontalDistance((ALine)l2, x))).map(l -> this.minHorizontalDistance((ALine)l, x)).orElse(0L);
        long maxLarger = intersected.stream().filter(l -> this.isRight((ALine)l, x)).min((l1, l2) -> Long.compare(this.minHorizontalDistance((ALine)l1, x), this.minHorizontalDistance((ALine)l2, x))).map(l -> this.minHorizontalDistance((ALine)l, x)).orElse(0L);
        return new APair((Object)(-maxSmaller), (Object)maxLarger);
    }

    private ARect makeARectByExpandVertically(Segment s, long ymin, long ymax) {
        long p0x = s.mSide.getP0().getX();
        long p1x = s.mSide.getP1().getX();
        return new ARect(Math.min(p0x, p1x) + 1L, ymin, Math.max(p0x, p1x) - 1L, ymax);
    }

    private ARect makeARectByExpandHorizontally(Segment s, long xmin, long xmax) {
        long p0y = s.mSide.getP0().getY();
        long p1y = s.mSide.getP1().getY();
        return new ARect(xmin, Math.min(p0y, p1y) + 1L, xmax, Math.max(p0y, p1y) - 1L);
    }

    private long minVerticalDistance(ALine l, long y) {
        if (l.isHorizontal()) {
            return Math.abs(y - l.getP0().getY());
        }
        long y0 = l.getP0().getY();
        long y1 = l.getP1().getY();
        return Math.min(Math.abs(y - y0), Math.abs(y - y1));
    }

    private long minHorizontalDistance(ALine l, long x) {
        if (l.isVertical()) {
            return Math.abs(x - l.getP0().getX());
        }
        long x0 = l.getP0().getX();
        long x1 = l.getP1().getX();
        return Math.min(Math.abs(x - x0), Math.abs(x - x1));
    }

    private boolean isBelow(ALine l, long y) {
        if (l.isHorizontal() && l.getP0().getY() < y) {
            return true;
        }
        return l.isVertical() && l.getP0().getY() < y && l.getP1().getY() < y;
    }

    private boolean isAbove(ALine l, long y) {
        if (l.isHorizontal() && l.getP0().getY() > y) {
            return true;
        }
        return l.isVertical() && l.getP0().getY() > y && l.getP1().getY() > y;
    }

    private boolean isLeft(ALine l, long x) {
        if (l.isVertical() && l.getP0().getX() < x) {
            return true;
        }
        return l.isHorizontal() && l.getP0().getX() < x && l.getP1().getX() < x;
    }

    private boolean isRight(ALine l, long x) {
        if (l.isVertical() && l.getP0().getX() > x) {
            return true;
        }
        return l.isHorizontal() && l.getP0().getX() > x && l.getP1().getX() > x;
    }

    private boolean isAnySegmentPartOfBoundary(List<Segment> segments) {
        List<ALine> boundary = this.getBoundary();
        return segments.stream().anyMatch(s -> s.isOrientedOverlappedWithAny(boundary));
    }

    private boolean isAnyLinePartOfBoundary(List<ALine> lines) {
        List<Segment> segments = lines.stream().map(Segment::new).collect(Collectors.toList());
        return this.isAnySegmentPartOfBoundary(segments);
    }

    public boolean canMove(List<Segment> movingSegments, long dx, long dy) {
        if (this.isAnySegmentPartOfBoundary(movingSegments)) {
            return false;
        }
        Map<Segment, APair<Long, Long>> moveRange = this.getMoveRange(movingSegments);
        if (moveRange.isEmpty()) {
            return false;
        }
        return movingSegments.stream().allMatch(s -> {
            APair range = (APair)moveRange.get(s);
            if (s.isHorizontal()) {
                return this.withinRange((APair<Long, Long>)range, dy);
            }
            return this.withinRange((APair<Long, Long>)range, dx);
        });
    }

    private boolean withinRange(APair<Long, Long> range, long n) {
        return n >= (Long)range.first && n <= (Long)range.second;
    }

    public boolean move(List<Segment> movingSegments, long dx, long dy, boolean checkMoveable) {
        if (this.isAnySegmentPartOfBoundary(movingSegments)) {
            return false;
        }
        if (dx == 0L && dy == 0L || dx != 0L && dy != 0L) {
            return false;
        }
        if (checkMoveable && !this.canMove(movingSegments, dx, dy)) {
            return false;
        }
        int editHandle = this.mUndoRedoTool.editBegin();
        this.slide(movingSegments, dx, dy);
        this.mUndoRedoTool.editEnd(editHandle);
        return true;
    }

    private void trim() {
        this.removeStrays();
        this.removeFalseJoints();
    }

    List<APoint2D> getJoints(List<Segment> segments) {
        return segments.stream().flatMap(s -> Stream.of(s.getFirstPoint(), s.getLastPoint())).distinct().collect(Collectors.toList());
    }

    private int removeStrays(List<APoint2D> checkPoints) {
        List<Segment> strays = this.getStraySegments(checkPoints);
        int n = strays.size();
        while (!strays.isEmpty()) {
            this.mSegments.removeAll(strays);
            strays = this.getStraySegments(this.getJoints(strays));
        }
        return n;
    }

    void removeStrays() {
        List<Segment> strays = this.getStraySegments();
        while (!strays.isEmpty()) {
            this.mSegments.removeAll(strays);
            strays = this.getStraySegments();
        }
    }

    public List<Segment> getStraySegments(List<APoint2D> checkPoints) {
        return checkPoints.stream().map(pt -> {
            List<Segment> segmentsEndWith = this.endsWith((APoint2D)pt);
            return this.areStrayed(segmentsEndWith, (APoint2D)pt) ? segmentsEndWith : null;
        }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean areStrayed(List<Segment> segments, APoint2D pt) {
        long nHorizontal = segments.stream().filter(Segment::isHorizontal).count();
        if (nHorizontal == (long)segments.size() || nHorizontal == 0L) {
            long nAtSmallerEnd = segments.stream().filter(s -> s.isAtSmallerEnd(pt)).count();
            return nAtSmallerEnd == (long)segments.size() || nAtSmallerEnd == 0L;
        }
        return false;
    }

    public List<Segment> getStraySegments() {
        List<APoint2D> points = this.mSegments.stream().flatMap(s -> Stream.of(s.getFirstPoint(), s.getLastPoint())).distinct().collect(Collectors.toList());
        return this.getStraySegments(points);
    }

    public boolean isValid() {
        Optional<Segment> fault = this.mSegments.stream().filter(this::overlapsByMoreThan1Point).findAny();
        if (fault.isPresent()) {
            ALog.logError((String)"Fault! Overlapped by more than 1 point:%s", (Object[])new Object[]{fault.get()});
            return false;
        }
        return true;
    }

    boolean overlapsByMoreThan1Point(Segment segment) {
        return this.mSegments.stream().anyMatch(s -> !s.equals(segment) && s.overlapsByMoreThan1Point(segment));
    }

    List<Segment> overlapsOfSameOrientation(Segment segment) {
        return this.mSegments.stream().filter(segment::overlapsAndSameOrientation).collect(Collectors.toList());
    }

    List<Segment> overlapsAndSameOrientation(List<Segment> fromSet, Segment segment) {
        return fromSet.stream().filter(segment::overlapsAndSameOrientation).collect(Collectors.toList());
    }

    private void slide(List<Segment> movingSegments, long dx, long dy) {
        int nStrays;
        int nFalseJoints;
        List<Segment> segmentsAdded = movingSegments.stream().flatMap(s -> {
            APoint2D b0 = s.getFirstPoint();
            APoint2D e0 = s.getLastPoint();
            APoint2D b1 = new APoint2D(b0.getX() + dx, b0.getY() + dy);
            APoint2D e1 = new APoint2D(e0.getX() + dx, e0.getY() + dy);
            return Stream.of(new Segment(b0, b1), new Segment(b1, e1), new Segment(e1, e0));
        }).distinct().collect(Collectors.toList());
        this.mSegments.removeAll(movingSegments);
        List<APoint2D> points = this.assimilate(segmentsAdded).stream().collect(Collectors.toList());
        do {
            nFalseJoints = this.removeFalseJoints(points);
            nStrays = this.removeStrays(points);
        } while (nFalseJoints != 0 || nStrays != 0);
    }

    private APair<Long, Long> getMinMax(List<Segment> segs) {
        long max;
        long min;
        if (segs == null || segs.isEmpty()) {
            return null;
        }
        if (segs.get(0).isHorizontal()) {
            min = segs.stream().mapToLong(s -> Math.min(s.getFirstPoint().getX(), s.getLastPoint().getX())).min().getAsLong();
            max = segs.stream().mapToLong(s -> Math.max(s.getFirstPoint().getX(), s.getLastPoint().getX())).max().getAsLong();
        } else {
            min = segs.stream().mapToLong(s -> Math.min(s.getFirstPoint().getY(), s.getLastPoint().getY())).min().getAsLong();
            max = segs.stream().mapToLong(s -> Math.max(s.getFirstPoint().getY(), s.getLastPoint().getY())).max().getAsLong();
        }
        return new APair((Object)min, (Object)max);
    }

    private Set<APoint2D> assimilate(List<Segment> segments) {
        this.mSegments.addAll(segments);
        List overlapGroups = segments.stream().map(s -> {
            List<Segment> overlaps = this.overlapsOfSameOrientation((Segment)s);
            APair<Long, Long> minMax = this.getMinMax(overlaps);
            return new SegmentGroup(overlaps, minMax);
        }).collect(Collectors.toList());
        Map<Long, List> overlapsByY = overlapGroups.stream().filter(SegmentGroup::isHorizontal).collect(Collectors.toMap(g -> g.getY(), g -> new ArrayList<SegmentGroup>(Arrays.asList(g)), (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
        Map<Long, List> overlapsByX = overlapGroups.stream().filter(g -> !g.isHorizontal()).collect(Collectors.toMap(g -> g.getX(), g -> new ArrayList<SegmentGroup>(Arrays.asList(g)), (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
        List merged = overlapsByY.entrySet().stream().flatMap(e -> {
            List<SegmentGroup> sortedList = ((List)e.getValue()).stream().sorted(SegmentGroup::compare).collect(Collectors.toList());
            return SegmentGroup.merge(sortedList).stream();
        }).collect(Collectors.toList());
        List mergedByX = overlapsByX.entrySet().stream().flatMap(e -> {
            List<SegmentGroup> sortedList = ((List)e.getValue()).stream().sorted(SegmentGroup::compare).collect(Collectors.toList());
            return SegmentGroup.merge(sortedList).stream();
        }).collect(Collectors.toList());
        merged.addAll(mergedByX);
        List overlapsList = merged.stream().map(sg -> sg.getSegments()).collect(Collectors.toList());
        Map<List, List> overlapsReplacement = overlapsList.stream().collect(Collectors.toMap(overlaps -> overlaps, overlaps -> {
            List<Segment> newSegments = Segment.newSegmentsFromSortedJoints(overlaps);
            if (PartitionTool.listEqualsIgnoreOrder(overlaps, newSegments)) {
                return Collections.emptyList();
            }
            return newSegments;
        }));
        List toRemove = overlapsReplacement.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).flatMap(e -> ((List)e.getKey()).stream()).distinct().collect(Collectors.toList());
        List toAdd = overlapsReplacement.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).distinct().collect(Collectors.toList());
        this.mSegments.removeAll(toRemove);
        this.mSegments.addAll(toAdd);
        Set<APoint2D> pointsAffected = overlapsReplacement.entrySet().stream().flatMap(e -> Stream.concat(((List)e.getKey()).stream(), ((List)e.getValue()).stream())).flatMap(s -> Stream.of(s.getFirstPoint(), s.getLastPoint())).distinct().collect(Collectors.toSet());
        return pointsAffected;
    }

    public static <T> boolean listEqualsIgnoreOrder(List<T> list1, List<T> list2) {
        return new HashSet<T>(list1).equals(new HashSet<T>(list2));
    }

    int joinSegmentsAtJoints(List<APoint2D> joints) {
        int joins = this.mSegments.size();
        for (APoint2D j : joints) {
            Segment s1;
            Segment s0;
            Segment join;
            List<Segment> sidesEndWith = this.endsWith(j);
            if (sidesEndWith.size() != 2 || (join = (s0 = sidesEndWith.get(0)).join(s1 = sidesEndWith.get(1))) == null) continue;
            this.mSegments.remove(s0);
            this.mSegments.remove(s1);
            this.mSegments.add(join);
        }
        return joins - this.mSegments.size();
    }

    List<APoint2D> getJointsSorted(List<LineAndIntersectedPoint> intersections) {
        return intersections.stream().map(LineAndIntersectedPoint::getPoint).distinct().sorted((p1, p2) -> p1.getX() == p2.getX() ? Long.compare(p1.getY(), p2.getY()) : Long.compare(p1.getX(), p2.getX())).collect(Collectors.toList());
    }

    void splitSegmentsAtIntersections(List<LineAndIntersectedPoint> intersections) {
        List splits = intersections.stream().flatMap(lip -> {
            ALine l = lip.getLine();
            APoint2D p = lip.getPoint();
            return Stream.of(new Segment(l.getFirstPoint(), p), new Segment(p, l.getLastPoint()));
        }).filter(l -> !l.getFirstPoint().equals((Object)l.getLastPoint())).distinct().collect(Collectors.toList());
        List segments = intersections.stream().map(lip -> new Segment(lip.getLine())).collect(Collectors.toList());
        this.mSegments.removeAll(segments);
        this.mSegments.addAll(splits);
    }

    List<Segment> endsWith(APoint2D p) {
        return this.mSegments.stream().filter(s -> s.endsWith(p)).collect(Collectors.toList());
    }

    APair<List<Segment>, List<Segment>> diff(PartitionTool other) {
        List onlyInSelf = this.mSegments.stream().filter(s -> !other.mSegments.contains(s)).collect(Collectors.toList());
        List onlyInOther = other.mSegments.stream().filter(s -> !this.mSegments.contains(s)).collect(Collectors.toList());
        return new APair(onlyInSelf, onlyInOther);
    }

    List<LineAndIntersectedPoint> intersects(ALine cutLine) {
        return cutLine.isHorizontal() ? this.intersectsOnVerticalSegments(cutLine) : this.intersectsOnHorizontalSegments(cutLine);
    }

    List<LineAndIntersectedPoint> intersectsOnVerticalSegments(ALine horizontalCut) {
        List verticalSegments = this.mSegments.stream().filter(Segment::isVertical).collect(Collectors.toList());
        long y = horizontalCut.getFirstPoint().getY();
        List<LineAndIntersectedPoint> intersections = verticalSegments.stream().filter(s -> s.mSide.yInOrOn(y)).filter(s -> horizontalCut.xInOrOn(s.getFirstPoint().getX())).map(s -> s.mSide).map(s -> new LineAndIntersectedPoint((ALine)s, new APoint2D(s.getFirstPoint().getX(), y))).collect(Collectors.toList());
        return intersections;
    }

    List<LineAndIntersectedPoint> intersectsOnHorizontalSegments(ALine verticalCut) {
        List horizontalSegments = this.mSegments.stream().filter(Segment::isHorizontal).collect(Collectors.toList());
        long x = verticalCut.getFirstPoint().getX();
        List<LineAndIntersectedPoint> intersections = horizontalSegments.stream().filter(s -> s.mSide.xInOrOn(x)).filter(s -> verticalCut.yInOrOn(s.getFirstPoint().getY())).map(s -> s.mSide).map(s -> new LineAndIntersectedPoint((ALine)s, new APoint2D(x, s.getFirstPoint().getY()))).collect(Collectors.toList());
        return intersections;
    }

    private List<ALine> getExtendSidesInClockwiseOrder(ALine side) {
        Segment segment = new Segment(side);
        return this.mSegments.stream().filter(s -> !s.equals(segment)).flatMap(Segment::getSides).filter(s -> this.canExtendTo(side, (ALine)s)).sorted((s1, s2) -> this.largerWhenCloser((ALine)s1, (ALine)s2, side)).collect(Collectors.toList());
    }

    private int largerWhenCloser(ALine s1, ALine s2, ALine side) {
        return (int)(side.cross(s2) - side.cross(s1));
    }

    private boolean canExtendTo(ALine side, ALine branch) {
        return side.getLastPoint().equals((Object)branch.getFirstPoint());
    }

    public List<SRPoly> getPolys() {
        List allSides = this.mSegments.stream().flatMap(Segment::getSides).collect(Collectors.toList());
        HashSet<ALine> traversedSides = new HashSet<ALine>();
        LinkedList<SRPoly> polys = new LinkedList<SRPoly>();
        for (ALine side : allSides) {
            if (traversedSides.contains(side)) continue;
            SRPoly p = this.getPolyByTraversingRightHanded(side, traversedSides);
            polys.add(p);
        }
        return polys;
    }

    public List<SRPoly> getUniquePolys() {
        List<SRPoly> polys = this.getPolys();
        List ccwPolys = polys.stream().filter(p -> !p.isClockwise()).collect(Collectors.toList());
        List<SRPoly> uniquePolys = new ArrayList<SRPoly>(polys);
        uniquePolys.removeAll(ccwPolys);
        uniquePolys = uniquePolys.stream().filter(p -> !p.containReverse(ccwPolys)).collect(Collectors.toList());
        uniquePolys.addAll(ccwPolys);
        return uniquePolys;
    }

    private void debugPartitionInformation() {
        List<Segment> strays = this.getStraySegments();
        ALog.logInfo((String)"Strayed:%s", (Object[])new Object[]{strays});
    }

    SRPoly getPolyByTraversingRightHanded(ALine side, Set<ALine> traversedSides) {
        APoint2D start = side.getFirstPoint();
        SRPoly p = SRPoly.newInstance(side);
        do {
            List<ALine> extendSides;
            if ((extendSides = this.getExtendSidesInClockwiseOrder(side)).isEmpty()) {
                throw new IllegalArgumentException("A side should have at least one connected side!");
            }
            side = extendSides.get(0);
            if (traversedSides.contains(side)) {
                this.debugPartitionInformation();
                ALog.logError((String)"Partition has these segments:%s", (Object[])new Object[]{this.mSegments});
                throw new IllegalArgumentException("A side should only be traversed once!");
            }
            p.addSide(side);
            traversedSides.add(side);
        } while (!side.getLastPoint().equals((Object)start));
        return p;
    }

    static boolean isTwin(ALine l0, ALine l1) {
        return l0.getFirstPoint().equals((Object)l1.getLastPoint()) && l0.getLastPoint().equals((Object)l1.getFirstPoint());
    }

    private void resetStateWithSegments(Set<Segment> segments) {
        this.mSegments = segments;
        this.mMoveOffsetRange.clear();
    }

    public void setUndoRedoStatusListener(BiConsumer<Boolean, Boolean> listener) {
        this.mUndoRedoStatusListener = listener;
    }

    public boolean canUndo() {
        return this.mUndoManager.canUndo();
    }

    public boolean canRedo() {
        return this.mUndoManager.canRedo();
    }

    public void undo() {
        this.mActionUndo.actionPerformed(new ActionEvent(this, 1001, null));
    }

    public void redo() {
        this.mActionRedo.actionPerformed(new ActionEvent(this, 1001, null));
    }

    private void refreshUndoRedo() {
        if (this.mUndoRedoStatusListener != null) {
            this.mUndoRedoStatusListener.accept(this.mUndoManager.canUndo(), this.mUndoManager.canRedo());
        }
    }

    private void editActionPerformed(Set<Segment> segmentsBeforeEdit, Set<Segment> segmentsAfterEdit) {
        Edit edit = new Edit(segmentsBeforeEdit, segmentsAfterEdit);
        this.mUndoSupport.postEdit(edit);
    }

    public static boolean test1(DevicePath topDevice) {
        List<APair<PartitionTool, Set<DevicePath>>> pts = PartitionTool.importFromTopDevice(topDevice, EnumSet.of(ChildCondition.IS_HIERARCHY_CHILD), true);
        if (pts.size() != 1) {
            ALog.logError((String)"Should have only 1 PT! We get %d pt", (Object[])new Object[]{pts.size()});
            return false;
        }
        APair<PartitionTool, Set<DevicePath>> ptdp = pts.get(0);
        PartitionTool pt = (PartitionTool)ptdp.first;
        if (!((Set)ptdp.second).isEmpty()) {
            ALog.logError((String)"Should have no invalid bounds! We get %d devices having invalid bounds", (Object[])new Object[]{((Set)ptdp.second).size()});
            return false;
        }
        if (pt.getPartitionChildren().size() != 4) {
            ALog.logError((String)"Should have 4 partition children! We get %d!", (Object[])new Object[]{pt.getPartitionChildren().size()});
            return false;
        }
        return true;
    }

    public static boolean test2(DevicePath topDevice) {
        List<APair<PartitionTool, Set<DevicePath>>> pts = PartitionTool.importFromTopDevice(topDevice, EnumSet.of(ChildCondition.IS_PARTITION_CHILD), true);
        if (pts.size() != 1) {
            ALog.logError((String)"Should have only 1 PT! We get %d pt", (Object[])new Object[]{pts.size()});
            return false;
        }
        APair<PartitionTool, Set<DevicePath>> ptdp = pts.get(0);
        PartitionTool pt = (PartitionTool)ptdp.first;
        if (!((Set)ptdp.second).isEmpty()) {
            ALog.logError((String)"Should have no invalid bounds! We get %d devices having invalid bounds", (Object[])new Object[]{((Set)ptdp.second).size()});
            return false;
        }
        if (pt.getPartitionChildren().size() != 4) {
            ALog.logError((String)"Should have 4 partition children! We get %d!", (Object[])new Object[]{pt.getPartitionChildren().size()});
            return false;
        }
        return true;
    }

    public static boolean test3(DevicePath topDevice) {
        List<APair<PartitionTool, Set<DevicePath>>> pts = PartitionTool.importFromTopDevice(topDevice, EnumSet.of(ChildCondition.IS_PARTITION_CHILD), true);
        if (pts.size() != 2) {
            ALog.logError((String)"Should have 2 PT! We get %d pt", (Object[])new Object[]{pts.size()});
            return false;
        }
        boolean foundPTWith4Childs = false;
        boolean foundPTWith2Childs = false;
        for (APair<PartitionTool, Set<DevicePath>> ptdp : pts) {
            PartitionTool pt = (PartitionTool)ptdp.first;
            if (pt.getPartitionChildren().size() == 4) {
                foundPTWith4Childs = true;
            }
            if (pt.getPartitionChildren().size() == 2) {
                foundPTWith2Childs = true;
            }
            if (((Set)ptdp.second).isEmpty()) continue;
            ALog.logError((String)"Should have no invalid bounds! Partition %s has %d devices having invalid bounds", (Object[])new Object[]{ptdp.first, ((Set)ptdp.second).size()});
            return false;
        }
        if (!foundPTWith4Childs) {
            ALog.logError((String)"Failed to find a partition with 4 children devices!");
            return false;
        }
        if (!foundPTWith2Childs) {
            ALog.logError((String)"Failed to find a partition with 2 children devices!");
            return false;
        }
        return true;
    }

    public static boolean test4(DevicePath topDevice) {
        List<APair<PartitionTool, Set<DevicePath>>> pts = PartitionTool.importFromTopDevice(topDevice, EnumSet.of(ChildCondition.IS_PARTITION_CHILD), true);
        if (pts.size() != 2) {
            ALog.logError((String)"Should have 2 PT! We get %d pt", (Object[])new Object[]{pts.size()});
            return false;
        }
        boolean foundPTWith4Childs = false;
        boolean foundPTWith2Childs = false;
        for (APair<PartitionTool, Set<DevicePath>> ptdp : pts) {
            PartitionTool pt = (PartitionTool)ptdp.first;
            if (pt.getPartitionChildren().size() == 4) {
                foundPTWith4Childs = true;
            }
            if (pt.getPartitionChildren().size() == 2) {
                foundPTWith2Childs = true;
            }
            if (pt.getPartitionChildren().size() == 2) {
                if (((Set)ptdp.second).size() == 1) continue;
                ALog.logError((String)"Should have only 1 invalid child! Partition %s has %d devices having invalid bounds", (Object[])new Object[]{ptdp.first, ((Set)ptdp.second).size()});
                return false;
            }
            if (((Set)ptdp.second).isEmpty()) continue;
            ALog.logError((String)"Wrong number of invalid bounds! Partition %s has %d devices having invalid bounds", (Object[])new Object[]{ptdp.first, ((Set)ptdp.second).size()});
            return false;
        }
        if (!foundPTWith4Childs) {
            ALog.logError((String)"Failed to find a partition with 4 children devices!");
            return false;
        }
        if (!foundPTWith2Childs) {
            ALog.logError((String)"Failed to find a partition with 2 children devices!");
            return false;
        }
        return true;
    }

    public static class IdentityTool {
        public static final String kPartitionParent = "PTParent";
        public static final String kPartitionChild = "PTChild";
        public static final String kPartitionBounds = "PTBounds";

        public static void savePartitionInfo(Device parentDevice, List<Device> childDevices) {
            UUID partitionID = IdentityTool.getUniqueID();
            IdentityTool.savePartitionParentInfo(parentDevice, partitionID);
            IdentityTool.saveParitiontChildInfo(childDevices, partitionID);
        }

        private static void saveParitiontChildInfo(List<Device> childDevices, UUID partitionID) {
            childDevices.stream().forEach(d -> {
                DeviceTemplate cdt = d.getTemplate();
                cdt.setValue(kPartitionBounds, (Object)cdt.getBounds());
                cdt.setValue(kPartitionChild, (Object)partitionID);
            });
        }

        private static void savePartitionParentInfo(Device parentDevice, UUID partitionID) {
            DeviceTemplate parentDT = parentDevice.getTemplate();
            Set<UUID> ids = IdentityTool.getPartitionParentID(parentDevice);
            ids.add(partitionID);
            parentDT.setValue(kPartitionParent, ids);
        }

        private static UUID getUniqueID() {
            return UUID.randomUUID();
        }

        private static Set<UUID> getPartitionParentID(Device d) {
            Set ids = (Set)d.getTemplate().getValue(kPartitionParent, Collection.class);
            if (ids == null) {
                return new HashSet<UUID>();
            }
            return ids;
        }

        private static UUID findPartitionChildID(DeviceTemplate dt, Set<UUID> partitionIDs) {
            UUID id = (UUID)dt.getValue(kPartitionChild, UUID.class);
            if (id == null) {
                return null;
            }
            return partitionIDs.contains(id) ? id : null;
        }

        private static Map<UUID, List<DeviceTemplate>> getPartitionChildTemplates(Device parent) {
            Set<UUID> idSet = IdentityTool.getPartitionParentID(parent);
            Db db = parent.getDb();
            if (db == null) {
                return Collections.emptyMap();
            }
            IterableIterator instances = db.getObjects(DeviceTemplate.class);
            if (instances == null) {
                return Collections.emptyMap();
            }
            Map<UUID, List<DeviceTemplate>> childDTs = instances.stream().filter(dt -> IdentityTool.findPartitionChildID(dt, idSet) != null).collect(Collectors.groupingBy(dt -> (UUID)dt.getValue(kPartitionChild)));
            return childDTs;
        }

        public static List<Set<DevicePath>> getPartitionChildrenSet(DevicePath topDevicePath) {
            Device parent = topDevicePath.getDevice();
            Map<UUID, List<DeviceTemplate>> childTs = IdentityTool.getPartitionChildTemplates(parent);
            return childTs.entrySet().stream().map(entry -> IdentityTool.getHierarchicalIntances((List)entry.getValue())).collect(Collectors.toList());
        }

        private static Set<DevicePath> getHierarchicalIntances(List<DeviceTemplate> dts) {
            return dts.stream().flatMap(dt -> dt.getHierarchicalInstances().stream()).collect(Collectors.toSet());
        }

        private static boolean isValidPartitionBounds(DeviceTemplate template) {
            AGeom bounds = (AGeom)template.getValue(kPartitionBounds);
            return bounds == null ? true : bounds.equals((Object)template.getBounds());
        }

        private static Set<DevicePath> findDevicesWithInvalidPartitionBounds(Set<DevicePath> dps) {
            return dps.stream().filter(dp -> !IdentityTool.isValidPartitionBounds(dp.getDeviceTemplate())).collect(Collectors.toSet());
        }
    }

    private class RedoAction
    extends AbstractAction {
        private RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PartitionTool.this.mUndoManager.redo();
            PartitionTool.this.refreshUndoRedo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        private UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PartitionTool.this.mUndoManager.undo();
            PartitionTool.this.refreshUndoRedo();
        }
    }

    private class Edit
    extends AbstractUndoableEdit {
        private Set<Segment> mSegmentsUndo;
        private Set<Segment> mSegmentsRedo;

        public Edit(Set<Segment> segmentsBeforeEdit, Set<Segment> segmentsAfterEdit) {
            this.mSegmentsUndo = new HashSet<Segment>(segmentsBeforeEdit);
            this.mSegmentsRedo = new HashSet<Segment>(segmentsAfterEdit);
        }

        @Override
        public void undo() throws CannotUndoException {
            PartitionTool.this.resetStateWithSegments(this.mSegmentsUndo);
        }

        @Override
        public void redo() throws CannotRedoException {
            PartitionTool.this.resetStateWithSegments(this.mSegmentsRedo);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            UndoableEdit edit = e.getEdit();
            PartitionTool.this.mUndoManager.addEdit(edit);
            PartitionTool.this.refreshUndoRedo();
        }
    }

    private class UndoRedoTool {
        final int kInvalidEditHandle = -1;
        final int kValidEditHandle = 1;
        int mEditHandle = -1;
        Set<Segment> mSegmentsBeforeEdit;

        private UndoRedoTool() {
        }

        private boolean isOpenEdit() {
            return this.mEditHandle == 1;
        }

        private void setEditOpen() {
            this.mEditHandle = 1;
        }

        private void setEditClose() {
            this.mEditHandle = -1;
        }

        int editBegin() {
            if (this.isOpenEdit()) {
                return -1;
            }
            this.setEditOpen();
            this.mSegmentsBeforeEdit = new HashSet<Segment>(PartitionTool.this.getSegments());
            return 1;
        }

        void editEnd(int editHandle) {
            if (editHandle != 1) {
                return;
            }
            assert (this.isOpenEdit());
            PartitionTool.this.editActionPerformed(this.mSegmentsBeforeEdit, PartitionTool.this.getSegments());
            this.setEditClose();
        }
    }

    public static enum ChildCondition {
        IS_HIERARCHY_CHILD,
        NOT_HIERARCHY_CHILD,
        IS_PARTITION_CHILD,
        NOT_PARTITION_CHILD;

    }
}

