/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.partitionTool.PTMODCursor;
import com.sigrity.orbit.ui.partitionTool.PTMODCutLine;
import com.sigrity.orbit.ui.partitionTool.PTMODFocus;
import com.sigrity.orbit.ui.partitionTool.PTMODMovingSegments;
import com.sigrity.orbit.ui.partitionTool.PTMODPartition;
import com.sigrity.orbit.ui.partitionTool.PTMODRuler;
import com.sigrity.orbit.ui.partitionTool.PTMODSelection;
import com.sigrity.orbit.ui.partitionTool.PartitionTool;
import com.sigrity.orbit.ui.partitionTool.PartitionToolModeOverlayDrawer;
import com.sigrity.orbit.ui.partitionTool.PartitionToolModeUI;
import com.sigrity.orbit.ui.partitionTool.Segment;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class PartitionToolMode
extends AbstractViewMode {
    static final int kDefaultCutLineAngleIndex = 0;
    static final int kDefaultCutLineAngle = 90;
    private StateMachine mStateMachine;
    private DevicePath mDevicePath;
    private DesignView2D.ViewMode mOldMode = null;
    private PartitionToolModeUI mUI;
    final KeyEventDispatcher mDispatcher = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                if (e.getID() == 401) {
                    PartitionToolMode.this.mStateMachine.onControlPressed();
                } else if (e.getID() == 402) {
                    PartitionToolMode.this.mStateMachine.onControlReleased();
                }
            }
            return false;
        }
    };
    private CancelAction mCancelAction = new CancelAction(this);
    private CommitAction mCommitAction = new CommitAction(this);
    private DeleteAction mDeleteAction = new DeleteAction(this);
    private ToggleAction mToggleAction = new ToggleAction(this);
    private DelAllAction mDelAllAction = new DelAllAction(this);
    private JMenuItem mMICancel = new JMenuItem(this.mCancelAction);
    private JMenuItem mMICommit = new JMenuItem(this.mCommitAction);
    private JMenuItem mMIDelete = new JMenuItem(this.mDeleteAction);
    private JMenuItem mMIToggle = new JMenuItem(this.mToggleAction);
    private JMenuItem mMIDelAll = new JMenuItem(this.mDelAllAction);
    private JMenuItem[] mMenuDrawState = new JMenuItem[]{this.mMICommit, this.mMIToggle};
    private JMenuItem[] mMenuDeleteState = new JMenuItem[]{this.mMIDelAll};
    private JMenuItem[] mMenuSlideState = new JMenuItem[]{this.mMICommit, this.mMICancel};
    private JMenuItem[] mMenuSlideMultiSelState = new JMenuItem[]{this.mMICancel};
    private JMenuItem[] mMenuSlidingState = new JMenuItem[]{this.mMICommit, this.mMICancel};
    private static PartitionTool mCurrentPartition;
    protected int mNearDistScreen = 24;
    protected JCheckBox mSnapDevice = new JCheckBox("Device", true);
    protected JCheckBox mSnapPin = new JCheckBox("Pin", true);
    protected JCheckBox mSnapPartition = new JCheckBox("Partition", true);
    protected JCheckBox[] mSnapObjTypes = new JCheckBox[]{this.mSnapDevice, this.mSnapPin, this.mSnapPartition};
    protected JCheckBox mSnapCenter = new JCheckBox("Center", true);
    protected JCheckBox mSnapEdge = new JCheckBox("Edge", true);
    protected JCheckBox[] mSnapLocTypes = new JCheckBox[]{this.mSnapCenter, this.mSnapEdge};
    private PartitionTool mPartition;
    private static List<Set<DevicePath>> mChildrenToRemove;

    public static PartitionToolMode newInstance(DevicePath dp) {
        PartitionToolMode ptm = new PartitionToolMode(dp);
        return ptm;
    }

    private PartitionToolMode(DevicePath dp) {
        this.mDevicePath = dp;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Cursor getCursor() {
        return UIUtil.createCursor((Icon)OrbitIcons.PARTITION_TOOL);
    }

    @Override
    public void installMode(DesignView2D view) {
        this.mOldMode = view.getPriorMode();
        super.installMode(view);
    }

    public PartitionToolModeUI getUI() {
        return this.mUI;
    }

    @Override
    protected void installedMode() {
        if (this.mUI != null) {
            this.mUI.reset();
        }
        Runnable callbackOnModeChange = () -> {
            if (this.mStateMachine != null && this.mUI != null) {
                this.mStateMachine.onModeChange(this.mUI.getMode());
            }
        };
        Runnable callbackOnClosingWindow = () -> {
            if (this.mView != null) {
                this.mView.setMode(this.mOldMode);
            }
        };
        this.mUI = PartitionToolModeUI.newInstance(this.mView, "Measure", this, this.mSnapObjTypes, this.mSnapLocTypes, callbackOnModeChange, callbackOnClosingWindow);
        this.resetPartition();
        this.mStateMachine = StateMachine.newInstance(this, this.mPartition);
        this.mUI.setStateMachine(this.mStateMachine);
        this.informUser("<html>Welcome to Partition Tool Mode!<br/>T to toggle.<br/>ESC to cancel move.", new Object[0]);
        this.setupUserKeyInputHandlers();
    }

    private void uninstallMe() {
        if (this.mStateMachine != null) {
            this.mStateMachine.onStop();
            this.mStateMachine = null;
        }
        if (this.mUI != null) {
            this.mUI.reset();
            this.mUI = null;
        }
        this.removeUserKeyInputHandlers();
        super.uninstallMode();
    }

    private void setupUserKeyInputHandlers() {
        if (this.mView == null) {
            return;
        }
        this.mView.getCanvas().getActionMap().put("Partition Tool Mode Action Cancel", this.mCancelAction);
        this.mView.getCanvas().bindKey("Partition Tool Mode Action Cancel");
        this.mView.getCanvas().getActionMap().put("Partition Tool Mode Action Commit", this.mCommitAction);
        this.mView.getCanvas().bindKey("Partition Tool Mode Action Commit");
        this.mView.getCanvas().getActionMap().put("Partition Tool Mode Action Delete Segment", this.mDeleteAction);
        this.mView.getCanvas().bindKey("Partition Tool Mode Action Delete Segment");
        this.mView.getCanvas().getActionMap().put("Partition Tool Mode Action Toggle Angle", this.mToggleAction);
        this.mView.getCanvas().bindKey("Partition Tool Mode Action Toggle Angle");
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.mDispatcher);
    }

    private void removeUserKeyInputHandlers() {
        if (this.mView == null) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.mDispatcher);
        this.mView.getCanvas().unbindKey(OrbitHotkey.getKeyStrokeStr("Partition Tool Mode Action Cancel"));
        this.mView.getCanvas().getActionMap().remove("Partition Tool Mode Action Cancel");
        this.mView.getCanvas().unbindKey(OrbitHotkey.getKeyStrokeStr("Partition Tool Mode Action Commit"));
        this.mView.getCanvas().getActionMap().remove("Partition Tool Mode Action Commit");
        this.mView.getCanvas().unbindKey(OrbitHotkey.getKeyStrokeStr("Partition Tool Mode Action Delete Segment"));
        this.mView.getCanvas().getActionMap().remove("Partition Tool Mode Action Delete Segment");
        this.mView.getCanvas().unbindKey(OrbitHotkey.getKeyStrokeStr("Partition Tool Mode Action Toggle Angle"));
        this.mView.getCanvas().getActionMap().remove("Partition Tool Mode Action Toggle Angle");
    }

    private void actionCancel() {
        this.mStateMachine.onCancel();
    }

    private void actionCommit() {
        this.mStateMachine.onSpace();
    }

    private void actionDelete() {
        this.mStateMachine.onDelete();
    }

    private void actionToggle() {
        this.mStateMachine.onT();
    }

    private void actionDelAll() {
        this.mStateMachine.onDelAll();
    }

    @Override
    public void uninstallMode() {
        this.uninstallMe();
    }

    @Override
    public void mousePressed(DesignView2D.MouseAction e) {
        super.mousePressed(e);
        this.mStateMachine.onPressed(e);
        this.repaintOverlay();
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        this.mStateMachine.onMoved(e);
        this.repaintOverlay();
    }

    @Override
    public void mouseDragged(DesignView2D.MouseAction e) {
        super.mouseDragged(e);
        this.mStateMachine.onDragged(e);
        this.repaintOverlay();
    }

    @Override
    public void mouseReleased(DesignView2D.MouseAction e) {
        super.mouseReleased(e);
        this.mStateMachine.onReleased(e);
        this.repaintOverlay();
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        this.mStateMachine.onClicked(e);
        this.repaintOverlay();
    }

    @Override
    protected void loadContextMenu(AbstractViewMode.ContextMenu menu, Point loc) {
        menu.setDelayUpdatedEnabled(false);
    }

    @Override
    protected boolean showContextMenu(JPopupMenu menu, Point loc) {
        JMenuItem[] ptmContextMenu;
        switch (this.mStateMachine.getState()) {
            case draw: {
                ptmContextMenu = this.mMenuDrawState;
                break;
            }
            case delete: {
                ptmContextMenu = this.mMenuDeleteState;
                break;
            }
            case slide: {
                ptmContextMenu = this.mMenuSlideState;
                break;
            }
            case sliding: {
                ptmContextMenu = this.mMenuSlidingState;
                break;
            }
            case slideMultiSel: {
                ptmContextMenu = this.mMenuSlideMultiSelState;
                break;
            }
            default: {
                ptmContextMenu = null;
                ALog.logError((String)"No swtich-case for state:%s", (Object[])new Object[]{this.mStateMachine.getState()});
            }
        }
        if (ptmContextMenu != null) {
            for (JMenuItem mi : ptmContextMenu) {
                menu.add(mi);
            }
        }
        return super.showContextMenu(menu, loc);
    }

    @Override
    protected void paintOverlay(Graphics2D g, Rectangle bounds) {
        super.paintOverlay(g, bounds);
        RenderingHints oldRenderingHints = g.getRenderingHints();
        Stroke oldStroke = g.getStroke();
        Color oldColor = g.getColor();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.mStateMachine.paintOverlay(g, bounds);
        g.setRenderingHints(oldRenderingHints);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    public APoint2D getWorldPt(Point screenPt) {
        return this.mView.getCanvas().getWorldPt(screenPt);
    }

    public void exportPartition() {
        AGeomUtil.AboutPt originPosition = AGeomUtil.AboutPt.LL;
        PartitionToolMode.setCurrentPartition(this.mPartition);
        Cp.exec((String)"unset(\"_pt\")", (Object[])new Object[0]);
        Cp.exec((String)"_pt = com.sigrity.orbit.ui.partitionTool.PartitionToolMode.getCurrentPartition()", (Object[])new Object[0]);
        Cp.exec((String)"_pt.exportToTemplatesAndDevices(com.sigrity.acl.geom.AGeomUtil.AboutPt.%s)", (Object[])new Object[]{originPosition.toString()});
        Cp.exec((String)"unset(\"_pt\")", (Object[])new Object[0]);
    }

    public static void setCurrentPartition(PartitionTool partition) {
        mCurrentPartition = partition;
    }

    public static PartitionTool getCurrentPartition() {
        return mCurrentPartition;
    }

    public boolean getSnapAnyDeviceTypes() {
        for (JCheckBox cb : this.mSnapObjTypes) {
            if (!cb.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean getSnapAnyLocTypes() {
        for (JCheckBox cb : this.mSnapLocTypes) {
            if (!cb.isSelected()) continue;
            return true;
        }
        return false;
    }

    public PartitionTool getPartition() {
        return this.mPartition;
    }

    public void resetPartition() {
        this.mPartition = PartitionTool.importFromDevice(this.mDevicePath);
        this.mPartition.setUndoRedoStatusListener((canUndo, canRedo) -> this.getUI().updateUndoRedoStatus((boolean)canUndo, (boolean)canRedo));
        SnapObject.setPartitionTool(this.mPartition);
    }

    protected IterableIterator<SnapPoint> getSnapPoints(HierInst<DbObject> hdbo, AGeom geom, APoint2D snapRef) {
        return SnapPoint.getFor(hdbo, geom, snapRef, this.mSnapCenter.isSelected(), this.mSnapEdge.isSelected());
    }

    public static void removeDevicesAndTemplates() {
        List allDevices = mChildrenToRemove.stream().flatMap(s -> s.stream()).map(dp -> dp.getDevice()).distinct().collect(Collectors.toList());
        List allTemplates = allDevices.stream().map(d -> d.getTemplate()).distinct().collect(Collectors.toList());
        allDevices.stream().forEach(d -> d.deleteFromDb(true));
        allTemplates.stream().forEach(t -> t.deleteFromDb());
    }

    static class StateMachine {
        private State mState = State.draw;
        private CutLineTool mCutLineTool = new CutLineTool();
        private DesignView2D.MouseAction mMouseAction;
        private CursorLoc mFocus;
        List<CursorLoc> mSelection = new LinkedList<CursorLoc>();
        PartitionToolMode mPTM;
        PTMODMovingSegments mDrawerMovingSegments;
        PTMODSelection mDrawerSelection;
        PTMODRuler mDrawerRuler;
        PTMODCursor mDrawerCursor;
        PTMODFocus mDrawerFocus;
        PTMODCutLine mDrawerCutLine;
        PTMODPartition mDrawerPartition;

        StateMachine() {
        }

        public static StateMachine newInstance(PartitionToolMode ptm, PartitionTool partition) {
            StateMachine sm = new StateMachine();
            sm.mPTM = ptm;
            sm.mDrawerMovingSegments = PTMODMovingSegments.newInstance(ptm);
            sm.mDrawerSelection = PTMODSelection.newInstance(ptm);
            sm.mDrawerRuler = PTMODRuler.newInstance(ptm);
            sm.mDrawerCursor = PTMODCursor.newInstance(ptm);
            sm.mDrawerFocus = PTMODFocus.newInstance(ptm);
            sm.mDrawerCutLine = PTMODCutLine.newInstance(ptm);
            sm.mDrawerPartition = PTMODPartition.newInstance(ptm);
            sm.mDrawerPartition.setPartition(partition);
            sm.mDrawerPartition.start();
            return sm;
        }

        public void stop() {
            this.mFocus = null;
            this.mSelection.clear();
            this.mCutLineTool.reset();
            this.mDrawerMovingSegments.stop();
            this.mDrawerSelection.stop();
            this.mDrawerRuler.stop();
            this.mDrawerCursor.stop();
            this.mDrawerFocus.stop();
            this.mDrawerCutLine.stop();
            this.mDrawerPartition.stop();
        }

        public State getState() {
            return this.mState;
        }

        public void resetPartition() {
            this.mPTM.resetPartition();
        }

        public void exportPartition() {
            this.mPTM.exportPartition();
        }

        public void paintOverlay(Graphics2D g, Rectangle bounds) {
            this.mDrawerRuler.paintOverlay(g, bounds);
            this.mDrawerPartition.paintOverlay(g, bounds);
            this.mDrawerSelection.paintOverlay(g, bounds);
            this.mDrawerFocus.paintOverlay(g, bounds);
            this.mDrawerCutLine.paintOverlay(g, bounds);
            this.mDrawerMovingSegments.paintOverlay(g, bounds);
            this.mDrawerCursor.paintOverlay(g, bounds);
        }

        public DesignView2D.MouseAction getMouseAction() {
            return this.mMouseAction;
        }

        public CursorLoc getFocus() {
            return this.mFocus;
        }

        public List<CursorLoc> getSelection() {
            return this.mSelection;
        }

        private void removeDifferentlyOrientedSegmentsFromSelection(CursorLoc sp) {
            boolean isHorizontal = sp.getSnappedToObj().getSegment().isHorizontal();
            this.mSelection = this.mSelection.stream().filter(cl -> cl.getSnappedToObj().getSegment().isHorizontal() == isHorizontal).collect(Collectors.toList());
        }

        public void modifySlideSelection(CursorLoc sp) {
            if (this.mSelection.contains(sp)) {
                this.mSelection.remove(sp);
            } else {
                this.removeDifferentlyOrientedSegmentsFromSelection(sp);
                this.mSelection.add(sp);
            }
            this.mDrawerSelection.setSelection(this.mSelection);
            this.mDrawerSelection.start();
            this.updateRulerAndStatus();
        }

        public void replaceSlideSelection(CursorLoc sp) {
            this.mSelection.clear();
            this.mSelection.add(sp);
            this.mDrawerSelection.setSelection(this.mSelection);
            this.mDrawerSelection.start();
            this.updateRulerAndStatus();
        }

        public void clearSlideSelection() {
            this.mSelection.clear();
            this.mDrawerSelection.setSelection(this.mSelection);
            this.updateRulerAndStatus();
        }

        public void modifyDeleteSelection(CursorLoc sp) {
            this.mSelection.clear();
            this.mSelection.add(sp);
            this.mDrawerSelection.setSelection(this.mSelection);
            this.mDrawerSelection.start();
            this.updateRulerAndStatus();
        }

        public void clearDrawSelection() {
            this.mSelection.clear();
            this.mDrawerSelection.setSelection(this.mSelection);
            this.updateRulerAndStatus();
            this.mCutLineTool.onSelectionChanged();
        }

        public void modifyDrawSelection(CursorLoc sp) {
            if (this.mSelection.contains(sp)) {
                this.mSelection.remove(sp);
            } else {
                if (this.mSelection.size() >= 2) {
                    this.mSelection.remove(0);
                }
                this.mSelection.add(sp);
            }
            this.mDrawerSelection.setSelection(this.mSelection);
            this.mDrawerSelection.start();
            this.mCutLineTool.onSelectionChanged();
        }

        public void updateCutLineByMouseMove(CursorLoc sp) {
            this.mCutLineTool.onMouseMoved(sp);
        }

        public boolean isSnappedOnSegment(CursorLoc sp) {
            if (sp == null) {
                return false;
            }
            SnapObject so = sp.getSnappedToObj();
            return so == null ? false : so.getSegment() != null;
        }

        public void modifySelection(CursorLoc sp) {
            if (this.mSelection.contains(sp)) {
                this.mSelection.remove(sp);
            } else {
                this.mSelection.add(sp);
            }
            this.mDrawerSelection.setSelection(this.mSelection);
            this.mDrawerSelection.start();
            this.updateRulerAndStatus();
        }

        public void replaceSelection(CursorLoc sp) {
            if (sp.isSegment()) {
                ALog.logInfo((String)"Select a segment", (Object[])new Object[]{sp});
            }
            this.mSelection.clear();
            this.mSelection.add(sp);
            this.mDrawerSelection.setSelection(this.mSelection);
            this.mDrawerSelection.start();
            this.updateRulerAndStatus();
        }

        public void switchModeByUI(PartitionToolModeUI.Mode mode) {
            SwingUtilities.invokeLater(() -> this.mPTM.getUI().setMode(mode));
        }

        public void toggleCutLineAngle() {
            this.mCutLineTool.onAngleChanged();
        }

        public boolean cut() {
            ALine cut = this.mCutLineTool.getCutLine();
            if (cut != null) {
                this.mPTM.getPartition().cut(cut, true);
                this.partitionDidChange();
                return true;
            }
            return false;
        }

        private boolean isSameOrientation(List<Segment> list) {
            boolean allHorizontal = list.stream().allMatch(s -> s.mSide.isHorizontal());
            if (allHorizontal) {
                return true;
            }
            return list.stream().allMatch(s -> s.mSide.isVertical());
        }

        public boolean moveBegin(DesignView2D.MouseAction e) {
            APair<List<CursorLoc>, List<Segment>> move = this.getSegmentsInSelection();
            if (((List)move.second).isEmpty()) {
                ALog.logInfo((String)"No segment is selected!");
                return false;
            }
            if (!this.isSameOrientation((List)move.second)) {
                ALog.logInfo((String)"Selected segments are not of the same orientation!");
                return false;
            }
            APair<Long, Long> range = this.mPTM.getPartition().getGreatestValidMoveRange((List)move.second);
            if (range == null) {
                ALog.logInfo((String)"Some selected segments can not be moved!");
                return false;
            }
            this.mDrawerMovingSegments.setSegmentsAndRange((List)move.second, e.getPoint(), range);
            this.mDrawerMovingSegments.start();
            this.mPTM.getUI().setSlideLimits(range);
            return true;
        }

        public void moveEnd() {
            assert (this.mDrawerMovingSegments != null);
            APoint2D offset = this.mDrawerMovingSegments.getOffsetToTargetWorld();
            long x = offset.getX();
            long y = offset.getY();
            if (x == 0L && y == 0L) {
                return;
            }
            if (x != 0L && y != 0L) {
                ALog.logError((String)"Illegal sliding with (%d, %d). Can only slide on either x or y!", (Object[])new Object[]{x, y});
                assert (false);
            }
            this.mPTM.getPartition().move(this.mDrawerMovingSegments.getSegments(), offset.getX(), offset.getY(), false);
            this.mDrawerMovingSegments.stop();
            this.partitionDidChange();
        }

        public void moveAbort() {
            this.mDrawerMovingSegments.stop();
        }

        private APair<List<CursorLoc>, List<Segment>> getSegmentsInSelection() {
            List cursorLocs = this.mSelection.stream().filter(c -> c.isSegment()).collect(Collectors.toList());
            List segments = cursorLocs.stream().map(c -> c.getSegment()).collect(Collectors.toList());
            return new APair(cursorLocs, segments);
        }

        public boolean deleteSelectedSegments() {
            APair<List<CursorLoc>, List<Segment>> delete = this.getSegmentsInSelection();
            if (delete == null) {
                return false;
            }
            this.mSelection.removeAll((Collection)delete.first);
            this.mPTM.getPartition().deleteAll((List)delete.second);
            return true;
        }

        public void moveSetTarget(DesignView2D.MouseAction e) {
            Point target = this.mFocus == null ? e.getPoint() : this.mFocus.getSnapScreen();
            this.mDrawerMovingSegments.setTarget(target);
        }

        public boolean moveSelectedSegments() {
            return true;
        }

        boolean isShiftAltDown(MouseEvent e) {
            return e.isAltDown() || e.isAltGraphDown() || e.isMetaDown() || e.isShiftDown();
        }

        private void updateContext(DesignView2D.MouseAction e) {
            this.updateCursorAndFocus(e);
            this.updateRulerAndStatus();
        }

        private void updateRulerAndStatus() {
            int selectionSize = this.mSelection.size();
            if (this.getCurrentMode() == PartitionToolModeUI.Mode.draw && selectionSize > 0 && this.mFocus != null) {
                this.mDrawerRuler.setReferencePoints(this.mFocus, this.mSelection.get(selectionSize - 1));
                this.mDrawerRuler.start();
            } else {
                this.mDrawerRuler.setReferencePoints(null, null);
            }
        }

        private PartitionToolModeUI.Mode getCurrentMode() {
            return this.mPTM.getUI().getMode();
        }

        protected void updateCursorAndFocus(DesignView2D.MouseAction e) {
            Point screenPt = e.getPoint();
            CursorLoc lastSelection = this.mSelection.isEmpty() ? null : this.mSelection.get(this.mSelection.size() - 1);
            PartitionToolMode partitionToolMode = this.mPTM;
            Objects.requireNonNull(partitionToolMode);
            this.mFocus = partitionToolMode.new CursorLoc(e, lastSelection, this.mPTM.getPartition(), this.getCurrentMode());
            this.mDrawerFocus.setFocus(this.mFocus);
            this.mDrawerFocus.start();
            this.mDrawerCursor.setCursorPoint(screenPt);
            this.mDrawerCursor.start();
            if (lastSelection == null || lastSelection.mSnapPreferred == null || lastSelection.equals(this.mFocus)) {
                return;
            }
            if (lastSelection.mSnapPreferred.getGeom() instanceof ACircle) {
                boolean refSameCircle = lastSelection.snappedToSameGeom(this.mFocus);
                ACircle c = (ACircle)lastSelection.mSnapPreferred.getGeom();
                APoint2D relSnapRef = this.mFocus.getSnap().transform(lastSelection.mSnapPreferred.getSnapObject().getDevicePath().getInverseTransform());
                boolean refInside = c.intersects(relSnapRef);
                if (refSameCircle || this.mFocus.getSnappedToObj() == null && refInside) {
                    assert (lastSelection.mSnapInitial != null);
                    if (lastSelection.mSnapInitial != null) {
                        lastSelection.mForceInitialSnap = true;
                        return;
                    }
                }
            }
            lastSelection.mForceInitialSnap = false;
            lastSelection.mSnapPreferred.updateDynamicSnap(this.mFocus.getSnap());
        }

        public void setCutLineAngle(int angle) {
            this.mCutLineTool.onSetAngle(angle);
        }

        public void setCutLinePositionByDivision(int numerator, int denominator) {
            this.mCutLineTool.onPositionByDivision(numerator, denominator);
        }

        public void setCutLinePositionByDistance(long x, long y) {
            this.mCutLineTool.onPositionByOffset(x, y);
        }

        public void resetCutLine() {
            this.mCutLineTool.reset();
        }

        public void showCutLine(boolean bShow) {
            this.mDrawerCutLine.setShow(bShow);
        }

        public void showRuler(boolean bShow) {
            this.mDrawerRuler.setShow(bShow);
        }

        public void setSlideOffset(boolean isByOffset, long offset) {
            this.mDrawerMovingSegments.useAlternateTarget(isByOffset);
            if (isByOffset) {
                this.mDrawerMovingSegments.setAlternateTargetByOffset(offset);
                this.mPTM.repaintOverlay();
            }
        }

        public void undoEdit() {
            this.mPTM.getPartition().undo();
            this.partitionDidChange();
        }

        public void redoEdit() {
            this.mPTM.getPartition().redo();
            this.partitionDidChange();
        }

        public void deleteAll() {
            this.mPTM.getPartition().reset();
            this.partitionDidChange();
        }

        private void partitionDidChange() {
            this.stop();
            this.mDrawerPartition.setPartition(this.mPTM.getPartition());
            this.mDrawerPartition.start();
            this.mPTM.repaintOverlay();
        }

        boolean isFocusOnSegment(DesignView2D.MouseAction e) {
            return true;
        }

        private void toDrawMode() {
            this.mDrawerMovingSegments.stop();
            this.showCutLine(true);
            this.showRuler(true);
            this.mSelection.clear();
            this.resetCutLine();
            this.updateRulerAndStatus();
        }

        private void toDeleteMode() {
            this.mDrawerMovingSegments.stop();
            this.showCutLine(false);
            this.showRuler(false);
            this.mSelection.clear();
            this.updateRulerAndStatus();
        }

        private void toSlideMode() {
            this.showCutLine(false);
            this.showRuler(false);
            this.mSelection.clear();
            this.updateRulerAndStatus();
        }

        public void exportPortitionWithOptionallyRemoveExistingChildren() {
            List<Set<DevicePath>> children = PartitionTool.findFilteredChildren(this.mPTM.getPartition().getDevicePath(), EnumSet.of(PartitionTool.ChildCondition.IS_HIERARCHY_CHILD, PartitionTool.ChildCondition.IS_PARTITION_CHILD));
            if (children.size() != 0) {
                this.mPTM.getUI().promptOverwrite(() -> {
                    mChildrenToRemove = children;
                    Cp.exec((String)"com.sigrity.orbit.ui.partitionTool.PartitionToolMode.removeDevicesAndTemplates()", (Object[])new Object[0]);
                    this.onExportPartition();
                }, () -> this.onExportPartition());
            } else {
                this.onExportPartition();
            }
        }

        public State onPressed(DesignView2D.MouseAction e) {
            this.updateContext(e);
            this.mMouseAction = e;
            State nextState = this.mState.onPressed(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onReleased(DesignView2D.MouseAction e) {
            this.mMouseAction = e;
            State nextState = this.mState.onReleased(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onMoved(DesignView2D.MouseAction e) {
            this.updateContext(e);
            this.mMouseAction = e;
            State nextState = this.mState.onMoved(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onDragged(DesignView2D.MouseAction e) {
            this.updateContext(e);
            this.mMouseAction = e;
            State nextState = this.mState.onDragged(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onClicked(DesignView2D.MouseAction e) {
            this.mMouseAction = e;
            State nextState = this.mState.onClicked(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onSpace() {
            State nextState = this.mState.onSpace(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onDelete() {
            State nextState = this.mState.onDelete(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onDelAll() {
            State nextState = this.mState.onDelAll(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onT() {
            State nextState = this.mState.onToggle(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onCancel() {
            State nextState = this.mState.onCancel(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onControlPressed() {
            State nextState = this.mState.onControlPressed(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onControlReleased() {
            State nextState = this.mState.onControlReleased(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onSlideOffsetTurnedOn() {
            State nextState = this.mState.onSlideOffsetTurnedOn(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onOffsetEntered() {
            State nextState = this.mState.onOffsetEntered(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onStop() {
            State nextState = this.mState.onStop(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onExportPartition() {
            State nextState = this.mState.onExportPartition(this);
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        public State onModeChange(PartitionToolModeUI.Mode mode) {
            State nextState;
            switch (mode) {
                default: {
                    nextState = this.mState.onModeDraw(this);
                    break;
                }
                case delete: {
                    nextState = this.mState.onModeDelete(this);
                    break;
                }
                case slide: {
                    nextState = this.mState.onModeSlide(this);
                }
            }
            if (nextState != State.noTransition) {
                this.changeState(nextState);
            }
            return this.mState;
        }

        private void changeState(State nextState) {
            this.mState.exit(this);
            this.mState = nextState;
            this.mState.enter(this);
        }

        class CutLineTool {
            private CursorLoc mRefNew;
            private CursorLoc mRefOld;
            private PositionCutLine mPositionBy = PositionCutLine.ByDivision;
            private double mDivisionRatioNumerator;
            private double mDivisionRatioDenominator;
            private long mOffsetX;
            private long mOffsetY;
            private int mAbsoluteAngle = 90;
            ALine mCutLine;

            CutLineTool() {
            }

            void reset() {
                this.mRefNew = null;
                this.mRefOld = null;
                StateMachine.this.mDrawerCutLine.setReferencePoints(null, null, null);
            }

            ALine getCutLine() {
                return this.mCutLine;
            }

            ALine updateCutLine() {
                this.mCutLine = this.mRefOld == null || this.mRefNew == null ? null : this.calculateCutLine(this.mRefNew.getSnap(), this.mRefOld.getSnap());
                StateMachine.this.mDrawerCutLine.setReferencePoints(this.mCutLine, this.mRefNew, this.mRefOld);
                StateMachine.this.mDrawerCutLine.start();
                this.updateMeasurements();
                return this.mCutLine;
            }

            void updateMeasurements() {
                APoint2D refNew;
                APoint2D refOld = this.mRefOld == null ? null : this.mRefOld.getSnap();
                APoint2D aPoint2D = refNew = this.mRefNew == null ? null : this.mRefNew.getSnap();
                if (this.mCutLine == null) {
                    StateMachine.this.mPTM.getUI().updateStatus(refOld, refNew, null, null, false);
                } else if (this.mAbsoluteAngle == 180) {
                    StateMachine.this.mPTM.getUI().updateStatus(refOld, refNew, null, this.mCutLine.center(), false);
                } else {
                    StateMachine.this.mPTM.getUI().updateStatus(refOld, refNew, this.mCutLine.center(), null, false);
                }
            }

            void onSelectionChanged() {
                int selectionSize = StateMachine.this.mSelection.size();
                if (selectionSize > 1) {
                    this.mRefNew = StateMachine.this.mSelection.get(selectionSize - 1).copy();
                    this.mRefOld = StateMachine.this.mSelection.get(selectionSize - 2).copy();
                    this.updateCutLine();
                } else if (selectionSize == 1 && StateMachine.this.mFocus != null) {
                    this.mRefNew = StateMachine.this.mFocus;
                    this.mRefOld = StateMachine.this.mSelection.get(0);
                    this.updateCutLine();
                } else {
                    this.mRefNew = null;
                    this.mRefOld = null;
                    this.updateCutLine();
                }
            }

            void onMouseMoved(CursorLoc cl) {
                if (StateMachine.this.mSelection.size() == 1 && cl != null) {
                    this.mRefNew = cl;
                    this.updateCutLine();
                }
            }

            void onAngleChanged() {
                this.mAbsoluteAngle = StateMachine.this.mPTM.getUI().toggleCutLineAngle();
                this.updateCutLine();
            }

            void onSetAngle(int angle) {
                this.mAbsoluteAngle = angle;
                this.updateCutLine();
            }

            void onPositionByDivision(int numerator, int denominator) {
                this.mPositionBy = PositionCutLine.ByDivision;
                this.mDivisionRatioNumerator = numerator;
                this.mDivisionRatioDenominator = denominator;
                this.updateCutLine();
            }

            void onPositionByOffset(long x, long y) {
                this.mPositionBy = PositionCutLine.ByDistance;
                this.mOffsetX = x;
                this.mOffsetY = y;
                this.updateCutLine();
            }

            private ALine getBisector(ALine l, ARect bounds) {
                long length = l.getLength();
                APoint2D divisionPoint = this.getDivisionPoint(l);
                APair<Long, Long> xy = this.getCosSin(length);
                long xside = (Long)xy.first;
                long yside = (Long)xy.second;
                ALine line = new ALine(divisionPoint.getX() - xside, divisionPoint.getY() - yside, divisionPoint.getX() + xside, divisionPoint.getY() + yside);
                assert (line.isHorizontal() || line.isVertical());
                return PartitionToolModeOverlayDrawer.extendsTo(line, bounds);
            }

            private APair<Long, Long> getCosSin(long length) {
                long y;
                long x;
                if (this.mAbsoluteAngle == 90) {
                    x = 0L;
                    y = length;
                } else {
                    x = length;
                    y = 0L;
                }
                return new APair((Object)x, (Object)y);
            }

            private APoint2D getDivisionPoint(ALine l) {
                if (this.mDivisionRatioNumerator <= 0.0 || this.mDivisionRatioDenominator <= 0.0) {
                    return l.center();
                }
                double ratio = this.mDivisionRatioNumerator / this.mDivisionRatioDenominator;
                return new APoint2D((double)l.getP0().getX() * ratio + (double)l.getP1().getX() * (1.0 - ratio), (double)l.getP0().getY() * ratio + (double)l.getP1().getY() * (1.0 - ratio));
            }

            private ALine calculateCutLine(APoint2D start, APoint2D end) {
                APoint2D p1;
                APoint2D p0;
                ARect bounds = StateMachine.this.mPTM.getView().getCanvas().getWorldBounds();
                if (this.mPositionBy == PositionCutLine.ByDivision) {
                    if (!start.equals((Object)end)) {
                        ALine refLine = new ALine(start.getX(), start.getY(), end.getX(), end.getY());
                        ALine orthoLine = this.getBisector(refLine, bounds);
                        p0 = new APoint2D(orthoLine.getP0().getX(), orthoLine.getP0().getY());
                        p1 = new APoint2D(orthoLine.getP1().getX(), orthoLine.getP1().getY());
                    } else if (this.mAbsoluteAngle == 90) {
                        p0 = new APoint2D(start.getX(), bounds.getLL().getY());
                        p1 = new APoint2D(start.getX(), bounds.getUR().getY());
                    } else {
                        p0 = new APoint2D(bounds.getLL().getX(), start.getY());
                        p1 = new APoint2D(bounds.getUR().getX(), start.getY());
                    }
                } else if (this.mAbsoluteAngle == 90) {
                    long distanceX = this.mOffsetX;
                    p0 = new APoint2D(end.getX() + distanceX, bounds.getLL().getY());
                    p1 = new APoint2D(end.getX() + distanceX, bounds.getUR().getY());
                } else {
                    long distanceY = this.mOffsetY;
                    p0 = new APoint2D(bounds.getLL().getX(), end.getY() + distanceY);
                    p1 = new APoint2D(bounds.getUR().getX(), end.getY() + distanceY);
                }
                this.mCutLine = new ALine(p0, p1);
                this.mCutLine = StateMachine.this.mPTM.getPartition().extendsAndGetBoundaryIntersection(this.mCutLine);
                return this.mCutLine;
            }
        }

        static enum PositionCutLine {
            ByDivision,
            ByDistance;

        }
    }

    static enum State implements StateEventHandler
    {
        noTransition,
        draw{

            @Override
            public State onPressed(StateMachine sm) {
                if (sm.isShiftAltDown(sm.getMouseAction())) {
                    return noTransition;
                }
                sm.modifyDrawSelection(sm.getFocus());
                return noTransition;
            }

            @Override
            public State onToggle(StateMachine sm) {
                sm.toggleCutLineAngle();
                return noTransition;
            }

            @Override
            public State onSpace(StateMachine sm) {
                sm.cut();
                return noTransition;
            }

            @Override
            public State onModeDraw(StateMachine sm) {
                return noTransition;
            }

            @Override
            public State onCancel(StateMachine sm) {
                sm.clearDrawSelection();
                return noTransition;
            }

            @Override
            public State onMoved(StateMachine sm) {
                sm.updateCutLineByMouseMove(sm.getFocus());
                return noTransition;
            }

            @Override
            public State onDragged(StateMachine sm) {
                sm.updateCutLineByMouseMove(sm.getFocus());
                return noTransition;
            }
        }
        ,
        delete{

            @Override
            public State onDelAll(StateMachine sm) {
                sm.deleteAll();
                sm.switchModeByUI(PartitionToolModeUI.Mode.draw);
                return noTransition;
            }

            @Override
            public State onPressed(StateMachine sm) {
                if (sm.isShiftAltDown(sm.getMouseAction())) {
                    return noTransition;
                }
                if (!sm.isSnappedOnSegment(sm.getFocus())) {
                    return noTransition;
                }
                sm.modifyDeleteSelection(sm.getFocus());
                sm.deleteSelectedSegments();
                return noTransition;
            }

            @Override
            public State onSpace(StateMachine sm) {
                sm.deleteSelectedSegments();
                return noTransition;
            }

            @Override
            public State onModeDelete(StateMachine sm) {
                return noTransition;
            }
        }
        ,
        slide{

            @Override
            public State onPressed(StateMachine sm) {
                if (sm.isShiftAltDown(sm.getMouseAction())) {
                    return noTransition;
                }
                if (!sm.isSnappedOnSegment(sm.getFocus())) {
                    return noTransition;
                }
                sm.replaceSlideSelection(sm.getFocus());
                if (sm.getSelection().size() > 0) {
                    return this.onSpace(sm);
                }
                return noTransition;
            }

            @Override
            public State onSpace(StateMachine sm) {
                if (sm.moveBegin(sm.getMouseAction())) {
                    return sliding;
                }
                return noTransition;
            }

            @Override
            public State onCancel(StateMachine sm) {
                sm.clearSlideSelection();
                return noTransition;
            }

            @Override
            public State onControlPressed(StateMachine sm) {
                return slideMultiSel;
            }

            @Override
            public State onSlideOffsetTurnedOn(StateMachine sm) {
                return this.onSpace(sm);
            }

            @Override
            public State onModeSlide(StateMachine sm) {
                return noTransition;
            }
        }
        ,
        slideMultiSel{

            @Override
            public State onPressed(StateMachine sm) {
                if (sm.isShiftAltDown(sm.getMouseAction())) {
                    return noTransition;
                }
                if (!sm.isSnappedOnSegment(sm.getFocus())) {
                    return noTransition;
                }
                sm.modifySlideSelection(sm.getFocus());
                return noTransition;
            }

            @Override
            public State onControlReleased(StateMachine sm) {
                if (sm.getSelection().size() > 0) {
                    if (sm.moveBegin(sm.getMouseAction())) {
                        return sliding;
                    }
                    ALog.logInfo((String)"Can not slide selected segment(s):%s", (Object[])new Object[]{sm.getSelection()});
                    sm.clearSlideSelection();
                    return slide;
                }
                return slide;
            }

            @Override
            public State onCancel(StateMachine sm) {
                sm.clearSlideSelection();
                return slide;
            }
        }
        ,
        sliding{

            @Override
            public void enter(StateMachine sm) {
                APair<Boolean, Long> slideOffsetOption = sm.mPTM.getUI().getSlideOffsetOption();
                sm.setSlideOffset((Boolean)slideOffsetOption.first, (Long)slideOffsetOption.second);
            }

            @Override
            public State onMoved(StateMachine sm) {
                sm.moveSetTarget(sm.getMouseAction());
                return noTransition;
            }

            @Override
            public State onSpace(StateMachine sm) {
                sm.moveEnd();
                return slide;
            }

            @Override
            public State onPressed(StateMachine sm) {
                return this.onSpace(sm);
            }

            @Override
            public State onCancel(StateMachine sm) {
                sm.moveAbort();
                return slide;
            }

            @Override
            public State onModeSlide(StateMachine sm) {
                return noTransition;
            }
        };

    }

    static interface StateEventHandler {
        default public State onPressed(StateMachine sm) {
            return State.noTransition;
        }

        default public State onReleased(StateMachine sm) {
            return State.noTransition;
        }

        default public State onMoved(StateMachine sm) {
            return State.noTransition;
        }

        default public State onDragged(StateMachine sm) {
            return State.noTransition;
        }

        default public State onClicked(StateMachine sm) {
            return State.noTransition;
        }

        default public State onSpace(StateMachine sm) {
            return State.noTransition;
        }

        default public State onDelete(StateMachine sm) {
            return State.noTransition;
        }

        default public State onDelAll(StateMachine sm) {
            return State.noTransition;
        }

        default public State onToggle(StateMachine sm) {
            return State.noTransition;
        }

        default public State onSlideOffsetTurnedOn(StateMachine sm) {
            return State.noTransition;
        }

        default public State onOffsetEntered(StateMachine sm) {
            return this.onSpace(sm);
        }

        default public State onCancel(StateMachine sm) {
            return State.noTransition;
        }

        default public State onControlPressed(StateMachine sm) {
            return State.noTransition;
        }

        default public State onControlReleased(StateMachine sm) {
            return State.noTransition;
        }

        default public State onStop(StateMachine sm) {
            sm.stop();
            sm.resetPartition();
            return State.noTransition;
        }

        default public State onExportPartition(StateMachine sm) {
            sm.exportPartition();
            return State.noTransition;
        }

        default public State onModeDraw(StateMachine sm) {
            sm.toDrawMode();
            return State.draw;
        }

        default public State onModeDelete(StateMachine sm) {
            sm.toDeleteMode();
            return State.delete;
        }

        default public State onModeSlide(StateMachine sm) {
            sm.toSlideMode();
            return State.slide;
        }

        default public void enter(StateMachine sm) {
        }

        default public void exit(StateMachine sm) {
        }
    }

    static class SnapObject {
        private static PartitionTool mPT;
        private HierInst<DbObject> mHdbo;
        private Segment mSegment;
        private AGeom mGeom;

        public static void setPartitionTool(PartitionTool pt) {
            mPT = pt;
        }

        public String toString() {
            return this.mSegment == null ? this.mHdbo.toString() : this.mSegment.toString();
        }

        public SnapObject(HierInst<DbObject> hdbo, AGeom geom) {
            this.mHdbo = hdbo;
            this.mGeom = geom;
        }

        public SnapObject(Segment segment, ALine line) {
            assert (mPT != null);
            this.mSegment = segment;
            this.mGeom = line;
            this.mHdbo = null;
        }

        public SnapObject(SnapObject so, AGeom geom) {
            this.mHdbo = so.mHdbo;
            this.mSegment = so.mSegment;
            this.mGeom = geom;
        }

        public HierInst<DbObject> getHdbo() {
            return this.mHdbo;
        }

        public DevicePath getDevicePath() {
            if (this.mHdbo != null) {
                return (DevicePath)this.mHdbo.first;
            }
            return null;
        }

        public boolean isSegment() {
            return this.mSegment != null;
        }

        public Segment getSegment() {
            return this.mSegment;
        }

        public AGeom getShape() {
            return this.mGeom;
        }
    }

    static class SnapPoint {
        SnapObject mSnapObj;
        Pt mRelPt;

        public static SnapPoint newInstance(Segment s, APoint2D refPt) {
            ALine l = s.mSide.distanceToPoint(refPt, true);
            assert (l != null);
            APoint2D p = l.getP0().equals((Object)refPt) ? l.getP1() : l.getP0();
            return new SnapPoint(s, Pt.dynamic(p, (AGeom)s.mSide));
        }

        public static IterableIterator<SnapPoint> getFor(final HierInst<DbObject> dbo, final AGeom geom, APoint2D refPt, boolean center, boolean edge) {
            return new ProcessingIterator<Pt, SnapPoint>(SnapPoint.getPts(geom, refPt, center, edge)){

                protected SnapPoint process(Pt pt) {
                    return new SnapPoint((HierInst<DbObject>)dbo, geom, pt);
                }
            };
        }

        public static IterableIterator<Pt> getPts(AGeom g, APoint2D refPt, boolean center, boolean edges) {
            LinkedList<Pt> pts = new LinkedList<Pt>();
            if (edges) {
                for (AGeom edge : SnapPoint.getEdges(g)) {
                    ALine l = edge.distanceToPoint(refPt, true);
                    if (l == null) continue;
                    APoint2D pt = l.getP0().equals((Object)refPt) ? l.getP1() : l.getP0();
                    pts.add(Pt.dynamic(pt, edge));
                }
            }
            if (center) {
                pts.add(Pt.fixed(g.getBounds().center()));
            }
            return AIterableItr.itr(pts);
        }

        public static IterableIterator<? extends AGeom> getEdges(AGeom g) {
            if (g instanceof ARect) {
                return g.toPoly().getSegments();
            }
            if (g instanceof APolygon) {
                return ((APolygon)g).getSegments();
            }
            if (g instanceof APath) {
                return g.toPoly().getSegments();
            }
            return ASingletonItr.create((Object)g);
        }

        protected SnapPoint(HierInst<DbObject> dbo, AGeom geom, Pt pt) {
            this.mSnapObj = new SnapObject(dbo, geom);
            this.mRelPt = pt;
        }

        protected SnapPoint(Segment s, Pt pt) {
            this.mSnapObj = new SnapObject(s, s.mSide);
            this.mRelPt = pt;
        }

        protected SnapPoint(SnapObject so, AGeom geom, Pt pt) {
            this.mSnapObj = new SnapObject(so, geom);
            this.mRelPt = pt;
        }

        public boolean isSegment() {
            return this.mSnapObj.isSegment();
        }

        public Segment getSegment() {
            return this.mSnapObj.getSegment();
        }

        public SnapObject getSnapObject() {
            return this.mSnapObj;
        }

        public AGeom getGeom() {
            return this.mSnapObj.getShape();
        }

        public APoint2D getRelPt() {
            return this.mRelPt.getPt();
        }

        public boolean isFixed() {
            return this.mRelPt.isFixed();
        }

        public AGeom getDynOn() {
            return this.mRelPt.getDynOn();
        }

        public APoint2D getWorldPt() {
            if (this.mSnapObj.getDevicePath() == null) {
                return this.mRelPt.getPt();
            }
            return this.mRelPt.getPt().transform(this.mSnapObj.getDevicePath().getTransform());
        }

        public void updateDynamicSnap(APoint2D snapRef) {
            if (this.isFixed()) {
                return;
            }
            DevicePath dp = this.mSnapObj.getDevicePath();
            if (dp != null) {
                snapRef = snapRef.transform(dp.getInverseTransform());
            }
            this.mRelPt.dynUpdate(snapRef);
        }

        public SnapPoint copy() {
            return new SnapPoint(this.mSnapObj, this.getGeom(), this.mRelPt.copy());
        }

        public static class Pt {
            APoint2D mPt;
            AGeom mDynOn = null;

            public static Pt fixed(APoint2D pt) {
                return new Pt(pt, null);
            }

            public static Pt dynamic(APoint2D pt, AGeom dynOn) {
                return new Pt(pt, dynOn);
            }

            public Pt(APoint2D pt, AGeom dynOn) {
                this.mPt = pt;
                this.mDynOn = dynOn;
            }

            public APoint2D getPt() {
                return this.mPt;
            }

            public boolean isFixed() {
                return this.mDynOn == null;
            }

            public AGeom getDynOn() {
                return this.mDynOn;
            }

            public boolean dynUpdate(APoint2D refPt) {
                APoint2D pt;
                if (this.mDynOn == null || refPt == null) {
                    return false;
                }
                ALine l = this.mDynOn.distanceToPoint(refPt, true);
                APoint2D aPoint2D = pt = l.getP0().equals((Object)refPt) ? l.getP1() : l.getP0();
                if (pt.equals((Object)this.mPt)) {
                    return false;
                }
                this.mPt = pt;
                return true;
            }

            public Pt copy() {
                return new Pt(this.mPt, this.mDynOn);
            }
        }
    }

    protected class CursorLoc {
        APoint2D mWorld;
        SnapPoint mSnapInitial = null;
        SnapPoint mSnapPreferred = null;
        boolean mForceInitialSnap = false;
        PartitionToolModeUI.Mode mMode;

        public CursorLoc copy() {
            CursorLoc cl = new CursorLoc();
            cl.mWorld = this.mWorld;
            cl.mSnapInitial = this.mSnapInitial == null ? null : this.mSnapInitial.copy();
            cl.mSnapPreferred = this.mSnapPreferred == null ? null : this.mSnapPreferred.copy();
            cl.mForceInitialSnap = this.mForceInitialSnap;
            cl.mMode = this.mMode;
            return cl;
        }

        private CursorLoc() {
        }

        public CursorLoc(DesignView2D.MouseAction e, CursorLoc snapReference, PartitionTool partition, PartitionToolModeUI.Mode mode) {
            Segment segment;
            SnapObject refObj;
            this.mMode = mode;
            Point screenPt = e.getPoint();
            this.mWorld = PartitionToolMode.this.mView.getCanvas().getWorldPt(screenPt);
            SnapObject snapObject = refObj = snapReference == null || snapReference.getSnap() == null ? null : snapReference.getSnappedToObj();
            if (!PartitionToolMode.this.getSnapAnyDeviceTypes() || !PartitionToolMode.this.getSnapAnyLocTypes()) {
                return;
            }
            Db db = PartitionToolMode.this.mView.getDb();
            Design design = Design.getDesign((Db)db, (boolean)false);
            if (design == null) {
                return;
            }
            SnapPoint bestPt = null;
            long bestDist = Long.MAX_VALUE;
            long snapDist = PartitionToolMode.this.mView.getCanvas().getXForm().getWorldLength(PartitionToolMode.this.mNearDistScreen);
            ViewColorizer visibility = PartitionToolMode.this.mView.getColorizer();
            if (snapReference != null) {
                AGeom refDynOn;
                AGeom aGeom = snapReference.mSnapInitial == null ? null : (refDynOn = snapReference.mSnapInitial.mRelPt == null ? null : snapReference.mSnapInitial.mRelPt.mDynOn);
                if (refDynOn instanceof ACircle) {
                    ACircle c = (ACircle)refDynOn;
                    ALine l = new ALine(snapReference.mSnapInitial.mRelPt.mPt, c.getC());
                    l.extendEnds(c.getR());
                    APoint2D oppositePtRel = l.getP1();
                    DevicePath dp = refObj.getDevicePath();
                    APoint2D dpRelCursorPt = this.mWorld.transform(dp.getInverseTransform());
                    long dist = oppositePtRel.distance(dpRelCursorPt);
                    if (dist < snapDist) {
                        this.mSnapPreferred = new SnapPoint(refObj, (AGeom)c, SnapPoint.Pt.dynamic(oppositePtRel, (AGeom)c));
                        this.mSnapInitial = this.mSnapPreferred.copy();
                        this.mForceInitialSnap = true;
                        return;
                    }
                }
            }
            if (partition != null && this.shouldSnapToPartition() && (segment = (Segment)partition.getNearestSegment(this.mWorld, snapDist).orElse(null)) != null) {
                bestPt = SnapPoint.newInstance(segment, this.mWorld);
            }
            for (HierInst hdbo : design.getObjectsNear(this.mWorld, snapDist)) {
                APoint2D snapRef;
                DevicePath dp = hdbo.getPath();
                DbObject dbo = hdbo.getDbObject();
                if (dp.equals((Object)PartitionToolMode.this.mDevicePath) && dbo instanceof Device) continue;
                LayerShape.Filter visibleShapeFilter = visibility.getVisibleShapesFilter(dp);
                APoint2D dpRelPt = this.mWorld.transform(dp.getInverseTransform());
                APoint2D aPoint2D = snapRef = snapReference == null || refObj != null && hdbo.equals(refObj.getHdbo()) ? dpRelPt : snapReference.getSnapPref().transform(dp.getInverseTransform());
                if (this.shouldSnapToPin(e) && dbo instanceof PortTemplate) {
                    PortTemplate portT = (PortTemplate)dbo;
                    for (LayerShape ls : portT.getLayerShapesFiltered(visibleShapeFilter)) {
                        AGeom objGeom = ls.getGeom().transform(portT.getTransform());
                        for (SnapPoint pt : PartitionToolMode.this.getSnapPoints((HierInst<DbObject>)hdbo, objGeom, snapRef)) {
                            long curDist = pt.getRelPt().distance(dpRelPt);
                            if (curDist >= snapDist || curDist >= bestDist) continue;
                            bestDist = curDist;
                            bestPt = pt;
                        }
                    }
                    continue;
                }
                if (!this.shouldSnapToDevice(e) || !(dbo instanceof Device)) continue;
                Device d = (Device)dbo;
                AGeom objGeom = d.getTemplate().getBounds(true);
                for (SnapPoint pt : PartitionToolMode.this.getSnapPoints((HierInst<DbObject>)hdbo, objGeom, snapRef)) {
                    long curDist = pt.getRelPt().distance(dpRelPt);
                    if (curDist >= snapDist || curDist >= bestDist) continue;
                    bestDist = curDist;
                    bestPt = pt;
                }
            }
            if (bestPt != null) {
                this.mSnapPreferred = bestPt;
                this.mSnapInitial = this.mSnapPreferred.copy();
            }
        }

        public boolean snappedToSameGeom(CursorLoc other) {
            if (this.mSnapPreferred == null || this.mSnapPreferred.getSnapObject() == null || this.mSnapPreferred.getGeom() == null || other.mSnapPreferred == null || other.mSnapPreferred.getSnapObject() == null || other.mSnapPreferred.getGeom() == null) {
                return false;
            }
            return this.mSnapPreferred.getSnapObject().equals(other.mSnapPreferred.getSnapObject()) && this.mSnapPreferred.getGeom().equals((Object)other.mSnapPreferred.getGeom());
        }

        public Point getScreen() {
            return PartitionToolMode.this.mView.getCanvas().getXForm().getScreenPt(this.mWorld);
        }

        public APoint2D getWorld() {
            return this.mWorld;
        }

        public APoint2D getSnap() {
            return this.mForceInitialSnap ? this.getSnapInit() : this.getSnapPref();
        }

        public Point getSnapScreen() {
            return this.mForceInitialSnap ? this.getSnapInitScreen() : this.getSnapPrefScreen();
        }

        public APoint2D getSnapPref() {
            return this.mSnapPreferred == null ? this.mWorld : this.mSnapPreferred.getWorldPt();
        }

        public Point getSnapPrefScreen() {
            return PartitionToolMode.this.mView.getCanvas().getXForm().getScreenPt(this.getSnapPref());
        }

        public APoint2D getSnapInit() {
            return this.mSnapInitial == null ? this.mWorld : this.mSnapInitial.getWorldPt();
        }

        public Point getSnapInitScreen() {
            return PartitionToolMode.this.mView.getCanvas().getXForm().getScreenPt(this.getSnapInit());
        }

        public SnapObject getSnappedToObj() {
            return this.mSnapPreferred == null ? null : this.mSnapPreferred.getSnapObject();
        }

        public AGeom getDynOn() {
            return this.mSnapPreferred == null ? null : this.mSnapPreferred.getDynOn();
        }

        public boolean isSnapped() {
            return this.mForceInitialSnap ? this.mSnapInitial != null : this.mSnapPreferred != null;
        }

        public boolean isSegment() {
            return this.mSnapPreferred == null ? false : this.mSnapPreferred.isSegment();
        }

        public Segment getSegment() {
            return this.mSnapPreferred == null ? null : this.mSnapPreferred.getSegment();
        }

        private boolean shouldSnapToDevice(DesignView2D.MouseAction e) {
            return this.mMode == PartitionToolModeUI.Mode.draw && !e.isShiftDown() && PartitionToolMode.this.mSnapDevice.isSelected();
        }

        private boolean shouldSnapToPin(DesignView2D.MouseAction e) {
            return this.mMode == PartitionToolModeUI.Mode.draw && !e.isShiftDown() && PartitionToolMode.this.mSnapPin.isSelected();
        }

        private boolean shouldSnapToPartition() {
            return PartitionToolMode.this.mSnapPartition.isSelected();
        }
    }

    private class DelAllAction
    extends AbstractAction {
        PartitionToolMode mPTM;
        public static final String ID = "Delete All Segments";

        public DelAllAction(PartitionToolMode ptm) {
            super(ID);
            this.mPTM = ptm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mPTM.actionDelAll();
        }
    }

    private static class ToggleAction
    extends AbstractAction {
        public static final String ID = "Partition Tool Mode Action Toggle Angle";
        PartitionToolMode mPTM;

        public ToggleAction(PartitionToolMode ptm) {
            super(ID);
            this.mPTM = ptm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mPTM.actionToggle();
        }
    }

    private static class DeleteAction
    extends AbstractAction {
        PartitionToolMode mPTM;
        public static final String ID = "Partition Tool Mode Action Delete Segment";

        public DeleteAction(PartitionToolMode ptm) {
            super(ID);
            this.mPTM = ptm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mPTM.actionDelete();
        }
    }

    private static class CommitAction
    extends AbstractAction {
        public static final String ID = "Partition Tool Mode Action Commit";
        PartitionToolMode mPTM;

        public CommitAction(PartitionToolMode ptm) {
            super(ID);
            this.mPTM = ptm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mPTM.actionCommit();
        }
    }

    private static class CancelAction
    extends AbstractAction {
        public static final String ID = "Partition Tool Mode Action Cancel";
        PartitionToolMode mPTM;

        public CancelAction(PartitionToolMode ptm) {
            super("Mode Action Cancel");
            this.mPTM = ptm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mPTM.actionCancel();
        }
    }
}

