/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.APolyline;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

interface PartitionToolModeOverlayDrawer {
    public static final int k1sec = 300;
    public static final int k0p1sec = 100;
    public static final int k7sec = 700;
    public static final int k5sec = 500;

    public void paintOverlay(Graphics2D var1, Rectangle var2);

    public void start();

    public void stop();

    default public void drawScreenShape(Graphics2D g, AGeom geom, PartitionToolMode ptm) {
        if (geom instanceof ARect) {
            g.draw(ptm.getScreenRect((ARect)geom));
        } else if (geom instanceof AOctagon) {
            g.drawPolygon(ptm.getScreenPolygon((APolygon)geom));
        } else if (geom instanceof APolyline) {
            ((APolyline)geom).getSegments().stream().forEach(seg -> {
                Point p0 = ptm.getScreenPoint(seg.getP0());
                Point p1 = ptm.getScreenPoint(seg.getP1());
                g.drawLine(p0.x, p0.y, p1.x, p1.y);
            });
        } else if (geom instanceof APolygon) {
            Polygon poly = ptm.getScreenPolygon((APolygon)geom);
            if (poly.npoints == 2) {
                g.drawLine(poly.xpoints[0], poly.ypoints[0], poly.xpoints[1], poly.ypoints[1]);
            } else {
                g.drawPolygon(poly);
            }
        } else if (geom instanceof ACircle) {
            g.draw(ptm.getScreenCircle((ACircle)geom));
        }
    }

    default public void fillScreenShape(Graphics2D g, AGeom geom, PartitionToolMode ptm) {
        if (geom instanceof ARect) {
            g.fill(ptm.getScreenRect((ARect)geom));
        } else if (geom instanceof AOctagon) {
            g.fillPolygon(ptm.getScreenPolygon((APolygon)geom));
        } else if (geom instanceof APolyline) {
            ((APolyline)geom).getSegments().stream().forEach(seg -> {
                Point p0 = ptm.getScreenPoint(seg.getP0());
                Point p1 = ptm.getScreenPoint(seg.getP1());
                g.drawLine(p0.x, p0.y, p1.x, p1.y);
            });
        } else if (geom instanceof APolygon) {
            Polygon poly = ptm.getScreenPolygon((APolygon)geom);
            if (poly.npoints == 2) {
                g.drawLine(poly.xpoints[0], poly.ypoints[0], poly.xpoints[1], poly.ypoints[1]);
            } else {
                g.fillPolygon(poly);
            }
        } else if (geom instanceof ACircle) {
            g.fill(ptm.getScreenCircle((ACircle)geom));
        }
    }

    public static ALine extendsTo(ALine l, ARect bounds) {
        if (!1.$assertionsDisabled && bounds == null) {
            throw new AssertionError();
        }
        bounds = bounds.normalize();
        Point bll = new Point((int)bounds.getLL().getX(), (int)bounds.getLL().getY());
        long bllx = (long)bll.getX();
        long blly = (long)bll.getY();
        Point bur = new Point((int)bounds.getUR().getX(), (int)bounds.getUR().getY());
        long burx = (long)bur.getX();
        long bury = (long)bur.getY();
        if (l.isHorizontal()) {
            return new ALine(bllx, l.getP0().getY(), burx, l.getP0().getY());
        }
        if (l.isVertical()) {
            return new ALine(l.getP0().getX(), blly, l.getP0().getX(), bury);
        }
        double y2 = l.getP1().getY();
        double y1 = l.getP0().getY();
        double x2 = l.getP1().getX();
        double x1 = l.getP0().getX();
        double m = (y2 - y1) / (x2 - x1);
        double c = y2 - m * x2;
        long lly = Math.min(Math.max(PartitionToolModeOverlayDrawer.getYFromLine(m, c, bllx), blly), bury);
        long llx = PartitionToolModeOverlayDrawer.getXFromLine(m, c, lly);
        long ury = Math.min(Math.max(PartitionToolModeOverlayDrawer.getYFromLine(m, c, burx), blly), bury);
        long urx = PartitionToolModeOverlayDrawer.getXFromLine(m, c, ury);
        return new ALine(llx, lly, urx, ury);
    }

    public static long getXFromLine(double m, double c, long y) {
        return (long)(((double)y - c) / m);
    }

    public static long getYFromLine(double m, double c, long x) {
        return (long)(m * (double)x + c);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

