/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.Unit;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.ALineBorder;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.UserUnitsPanel;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class PartitionToolModeUI {
    private DesignView2D mView;
    protected AFloatWindow mWindow;
    protected String mWindowTitle = "Partition";
    protected JPanel mPnlInteractiveRulerStatus;
    protected JTextField mTxtRef1;
    private JTextField mTxtInvisibleRef1X = new JTextField("0");
    private JTextField mTxtInvisibleRef1Y = new JTextField("0");
    protected JTextField mTxtRef2;
    private JTextField mTxtInvisibleRef2X = new JTextField("0");
    private JTextField mTxtInvisibleRef2Y = new JTextField("0");
    protected JTextField mTxtCutLine;
    private JTextField mTxtInvisibleCutLineX = new JTextField("0");
    private JTextField mTxtInvisibleCutLineY = new JTextField("0");
    protected boolean mWasVisible;
    private JComboBox<String> mMbCutLineAngle;
    private JTextField mTxtCutLineDivisionRatioDenominator;
    private JTextField mTxtCutLineOffsetX;
    private JTextField mTxtCutLineOffsetY;
    private JCheckBox mCbSlideByOffset;
    private JTextField mTxtSlideOffset;
    private UserUnitsPanel mUnitsPanel = null;
    private JTextField mTxtDx;
    private JTextField mTxtDy;
    private JTextField mTxtDt;
    private JTextField mTxtDir;
    private JTextField mTxtInvisibleDx = new JTextField("0");
    private JTextField mTxtInvisibleDy = new JTextField("0");
    private JTextField mTxtInvisibleDt = new JTextField("0");
    private String mFloatDisplayFormat = null;
    protected String mPointDisplayFormat = null;
    private String mHorizontalLineDisplayFormat = null;
    private String mVerticalLineDisplayFormat = null;
    private JToggleButton mBtnDrawMode;
    private JToggleButton mBtnDeleteMode;
    private JToggleButton mBtnSlideMode;
    ComponentListener mViewComponentListener = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent e) {
            PartitionToolModeUI.this.mWasVisible = PartitionToolModeUI.this.mWindow.isVisible();
            PartitionToolModeUI.this.mWindow.setVisible(false);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (PartitionToolModeUI.this.mWasVisible) {
                if (PartitionToolModeUI.this.mWindow != null) {
                    PartitionToolModeUI.this.mWindow.pack();
                    PartitionToolModeUI.this.mWindow.setVisible(true);
                }
                PartitionToolModeUI.this.refocusView();
            }
        }
    };
    PartitionToolMode.StateMachine mSM = null;
    static final String[] kAngles = new String[]{"90", "180"};
    static final int kAngle90 = 0;
    static final int kAngle180 = 1;
    JPanel mPanelDrawOptions;
    JPanel mPanelSlideOptions;
    JButton mBtnUndo;
    JButton mBtnRedo;
    private Mode mMode = Mode.draw;
    private Map<Component, Boolean> mEnabledState = new HashMap<Component, Boolean>();
    private APair<Long, Long> mSlideLimit;

    private void updateInvisibleFields(APoint2D ref1, APoint2D ref2, APoint2D cutLineX, APoint2D cutLineY) {
        Unit unit = this.getUnitDist();
        if (ref1 != null) {
            this.mTxtInvisibleRef1X.setText(String.valueOf(unit.toUser(ref1.getX())));
            this.mTxtInvisibleRef1Y.setText(String.valueOf(unit.toUser(ref1.getY())));
        }
        this.mTxtInvisibleRef1X.setEnabled(ref1 != null);
        if (ref2 != null) {
            this.mTxtInvisibleRef2X.setText(String.valueOf(unit.toUser(ref2.getX())));
            this.mTxtInvisibleRef2Y.setText(String.valueOf(unit.toUser(ref2.getY())));
        }
        this.mTxtInvisibleRef2X.setEnabled(ref2 != null);
        if (cutLineX != null) {
            this.mTxtInvisibleCutLineX.setText(String.valueOf(unit.toUser(cutLineX.getX())));
        }
        this.mTxtInvisibleCutLineX.setEnabled(cutLineX != null);
        if (cutLineY != null) {
            this.mTxtInvisibleCutLineY.setText(String.valueOf(unit.toUser(cutLineY.getY())));
        }
        this.mTxtInvisibleCutLineY.setEnabled(cutLineY != null);
        if (ref1 != null && ref2 != null) {
            long x1 = ref1.getX();
            long y1 = ref1.getY();
            long x2 = ref2.getX();
            long y2 = ref2.getY();
            long dx = x2 - x1;
            long dy = y2 - y1;
            long dt = (long)Math.hypot(dx, dy);
            this.mTxtInvisibleDx.setText(String.valueOf(unit.toUser(dx)));
            this.mTxtInvisibleDy.setText(String.valueOf(unit.toUser(dy)));
            this.mTxtInvisibleDt.setText(String.valueOf(unit.toUser(dt)));
        }
        this.mTxtInvisibleDx.setEnabled(ref1 != null && ref2 != null);
        this.mTxtInvisibleDy.setEnabled(ref1 != null && ref2 != null);
        this.mTxtInvisibleDt.setEnabled(ref1 != null && ref2 != null);
    }

    private void updateVisibleFields(APoint2D ref1, APoint2D ref2, boolean isTriggeredByUnitChange) {
        try {
            if (this.mTxtInvisibleRef1X.isEnabled()) {
                double ref1x = Double.parseDouble(this.mTxtInvisibleRef1X.getText());
                double ref1y = Double.parseDouble(this.mTxtInvisibleRef1Y.getText());
                this.mTxtRef1.setText(String.format(this.mPointDisplayFormat, ref1x, ref1y));
            } else {
                this.mTxtRef1.setText("");
            }
            if (this.mTxtInvisibleRef2X.isEnabled()) {
                double ref2x = Double.parseDouble(this.mTxtInvisibleRef2X.getText());
                double ref2y = Double.parseDouble(this.mTxtInvisibleRef2Y.getText());
                this.mTxtRef2.setText(String.format(this.mPointDisplayFormat, ref2x, ref2y));
            } else {
                this.mTxtRef2.setText("");
            }
            if (this.mTxtInvisibleCutLineX.isEnabled()) {
                double cutLineX = Double.parseDouble(this.mTxtInvisibleCutLineX.getText());
                this.mTxtCutLine.setText(String.format(this.mVerticalLineDisplayFormat, cutLineX));
            } else if (this.mTxtInvisibleCutLineY.isEnabled()) {
                double cutLineY = Double.parseDouble(this.mTxtInvisibleCutLineY.getText());
                this.mTxtCutLine.setText(String.format(this.mHorizontalLineDisplayFormat, cutLineY));
            } else {
                this.mTxtCutLine.setText("");
            }
            if (this.mTxtInvisibleDx.isEnabled()) {
                double dx = Double.parseDouble(this.mTxtInvisibleDx.getText());
                this.mTxtDx.setText(String.format(this.mFloatDisplayFormat, dx));
            } else {
                this.mTxtDx.setText("");
            }
            if (this.mTxtInvisibleDy.isEnabled()) {
                double dy = Double.parseDouble(this.mTxtInvisibleDy.getText());
                this.mTxtDy.setText(String.format(this.mFloatDisplayFormat, dy));
            } else {
                this.mTxtDy.setText("");
            }
            if (this.mTxtInvisibleDt.isEnabled()) {
                double dt = Double.parseDouble(this.mTxtInvisibleDt.getText());
                this.mTxtDt.setText(String.format(this.mFloatDisplayFormat, dt));
            } else {
                this.mTxtDt.setText("");
            }
            if (!isTriggeredByUnitChange) {
                if (ref1 != null && ref2 != null) {
                    long x1 = ref1.getX();
                    long y1 = ref1.getY();
                    long x2 = ref2.getX();
                    long y2 = ref2.getY();
                    double dx = x2 - x1;
                    double dy = y2 - y1;
                    double angle = 0.0;
                    if (dx == 0.0 && dy == 0.0) {
                        angle = 0.0;
                    } else if (dx == 0.0) {
                        angle = dy > 0.0 ? 90.0 : 270.0;
                    } else if (dy == 0.0) {
                        angle = dx > 0.0 ? 0.0 : 180.0;
                    } else {
                        angle = Math.atan(dy / dx) * 180.0 / Math.PI;
                        if (dx < 0.0) {
                            angle += 180.0;
                        } else if (dy < 0.0) {
                            angle += 360.0;
                        }
                    }
                    this.mTxtDir.setText(String.format(this.mFloatDisplayFormat, angle));
                } else {
                    this.mTxtDir.setText("");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateStatus(APoint2D start, APoint2D end, APoint2D cutLineX, APoint2D cutLineY, boolean isFinal) {
        this.updateInvisibleFields(start, end, cutLineX, cutLineY);
        this.updateVisibleFields(start, end, false);
        if (!isFinal) {
            this.mWindow.setTitle(this.mWindowTitle + " *");
        } else {
            this.mWindow.setTitle(this.mWindowTitle);
        }
    }

    public static PartitionToolModeUI newInstance(DesignView2D view, String title, PartitionToolMode ptm, JCheckBox[] snapObjTypes, JCheckBox[] snapLocTypes, Runnable callbackOnModeChange, Runnable callbackOnClosingWindow) {
        return new PartitionToolModeUI(view, title, ptm, snapObjTypes, snapLocTypes, callbackOnModeChange, callbackOnClosingWindow);
    }

    public void setStateMachine(PartitionToolMode.StateMachine sm) {
        this.mSM = sm;
    }

    private PartitionToolModeUI(DesignView2D view, String title, PartitionToolMode ptm, JCheckBox[] snapObjTypes, JCheckBox[] snapLocTypes, Runnable callbackOnModeChange, final Runnable callbackOnClosingWindow) {
        this.mView = view;
        this.setupDisplayFormat(view);
        this.mWindow = AFloatWindow.createInstance(UIUtil.getParentWindow((Component)view), this.mWindowTitle, false);
        GridBagManager l = new GridBagManager(this.mWindow.getContentPane());
        this.mWindow.setForcePinned(true);
        l.push((GridBagConstraints)GridBagManager.FILLALL);
        this.addModeButtons(l, callbackOnModeChange);
        l.newline();
        this.addDrawOptions(l);
        this.addSlideOptions(l);
        this.getEnabledChildrenState(this.mPanelSlideOptions);
        this.setEnabledChildren(this.mPanelSlideOptions, false);
        this.addMeasurement(l);
        l.addFillY();
        l.pop();
        JPanel options = this.createOptionsPanel(snapObjTypes, snapLocTypes);
        l.push((GridBagConstraints)GridBagManager.FILLALL);
        l.add((Component)options);
        l.newline();
        l.addFillY();
        l.pop();
        l.newline();
        this.mUnitsPanel = new UserUnitsPanel(this.getUnitDist());
        l.addNl((Component)this.mUnitsPanel, (GridBagConstraints)GridBagManager.LEFT);
        l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        this.addDoButtons(l);
        JButton btnExportPartition = (JButton)l.add((Component)new JButton("Partition"), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        this.makeSmallButton(btnExportPartition);
        btnExportPartition.addActionListener(e -> {
            if (this.mSM != null) {
                this.mSM.exportPortitionWithOptionallyRemoveExistingChildren();
            }
        });
        l.pop();
        l.newline();
        this.mWindow.pack();
        Rectangle viewBounds = view.getBounds();
        Point p = new Point(viewBounds.x + viewBounds.width / 2 - this.mWindow.getBounds().width / 2, viewBounds.y + viewBounds.height);
        SwingUtilities.convertPointToScreen(p, view.getParent());
        this.mWindow.setLocation(p);
        this.mWindow.setVisible(true);
        this.mWasVisible = true;
        this.mWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                SwingUtilities.invokeLater(() -> {
                    PartitionToolModeUI.this.mWindow = null;
                    callbackOnClosingWindow.run();
                });
            }
        });
        view.addComponentListener(this.mViewComponentListener);
        DocumentListener invisibleFieldsDocumentListener = new DocumentListener(){

            void updateVisibles() {
                PartitionToolModeUI.this.updateVisibleFields(null, null, true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateVisibles();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateVisibles();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateVisibles();
            }
        };
        this.mTxtInvisibleRef1X.getDocument().addDocumentListener(invisibleFieldsDocumentListener);
        this.mTxtInvisibleRef1Y.getDocument().addDocumentListener(invisibleFieldsDocumentListener);
        this.mTxtInvisibleRef2X.getDocument().addDocumentListener(invisibleFieldsDocumentListener);
        this.mTxtInvisibleRef2Y.getDocument().addDocumentListener(invisibleFieldsDocumentListener);
        this.mTxtInvisibleCutLineX.getDocument().addDocumentListener(invisibleFieldsDocumentListener);
        this.mTxtInvisibleCutLineY.getDocument().addDocumentListener(invisibleFieldsDocumentListener);
        this.mTxtInvisibleDx.getDocument().addDocumentListener(invisibleFieldsDocumentListener);
        this.mTxtInvisibleDy.getDocument().addDocumentListener(invisibleFieldsDocumentListener);
        this.mTxtInvisibleDt.getDocument().addDocumentListener(invisibleFieldsDocumentListener);
        this.mUnitsPanel.addTextField(this.mTxtCutLineOffsetX);
        this.mUnitsPanel.addTextField(this.mTxtCutLineOffsetY);
        this.mUnitsPanel.addTextField(this.mTxtSlideOffset);
        this.mUnitsPanel.addTextField(this.mTxtInvisibleRef1X);
        this.mUnitsPanel.addTextField(this.mTxtInvisibleRef1Y);
        this.mUnitsPanel.addTextField(this.mTxtInvisibleRef2X);
        this.mUnitsPanel.addTextField(this.mTxtInvisibleRef2Y);
        this.mUnitsPanel.addTextField(this.mTxtInvisibleCutLineX);
        this.mUnitsPanel.addTextField(this.mTxtInvisibleCutLineY);
        this.mUnitsPanel.addTextField(this.mTxtInvisibleDx);
        this.mUnitsPanel.addTextField(this.mTxtInvisibleDy);
        this.mUnitsPanel.addTextField(this.mTxtInvisibleDt);
        this.mTxtRef1.setFocusable(false);
        this.mTxtRef2.setFocusable(false);
        this.mTxtCutLine.setFocusable(false);
        this.mTxtDx.setFocusable(false);
        this.mTxtDy.setFocusable(false);
        this.mTxtDt.setFocusable(false);
        this.mTxtDir.setFocusable(false);
    }

    public Unit getUnitDist() {
        if (this.mUnitsPanel != null) {
            return this.mUnitsPanel.getUnit();
        }
        return this.mView.getUnit();
    }

    private void setupDisplayFormat(DesignView2D view) {
        Unit unit = view.getUnit();
        this.mFloatDisplayFormat = "%,.4f";
        if (unit != null) {
            this.mFloatDisplayFormat = unit.getShortFormat();
        }
        this.mPointDisplayFormat = String.format("(%s, %s)", this.mFloatDisplayFormat, this.mFloatDisplayFormat);
        this.mVerticalLineDisplayFormat = String.format(" X = %s", this.mFloatDisplayFormat);
        this.mHorizontalLineDisplayFormat = String.format(" Y = %s", this.mFloatDisplayFormat);
    }

    private void addModeButtons(GridBagManager l, Runnable callbackOnModeChange) {
        this.mBtnDrawMode = new JToggleButton();
        this.mBtnDrawMode.setSelected(true);
        this.mBtnDeleteMode = new JToggleButton();
        this.mBtnDeleteMode.setSelected(false);
        this.mBtnSlideMode = new JToggleButton();
        this.mBtnSlideMode.setSelected(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mBtnDrawMode);
        group.add(this.mBtnDeleteMode);
        group.add(this.mBtnSlideMode);
        this.mBtnDrawMode.setAction(new ModeAction(UIUtil.getScaledIcon((Icon)OrbitIcons.ADD, (int)16, (int)16), "Add a partition segment", callbackOnModeChange));
        this.mBtnDeleteMode.setAction(new ModeAction(UIUtil.getScaledIcon((Icon)OrbitIcons.CROSS, (int)16, (int)16), "Delete partition segment(s)", callbackOnModeChange));
        this.mBtnSlideMode.setAction(new ModeAction(UIUtil.getScaledIcon((Icon)OrbitIcons.MOVE_DEVICE, (int)16, (int)16), "Move partition segment(s)", callbackOnModeChange));
        UIUtil.makeToolBarButton((AbstractButton)this.mBtnDrawMode);
        UIUtil.makeToolBarButton((AbstractButton)this.mBtnDeleteMode);
        UIUtil.makeToolBarButton((AbstractButton)this.mBtnSlideMode);
        l.push("Mode", (GridBagConstraints)GridBagManager.FILLX);
        l.add((Component)this.mBtnDrawMode, (GridBagConstraints)GridBagManager.LEFT);
        l.add((Component)this.mBtnSlideMode, (GridBagConstraints)GridBagManager.LEFT);
        l.add((Component)this.mBtnDeleteMode, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.popNl();
    }

    private void addDoButtons(GridBagManager l) {
        this.mBtnUndo = (JButton)l.add((Component)new JButton("Undo"), (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnUndo.setIcon(OrbitIcons.UNDO);
        this.mBtnUndo.setEnabled(false);
        this.makeSmallButton(this.mBtnUndo);
        this.mBtnRedo = (JButton)l.add((Component)new JButton("Redo"), (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnRedo.setIcon(OrbitIcons.REDO);
        this.mBtnRedo.setEnabled(false);
        this.makeSmallButton(this.mBtnRedo);
        JButton btnApply = (JButton)l.add((Component)new JButton("Apply"), (GridBagConstraints)GridBagManager.LEFT);
        this.makeSmallButton(btnApply);
        this.mBtnUndo.addActionListener(e -> {
            if (this.mSM != null) {
                this.mSM.undoEdit();
            }
        });
        this.mBtnRedo.addActionListener(e -> {
            if (this.mSM != null) {
                this.mSM.redoEdit();
            }
        });
        btnApply.addActionListener(e -> {
            if (this.mSM != null) {
                this.mSM.onSpace();
            }
        });
    }

    public void updateUndoRedoStatus(boolean canUndo, boolean canRedo) {
        this.mBtnUndo.setEnabled(canUndo);
        this.mBtnRedo.setEnabled(canRedo);
    }

    private void addMeasurement(GridBagManager l) {
        l.push("Measure", (GridBagConstraints)GridBagManager.FILLX);
        this.mPnlInteractiveRulerStatus = l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.indent());
        this.mTxtRef1 = this.addFloatDisplay(l, "Ref1", 2);
        l.newline();
        this.mTxtRef2 = this.addFloatDisplay(l, "Ref2", 2);
        l.newline();
        this.mTxtCutLine = this.addFloatDisplay(l, "Cut Line", 2);
        l.newline();
        this.mTxtDx = this.addFloatDisplay(l, "Horizontal", 1);
        l.newline();
        this.mTxtDy = this.addFloatDisplay(l, "Vertical", 1);
        l.newline();
        this.mTxtDt = this.addFloatDisplay(l, "Total", 1);
        l.newline();
        this.mTxtDir = this.addFloatDisplay(l, "Direction", 1);
        l.popNl();
        l.addFillX();
        l.popNl();
    }

    private void addDrawOptions(GridBagManager l) {
        JPanel panel = l.push("Draw Options", (GridBagConstraints)GridBagManager.FILLX);
        JPanel leftPanel = new JPanel();
        l.push((Container)leftPanel, (GridBagConstraints)GridBagManager.TOPLEFT);
        final JRadioButton buttonDivisionRatio = (JRadioButton)l.add((Component)new JRadioButton("By Ratio"), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
        String kButtionDivisionRatio = "rbDivisionRatio";
        buttonDivisionRatio.setActionCommand("rbDivisionRatio");
        buttonDivisionRatio.setSelected(true);
        l.add((Component)new JLabel("1 /"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.mTxtCutLineDivisionRatioDenominator = (JTextField)l.add((Component)new JTextField("2", 5), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
        UIUtil.setMinToPref((Component)this.mTxtCutLineDivisionRatioDenominator);
        this.mTxtCutLineDivisionRatioDenominator.setEnabled(true);
        l.addFillX();
        l.newline();
        l.push((Container)new JPanel(), new GridBagConstraints());
        final JRadioButton buttonCutLineOffset = (JRadioButton)l.add((Component)new JRadioButton("By Offset"), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
        String kButtonDistance = "rbDistance";
        buttonCutLineOffset.setActionCommand("rbDistance");
        l.add((Component)new JLabel("X:"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
        this.mTxtCutLineOffsetX = (JTextField)l.add((Component)new JTextField("0", 5), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
        UIUtil.setMinToPref((Component)this.mTxtCutLineOffsetX);
        this.mTxtCutLineOffsetX.setEnabled(false);
        l.add((Component)new JLabel("Y:"));
        this.mTxtCutLineOffsetY = (JTextField)l.add((Component)new JTextField("0", 5), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
        UIUtil.setMinToPref((Component)this.mTxtCutLineOffsetY);
        this.mTxtCutLineOffsetY.setEnabled(false);
        l.popNl();
        l.add((Component)new JLabel("Angle:"), (GridBagConstraints)GridBagManager.LEFT);
        this.mMbCutLineAngle = (JComboBox)l.add(new JComboBox<String>(kAngles), (GridBagConstraints)GridBagManager.LEFT);
        this.mMbCutLineAngle.setSelectedIndex(0);
        l.addFillX();
        l.popNl();
        this.mPanelDrawOptions = panel;
        ButtonGroup group = new ButtonGroup();
        group.add(buttonDivisionRatio);
        group.add(buttonCutLineOffset);
        ActionListener buttonActionListener = e -> {
            boolean isSelectedButtonDistance = buttonCutLineOffset.isSelected();
            boolean isSelectedButtonDivision = buttonDivisionRatio.isSelected();
            this.mTxtCutLineOffsetX.setEnabled(isSelectedButtonDistance);
            this.mTxtCutLineOffsetY.setEnabled(isSelectedButtonDistance);
            this.mTxtCutLineDivisionRatioDenominator.setEnabled(isSelectedButtonDivision);
            if (isSelectedButtonDivision) {
                this.updateDivisionRatioFromUI();
            } else {
                this.updateCutLineOffsetFromUI();
            }
        };
        buttonDivisionRatio.addActionListener(buttonActionListener);
        buttonCutLineOffset.addActionListener(buttonActionListener);
        DocumentListener divisionRatioDocumentListener = new DocumentListener(){

            void updateDivisionRatio() {
                if (buttonDivisionRatio.isSelected()) {
                    SwingUtilities.invokeLater(() -> PartitionToolModeUI.this.updateDivisionRatioFromUI());
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateDivisionRatio();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateDivisionRatio();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateDivisionRatio();
            }
        };
        this.mTxtCutLineDivisionRatioDenominator.getDocument().addDocumentListener(divisionRatioDocumentListener);
        DocumentListener cutLineOffsetDocumentListener = new DocumentListener(){

            void updateOffset() {
                if (buttonCutLineOffset.isSelected()) {
                    SwingUtilities.invokeLater(() -> PartitionToolModeUI.this.updateCutLineOffsetFromUI());
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateOffset();
            }
        };
        this.mTxtCutLineOffsetX.getDocument().addDocumentListener(cutLineOffsetDocumentListener);
        this.mTxtCutLineOffsetY.getDocument().addDocumentListener(cutLineOffsetDocumentListener);
        ActionListener offsetEntered = e -> {
            if (buttonCutLineOffset.isSelected()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.mSM != null) {
                        this.mSM.onOffsetEntered();
                    }
                });
            }
        };
        this.mTxtCutLineOffsetX.addActionListener(offsetEntered);
        this.mTxtCutLineOffsetY.addActionListener(offsetEntered);
        this.mMbCutLineAngle.addActionListener(e -> {
            int angle = this.mMbCutLineAngle.getSelectedIndex();
            if (this.mSM != null) {
                this.mSM.setCutLineAngle(angle == 0 ? 90 : 180);
            }
        });
    }

    private JPanel addSlideOptions(GridBagManager l) {
        JPanel panel = l.push("Slide Option", (GridBagConstraints)GridBagManager.FILLX);
        this.mCbSlideByOffset = (JCheckBox)l.add((Component)new JCheckBox("Offset:"), (GridBagConstraints)GridBagManager.LEFT);
        this.mCbSlideByOffset.setSelected(true);
        this.mTxtSlideOffset = (JTextField)l.add((Component)new JTextField("0", 5), (GridBagConstraints)GridBagManager.LEFT);
        this.mTxtSlideOffset.setEnabled(false);
        l.addFillX();
        l.newline();
        l.popNl();
        this.mPanelSlideOptions = panel;
        this.mCbSlideByOffset.addActionListener(e -> {
            boolean isSelected = this.mCbSlideByOffset.isSelected();
            SwingUtilities.invokeLater(() -> {
                if (isSelected && this.mSM != null) {
                    this.mSM.onSlideOffsetTurnedOn();
                }
                this.enableSlideOffsetFields(isSelected);
                this.updateSlideOffsetFromUI(isSelected);
            });
        });
        DocumentListener slideOffsetDocumentListener = new DocumentListener(){

            void updateSlideOffset() {
                if (PartitionToolModeUI.this.mCbSlideByOffset.isSelected()) {
                    SwingUtilities.invokeLater(() -> PartitionToolModeUI.this.updateSlideOffsetFromUI(true));
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateSlideOffset();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateSlideOffset();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateSlideOffset();
            }
        };
        this.mTxtSlideOffset.getDocument().addDocumentListener(slideOffsetDocumentListener);
        this.mTxtSlideOffset.addActionListener(e -> {
            if (this.mCbSlideByOffset.isSelected()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.mSM != null) {
                        this.mSM.onOffsetEntered();
                    }
                });
            }
        });
        return panel;
    }

    public Mode getMode() {
        return this.mMode;
    }

    public void setMode(Mode mode) {
        ModeAction action = null;
        switch (mode) {
            case draw: {
                action = (ModeAction)this.mBtnDrawMode.getAction();
                break;
            }
            case delete: {
                action = (ModeAction)this.mBtnDeleteMode.getAction();
                break;
            }
            case slide: {
                action = (ModeAction)this.mBtnSlideMode.getAction();
            }
        }
        if (action != null) {
            action.actionPerformed(null);
        }
    }

    private void enableOptionsByMode() {
        if (this.mPanelDrawOptions.isEnabled()) {
            this.getEnabledChildrenState(this.mPanelDrawOptions);
        }
        if (this.mPanelSlideOptions.isEnabled()) {
            this.getEnabledChildrenState(this.mPanelSlideOptions);
        }
        switch (this.mMode) {
            case draw: {
                this.setEnabledChildren(this.mPanelDrawOptions, true);
                this.setEnabledChildren(this.mPanelSlideOptions, false);
                break;
            }
            case delete: {
                this.setEnabledChildren(this.mPanelDrawOptions, false);
                this.setEnabledChildren(this.mPanelSlideOptions, false);
                break;
            }
            case slide: {
                this.setEnabledChildren(this.mPanelDrawOptions, false);
                this.setEnabledChildren(this.mPanelSlideOptions, true);
            }
        }
    }

    private void getEnabledChildrenState(Component component) {
        this.mEnabledState.put(component, component.isEnabled());
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                this.getEnabledChildrenState(child);
            }
        }
    }

    private void setEnabledChildren(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                this.setEnabledChildren(child, enabled);
            }
        }
    }

    public int getCutLineAngle() {
        return this.mMbCutLineAngle.getSelectedIndex() == 0 ? 90 : 180;
    }

    public int toggleCutLineAngle() {
        int index = this.mMbCutLineAngle.getSelectedIndex();
        index = index == 0 ? 1 : 0;
        this.mMbCutLineAngle.setSelectedIndex(index);
        return this.getCutLineAngle();
    }

    public void reset() {
        if (this.mWindow != null) {
            UIUtil.closeWindow((Window)((Object)this.mWindow));
        }
    }

    private JPanel createOptionsPanel(JCheckBox[] snapObjTypes, JCheckBox[] snapLocTypes) {
        JPanel p = new JPanel();
        GridBagManager l = GridBagManager.layout((Container)p);
        l.addNl("Snap to:", (GridBagConstraints)GridBagManager.LEFT.noInsets());
        for (JCheckBox cb : snapObjTypes) {
            l.addNl((Component)cb, (GridBagConstraints)GridBagManager.LEFT.noInsets());
        }
        ((JLabel)l.addNl((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets())).setBorder(new ALineBorder(this.mWindow.getForeground(), 0, 0, 1, 0));
        for (JCheckBox cb : snapLocTypes) {
            l.addNl((Component)cb, (GridBagConstraints)GridBagManager.LEFT.noInsets());
        }
        return p;
    }

    private JTextField addFloatDisplay(GridBagManager l, String lbl, int floatCount, Integer insetBottom) {
        GridBagManager.GridBagConstraintsEx gbcLbl = GridBagManager.LEFT.insetTop(0);
        if (insetBottom != null) {
            gbcLbl = gbcLbl.insetBottom(insetBottom.intValue());
        }
        l.add(lbl + ": ", (GridBagConstraints)gbcLbl);
        JTextField tf = new JTextField(8 * floatCount);
        tf.setBorder(null);
        tf.setEditable(false);
        UIUtil.addCopySupport((JTextComponent)tf);
        tf.setFont(tf.getFont().deriveFont(1));
        GridBagManager.GridBagConstraintsEx gbcTxt = GridBagManager.FILLX.insetTop(0);
        if (insetBottom != null) {
            gbcTxt = gbcTxt.insetBottom(insetBottom.intValue());
        }
        return (JTextField)l.add((Component)tf, (GridBagConstraints)gbcTxt);
    }

    private JTextField addFloatDisplay(GridBagManager l, String lbl, int floatCount) {
        return this.addFloatDisplay(l, lbl, floatCount, null);
    }

    private void makeSmallButton(AbstractButton b) {
        UIUtil.makeFootButton((AbstractButton)b);
    }

    private void updateDivisionRatioFromUI() {
        try {
            int numerator = 1;
            int denominator = Integer.parseInt(this.mTxtCutLineDivisionRatioDenominator.getText());
            if (numerator < 0 || denominator < 0) {
                return;
            }
            if (this.mSM != null) {
                this.mSM.setCutLinePositionByDivision(numerator, denominator);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateCutLineOffsetFromUI() {
        ALog.logInfo((String)"updateCutLineOffsetFromUI:%s, %s", (Object[])new Object[]{this.mTxtCutLineOffsetX.getText(), this.mTxtCutLineOffsetY.getText()});
        if (this.mTxtCutLineOffsetX.getText().isEmpty() && this.mTxtCutLineOffsetY.getText().isEmpty()) {
            return;
        }
        Unit unit = this.getUnitDist();
        Long offsetX = unit.fromUserString(this.mTxtCutLineOffsetX.getText());
        Long offsetY = unit.fromUserString(this.mTxtCutLineOffsetY.getText());
        if (offsetX != null && offsetY != null && this.mSM != null) {
            this.mSM.setCutLinePositionByDistance(offsetX, offsetY);
        }
    }

    public void setSlideLimits(APair<Long, Long> range) {
        this.mSlideLimit = range;
        this.enableSlideOffsetFields(this.mCbSlideByOffset.isSelected());
    }

    private void enableSlideOffsetFields(boolean isSlideByOffsetOn) {
        this.mTxtSlideOffset.setEnabled(isSlideByOffsetOn);
    }

    private boolean isInOffsetRange(double offset) {
        if (this.mSlideLimit == null) {
            return true;
        }
        return offset >= (double)((Long)this.mSlideLimit.first).longValue() && offset <= (double)((Long)this.mSlideLimit.second).longValue();
    }

    private void updateSlideOffsetFromUI(boolean isByOffset) {
        APair<Boolean, Long> slideOffsetOption = this.getSlideOffsetOption();
        if (this.mSM != null) {
            this.mSM.setSlideOffset((Boolean)slideOffsetOption.first, (Long)slideOffsetOption.second);
        }
    }

    public APair<Boolean, Long> getSlideOffsetOption() {
        boolean isByOffset = this.mCbSlideByOffset.isSelected();
        if (!isByOffset) {
            return new APair((Object)false, (Object)0L);
        }
        Unit unit = this.getUnitDist();
        if (this.mTxtSlideOffset.getText().isEmpty()) {
            return new APair((Object)isByOffset, (Object)0L);
        }
        Long offset = unit.fromUserString(this.mTxtSlideOffset.getText());
        if (offset == null) {
            return new APair((Object)isByOffset, (Object)0L);
        }
        if (!this.isInOffsetRange(offset.longValue())) {
            offset = offset < 0L ? (Long)this.mSlideLimit.first : (Long)this.mSlideLimit.second;
            long offsetCopy = offset;
            SwingUtilities.invokeLater(() -> this.mTxtSlideOffset.setText(unit.toUserStr(offsetCopy)));
        }
        return new APair((Object)isByOffset, (Object)offset);
    }

    private void refocusView() {
        EventQueue.invokeLater(() -> {
            Window parentWin;
            if (this.mWindow.isActive() && (parentWin = UIUtil.getParentWindow((Component)this.mView)) != null) {
                parentWin.setVisible(true);
                this.mView.getCanvas().requestFocusInWindow();
            }
        });
    }

    public void promptOverwrite(Runnable callbackOverwrite, Runnable callbackAppend) {
        boolean kSelOverwrite = false;
        boolean kSelAppend = true;
        Object[] options = new Object[]{"Overwrite", "Append", "Cancel"};
        int sel = JOptionPane.showOptionDialog(UIUtil.getParentWindow((Component)this.mView), "Do you want to overwrite, i.e. delete all previously partition generated devices? Or just append without deleteing.", "Attention", -1, 3, null, options, options[0]);
        if (sel != -1) {
            SwingUtilities.invokeLater(() -> {
                if (sel == 0) {
                    callbackOverwrite.run();
                } else if (sel == 1) {
                    callbackAppend.run();
                }
            });
        }
    }

    private class ModeAction
    extends AbstractAction {
        Runnable mCallback;

        public ModeAction(Icon icon, String desc, Runnable callback) {
            this.putValue("ShortDescription", desc);
            this.putValue("SmallIcon", icon);
            this.mCallback = callback;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PartitionToolModeUI.this.mBtnDrawMode.isSelected() && PartitionToolModeUI.this.mMode != Mode.draw) {
                PartitionToolModeUI.this.mMode = Mode.draw;
            } else if (PartitionToolModeUI.this.mBtnDeleteMode.isSelected() && PartitionToolModeUI.this.mMode != Mode.delete) {
                PartitionToolModeUI.this.mMode = Mode.delete;
            } else if (PartitionToolModeUI.this.mBtnSlideMode.isSelected() && PartitionToolModeUI.this.mMode != Mode.slide) {
                PartitionToolModeUI.this.mMode = Mode.slide;
            }
            PartitionToolModeUI.this.enableOptionsByMode();
            if (this.mCallback != null) {
                this.mCallback.run();
            }
        }
    }

    public static enum Mode {
        draw,
        delete,
        slide;

    }
}

