/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.ui.partitionTool.LineAndIntersectedPoint;
import com.sigrity.orbit.ui.partitionTool.SRPoly;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

class PolyAndIntersections {
    final SRPoly poly;
    final List<LineAndIntersectedPoint> intersections;

    public SRPoly getPoly() {
        return this.poly;
    }

    public List<LineAndIntersectedPoint> getIntersections() {
        return this.intersections;
    }

    PolyAndIntersections(SRPoly poly, List<LineAndIntersectedPoint> intersections) {
        this.poly = poly;
        this.intersections = intersections;
    }

    List<ALine> getCuts() {
        List<Object> cuts = new LinkedList();
        for (int i = 0; i < this.intersections.size() - 1; ++i) {
            APoint2D pt0 = this.intersections.get(i).getPoint();
            for (int j = i + 1; j < this.intersections.size(); ++j) {
                APoint2D pt1 = this.intersections.get(j).getPoint();
                cuts.add(new ALine(pt0, pt1));
            }
        }
        cuts = cuts.stream().filter(c -> !this.poly.has((ALine)c)).filter(this.poly::isInside).collect(Collectors.toList());
        List twins = cuts.stream().map(ALine::reverse).filter(c -> !this.poly.has((ALine)c)).collect(Collectors.toList());
        cuts.addAll(twins);
        return cuts;
    }
}

