/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.GOD;
import com.sigrity.orbit.ui.partitionTool.LineAndIntersectedPoint;
import java.awt.geom.AffineTransform;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SRPoly {
    LinkedList<ALine> mSides = new LinkedList();
    boolean mHashCodeComputed = false;
    int mHashCode;
    Set<ALine> mHorizontalCross = new HashSet<ALine>();
    Set<ALine> mVerticalCross = new HashSet<ALine>();

    public boolean containReverse(List<SRPoly> polys) {
        return polys.stream().anyMatch(this::isReverse);
    }

    public List<ALine> getSides() {
        return this.mSides;
    }

    public ALine getLast() {
        return this.mSides.getLast();
    }

    public void setSides(LinkedList<ALine> sides) {
        this.mSides = sides;
    }

    public SRPoly reverseOrientation() {
        LinkedList<ALine> reverseSides = new LinkedList<ALine>();
        for (ALine s : this.mSides) {
            reverseSides.add(new ALine(s.getLastPoint(), s.getFirstPoint()));
        }
        Collections.reverse(reverseSides);
        return SRPoly.newInstance(reverseSides);
    }

    public APair<APoint2D, SRPoly> normalize(AffineTransform relative2TemplateXform, AGeomUtil.AboutPt originPosition) {
        if (originPosition != AGeomUtil.AboutPt.CENTER && originPosition != AGeomUtil.AboutPt.LL) {
            throw new IllegalArgumentException("Origin can only be at center or lower left corner!");
        }
        List relative2TemplateSides = this.mSides.stream().map(s -> s.transform(relative2TemplateXform)).collect(Collectors.toList());
        List allXs = relative2TemplateSides.stream().flatMap(s -> Stream.of(s.getFirstPoint().getX(), s.getLastPoint().getX())).collect(Collectors.toList());
        List allYs = relative2TemplateSides.stream().flatMap(s -> Stream.of(s.getFirstPoint().getY(), s.getLastPoint().getY())).collect(Collectors.toList());
        long xmin = allXs.stream().mapToLong(Long::longValue).min().getAsLong();
        long xmax = allXs.stream().mapToLong(Long::longValue).max().getAsLong();
        long ymin = allYs.stream().mapToLong(Long::longValue).min().getAsLong();
        long ymax = allYs.stream().mapToLong(Long::longValue).max().getAsLong();
        APoint2D origin = new APoint2D();
        if (originPosition == AGeomUtil.AboutPt.CENTER) {
            origin.setX((xmin + xmax) / 2L);
            origin.setY((ymin + ymax) / 2L);
        } else {
            origin.setX(xmin);
            origin.setY(ymin);
        }
        LinkedList<ALine> offsetSides = new LinkedList<ALine>();
        for (ALine s2 : relative2TemplateSides) {
            offsetSides.add(new ALine(s2.getFirstPoint().sub(origin), s2.getLastPoint().sub(origin)));
        }
        return new APair((Object)origin, (Object)SRPoly.newInstance(offsetSides));
    }

    public APair<APoint2D, SRPoly> normalize(AGeomUtil.AboutPt originPosition) {
        if (originPosition != AGeomUtil.AboutPt.CENTER && originPosition != AGeomUtil.AboutPt.LL) {
            throw new IllegalArgumentException("Origin can only be at center or lower left corner!");
        }
        List allXs = this.mSides.stream().flatMap(s -> Stream.of(s.getFirstPoint().getX(), s.getLastPoint().getX())).collect(Collectors.toList());
        List allYs = this.mSides.stream().flatMap(s -> Stream.of(s.getFirstPoint().getY(), s.getLastPoint().getY())).collect(Collectors.toList());
        long xmin = allXs.stream().mapToLong(Long::longValue).min().getAsLong();
        long xmax = allXs.stream().mapToLong(Long::longValue).max().getAsLong();
        long ymin = allYs.stream().mapToLong(Long::longValue).min().getAsLong();
        long ymax = allYs.stream().mapToLong(Long::longValue).max().getAsLong();
        APoint2D origin = new APoint2D();
        if (originPosition == AGeomUtil.AboutPt.CENTER) {
            origin.setX((xmin + xmax) / 2L);
            origin.setY((ymin + ymax) / 2L);
        } else {
            origin.setX(xmin);
            origin.setY(ymin);
        }
        LinkedList<ALine> offsetSides = new LinkedList<ALine>();
        for (ALine s2 : this.mSides) {
            offsetSides.add(new ALine(s2.getFirstPoint().sub(origin), s2.getLastPoint().sub(origin)));
        }
        return new APair((Object)origin, (Object)SRPoly.newInstance(offsetSides));
    }

    public APolygon toAPolygon() {
        LinkedList<APoint2D> points = new LinkedList<APoint2D>();
        for (ALine s : this.mSides) {
            points.add(s.getFirstPoint());
        }
        return new APolygon(points);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder((this.mSides.size() + 1) * 128);
        sb.append(String.format("%d sides:%n", this.mSides.size()));
        for (ALine s : this.mSides) {
            sb.append(s.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SRPoly)) {
            return false;
        }
        SRPoly other = (SRPoly)obj;
        if (this.mSides.size() != other.mSides.size()) {
            return false;
        }
        return this.mSides.stream().allMatch(s -> other.mSides.stream().anyMatch(arg_0 -> ((ALine)s).equals(arg_0)));
    }

    public int hashCode() {
        if (!this.mHashCodeComputed) {
            this.computeHashCode();
        }
        return this.mHashCode;
    }

    public boolean isClockwise() {
        return this.shoelaceSum().compareTo(BigInteger.ZERO) > 0;
    }

    private boolean hasCommonSides(SRPoly other) {
        return other.getSides().stream().anyMatch(s -> this.has((ALine)s) || this.has(s.reverse()));
    }

    public boolean enclosesAnySide(List<SRPoly> polys) {
        List questionables = polys.stream().filter(p -> !p.equals(this)).filter(this::hasCommonSides).collect(Collectors.toList());
        List inSidesOfOtherPolygons = questionables.stream().flatMap(p -> p.getSides().stream()).filter(s -> !this.has((ALine)s) && !this.has(s.reverse())).filter(this::isInside).collect(Collectors.toList());
        return !inSidesOfOtherPolygons.isEmpty();
    }

    public boolean isMinimal(List<SRPoly> polys) {
        List inSidesOfOtherPolygons = polys.stream().filter(p -> !p.equals(this)).flatMap(p -> p.getSides().stream()).filter(s -> !this.has((ALine)s) && !this.has(s.reverse())).filter(this::isInside).collect(Collectors.toList());
        return inSidesOfOtherPolygons.isEmpty();
    }

    public boolean isSameShape(SRPoly other) {
        return this.equals(other) || this.equals(other.reverseOrientation());
    }

    BigInteger shoelaceSum() {
        return this.mSides.stream().map(this::shoelace).reduce(BigInteger.ZERO, BigInteger::add);
    }

    BigInteger shoelace(ALine side) {
        APoint2D p0 = side.getFirstPoint();
        APoint2D p1 = side.getLastPoint();
        BigInteger p0x = BigInteger.valueOf(p0.getX());
        BigInteger p0y = BigInteger.valueOf(p0.getY());
        BigInteger p1x = BigInteger.valueOf(p1.getX());
        BigInteger p1y = BigInteger.valueOf(p1.getY());
        return p1x.subtract(p0x).multiply(p1y.add(p0y));
    }

    private void computeHashCode() {
        long sumOfFirstPointX = this.mSides.stream().mapToLong(s -> s.getFirstPoint().getX()).sum();
        this.mHashCode = new HashCodeBuilder(17, 37).append(sumOfFirstPointX).toHashCode();
        this.mHashCodeComputed = true;
    }

    public static SRPoly newInstance(ALine initialSide) {
        SRPoly p = new SRPoly();
        p.addSide(initialSide);
        return p;
    }

    public static SRPoly newInstance(SRPoly base, ALine tail) {
        SRPoly p = new SRPoly();
        for (ALine side : base.getSides()) {
            p.addSide(side);
        }
        p.addSide(tail);
        return p;
    }

    public static SRPoly newInstance(Set<ALine> sides) {
        SRPoly p = new SRPoly();
        ALine initialSide = sides.iterator().next();
        p.addSide(initialSide);
        APoint2D startPoint = initialSide.getFirstPoint();
        APoint2D currentEndpoint = initialSide.getLastPoint();
        try {
            do {
                ALine next = SRPoly.startWith(currentEndpoint, sides);
                currentEndpoint = next.getLastPoint();
                p.addSide(next);
            } while (!currentEndpoint.equals((Object)startPoint));
        }
        catch (Exception e) {
            ALog.logError((String)"Exception:%s @ SRPoly::newInstance", (Object[])new Object[]{e});
            p = null;
        }
        return p;
    }

    private static ALine startWith(APoint2D point, Set<ALine> sides) {
        return sides.stream().filter(s -> s.getFirstPoint().equals((Object)point)).findAny().orElse(null);
    }

    public static SRPoly newInstance(ALine[] array) {
        return SRPoly.newInstance(new ArrayList<ALine>(Arrays.asList(array)));
    }

    public static SRPoly newInstance(List<ALine> initialSides) {
        SRPoly p = new SRPoly();
        APoint2D expectPoint = null;
        try {
            for (ALine s : initialSides) {
                if (expectPoint != null && !expectPoint.equals((Object)s.getFirstPoint())) {
                    throw new IllegalArgumentException("Could not create a new instance as the initial sides are not connected in order!");
                }
                p.addSide(s);
                expectPoint = s.getLastPoint();
            }
        }
        catch (Exception e) {
            ALog.logError((String)"Exception %s with input: %s", (Object[])new Object[]{e.getMessage(), initialSides});
            p = null;
        }
        return p;
    }

    public boolean isInside(ALine side) {
        if (this.mHorizontalCross.isEmpty() && this.mVerticalCross.isEmpty()) {
            this.buildCrossInformation();
        }
        int nCrossedSides = side.isVertical() ? this.getNumCrossedHoriztonalSidesOnTheTop(side) : this.getNumCrossedVerticalSidesOnTheRight(side);
        return (nCrossedSides & 1) == 1;
    }

    /*
     * WARNING - void declaration
     */
    void buildCrossInformation() {
        this.mHorizontalCross.clear();
        this.mVerticalCross.clear();
        LinkedList<ALine> orderedHorizontalSides = new LinkedList<ALine>();
        LinkedList<ALine> orderedVerticalSides = new LinkedList<ALine>();
        for (ALine aLine : this.mSides) {
            if (aLine.isHorizontal()) {
                orderedHorizontalSides.add(aLine);
                continue;
            }
            orderedVerticalSides.add(aLine);
        }
        orderedHorizontalSides.add((ALine)orderedHorizontalSides.get(0));
        orderedVerticalSides.add((ALine)orderedVerticalSides.get(0));
        ALine prevHorizontalSide = null;
        for (ALine s : orderedHorizontalSides) {
            if (prevHorizontalSide != null && this.sameHorizontalDirection(s, prevHorizontalSide)) {
                this.mHorizontalCross.add(s);
            }
            prevHorizontalSide = s;
        }
        Object var4_6 = null;
        for (ALine s : orderedVerticalSides) {
            void var4_7;
            if (var4_7 != null && this.sameVerticalDirection(s, (ALine)var4_7)) {
                this.mVerticalCross.add(s);
            }
            ALine aLine = s;
        }
    }

    boolean sameHorizontalDirection(ALine s0, ALine s1) {
        return this.cmpZero(s0.dX()) * this.cmpZero(s1.dX()) > 0L;
    }

    boolean sameVerticalDirection(ALine s0, ALine s1) {
        return this.cmpZero(s0.dY()) * this.cmpZero(s1.dY()) > 0L;
    }

    private long cmpZero(long v) {
        return v < 0L ? -1L : (long)(v == 0L ? 0 : 1);
    }

    private boolean isIn(long v0, long v1, long v) {
        long min = Math.min(v0, v1);
        long max = Math.max(v0, v1);
        return v < max && v > min;
    }

    int getNumCrossedHoriztonalSidesOnTheTop(ALine verticalSide) {
        long x = verticalSide.getFirstPoint().getX();
        long y = (verticalSide.getFirstPoint().getY() + verticalSide.getLastPoint().getY()) / 2L;
        int type1Cross = (int)this.mSides.stream().filter(ALine::isHorizontal).filter(s -> s.getFirstPoint().getY() >= y).filter(s -> s.getFirstPoint().getX() == x).filter(s -> this.mHorizontalCross.contains(s)).count();
        int type2Cross = (int)this.mSides.stream().filter(ALine::isHorizontal).filter(s -> s.getFirstPoint().getY() >= y).filter(s -> this.isIn(s.getFirstPoint().getX(), s.getLastPoint().getX(), x)).count();
        return type1Cross + type2Cross;
    }

    int getNumCrossedVerticalSidesOnTheRight(ALine horizontalSide) {
        long x = (horizontalSide.getFirstPoint().getX() + horizontalSide.getLastPoint().getX()) / 2L;
        long y = horizontalSide.getFirstPoint().getY();
        int type1Cross = (int)this.mSides.stream().filter(ALine::isVertical).filter(s -> s.getFirstPoint().getX() >= x).filter(s -> s.getFirstPoint().getY() == y).filter(s -> this.mVerticalCross.contains(s)).count();
        int type2Cross = (int)this.mSides.stream().filter(ALine::isVertical).filter(s -> s.getFirstPoint().getX() >= x).filter(s -> this.isIn(s.getFirstPoint().getY(), s.getLastPoint().getY(), y)).count();
        return type1Cross + type2Cross;
    }

    public boolean isReverse(SRPoly other) {
        if (this.mSides.size() != other.mSides.size()) {
            return false;
        }
        return this.mSides.stream().allMatch(s -> other.has(s.reverse()));
    }

    public boolean addSide(ALine side) {
        assert (!this.has(side));
        this.mSides.add(side);
        this.mHashCodeComputed = false;
        return true;
    }

    public boolean canAddToTail(ALine side) {
        if (this.mSides.isEmpty()) {
            return true;
        }
        if (this.has(side) || this.has(side.reverse())) {
            return false;
        }
        return this.mSides.getLast().getLastPoint().equals((Object)side.getFirstPoint());
    }

    public Optional<ALine> findOneCanAddToTail(Map<APoint2D, ALine> linesByBeginpoint) {
        APoint2D currentEndpoint = this.mSides.getLast().getLastPoint();
        if (linesByBeginpoint.containsKey(currentEndpoint)) {
            return Optional.of(linesByBeginpoint.get(currentEndpoint));
        }
        return Optional.empty();
    }

    public boolean isClosed() {
        return this.mSides.isEmpty() ? false : this.mSides.getLast().getLastPoint().equals((Object)this.mSides.getFirst().getFirstPoint());
    }

    List<LineAndIntersectedPoint> getIntersectionsOnVerticalSides(ALine horizontalCut) {
        List verticalSides = this.mSides.stream().filter(ALine::isVertical).collect(Collectors.toList());
        long y = horizontalCut.getFirstPoint().getY();
        List<LineAndIntersectedPoint> intersections = verticalSides.stream().filter(s -> horizontalCut.xInOrOn(s.getFirstPoint().getX())).map(s -> new LineAndIntersectedPoint((ALine)s, new APoint2D(s.getFirstPoint().getX(), y))).collect(Collectors.toList());
        return intersections;
    }

    List<LineAndIntersectedPoint> getIntersectionsOnHorizontalSides(ALine verticalCut) {
        List horizontalSides = this.mSides.stream().filter(ALine::isHorizontal).collect(Collectors.toList());
        long x = verticalCut.getFirstPoint().getX();
        List<LineAndIntersectedPoint> intersections = horizontalSides.stream().filter(s -> verticalCut.yInOrOn(s.getFirstPoint().getY())).map(s -> new LineAndIntersectedPoint((ALine)s, new APoint2D(x, s.getFirstPoint().getY()))).collect(Collectors.toList());
        return intersections;
    }

    boolean has(ALine line) {
        return this.mSides.stream().anyMatch(s -> s.equals((Object)line));
    }

    public void testDebugGod(boolean reset) {
        if (reset) {
            GOD.reset();
        }
        GOD.setAutoClose((boolean)false);
        for (ALine l : this.mSides) {
            GOD.line((long)l.getFirstPoint().getX(), (long)l.getFirstPoint().getY(), (long)l.getLastPoint().getX(), (long)l.getLastPoint().getY(), (boolean)false);
        }
        GOD.flush();
        GOD.setAutoClose((boolean)true);
    }
}

