/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Segment {
    ALine mSide;
    ALine mTwinSide;

    public Segment(APoint2D p0, APoint2D p1) {
        this.mSide = new ALine(p0, p1);
        this.mTwinSide = new ALine(p1, p0);
    }

    public Segment(ALine line) {
        this.mSide = line;
        this.mTwinSide = new ALine(line.getLastPoint(), line.getFirstPoint());
    }

    public Segment(long l, long m, long n, long o) {
        this.mSide = new ALine(l, m, n, o);
        this.mTwinSide = new ALine(n, o, l, m);
    }

    public boolean contains(ALine side) {
        return this.mSide.equals((Object)side) || this.mTwinSide.equals((Object)side);
    }

    public Stream<ALine> getSides() {
        return Stream.of(this.mSide, this.mTwinSide);
    }

    public APoint2D getFirstPoint() {
        return this.mSide.getFirstPoint();
    }

    public APoint2D getLastPoint() {
        return this.mSide.getLastPoint();
    }

    public APoint2D getP0() {
        return this.mSide.getFirstPoint();
    }

    public APoint2D getP1() {
        return this.mSide.getLastPoint();
    }

    public boolean endsWith(APoint2D p) {
        return this.getFirstPoint().equals((Object)p) || this.getLastPoint().equals((Object)p);
    }

    public boolean isHorizontal() {
        return this.mSide.isHorizontal();
    }

    public boolean isVertical() {
        return this.mSide.isVertical();
    }

    public boolean sameOrientation(Segment other) {
        return this.mSide.isHorizontal() && other.mSide.isHorizontal() || this.mSide.isVertical() && other.mSide.isVertical();
    }

    public boolean isOrientedOverlappedWithAny(List<ALine> lines) {
        return lines.stream().anyMatch(this::overlapsAndSameOrientation);
    }

    public boolean overlapsAndSameOrientation(Segment other) {
        return this.overlapsAndSameOrientation(this.mSide, other.mSide);
    }

    public boolean overlapsAndSameOrientation(ALine line) {
        return this.overlapsAndSameOrientation(this.mSide, line);
    }

    private boolean horizontalLinesWithSameY(ALine l0, ALine l1) {
        return l0.isHorizontal() && l1.isHorizontal() && l0.getFirstPoint().getY() == l1.getFirstPoint().getY();
    }

    private boolean verticalLinesWithSameX(ALine l0, ALine l1) {
        return l0.isVertical() && l1.isVertical() && l0.getFirstPoint().getX() == l1.getFirstPoint().getX();
    }

    private boolean overlapsAndSameOrientation(ALine l0, ALine l1) {
        return this.horizontalLinesWithSameY(l0, l1) ? this.overlaps(l0.getFirstPoint().getX(), l0.getLastPoint().getX(), l1.getFirstPoint().getX(), l1.getLastPoint().getX()) : this.verticalLinesWithSameX(l0, l1) && this.overlaps(l0.getFirstPoint().getY(), l0.getLastPoint().getY(), l1.getFirstPoint().getY(), l1.getLastPoint().getY());
    }

    private boolean overlaps(long xy1, long xy2, long xy3, long xy4) {
        long t = xy1;
        xy1 = Math.min(t, xy2);
        xy2 = Math.max(t, xy2);
        t = xy3;
        xy3 = Math.min(t, xy4);
        xy4 = Math.max(t, xy4);
        if (xy3 >= xy1) {
            return xy3 <= xy2;
        }
        return xy1 <= xy4;
    }

    public boolean overlapsByMoreThan1Point(Segment other) {
        ALine l0 = this.mSide;
        ALine l1 = other.mSide;
        if (l0.getFirstPoint().equals((Object)l0.getLastPoint()) || l1.getFirstPoint().equals((Object)l1.getLastPoint())) {
            return false;
        }
        return l0.isHorizontal() && l1.isHorizontal() ? l0.getFirstPoint().getY() == l1.getFirstPoint().getY() && this.overlapsByMoreThan1Point(l0.getFirstPoint().getX(), l0.getLastPoint().getX(), l1.getFirstPoint().getX(), l1.getLastPoint().getX()) : l0.isVertical() && l1.isVertical() && l0.getFirstPoint().getX() == l1.getFirstPoint().getX() && this.overlapsByMoreThan1Point(l0.getFirstPoint().getY(), l0.getLastPoint().getY(), l1.getFirstPoint().getY(), l1.getLastPoint().getY());
    }

    private boolean overlapsByMoreThan1Point(long xy1, long xy2, long xy3, long xy4) {
        long t = xy1;
        xy1 = Math.min(t, xy2);
        xy2 = Math.max(t, xy2);
        t = xy3;
        xy3 = Math.min(t, xy4);
        xy4 = Math.max(t, xy4);
        if (xy3 >= xy1) {
            return xy3 < xy2;
        }
        return xy1 < xy4;
    }

    public static List<Segment> segmentsFromAny2NeighboringPoints(List<APoint2D> joints) {
        LinkedList<Segment> newSegments = new LinkedList<Segment>();
        APoint2D beginPoint = joints.get(0);
        for (APoint2D p : joints) {
            newSegments.add(new Segment(beginPoint, p));
            beginPoint = p;
        }
        newSegments.remove(0);
        return newSegments.stream().distinct().collect(Collectors.toList());
    }

    public static List<Segment> newSegmentsFromSortedJoints(List<Segment> overlappedSegments) {
        List<APoint2D> joints = overlappedSegments.stream().flatMap(os -> Stream.of(os.getFirstPoint(), os.getLastPoint())).distinct().sorted((p1, p2) -> p1.getX() == p2.getX() ? Long.compare(p1.getY(), p2.getY()) : Long.compare(p1.getX(), p2.getX())).collect(Collectors.toList());
        return Segment.segmentsFromAny2NeighboringPoints(joints);
    }

    boolean isAtSmallerEnd(APoint2D p) {
        if (p.equals((Object)this.getP0()) || p.equals((Object)this.getP1())) {
            if (this.isHorizontal()) {
                return p.getX() <= this.getP0().getX() && p.getX() <= this.getP1().getX();
            }
            return p.getY() <= this.getP0().getY() && p.getY() <= this.getP1().getY();
        }
        return false;
    }

    public Segment xorJoin(Segment other) {
        if (!this.sameOrientation(other)) {
            throw new IllegalArgumentException("The two segments must be of the same orientation!");
        }
        APoint2D b0 = this.getFirstPoint();
        APoint2D e0 = this.getLastPoint();
        APoint2D b1 = other.getFirstPoint();
        APoint2D e1 = other.getLastPoint();
        if (b0.equals((Object)b1)) {
            return new Segment(e0, e1);
        }
        if (b0.equals((Object)e1)) {
            return new Segment(e0, b1);
        }
        if (e0.equals((Object)b1)) {
            return new Segment(b0, e1);
        }
        if (e0.equals((Object)e1)) {
            return new Segment(b0, b1);
        }
        return null;
    }

    public Segment join(Segment s1) {
        if (this.sameOrientation(s1)) {
            return this.xorJoin(s1);
        }
        return null;
    }

    public int compareTo(Segment other) {
        if (this.equals(other)) {
            return 0;
        }
        long w0 = this.getP0().getX() + this.getP0().getY();
        long w1 = this.getP1().getX() + this.getP1().getY();
        long ow0 = other.getP0().getX() + other.getP0().getY();
        long ow1 = other.getP1().getX() + other.getP1().getY();
        if (w0 == ow0) {
            return Long.compare(w1, ow1);
        }
        return Long.compare(w0, ow0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)obj;
        ALine otherLine = other.mSide;
        return this.mSide.equals((Object)otherLine) || this.mTwinSide.equals((Object)otherLine);
    }

    public int hashCode() {
        return this.mSide.hashCode() + this.mTwinSide.hashCode();
    }

    public String toString() {
        return String.format("Segment[%s - %s]", this.getP0(), this.getP1());
    }
}

