/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.partitionTool;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.orbit.ui.partitionTool.Segment;
import java.util.LinkedList;
import java.util.List;

class SegmentGroup {
    List<Segment> mSegments;
    boolean mIsHorizontal;
    long mMin;
    long mMax;

    SegmentGroup(List<Segment> segs, APair<Long, Long> minMax) {
        this.mSegments = segs;
        this.mMin = (Long)minMax.first;
        this.mMax = (Long)minMax.second;
        this.mIsHorizontal = this.mSegments.get(0).isHorizontal();
    }

    List<Segment> getSegments() {
        return this.mSegments;
    }

    boolean isHorizontal() {
        return this.mIsHorizontal;
    }

    private void checkOrientation(SegmentGroup other) {
        if (this.isHorizontal() != other.isHorizontal()) {
            ALog.logError((String)"Operating on differently oriented segment groups! Should always operate on same-oriented groups!");
            assert (false);
        }
    }

    long getX() {
        return this.mSegments.get(0).getFirstPoint().getX();
    }

    long getY() {
        return this.mSegments.get(0).getFirstPoint().getY();
    }

    static int compare(SegmentGroup sg1, SegmentGroup sg2) {
        sg1.checkOrientation(sg2);
        return Long.compare(sg1.mMin, sg2.mMin);
    }

    boolean overlaps(SegmentGroup other) {
        this.checkOrientation(other);
        if (this.mMin <= other.mMin) {
            return other.mMin <= this.mMax;
        }
        return this.mMin <= other.mMax;
    }

    static List<SegmentGroup> merge(List<SegmentGroup> sortedList) {
        LinkedList<SegmentGroup> merged = new LinkedList<SegmentGroup>();
        SegmentGroup group = null;
        for (SegmentGroup sg : sortedList) {
            if (group == null) {
                group = sg;
                continue;
            }
            if (group.overlaps(sg)) {
                group.add(sg);
                continue;
            }
            merged.add(group);
            group = sg;
        }
        if (group != null) {
            merged.add(group);
        }
        return merged;
    }

    void add(SegmentGroup other) {
        this.checkOrientation(other);
        this.mSegments.addAll(other.mSegments);
        this.mMin = Math.min(this.mMin, other.mMin);
        this.mMax = Math.max(this.mMax, other.mMax);
    }
}

