/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.rename_group;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AComboBoxUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.AlphabetFull;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.JedecAlphabet;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.automation.group_rename.MatrixName;
import com.sigrity.orbit.ui.rename_group.GroupUIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MatrixNamerUI
implements GroupUIFactory.GroupNamingStrategyFactory {
    private String mObjType = "";
    protected JComboBox<MatrixName.Pattern> mCboPattern;
    protected JComboBox<MatrixName.Origin> mCboOrigin;
    protected JComboBox<CharsOpt> mCboCharsOptA;
    protected JComboBox<CharsOpt> mCboCharsOptB;
    protected JLabel mLblCharsOptA;
    protected JLabel mLblCharsOptB;
    protected JComboBox<MatrixName.Prefix> mCboPrefix;
    protected JLabel mLbPrefixText;
    protected JTextField mCboPrefixText;
    protected JLabel mLblOnlyPrefixIfOneDevice;
    protected JCheckBox mCbOnlyPrefixIfOneDevice;

    public MatrixNamerUI(String type) {
        this.mObjType = type;
    }

    @Override
    public String getName() {
        return String.format("Matrix %s Names", this.mObjType);
    }

    @Override
    public String getDesc() {
        return String.format("Name %ss based on row and column positions in a derived matrix", this.mObjType);
    }

    @Override
    public Optional<JPanel> getOptionUI() {
        return Optional.of(this.getOptsUI());
    }

    @Override
    public String getCtorCmd() {
        String pattern = String.format("setPattern(%s); ", AReflection.getQualifiedName((Enum)((Enum)UIUtil.getSelectedItem(this.mCboPattern))));
        String origin = String.format("setOrigin(%s); ", AReflection.getQualifiedName((Enum)((Enum)UIUtil.getSelectedItem(this.mCboOrigin))));
        String charOptA = String.format("setNameGeneratorA(%s.getGenerator()); ", AReflection.getQualifiedName((Enum)((Enum)UIUtil.getSelectedItem(this.mCboCharsOptA))));
        String charOptB = this.mCboCharsOptB.isVisible() ? String.format("setNameGeneratorB(Optional.of(%s.getGenerator())); ", AReflection.getQualifiedName((Enum)((Enum)UIUtil.getSelectedItem(this.mCboCharsOptB)))) : "setNameGeneratorB(Optional.empty()); ";
        String prefix = String.format("setPrefix(%s); ", AReflection.getQualifiedName((Enum)((Enum)UIUtil.getSelectedItem(this.mCboPrefix))));
        String prefixText = "setPrefixText(null); ";
        if (UIUtil.getSelectedItem(this.mCboPrefix) == MatrixName.Prefix.TEXT) {
            prefixText = String.format("setPrefixText(\"%s_\"); ", this.mCboPrefixText.getText());
        }
        String genCond = String.format("setOnlyPrefixIfOneDbObject(%b);", this.mCbOnlyPrefixIfOneDevice.isSelected());
        return String.format("new %s(){{ %s%s%s%s%s%s%s}}", AReflection.getJavaClassName(MatrixName.class), pattern, origin, charOptA, charOptB, prefix, genCond, prefixText);
    }

    protected JPanel getOptsUI() {
        final JPanel pnl = new JPanel();
        GridBagManager l = GridBagManager.layout((Container)pnl);
        l.add("Pattern:");
        this.mCboPattern = new JComboBox<MatrixName.Pattern>(MatrixName.Pattern.values());
        AComboBoxUtil.setRenderer(this.mCboPattern, r -> r.setText(((MatrixName.Pattern)r.getValue()).getDesc()));
        l.add(this.mCboPattern, (GridBagConstraints)GridBagManager.FILLX);
        l.add("Origin:");
        this.mCboOrigin = new JComboBox<MatrixName.Origin>(MatrixName.Origin.values());
        AComboBoxUtil.setRenderer(this.mCboOrigin, r -> r.setText(((MatrixName.Origin)r.getValue()).getDesc()));
        l.add(this.mCboOrigin, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.mLblCharsOptA = l.add("Row name:");
        this.mCboCharsOptA = new JComboBox<CharsOpt>(CharsOpt.values());
        AComboBoxUtil.setRenderer(this.mCboCharsOptA, r -> r.setText(((CharsOpt)((Object)((Object)r.getValue()))).getDesc()));
        l.add(this.mCboCharsOptA, (GridBagConstraints)GridBagManager.FILLX);
        this.mLblCharsOptB = l.add("Column name:");
        this.mCboCharsOptB = new JComboBox<CharsOpt>(CharsOpt.values());
        this.mCboCharsOptB.setSelectedIndex(1);
        AComboBoxUtil.setRenderer(this.mCboCharsOptB, r -> r.setText(((CharsOpt)((Object)((Object)r.getValue()))).getDesc()));
        l.add(this.mCboCharsOptB, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add("Prefix:");
        this.mCboPrefix = new JComboBox<MatrixName.Prefix>(MatrixName.Prefix.values());
        AComboBoxUtil.setRenderer(this.mCboPrefix, r -> r.setText(((MatrixName.Prefix)r.getValue()).getDesc()));
        l.add(this.mCboPrefix, (GridBagConstraints)GridBagManager.FILLX);
        this.mLblOnlyPrefixIfOneDevice = l.add("Only prefix if one");
        this.mCbOnlyPrefixIfOneDevice = new JCheckBox();
        l.add((Component)this.mCbOnlyPrefixIfOneDevice, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.mLbPrefixText = l.add("Text:");
        this.mCboPrefixText = new JTextField();
        l.add((Component)this.mCboPrefixText, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        final JComponent preview = (JComponent)l.add((Component)new Preview(), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        ActionListener optsChanged = new ActionListener(){

            void setControls(String lblNameA, boolean nameBEnabled, String lblNameB) {
                MatrixNamerUI.this.mLblCharsOptA.setText(lblNameA);
                MatrixNamerUI.this.mLblCharsOptB.setText(lblNameB);
                MatrixNamerUI.this.mLblCharsOptB.setVisible(nameBEnabled);
                MatrixNamerUI.this.mCboCharsOptB.setVisible(nameBEnabled);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Window w;
                switch ((MatrixName.Pattern)UIUtil.getSelectedItem(MatrixNamerUI.this.mCboPattern)) {
                    case RowCol: {
                        this.setControls("Row name:", true, "Column name:");
                        break;
                    }
                    case ColRow: {
                        this.setControls("Column name:", true, "Row name:");
                        break;
                    }
                    default: {
                        this.setControls("Name:", false, "");
                    }
                }
                boolean isNone = MatrixNamerUI.this.mCboPrefix.getSelectedItem() == MatrixName.Prefix.NONE;
                MatrixNamerUI.this.mCbOnlyPrefixIfOneDevice.setVisible(!isNone);
                MatrixNamerUI.this.mLblOnlyPrefixIfOneDevice.setVisible(!isNone);
                boolean isText = MatrixNamerUI.this.mCboPrefix.getSelectedItem() == MatrixName.Prefix.TEXT;
                MatrixNamerUI.this.mCboPrefixText.setVisible(isText);
                MatrixNamerUI.this.mLbPrefixText.setVisible(isText);
                if (isText) {
                    MatrixName.Prefix.TEXT.setPrefix(device -> MatrixNamerUI.this.mCboPrefixText.getText() + "_");
                }
                if ((w = (Window)UIUtil.getAncestorOfType((Component)pnl, Window.class)) != null) {
                    w.pack();
                }
                preview.repaint();
            }
        };
        this.mCboPattern.addActionListener(optsChanged);
        this.mCboOrigin.addActionListener(optsChanged);
        this.mCboCharsOptA.addActionListener(optsChanged);
        this.mCboCharsOptB.addActionListener(optsChanged);
        this.mCboPrefix.addActionListener(optsChanged);
        this.mCbOnlyPrefixIfOneDevice.addActionListener(optsChanged);
        this.mCboPrefixText.addActionListener(optsChanged);
        optsChanged.actionPerformed(null);
        return pnl;
    }

    public static enum CharsOpt {
        AlphaJedec("Alpha, JEDEC", () -> JedecAlphabet.get().stream()),
        Numeric("Numeric", () -> Stream.iterate(1, i -> i + 1).map(i -> Integer.toString(i))),
        Alpha("Alpha", () -> AlphabetFull.get().stream());

        private String mDesc;
        private Supplier<Stream<String>> mGenerator;

        private CharsOpt(String desc, Supplier<Stream<String>> generator) {
            this.mDesc = desc;
            this.mGenerator = generator;
        }

        public Stream<String> getGenerator() {
            return this.mGenerator.get();
        }

        public String getDesc() {
            return this.mDesc;
        }
    }

    protected class Preview
    extends JComponent {
        int mRows;
        int mCols;
        List<HierInst<DbObject>> mSampleDevices;

        public Preview() {
            block8: {
                this.mRows = 10;
                this.mCols = 10;
                this.mSampleDevices = new LinkedList<HierInst<DbObject>>();
                this.setBorder(BorderFactory.createTitledBorder("Example"));
                this.setPreferredSize(new Dimension(300, 200));
                this.setMinimumSize(new Dimension(240, 180));
                try (OrbitApp.ChangeWarningSilencer cm = OrbitApp.suppressDbChangeMonitorWarnings();){
                    Class clsDb = AReflection.getClassByName((String)"com.sigrity.acl.db.Db");
                    Constructor ctorDb = clsDb.getDeclaredConstructor(new Class[0]);
                    ctorDb.setAccessible(true);
                    Db db = (Db)ctorDb.newInstance(new Object[0]);
                    Substrate substrate = Substrate.create((Db)db, (String)"Substrate");
                    DeviceTemplate parentDevT = DeviceTemplate.create((Substrate)substrate, (String)"Parent", (boolean)false);
                    DeviceTemplate devT = DeviceTemplate.create((Substrate)substrate, (String)"DeviceTemplate", (boolean)false);
                    DevicePath path = new DevicePath(parentDevT);
                    IntStream.range(0, this.mRows).forEach(r -> IntStream.range(0, this.mCols).forEach(c -> {
                        Device device = Device.create((String)String.format("%d%d", c, r), (DeviceTemplate)devT, (DeviceTemplate)parentDevT);
                        device.setLoc(new APoint2D((long)c * 1000L, (long)(this.mRows * 100) - (long)r * 1000L));
                        this.mSampleDevices.add((HierInst<DbObject>)HierInst.create((DevicePath)path, (DbObject)device));
                    }));
                }
                catch (Exception e) {
                    ALog.logError((String)e.getMessage());
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D g = (Graphics2D)graphics;
            MatrixName mbn = new MatrixName();
            mbn.setPattern((MatrixName.Pattern)UIUtil.getSelectedItem(MatrixNamerUI.this.mCboPattern));
            mbn.setOrigin((MatrixName.Origin)UIUtil.getSelectedItem(MatrixNamerUI.this.mCboOrigin));
            mbn.setNameGeneratorA(((CharsOpt)((Object)UIUtil.getSelectedItem(MatrixNamerUI.this.mCboCharsOptA))).getGenerator());
            mbn.setNameGeneratorB(MatrixNamerUI.this.mCboCharsOptB.isVisible() ? Optional.of(((CharsOpt)((Object)UIUtil.getSelectedItem(MatrixNamerUI.this.mCboCharsOptB))).getGenerator()) : Optional.empty());
            mbn.setPrefix((MatrixName.Prefix)UIUtil.getSelectedItem(MatrixNamerUI.this.mCboPrefix));
            mbn.setOnlyPrefixIfOneDbObject(MatrixNamerUI.this.mCbOnlyPrefixIfOneDevice.isSelected());
            APair result = mbn.setObjs(() -> this.mSampleDevices.stream());
            if (!((Boolean)result.first).booleanValue()) {
                ALog.logError((String)((String)result.second));
                return;
            }
            int border = 0;
            Insets insets = this.getInsets();
            insets.bottom += border;
            insets.top += border;
            insets.left += border;
            insets.right += border;
            int dx = (this.getWidth() - insets.left - insets.right - 1) / this.mCols;
            int dy = (this.getHeight() - insets.top - insets.bottom - 1) / this.mRows;
            int y = insets.top;
            Iterator<HierInst<DbObject>> itrDevices = this.mSampleDevices.iterator();
            for (int r = 0; r < this.mRows; ++r) {
                int x = insets.left;
                for (int c = 0; c < this.mCols; ++c) {
                    String name = mbn.getName(itrDevices.next()).orElse("");
                    Rectangle2D bounds = UIUtil.getTextBounds((Graphics2D)g, (String)name);
                    if (bounds == null) {
                        bounds = new Rectangle();
                    }
                    int extraX = (int)Math.round(((double)dx - bounds.getWidth()) / 2.0);
                    int extraY = (int)Math.round(((double)dy - bounds.getHeight()) / 2.0);
                    g.drawString(name, x - (int)bounds.getX() + extraX, y - (int)bounds.getY() + extraY);
                    x += dx;
                }
                y += dy;
            }
        }
    }
}

