/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.rename_group;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.group_rename.Group;
import com.sigrity.orbit.automation.group_rename.RenameDeviceGroup;
import com.sigrity.orbit.ui.rename_group.GroupUIFactory;
import com.sigrity.orbit.ui.rename_group.MatrixNamerUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class RenameDeviceGroupUI {
    private static Set<GroupUIFactory.GroupSelectorFactory> deviceGroupSelectorRegistry;
    private static Set<GroupUIFactory.GroupNamingStrategyFactory> deviceNamingRegistry;

    public static RenameDeviceGroupAction createAction(DevicePath path) {
        return new RenameDeviceGroupAction(path);
    }

    public static void show(Window owner, DevicePath path) {
        new RenameDeviceGroupDlg(owner, path).setVisible(true);
    }

    public static void resetRegistries() {
        deviceGroupSelectorRegistry = new LinkedHashSet<GroupUIFactory.GroupSelectorFactory>();
        deviceGroupSelectorRegistry.addAll(AUtil.linkedList((Object[])new GroupUIFactory.GroupSelectorFactory[]{new DeviceTemplateDevicesFactory(), new UserSelectedDevicesFactory()}));
        deviceNamingRegistry = new LinkedHashSet<GroupUIFactory.GroupNamingStrategyFactory>();
        deviceNamingRegistry.addAll(AUtil.linkedList((Object[])new MatrixNamerUI[]{new MatrixNamerUI("Device")}));
    }

    static {
        RenameDeviceGroupUI.resetRegistries();
    }

    public static class DeviceTemplateDevicesFactory
    implements GroupUIFactory.GroupSelectorFactory {
        protected JCheckBox mCbDescendants;

        @Override
        public String getName() {
            return "Device children devices";
        }

        @Override
        public String getDesc() {
            return "Devices of the Device children";
        }

        @Override
        public Optional<JPanel> getOptionUI() {
            return Optional.empty();
        }

        @Override
        public String getCtorCmd() {
            return String.format("new %s()", AReflection.getJavaClassName(RenameDeviceGroup.DeviceTemplateDevices.class));
        }
    }

    public static class UserSelectedDevicesFactory
    implements GroupUIFactory.GroupSelectorFactory {
        @Override
        public String getName() {
            return "Selected devices";
        }

        @Override
        public String getDesc() {
            return "The currenlty selected devices in the design.";
        }

        @Override
        public Optional<JPanel> getOptionUI() {
            return Optional.empty();
        }

        @Override
        public String getCtorCmd() {
            return String.format("new %s()", AReflection.getJavaClassName(RenameDeviceGroup.UserSelectedDevices.class));
        }
    }

    static class RenameDeviceGroupDlg
    extends DbDialog {
        protected DevicePath mPath;
        protected JComboBox<GroupUIFactory.GroupSelectorFactory> mCboDeviceGrpSel;
        protected JPanel mPnlSelOpts;
        protected JComboBox<GroupUIFactory.GroupNamingStrategyFactory> mCboDeviceNameStrategy;
        protected JPanel mPnlNameOpts;
        protected JButton mBtnOk;

        public RenameDeviceGroupDlg(Window owner, DevicePath path) {
            super(path.getDb(), (Component)owner);
            this.setRecallBounds(false);
            this.mPath = path;
            Object title = "Rename Devices";
            if (path.getDeviceTemplate() != null) {
                title = (String)title + String.format(" of '%s'", path.getDeviceTemplate().getName());
            }
            this.setTitle((String)title);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.pushFillXRemainX();
            l.add("Rename:");
            this.mCboDeviceGrpSel = (JComboBox)l.add(new JComboBox());
            l.addFillX();
            l.newline();
            this.mPnlSelOpts = (JPanel)l.add((Component)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.indent().indent());
            this.mPnlSelOpts.setLayout(new GridBagLayout());
            l.popNl();
            l.pushFillAllRemainX();
            l.add("Naming Strategy:");
            this.mCboDeviceNameStrategy = (JComboBox)l.add(new JComboBox());
            l.addFillX();
            l.newline();
            this.mPnlNameOpts = (JPanel)l.add((Component)new JPanel(), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.indent().indent());
            this.mPnlNameOpts.setLayout(new GridBagLayout());
            l.popNl();
            l.addFillY();
            l.addFillX();
            this.mBtnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            deviceGroupSelectorRegistry.forEach(f -> this.mCboDeviceGrpSel.addItem((GroupUIFactory.GroupSelectorFactory)f));
            this.mCboDeviceGrpSel.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int idx, boolean selected, boolean hasFocus) {
                    super.getListCellRendererComponent(list, value, idx, selected, hasFocus);
                    GroupUIFactory.GroupSelectorFactory f = (GroupUIFactory.GroupSelectorFactory)value;
                    this.setText(f.getName());
                    this.setToolTipText(f.getDesc());
                    return this;
                }
            });
            this.mCboDeviceGrpSel.addActionListener(e -> this.updateDeviceGrpSelector());
            deviceNamingRegistry.forEach(f -> this.mCboDeviceNameStrategy.addItem((GroupUIFactory.GroupNamingStrategyFactory)f));
            this.mCboDeviceNameStrategy.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int idx, boolean selected, boolean hasFocus) {
                    super.getListCellRendererComponent(list, value, idx, selected, hasFocus);
                    GroupUIFactory.GroupNamingStrategyFactory f = (GroupUIFactory.GroupNamingStrategyFactory)value;
                    if (f != null) {
                        this.setText(f.getName());
                        this.setToolTipText(f.getDesc());
                    }
                    return this;
                }
            });
            this.mCboDeviceNameStrategy.addActionListener(e -> this.updateDeviceNamingStrategy());
            this.updateDeviceGrpSelector();
            this.updateDeviceNamingStrategy();
            UIUtil.prepareDlg((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnCancel);
            this.setMinimumSize(this.getPreferredSize());
            this.mBtnOk.addActionListener(e -> {
                Optional<GroupUIFactory.GroupSelectorFactory> optSelector = this.getDeviceGrpSelector();
                if (optSelector.isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "A DeviceGroupSelector must be specified.", "Error", 0);
                    return;
                }
                Optional<GroupUIFactory.GroupNamingStrategyFactory> optNamer = this.getDeviceNamingStrategy();
                if (optNamer.isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "A DeviceNamingStrategy must be specified.", "Error", 0);
                    return;
                }
                String selectorCtorCmd = optSelector.get().getCtorCmd();
                if (selectorCtorCmd == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Invalid selection options.", "Error", 0);
                    return;
                }
                String namerCtorCmd = optNamer.get().getCtorCmd();
                if (namerCtorCmd == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Invalid naming options.", "Error", 0);
                    return;
                }
                Cp.exec((String)"unset(\"_selector\")", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_namer\")", (Object[])new Object[0]);
                Cp.exec((String)("_selector = " + selectorCtorCmd), (Object[])new Object[0]);
                Cp.exec((String)("_namer = " + namerCtorCmd), (Object[])new Object[0]);
                Object res = Cp.exec((String)"%s.rename(curDb(), \"%s\", _selector, _namer)", (Object[])new Object[]{AReflection.getJavaClassName(RenameDeviceGroup.class), this.mPath.escapedString()});
                Cp.exec((String)"unset(\"_selector\")", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_namer\")", (Object[])new Object[0]);
                if (res instanceof Optional) {
                    Optional opt = (Optional)res;
                    if (opt.isPresent()) {
                        Object o = opt.get();
                        if (!(o instanceof Group)) {
                            ALog.logError((String)"Unexpected return (Optional<%s>) type from %s.rename.", (Object[])new Object[]{AReflection.getJavaClassName(o.getClass()), AReflection.getJavaClassName(RenameDeviceGroup.class)});
                        }
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)this), "No devices were found to rename.");
                    }
                } else {
                    ALog.logError((String)"Unexpected return type from %s.rename.", (Object[])new Object[]{AReflection.getJavaClassName(RenameDeviceGroup.class)});
                }
            });
        }

        protected Optional<GroupUIFactory.GroupSelectorFactory> getDeviceGrpSelector() {
            int selIdx = this.mCboDeviceGrpSel.getSelectedIndex();
            if (selIdx < 0) {
                return Optional.empty();
            }
            return Optional.of((GroupUIFactory.GroupSelectorFactory)this.mCboDeviceGrpSel.getModel().getElementAt(selIdx));
        }

        protected Optional<GroupUIFactory.GroupNamingStrategyFactory> getDeviceNamingStrategy() {
            int selIdx = this.mCboDeviceNameStrategy.getSelectedIndex();
            if (selIdx < 0) {
                return Optional.empty();
            }
            return Optional.of((GroupUIFactory.GroupNamingStrategyFactory)this.mCboDeviceNameStrategy.getModel().getElementAt(selIdx));
        }

        protected void updateDeviceGrpSelector() {
            this.getDeviceGrpSelector().ifPresent(pgs -> {
                this.mPnlSelOpts.removeAll();
                pgs.getOptionUI().ifPresent(pnlOpts -> this.mPnlSelOpts.add((Component)pnlOpts, GridBagManager.FILLALL));
                SwingUtilities.invokeLater(() -> this.pack());
            });
        }

        protected void updateDeviceNamingStrategy() {
            this.getDeviceNamingStrategy().ifPresent(pns -> {
                this.mPnlNameOpts.removeAll();
                pns.getOptionUI().ifPresent(pnlOpts -> this.mPnlNameOpts.add((Component)pnlOpts, GridBagManager.FILLALL));
                SwingUtilities.invokeLater(() -> this.pack());
            });
        }

        protected static JTextArea createTextDisplay() {
            JTextArea td = new JTextArea();
            td.setEditable(false);
            td.setOpaque(false);
            td.setFont(td.getFont().deriveFont(2));
            td.setLineWrap(true);
            td.setWrapStyleWord(true);
            return td;
        }
    }

    private static class RenameDeviceGroupAction
    extends AbstractAction {
        protected DevicePath mPath;

        public RenameDeviceGroupAction(DevicePath path) {
            super("Rename Devices...");
            this.mPath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameDeviceGroupUI.show(OrbitIO.getMainWindow(), this.mPath);
        }
    }
}

