/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.rename_group;

import com.sigrity.acl.ABoolean;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.AStream;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.group_rename.Group;
import com.sigrity.orbit.automation.group_rename.RenamePinGroup;
import com.sigrity.orbit.ui.common.PinTypeSelector;
import com.sigrity.orbit.ui.rename_group.GroupUIFactory;
import com.sigrity.orbit.ui.rename_group.MatrixNamerUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class RenamePinGroupUI {
    private static Set<GroupUIFactory.GroupSelectorFactory> pinGroupSelectorRegistry;
    private static Set<GroupUIFactory.GroupNamingStrategyFactory> pinNamingRegistry;

    public static RenamePinGroupAction createAction(DevicePath path) {
        return new RenamePinGroupAction(path);
    }

    public static void show(Window owner, DevicePath path) {
        new RenamePinGroupDlg(owner, path).setVisible(true);
    }

    public static void resetRegistries() {
        pinGroupSelectorRegistry = new LinkedHashSet<GroupUIFactory.GroupSelectorFactory>();
        pinGroupSelectorRegistry.addAll(AUtil.linkedList((Object[])new GroupUIFactory.GroupSelectorFactory[]{new DeviceTemplatePinsFactory(), new UserSelectedPinsFactory()}));
        pinNamingRegistry = new LinkedHashSet<GroupUIFactory.GroupNamingStrategyFactory>();
        pinNamingRegistry.addAll(AUtil.linkedList((Object[])new MatrixNamerUI[]{new MatrixNamerUI("Pin")}));
    }

    static {
        RenamePinGroupUI.resetRegistries();
    }

    public static class DeviceTemplatePinsFactory
    implements GroupUIFactory.GroupSelectorFactory {
        private static final Set<PinTemplate.Type> DEFAULT_PIN_TYPE = (Set)AStream.of((Object[])PinTemplate.Type.values()).filter(t -> t != PinTemplate.Type.TOPOLOGYPOINT && t != PinTemplate.Type.WIREEND).collect(Collectors.toSet());
        protected JCheckBox mCbDescendants;
        protected PinTypeSelector mPinTypeSel;

        @Override
        public String getName() {
            return "Device template pins";
        }

        @Override
        public String getDesc() {
            return "Pins of the DeviceTemplate and, optionally, its descendants";
        }

        @Override
        public Optional<JPanel> getOptionUI() {
            final JPanel pnl = new JPanel();
            GridBagManager l = GridBagManager.layout((Container)pnl);
            this.mCbDescendants = (JCheckBox)l.add((Component)new JCheckBox("Include descendants on substrate"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            l.add("Pins of type(s):");
            this.mPinTypeSel = (PinTypeSelector)l.add((Component)new PinTypeSelector(DEFAULT_PIN_TYPE){

                @Override
                protected void updateSelectedPinTypes() {
                    Window w;
                    super.updateSelectedPinTypes();
                    if (this.getSelectedTypes().isEmpty()) {
                        this.mTxtPinTypes.setText("All");
                        this.mTxtPinTypes.setToolTipText("Pins of all types");
                    }
                    if ((w = (Window)UIUtil.getAncestorOfType((Component)pnl, Window.class)) != null) {
                        w.pack();
                    }
                }
            }, (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
            return Optional.of(pnl);
        }

        @Override
        public String getCtorCmd() {
            String pinTypeArgs = "";
            Set<PinTemplate.Type> selPinTypes = this.mPinTypeSel.getSelectedTypes();
            if (!selPinTypes.isEmpty()) {
                pinTypeArgs = String.format(", new PinTemplate.Type[] { %s }", selPinTypes.stream().map(pt -> String.format("PinTemplate.Type.%s", pt.name())).collect(Collectors.joining(", ")));
            }
            return String.format("new %s(%s%s)", AReflection.getJavaClassName(RenamePinGroup.DeviceTemplatePins.class), ABoolean.toString((boolean)this.mCbDescendants.isSelected()), pinTypeArgs);
        }
    }

    public static class UserSelectedPinsFactory
    implements GroupUIFactory.GroupSelectorFactory {
        @Override
        public String getName() {
            return "Selected pins";
        }

        @Override
        public String getDesc() {
            return "The currenlty selected pins in the design.";
        }

        @Override
        public Optional<JPanel> getOptionUI() {
            return Optional.empty();
        }

        @Override
        public String getCtorCmd() {
            return String.format("new %s()", AReflection.getJavaClassName(RenamePinGroup.UserSelectedPins.class));
        }
    }

    static class RenamePinGroupDlg
    extends DbDialog {
        protected DevicePath mPath;
        protected JComboBox<GroupUIFactory.GroupSelectorFactory> mCboPinGrpSel;
        protected JPanel mPnlSelOpts;
        protected JComboBox<GroupUIFactory.GroupNamingStrategyFactory> mCboPinNameStrategy;
        protected JPanel mPnlNameOpts;
        protected JButton mBtnOk;

        public RenamePinGroupDlg(Window owner, DevicePath path) {
            super(path.getDb(), (Component)owner);
            this.setRecallBounds(false);
            this.mPath = path;
            Object title = "Rename Pins";
            if (path.getDeviceTemplate() != null) {
                title = (String)title + String.format(" of '%s'", path.getDeviceTemplate().getName());
            }
            this.setTitle((String)title);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.pushFillXRemainX();
            l.add("Rename:");
            this.mCboPinGrpSel = (JComboBox)l.add(new JComboBox());
            l.addFillX();
            l.newline();
            this.mPnlSelOpts = (JPanel)l.add((Component)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.indent().indent());
            this.mPnlSelOpts.setLayout(new GridBagLayout());
            l.popNl();
            l.pushFillAllRemainX();
            l.add("Naming Strategy:");
            this.mCboPinNameStrategy = (JComboBox)l.add(new JComboBox());
            l.addFillX();
            l.newline();
            this.mPnlNameOpts = (JPanel)l.add((Component)new JPanel(), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.indent().indent());
            this.mPnlNameOpts.setLayout(new GridBagLayout());
            l.popNl();
            l.addFillY();
            l.addFillX();
            this.mBtnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            pinGroupSelectorRegistry.forEach(f -> this.mCboPinGrpSel.addItem((GroupUIFactory.GroupSelectorFactory)f));
            this.mCboPinGrpSel.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int idx, boolean selected, boolean hasFocus) {
                    super.getListCellRendererComponent(list, value, idx, selected, hasFocus);
                    GroupUIFactory.GroupSelectorFactory f = (GroupUIFactory.GroupSelectorFactory)value;
                    this.setText(f.getName());
                    this.setToolTipText(f.getDesc());
                    return this;
                }
            });
            this.mCboPinGrpSel.addActionListener(e -> this.updatePinGrpSelector());
            pinNamingRegistry.forEach(f -> this.mCboPinNameStrategy.addItem((GroupUIFactory.GroupNamingStrategyFactory)f));
            this.mCboPinNameStrategy.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int idx, boolean selected, boolean hasFocus) {
                    super.getListCellRendererComponent(list, value, idx, selected, hasFocus);
                    GroupUIFactory.GroupNamingStrategyFactory f = (GroupUIFactory.GroupNamingStrategyFactory)value;
                    if (f != null) {
                        this.setText(f.getName());
                        this.setToolTipText(f.getDesc());
                    }
                    return this;
                }
            });
            this.mCboPinNameStrategy.addActionListener(e -> this.updatePinNamingStrategy());
            this.updatePinGrpSelector();
            this.updatePinNamingStrategy();
            UIUtil.prepareDlg((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnCancel);
            this.setMinimumSize(this.getPreferredSize());
            this.mBtnOk.addActionListener(e -> {
                Optional<GroupUIFactory.GroupSelectorFactory> optSelector = this.getPinGrpSelector();
                if (optSelector.isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "A PinGroupSelector must be specified.", "Error", 0);
                    return;
                }
                Optional<GroupUIFactory.GroupNamingStrategyFactory> optNamer = this.getPinNamingStrategy();
                if (optNamer.isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "A PinNamingStrategy must be specified.", "Error", 0);
                    return;
                }
                String selectorCtorCmd = optSelector.get().getCtorCmd();
                if (selectorCtorCmd == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Invalid selection options.", "Error", 0);
                    return;
                }
                String namerCtorCmd = optNamer.get().getCtorCmd();
                if (namerCtorCmd == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Invalid naming options.", "Error", 0);
                    return;
                }
                Cp.exec((String)"unset(\"_selector\")", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_namer\")", (Object[])new Object[0]);
                Cp.exec((String)("_selector = " + selectorCtorCmd), (Object[])new Object[0]);
                Cp.exec((String)("_namer = " + namerCtorCmd), (Object[])new Object[0]);
                Object res = Cp.exec((String)"%s.rename(curDb(), \"%s\", _selector, _namer)", (Object[])new Object[]{AReflection.getJavaClassName(RenamePinGroup.class), this.mPath.escapedString()});
                Cp.exec((String)"unset(\"_selector\")", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_namer\")", (Object[])new Object[0]);
                if (res instanceof Optional) {
                    Optional opt = (Optional)res;
                    if (opt.isPresent()) {
                        Object o = opt.get();
                        if (o instanceof Group) {
                            Group pg = (Group)o;
                            if (pg.getAnchor().isPresent()) {
                                OrbitIO.refreshViewsOf((DbObject)pg.getAnchor().get());
                                UIUtil.closeWindow((Window)((Object)this));
                            }
                        } else {
                            ALog.logError((String)"Unexpected return (Optional<%s>) type from %s.rename.", (Object[])new Object[]{AReflection.getJavaClassName(o.getClass()), AReflection.getJavaClassName(RenamePinGroup.class)});
                        }
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)this), "No pins were found to rename.");
                    }
                } else {
                    ALog.logError((String)"Unexpected return type from %s.rename.", (Object[])new Object[]{AReflection.getJavaClassName(RenamePinGroup.class)});
                }
            });
        }

        protected Optional<GroupUIFactory.GroupSelectorFactory> getPinGrpSelector() {
            int selIdx = this.mCboPinGrpSel.getSelectedIndex();
            if (selIdx < 0) {
                return Optional.empty();
            }
            return Optional.of((GroupUIFactory.GroupSelectorFactory)this.mCboPinGrpSel.getModel().getElementAt(selIdx));
        }

        protected Optional<GroupUIFactory.GroupNamingStrategyFactory> getPinNamingStrategy() {
            int selIdx = this.mCboPinNameStrategy.getSelectedIndex();
            if (selIdx < 0) {
                return Optional.empty();
            }
            return Optional.of((GroupUIFactory.GroupNamingStrategyFactory)this.mCboPinNameStrategy.getModel().getElementAt(selIdx));
        }

        protected void updatePinGrpSelector() {
            this.getPinGrpSelector().ifPresent(pgs -> {
                this.mPnlSelOpts.removeAll();
                pgs.getOptionUI().ifPresent(pnlOpts -> this.mPnlSelOpts.add((Component)pnlOpts, GridBagManager.FILLALL));
                SwingUtilities.invokeLater(() -> this.pack());
            });
        }

        protected void updatePinNamingStrategy() {
            this.getPinNamingStrategy().ifPresent(pns -> {
                this.mPnlNameOpts.removeAll();
                pns.getOptionUI().ifPresent(pnlOpts -> this.mPnlNameOpts.add((Component)pnlOpts, GridBagManager.FILLALL));
                SwingUtilities.invokeLater(() -> this.pack());
            });
        }

        protected static JTextArea createTextDisplay() {
            JTextArea td = new JTextArea();
            td.setEditable(false);
            td.setOpaque(false);
            td.setFont(td.getFont().deriveFont(2));
            td.setLineWrap(true);
            td.setWrapStyleWord(true);
            return td;
        }
    }

    private static class RenamePinGroupAction
    extends AbstractAction {
        protected DevicePath mPath;

        public RenamePinGroupAction(DevicePath path) {
            super("Rename Pins...");
            this.mPath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenamePinGroupUI.show(OrbitIO.getMainWindow(), this.mPath);
        }
    }
}

