/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.route_edit;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.automation.router.InteractiveBundleCreator;
import com.sigrity.orbit.automation.router.InteractiveRouter;
import com.sigrity.orbit.automation.router.InteractiveSingleLayerRouter;
import com.sigrity.orbit.ui.DeviceChooser;
import com.sigrity.orbit.ui.GridChooser;
import com.sigrity.orbit.ui.LayerChooser;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.route_edit.InteractiveWireCreator;
import com.sigrity.orbit.ui.route_edit.RoutingOverlay;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EditRouteMode
extends AbstractViewMode {
    public static final int COLS_TEXT_DEFAULT = 16;
    public static final String MODE_NAME = "EditRouteMode";
    public static final Insets INSETS_RIBBON = new Insets(2, 4, 2, 4);
    protected DevicePath mDevicePath = null;
    protected Layer mLayer = null;
    protected OptionsWindow mOptionsWindow = null;
    protected SubMode mSubMode = null;
    protected RoutingOverlay mRoutingOverLay = null;
    protected LinkedList<Component> mBaseModeMenu = null;
    protected APoint2D mCurrentLoc = null;
    protected boolean mConstrainToDevice = true;
    protected boolean mInBusRouteMode = false;
    protected boolean mInteractiveEditorMode = false;
    protected JMenuItem mMIStartTrace = new JMenuItem(){
        {
            this.setAction(new AbstractAction("Start Trace"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRouteMode.this.startTrace();
                }
            });
        }

        @Override
        public void addNotify() {
            this.setEnabled(EditRouteMode.this.mDevicePath != null);
            super.addNotify();
        }
    };
    protected WindowListener mOptionsWindowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            super.windowClosing(e);
            EditRouteMode.this.mOptionsWindow = null;
        }
    };

    @Override
    public Cursor getCursor() {
        return null;
    }

    @Override
    public String getName() {
        return "Edit Route Mode";
    }

    @Override
    public void installedMode() {
        super.installedMode();
        this.mSubMode = null;
        Db db = this.mView.getDb();
        if (!this.mInBusRouteMode && !this.mInteractiveEditorMode) {
            this.createOptionsDisplay();
            if (this.mDevicePath == null) {
                DevicePath device = DeviceChooser.getDevicePath((Component)((Object)this.mOptionsWindow), db);
                this.setDevice(device == null ? null : device);
            }
            this.setGrid(null);
        }
    }

    @Override
    protected void removingMode() {
        this.endSubmode();
        super.removingMode();
        if (this.mOptionsWindow != null) {
            UIUtil.closeWindow((Window)((Object)this.mOptionsWindow));
        }
        if (this.mRoutingOverLay != null) {
            this.mView.removeOverlay(this.mRoutingOverLay);
            this.mRoutingOverLay = null;
        }
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        this.mCurrentLoc = e.getButton() == 1 && this.mSubMode != null ? this.mSubMode.mouseClicked(e.getButton(), this.getSubmodeWorldPoint(e)) : this.getSnappedWorldPoint(e);
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        APoint2D oldLoc = this.mCurrentLoc;
        this.mCurrentLoc = this.mSubMode != null ? this.mSubMode.mouseMoved(oldLoc, this.getSubmodeWorldPoint(e)) : this.getSnappedWorldPoint(e);
    }

    @Override
    protected void loadContextMenu(AbstractViewMode.ContextMenu menu, Point loc) {
        LinkedList<Component> modeItems = this.mSubMode == null ? this.getContextMenu() : this.mSubMode.getContextMenu(loc);
        this.concatMenuItems(menu, modeItems);
        menu.setDelayUpdatedEnabled(false);
    }

    @Override
    protected boolean showContextMenu(JPopupMenu menu, Point loc) {
        return super.showContextMenu(menu, loc);
    }

    @Override
    protected void paintOverlay(Graphics2D g, Rectangle bounds) {
        super.paintOverlay(g, bounds);
        if (this.mSubMode != null) {
            this.mSubMode.paintOverlay(g, bounds);
        }
    }

    protected void createOptionsDisplay() {
        this.mOptionsWindow = new OptionsWindow();
        this.mOptionsWindow.addWindowListener(this.mOptionsWindowListener);
        this.mOptionsWindow.setVisible(true);
    }

    public NamedGrid getGrid() {
        return this.mRoutingOverLay == null ? null : this.mRoutingOverLay.getGrid();
    }

    @Override
    public DesignView2D getView() {
        return this.mView;
    }

    public DevicePath getDevicePath() {
        return this.mDevicePath;
    }

    public Layer getLayer() {
        return this.mLayer;
    }

    public APoint2D getCursorLoc() {
        return this.mCurrentLoc;
    }

    protected void setBusRouteMode(InteractiveBundleCreator ibr) {
        this.mInBusRouteMode = true;
    }

    public void setInteractiveRouterMode() {
        this.mInteractiveEditorMode = true;
    }

    protected APoint2D getSubmodeWorldPoint(DesignView2D.MouseAction e) {
        if (this.mSubMode instanceof SubMode.RawCoords) {
            return this.getWorldPoint(e);
        }
        return this.getSnappedWorldPoint(e);
    }

    protected APoint2D getSnappedWorldPoint(DesignView2D.MouseAction e) {
        ARect bounds;
        APoint2D worldPoint = this.getWorldPoint(e);
        if (this.mDevicePath == null) {
            return worldPoint;
        }
        NamedGrid curGrid = this.getGrid();
        ARect aRect = bounds = this.mConstrainToDevice ? this.mDevicePath.getBB() : null;
        if (curGrid != null) {
            worldPoint = curGrid.getGrid().snapToGrid(worldPoint, bounds);
        } else if (bounds != null && !bounds.contains(worldPoint)) {
            if (worldPoint.getX() < bounds.left()) {
                worldPoint.setX(bounds.left());
            }
            if (worldPoint.getX() > bounds.right()) {
                worldPoint.setX(bounds.right());
            }
            if (worldPoint.getY() < bounds.bottom()) {
                worldPoint.setY(bounds.bottom());
            }
            if (worldPoint.getY() > bounds.top()) {
                worldPoint.setY(bounds.top());
            }
        }
        return worldPoint;
    }

    protected void concatMenuItems(JPopupMenu menu, Collection<Component> items) {
        for (Component i : items) {
            menu.add(i);
        }
    }

    protected void removeMenuItems(JPopupMenu menu, Collection<Component> items) {
        for (Component i : items) {
            menu.remove(i);
        }
    }

    protected void setGrid(NamedGrid grid) {
        String desc;
        String string = desc = grid == null ? "" : grid.toString();
        if (this.mOptionsWindow != null) {
            this.mOptionsWindow.mOptionsPanel.mTxtGrid.setText(desc);
        }
        this.updateOverlay(grid);
    }

    private void updateOverlay(NamedGrid grid) {
        if (this.mView == null) {
            return;
        }
        if (this.mRoutingOverLay != null) {
            this.mView.removeOverlay(this.mRoutingOverLay);
            this.mRoutingOverLay = null;
        }
        this.mRoutingOverLay = this.createOverlay(grid);
        this.mRoutingOverLay.setSpotlight(true);
        this.mView.addOverlay(this.mRoutingOverLay);
    }

    protected RoutingOverlay createOverlay(NamedGrid grid) {
        return new RoutingOverlay(this, grid);
    }

    protected RoutingOverlay getRoutingOverlay() {
        return this.mRoutingOverLay;
    }

    public void setDevice(DevicePath p) {
        this.mDevicePath = p;
        Layer layer = null;
        String name = "";
        if (p != null) {
            name = p.toString();
        }
        if (this.mOptionsWindow != null) {
            this.mOptionsWindow.mOptionsPanel.mTxtDevice.setText(name);
        }
        if (this.mLayer == null) {
            Substrate s;
            if (p != null && (s = p.getSubstrate()) != null) {
                layer = LayerChooser.getLayer((Component)((Object)this.mOptionsWindow), s);
            }
            this.setLayer(layer);
        }
        this.updateOverlay(null);
    }

    public void setLayer(Layer layer) {
        this.mLayer = layer;
        String layerName = "";
        if (layer != null) {
            layerName = layer.getName();
        }
        if (this.mOptionsWindow != null) {
            this.mOptionsWindow.mOptionsPanel.mTxtLayer.setText(layerName);
        }
    }

    public void setContext(DevicePath path, Layer layer) {
        this.setLayer(layer);
        this.setDevice(path);
    }

    public AbstractViewMode.ContextMenu getContextPopUp() {
        return this.mContextMenu;
    }

    protected LinkedList<Component> getContextMenu() {
        if (this.mBaseModeMenu == null) {
            this.mBaseModeMenu = new LinkedList();
            this.mBaseModeMenu.add(new JSeparator());
            this.mBaseModeMenu.add(this.mMIStartTrace);
        }
        return this.mBaseModeMenu;
    }

    public void setBundle(DevicePath path) {
        this.mInBusRouteMode = true;
        this.mDevicePath = path;
    }

    public void startBundle(InteractiveBundleCreator ibr) {
        this.startSubmode(ibr);
    }

    protected void startTrace() {
        this.startSubmode(new InteractiveWireCreator());
    }

    public void startRoute(InteractiveRouter ir) {
        this.startSubmode(ir);
    }

    public void startSingleLayerRouter(InteractiveSingleLayerRouter islr) {
        this.startSubmode(islr);
    }

    public void startSubmode(SubMode mode) {
        this.endSubmode();
        if (mode.install(this)) {
            this.mSubMode = mode;
        }
        if (this.mSubMode == null) {
            // empty if block
        }
    }

    public void endSubmode() {
        if (this.mSubMode != null) {
            this.mSubMode.uninstall();
            this.mSubMode = null;
        }
    }

    protected void queryUserGrid() {
        NamedGrid grid;
        NamedGrid curGrid = this.getGrid();
        ArrayList<NamedGrid> extraGrids = new ArrayList<NamedGrid>();
        extraGrids.add(NamedGrid.NONE);
        if (curGrid != null && !curGrid.isStored()) {
            extraGrids.add(curGrid);
        }
        if ((grid = GridChooser.getGrid((Component)((Object)this.mOptionsWindow), this.mDevicePath.getSubstrate(), this.mView.getUnit(), curGrid, extraGrids)) == NamedGrid.NONE) {
            grid = null;
        }
        this.setGrid(grid);
    }

    protected class OptionsWindow
    extends AFloatWindow {
        protected final BaseOptionsPanel mOptionsPanel;

        public OptionsWindow() {
            super(EditRouteMode.this.getParentWindow());
            this.setForcePinned(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            this.mOptionsPanel = (BaseOptionsPanel)l.add((Component)new BaseOptionsPanel(), (GridBagConstraints)GridBagManager.FILLALL.noInsets());
            this.pack();
            Component viewComp = EditRouteMode.this.getViewComponent();
            Rectangle viewBounds = viewComp.getBounds();
            Point loc = new Point(viewBounds.x, viewBounds.y + viewBounds.height);
            SwingUtilities.convertPointToScreen(loc, viewComp.getParent());
            this.setLocation(loc);
            UIUtil.verifyWindowOnScreen((Window)((Object)this));
        }
    }

    protected class BaseOptionsPanel
    extends JPanel {
        protected JTextField mTxtDevice;
        protected JTextField mTxtLayer;
        protected JTextField mTxtGrid;

        public BaseOptionsPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            this.mTxtDevice = this.createTextDisplay("Device:", l);
            this.mTxtLayer = this.createTextDisplay("Layer:", l);
            this.mTxtGrid = this.createTextDisplay("Grid:", l);
            this.mTxtGrid.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        EditRouteMode.this.queryUserGrid();
                        e.consume();
                    }
                }
            });
        }

        protected JTextField createTextDisplay(String lbl, GridBagManager l) {
            l.add(lbl, (GridBagConstraints)GridBagManager.LEFT.insets(INSETS_RIBBON));
            JTextField f = (JTextField)l.add((Component)new JTextField(16), (GridBagConstraints)GridBagManager.FILLX.insets(INSETS_RIBBON));
            f.setEditable(false);
            f.setFocusable(false);
            Dimension prefSize = f.getPreferredSize();
            f.setColumns(0);
            f.setMinimumSize(new Dimension(0, prefSize.height));
            f.setPreferredSize(prefSize);
            return f;
        }
    }

    public static interface SubMode {
        public boolean install(EditRouteMode var1);

        public void uninstall();

        public APoint2D mouseClicked(int var1, APoint2D var2);

        public APoint2D mouseMoved(APoint2D var1, APoint2D var2);

        public void paintOverlay(Graphics2D var1, Rectangle var2);

        public LinkedList<Component> getContextMenu(Point var1);

        public static interface RawCoords {
        }
    }
}

