/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.route_edit;

import bsh.EvalError;
import com.sigrity.acl.AColor;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AExpression;
import com.sigrity.acl.AGridUtil;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DeviceRegionMap;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APoint2DDouble;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.dlg.SelectFromListDlg;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPortShape;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.cmd.BundleCommands;
import com.sigrity.orbit.cmd.WireCommands;
import com.sigrity.orbit.factory.ViaFactory;
import com.sigrity.orbit.ui.DeviceChooser;
import com.sigrity.orbit.ui.DeviceListCellRenderer;
import com.sigrity.orbit.ui.GridChooser;
import com.sigrity.orbit.ui.GridOverlay;
import com.sigrity.orbit.ui.LayerChooser;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_modes.SpotLight;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.wb_route.RouteQueueDlg;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.ArrayUtils;

public class InteractiveRouteEditMode
extends AbstractViewMode {
    public static final String MODE_NAME = "InteractiveRouteEditor";
    public static final int SNAP_EPS_DEG = 8;
    public static final double SNAP_EPS_COLINEAR = 0.03;
    public static final Icon ICON_ROUTE_EDIT = OrbitIcons.ROUTE_EDIT;
    static final Color CURSOR_COLOR = Color.RED;
    static final Color CURSOR_COLOR_XOR = Color.WHITE;
    static final int CURSOR_LEG_SIZE = 7;
    static final Color HIGHLIGHT_COLOR = Color.YELLOW;
    static final Color DRAG_COLOR = Color.RED;
    static final Color CANDIDATE_COLOR = AColor.withAlpha((Color)Color.WHITE, (int)128);
    static final Color CANDIDATE_OUTLINE_COLOR = Color.WHITE;
    protected static final float[] DASH_PATTERN = new float[]{4.0f, 3.0f};
    protected static final Stroke STROKE_DASH = new BasicStroke(1.0f, 0, 0, 1.0f, DASH_PATTERN, 0.0f);
    protected int mOptionalSnappingDist = 32;
    protected OptionsUI mOptionsUI = null;
    protected Overlay mOverlay = null;
    protected DevicePath mRouteOwner = null;
    protected Layer mLayer = null;
    protected Net mNet = null;
    protected NamedGrid mGrid = null;
    protected long mRouteWidth = 0L;
    protected boolean mShowOptionsUIOnInstall = true;
    protected DesignView2D.ViewMode mEditEndMode = null;
    protected OverlayPainter mPrePaint = null;
    protected OverlayPainter mPostPaint = null;
    protected LinkedList<HierPortShape> mNetShapesOnLayer = null;
    protected Mode mMode = null;
    protected int mRoutingAngle = 90;
    protected APoint2D mCursorPt = null;
    protected boolean mDimBlockedAreas = true;
    protected boolean mNetUnusedIsObstacle = true;
    protected HierPortShape mTarget = null;
    protected APoint2D mTargetPt = null;
    protected boolean mUsingWires = true;
    public static final int HANDLE_SIZE = 7;
    protected LinkedHashSet<EditListener> mEditListeners = new LinkedHashSet();

    public static void install(DesignView2D view) {
        if (view == null) {
            return;
        }
        view.setMode(new InteractiveRouteEditMode());
    }

    public static InteractiveRouteEditMode installBundleEditMode(DesignView2D view) {
        if (view == null) {
            return null;
        }
        InteractiveRouteEditMode iredm = new InteractiveRouteEditMode();
        iredm.setUsingWires(false);
        iredm.mRoutingAngle = 45;
        iredm.setShowOptionsUIOnInstall(false);
        view.setMode(iredm);
        return iredm;
    }

    public static InteractiveRouteEditMode startNewWire(DesignView2D view, boolean showOptionsUI) {
        if (view == null) {
            return null;
        }
        InteractiveRouteEditMode irem = new InteractiveRouteEditMode();
        irem.setShowOptionsUIOnInstall(showOptionsUI);
        view.setMode(irem);
        irem.setEditMode(irem.new NewWireMode());
        return irem;
    }

    public static InteractiveRouteEditMode startEditWire(DesignView2D view, DevicePath path, Wire wire, boolean showOptionsUI) {
        if (view == null) {
            return null;
        }
        DesignView2D.ViewMode oldMode = view.getCurMode();
        InteractiveRouteEditMode irem = new InteractiveRouteEditMode();
        irem.setShowOptionsUIOnInstall(showOptionsUI);
        view.setMode(irem);
        irem.setDevice(path);
        irem.startEditing(wire);
        irem.setEndEditMode(oldMode);
        return irem;
    }

    public static InteractiveRouteEditMode startEditBundle(DesignView2D view, DevicePath path, Bundle bundle, boolean showOptionsUI) {
        if (view == null) {
            return null;
        }
        DesignView2D.ViewMode oldMode = view.getCurMode();
        InteractiveRouteEditMode irem = InteractiveRouteEditMode.installBundleEditMode(view);
        view.setMode(irem);
        irem.setShowOptionsUIOnInstall(showOptionsUI);
        irem.setDevice(path);
        irem.setEndEditMode(oldMode);
        irem.startEditingBundle(bundle);
        return irem;
    }

    public static void editBundleInit(Bundle bundle) {
        DeviceTemplate dt = bundle.getTemplate();
        Device d = dt.getAnInstance();
        DevicePath path = d.getADevicePath();
        if (RouteQueueDlg.getLastDialog() != null) {
            RouteQueueDlg.getLastDialog().removeNotify();
        }
        InteractiveRouteEditMode.startEditBundle((DesignView2D)OrbitIO.getCurView(), path, bundle, false);
    }

    public void setUsingWires(boolean usingWires) {
        this.mUsingWires = usingWires;
    }

    public boolean getUsingWires() {
        return this.mUsingWires;
    }

    @Override
    public String getName() {
        return "Interactive Route Editing";
    }

    @Override
    public Cursor getCursor() {
        return UIUtil.createCursor((Icon)ICON_ROUTE_EDIT);
    }

    @Override
    public void installMode(DesignView2D view) {
        super.installMode(view);
        this.mOverlay = new Overlay(null);
        view.addOverlay(this.mOverlay);
        this.mOverlay.setCursor(this.getCursor());
        if (this.mShowOptionsUIOnInstall) {
            this.mOptionsUI = new OptionsUI();
        }
        this.setEditMode(new EditWireMode());
        Cp.exec((String)"import com.sigrity.orbit.cmd.WireCommands", (Object[])new Object[0]);
    }

    @Override
    public void uninstallMode() {
        this.setEditMode(null);
        if (this.mOverlay != null) {
            this.mView.removeOverlay(this.mOverlay);
            this.mOverlay = null;
        }
        if (this.mOptionsUI != null) {
            UIUtil.closeWindow((Window)((Object)this.mOptionsUI));
        }
        super.uninstallMode();
    }

    public APoint2D getDeviceRelativePt(APoint2D worldPt) {
        if (this.mRouteOwner == null) {
            return worldPt;
        }
        return worldPt.transform(ATransformUtil.inverse((AffineTransform)this.mRouteOwner.getTransform()));
    }

    public DbObject getEditObject() {
        if (this.mUsingWires) {
            return this.getEditWire();
        }
        return this.getEditBundle();
    }

    public APath getEditObjectPath() {
        DbObject dbo = this.getEditObject();
        if (dbo == null) {
            return null;
        }
        return this.mUsingWires ? ((Wire)dbo).getPath() : ((Bundle)dbo).getPath();
    }

    public Wire getEditWire() {
        try {
            Wire w = (Wire)Cp.getCp().getInterpreter().get("ireWire");
            if (w != null && w.getDb() != this.mView.getDb()) {
                this.clearEditObject();
                return null;
            }
            return w;
        }
        catch (EvalError e) {
            ALog.logDebug((Throwable)e, (String)"Unexpected error getting current edit wire.", (Object[])new Object[0]);
            return null;
        }
    }

    public Bundle getEditBundle() {
        try {
            Bundle b = (Bundle)Cp.getCp().getInterpreter().get("ireBundle");
            if (b != null && b.getDb() != this.mView.getDb()) {
                this.clearEditObject();
                return null;
            }
            return b;
        }
        catch (EvalError e) {
            ALog.logDebug((Throwable)e, (String)"Unexpected error getting current edit bundle.", (Object[])new Object[0]);
            return null;
        }
    }

    public HierInst<DbObject> getEditHierObject() {
        HierInst ho = null;
        if (this.mUsingWires) {
            HierInst<Wire> hw = this.getEditHierWire();
            if (hw != null) {
                ho = new HierInst((DevicePath)hw.first, (DbObject)hw.second);
            }
        } else {
            HierInst<Bundle> hw = this.getEditHierBundle();
            if (hw != null) {
                ho = new HierInst((DevicePath)hw.first, (DbObject)hw.second);
            }
        }
        return ho;
    }

    public HierInst<Wire> getEditHierWire() {
        Wire w = this.getEditWire();
        if (w == null) {
            return null;
        }
        return new HierInst(this.mRouteOwner, (DbObject)w);
    }

    public HierInst<Bundle> getEditHierBundle() {
        Bundle b = this.getEditBundle();
        if (b == null) {
            return null;
        }
        return new HierInst(this.mRouteOwner, (DbObject)b);
    }

    public HierInst<PortTemplate> getVia(int vertexIdx) {
        Wire wire = this.getEditWire();
        return wire == null ? null : wire.getViaPin(vertexIdx);
    }

    public APair<Wire, Integer> getViaConnectedWire(int vertexIdx) {
        Wire editWire = this.getEditWire();
        HierInst<PortTemplate> hVia = this.getVia(vertexIdx);
        if (hVia == null) {
            return null;
        }
        if (!hVia.getPath().isEmpty()) {
            return null;
        }
        for (APair wire : ((PortTemplate)hVia.getDbObject()).getConnectedWires()) {
            if (wire.first == editWire) continue;
            return wire;
        }
        return null;
    }

    public void notifyEditWireSet(Wire w) {
        this.validateTarget();
        this.fireEditWireChanged();
    }

    public void clearEditObject() {
        if (this.mUsingWires) {
            Cp.exec((String)"unset(\"ireWire\")", (Object[])new Object[0]);
        } else {
            Cp.exec((String)"unset(\"ireBundle\")", (Object[])new Object[0]);
        }
        this.fireEditWireChanged();
    }

    protected boolean addWirePt(APoint2D worldPt) {
        APoint2D pt = this.getDeviceRelativePt(worldPt);
        if (this.getEditWire() == null) {
            DeviceTemplate template = this.mRouteOwner.getLast().getTemplate();
            Net net = this.mNet == null ? template.getNetUnused() : this.mNet;
            Cp.exec((String)"unset(\"ireWire\")", (Object[])new Object[0]);
            Cp.exec((String)"ireWire = WireCommands.createWire(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{template.getKeyStr(), net.getName(), this.mLayer.getName()});
            Object o = Cp.exec((boolean)false, (String)"ireWire", (Object[])new Object[0]);
            if (!(o instanceof Wire)) {
                ALog.logError((Throwable)new RuntimeException("Unexpected command result"), (String)"Error creating Wire.", (Object[])new Object[0]);
                assert (false);
                Cp.exec((String)"unset(\"ireWire\")", (Object[])new Object[0]);
                return false;
            }
            Wire w = (Wire)o;
            this.notifyEditWireSet(w);
            Cp.exec((String)"WireCommands.setWireWidth(ireWire, %dL)", (Object[])new Object[]{this.mRouteWidth});
        }
        Cp.exec((String)"WireCommands.addWirePoint(ireWire, %dL, %dL)", (Object[])new Object[]{pt.getX(), pt.getY()});
        this.mView.repaint();
        return true;
    }

    public long getMouseSensitivity() {
        return this.getWorldLen(8);
    }

    public void setEndEditMode(DesignView2D.ViewMode mode) {
        this.mEditEndMode = mode;
    }

    public void setShowOptionsUIOnInstall(boolean b) {
        this.mShowOptionsUIOnInstall = b;
    }

    public void setPrePaint(OverlayPainter painter) {
        this.mPrePaint = painter;
    }

    public void setPostPaint(OverlayPainter painter) {
        this.mPostPaint = painter;
    }

    public void setDevice(DevicePath path) {
        if (this.mRouteOwner != path) {
            this.mRouteOwner = path;
            this.mOverlay.setDevicePath(path);
        }
        this.updateOptionsUI();
        this.validateSelectedLayer();
    }

    public void setLayer(Layer layer) {
        this.mLayer = layer;
        this.updateOptionsUI();
        if (layer != null && this.getEditWire() != null && this.getEditWire().getLayer() != this.mLayer) {
            Cp.exec((String)"WireCommands.setWireLayer(ireWire, \"%s\")", (Object[])new Object[]{layer.getName()});
            this.repaintView();
        }
    }

    public void setNet(Net net) {
        if (this.mNet == net) {
            return;
        }
        this.mNet = net;
        this.updateOptionsUI();
        if (net != null && this.getEditWire() != null && this.getEditWire().getNet() != net) {
            Cp.exec((String)"WireCommands.setWireNet(ireWire, \"%s\")", (Object[])new Object[]{net.getName()});
            this.repaintView();
        }
        this.mNetShapesOnLayer = this.findCandidatesOfCurNet();
    }

    public void setGrid(NamedGrid g) {
        this.mGrid = g;
        this.mOverlay.setGrid(g);
        this.updateOptionsUI();
    }

    public void setRouteWidth(long w) {
        this.mRouteWidth = w;
        this.updateOptionsUI();
        this.repaintOverlay();
        Wire wire = this.getEditWire();
        if (w > 0L && wire != null && wire.getWidth() != w) {
            Cp.exec((String)"WireCommands.setWireWidth(ireWire, %dL)", (Object[])new Object[]{w});
            this.repaintView();
        }
    }

    public void setRouteAngle(int angle) {
        this.mRoutingAngle = angle;
        this.updateOptionsUI();
        this.repaintOverlay();
    }

    public void startEditing(Wire wire) {
        this.clearInformUser();
        if (this.mRouteOwner == null) {
            String msg = "Must set Device before calling startEditing(Wire).";
            ALog.logError((Throwable)new IllegalStateException(msg), (String)msg, (Object[])new Object[0]);
            assert (false);
            return;
        }
        APoint2D p0 = wire.getPath().getPoint(0);
        p0 = this.mRouteOwner.transformPt(p0);
        int n = -1;
        int idx = 0;
        for (Wire w : WireCommands.getWires(this.mRouteOwner, p0.getX(), p0.getY())) {
            if (w == wire) {
                n = idx;
                break;
            }
            ++idx;
        }
        if (n < 0) {
            ALog.logError((String)"Unable to start editing specified Wire. Is it from the current edit Device '%s'?", (Object[])new Object[]{this.mRouteOwner.getString()});
            return;
        }
        Cp.exec((String)"unset(\"ireWire\")", (Object[])new Object[0]);
        Cp.exec((String)"ireWire = WireCommands.getNthWire(curDb(), \"%s\", %dL, %dL, %d)", (Object[])new Object[]{this.mRouteOwner.getString(), p0.getX(), p0.getY(), n});
        Wire setWire = this.getEditWire();
        assert (setWire == wire);
        this.notifyEditWireSet(setWire);
    }

    public void startEditingBundle(Bundle bundle) {
        this.clearInformUser();
        if (this.mRouteOwner == null) {
            String msg = "Must set Device before calling startEditing(Wire).";
            ALog.logError((Throwable)new IllegalStateException(msg), (String)msg, (Object[])new Object[0]);
            assert (false);
            return;
        }
        this.clearEditObject();
        Cp.exec((String)"ireBundle= curDb().getByKeyStr(Bundle.class, \"%s\");", (Object[])new Object[]{bundle.getKeyStr()});
    }

    public void simulateMouseClick(APoint2D worldPt) {
        Point pt = this.getScreenPoint(worldPt);
        MouseEvent me = new MouseEvent(this.getViewComponent(), 500, new Date().getTime(), 0, pt.x, pt.y, 1, false, 1);
        this.mouseClicked(new DesignView2D.MouseAction(me));
    }

    public void setTarget(HierPortShape target) {
        HierPortShape oldTarget = this.mTarget;
        this.mTarget = target;
        this.validateTarget();
        if (!AUtil.equals((Object)oldTarget, (Object)this.mTarget)) {
            this.mTargetPt = this.mTarget == null ? null : this.mTarget.getCenter();
            this.repaintOverlay();
        }
    }

    protected void validateTarget() {
        if (this.mTarget == null) {
            return;
        }
        Wire w = this.getEditWire();
        if (w == null) {
            return;
        }
        DevicePath targetDPath = this.mTarget.getDevicePath();
        if (this.mRouteOwner != null && !this.mRouteOwner.equals((Object)targetDPath) && !this.mTarget.getDevicePath().isChildOf(this.mRouteOwner)) {
            this.setTarget(null);
            return;
        }
        Net wireNet = w.getNet();
        Net tgtNet = this.mTarget.getNet();
        boolean netOk = false;
        if (wireNet == null || wireNet.isUnused()) {
            netOk = true;
        }
        if (tgtNet == null || tgtNet.isUnused()) {
            netOk = true;
        }
        if (!netOk && AUtil.equals((Object)wireNet, (Object)tgtNet)) {
            netOk = true;
        }
        if (!netOk && NetMap.isConnected((Net)wireNet, (DevicePath)this.mRouteOwner, (Net)this.mTarget.getNet(), (DevicePath)this.mTarget.getDevicePath())) {
            netOk = true;
        }
        if (!netOk) {
            this.setTarget(null);
            return;
        }
    }

    protected void updateOptionsUI() {
        if (this.mOptionsUI != null) {
            this.mOptionsUI.updateData();
        }
    }

    protected Substrate getSubstrate() {
        if (this.mRouteOwner != null && !this.mRouteOwner.isEmpty()) {
            return this.mRouteOwner.getSubstrate();
        }
        return null;
    }

    protected boolean validateSelectedLayer() {
        if (this.mLayer == null) {
            return false;
        }
        Substrate s = this.getSubstrate();
        if (s == null) {
            return false;
        }
        if (this.mLayer.getSubstrate() == s) {
            return true;
        }
        this.setLayer(null);
        return false;
    }

    protected void setEditMode(Mode mode) {
        if (this.mMode != null && !this.mMode.uninstall()) {
            return;
        }
        this.mMode = null;
        if (mode != null && mode.install()) {
            this.mMode = mode;
        }
        this.updateOptionsUI();
        this.repaintOverlay();
    }

    public NamedGrid getGrid() {
        return this.mGrid;
    }

    public AGrid getAGrid() {
        return this.mGrid == null ? null : this.mGrid.getGrid();
    }

    protected HierInst<Wire> findWire(APoint2D loc, boolean useCp) {
        long delta = this.getWorldLen(1);
        if (!useCp) {
            return WireCommands.findWireAtLoc(this.mView, loc.getX(), loc.getY(), delta, this.mRouteOwner == null ? null : "" + this.mRouteOwner);
        }
        String strDPath = this.mRouteOwner == null ? "null" : String.format("\"%s\"", this.mRouteOwner);
        Cp.exec((String)"unset(\"ireWire\")", (Object[])new Object[0]);
        HierInst hw = (HierInst)Cp.exec((String)"ireWire = WireCommands.findWireAtLoc(OrbitIO.getCurView(), %dL, %dL, %dL, %s)", (Object[])new Object[]{loc.getX(), loc.getY(), delta, strDPath});
        if (hw != null) {
            Cp.exec((String)"ireWire = ireWire.getDbObject()", (Object[])new Object[0]);
            this.setDevice(hw.getPath());
        }
        this.notifyEditWireSet(this.getEditWire());
        return hw;
    }

    protected HierInst<Bundle> findBundle(APoint2D loc, boolean useCp) {
        long delta = this.getWorldLen(1);
        if (!useCp) {
            return BundleCommands.findBundleAtLoc(this.mView, loc.getX(), loc.getY(), delta, this.mRouteOwner == null ? null : "" + this.mRouteOwner);
        }
        String strDPath = this.mRouteOwner == null ? "null" : String.format("\"%s\"", this.mRouteOwner);
        this.clearEditObject();
        HierInst hb = (HierInst)Cp.exec((String)"ireBundle = BundleCommands.findBundleAtLoc(OrbitIO.getCurView(), %dL, %dL, %dL, %s)", (Object[])new Object[]{loc.getX(), loc.getY(), delta, strDPath});
        if (hb != null) {
            Cp.exec((String)"ireBundle = ireBundle.getDbObject()", (Object[])new Object[0]);
            this.setDevice(hb.getPath());
        }
        return hb;
    }

    protected APath getPath(HierInst<DbObject> ho) {
        APath path = null;
        path = this.mUsingWires ? ((Wire)ho.getDbObject()).getPath() : ((Bundle)ho.getDbObject()).getPath();
        return path;
    }

    protected APath getPath(DbObject o) {
        APath path = null;
        path = this.mUsingWires ? ((Wire)o).getPath() : ((Bundle)o).getPath();
        return path;
    }

    protected int[] findVertexOrSegment(HierInst<DbObject> ho, APoint2D loc, long maxDist) {
        if (ho == null) {
            return null;
        }
        int bestVertex = -1;
        int bestSegStart = -1;
        long bestDist = Long.MAX_VALUE;
        APoint2D devRelLoc = loc.transform(ATransformUtil.inverse((AffineTransform)ho.getPath().getTransform()));
        List pts = this.getPath(ho).getPointList();
        for (int idx = 0; idx < pts.size(); ++idx) {
            APoint2D pt0;
            ALine l;
            APoint2D pt = (APoint2D)pts.get(idx);
            long dist = pt.distance(devRelLoc);
            if (dist <= maxDist && dist <= bestDist) {
                bestVertex = idx;
                bestDist = dist;
            }
            if (idx <= 0 || (dist = (l = new ALine(pt0 = (APoint2D)pts.get(idx - 1), pt)).distance(devRelLoc)) > maxDist || dist > bestDist) continue;
            bestSegStart = idx - 1;
            bestDist = dist;
        }
        if (bestVertex >= 0) {
            return new int[]{bestVertex};
        }
        if (bestSegStart >= 0) {
            return new int[]{bestSegStart, bestSegStart + 1};
        }
        return null;
    }

    protected boolean selectDevice(APoint2D byLoc) {
        DevicePath path = null;
        if (byLoc != null) {
            path = this.mView.getDeviceAt(byLoc, "Select Device", true);
        } else {
            DeviceChooser.InitHook ih = new DeviceChooser.InitHook(){

                @Override
                public void initDeviceChooser(DeviceChooser.DCPanel dc) {
                    JPanel cpanel = dc.getCustomTopPanel();
                    cpanel.setVisible(true);
                    GridBagManager l = GridBagManager.layout((Container)cpanel);
                    JCheckBox cbOnlySubstrates = (JCheckBox)l.add((Component)new JCheckBox("Limit to substrates"));
                    cbOnlySubstrates.setSelected(true);
                    l.add((Component)cbOnlySubstrates, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
                    cbOnlySubstrates.addActionListener(e -> dc.updateAllDevices());
                    dc.setDeviceFilter(d -> !cbOnlySubstrates.isSelected() || d.getIsSubstrate());
                }
            };
            path = DeviceChooser.getDevicePath(this.mView, this.mView.getDb(), ih);
        }
        if (path == null) {
            return false;
        }
        this.setDevice(path);
        return true;
    }

    protected boolean selectLayer(boolean auto) {
        Layer l;
        Substrate s = this.getSubstrate();
        if (s == null) {
            if (auto) {
                return false;
            }
            if (!this.selectDevice(null)) {
                return false;
            }
        }
        if ((s = this.getSubstrate()) == null) {
            return false;
        }
        if (auto) {
            for (Layer l2 : s.getLayers()) {
                if (l2.getType() != Layer.LayerType.Route) continue;
                this.setLayer(l2);
                return true;
            }
            for (Layer l2 : s.getLayers()) {
                switch (l2.getType()) {
                    case Mixed: 
                    case Power: 
                    case Signal: {
                        this.setLayer(l2);
                        return true;
                    }
                }
            }
        }
        if ((l = LayerChooser.getLayer(this.mView, s)) != null) {
            this.setLayer(l);
            return true;
        }
        return false;
    }

    protected boolean selectGrid(boolean auto) {
        NamedGrid grid;
        if (auto) {
            NamedGrid mg;
            Substrate s = this.getSubstrate();
            if (s != null && (mg = NamedGrid.get((Substrate)s, (String)"Manufacturing Grid")) != null) {
                this.setGrid(mg);
                return true;
            }
            this.setGrid(null);
            return true;
        }
        NamedGrid curGrid = this.mGrid;
        if (this.getSubstrate() == null && !this.selectDevice(null)) {
            return false;
        }
        ArrayList<NamedGrid> extraGrids = new ArrayList<NamedGrid>();
        extraGrids.add(NamedGrid.NONE);
        if (curGrid != null && !curGrid.isStored()) {
            extraGrids.add(curGrid);
        }
        if ((grid = GridChooser.getGrid(this.mView, this.getSubstrate(), this.mView.getUnit(), curGrid, extraGrids)) == NamedGrid.NONE) {
            grid = null;
        }
        this.setGrid(grid);
        return true;
    }

    protected boolean selectRouteWidth(boolean auto) {
        if (auto) {
            this.mRouteWidth = Design.micronToInternal((Db)this.mView.getDb(), (double)1.0);
            return true;
        }
        Unit u = this.mView.getUnit();
        String strCurWidth = u.toUserStr(this.mRouteWidth >= 0L ? this.mRouteWidth : 0L);
        Window owner = (Window)UIUtil.getAncestorOfType((Component)this.mView, Window.class);
        AFloatWindow d = new AFloatWindow(owner, "Set Routing Width", Dialog.ModalityType.DOCUMENT_MODAL);
        GridBagManager l = new GridBagManager(d.getContentPane());
        l.add("Width:");
        JTextField txtWidth = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        txtWidth.setText(strCurWidth);
        l.newline();
        l.addFillX();
        JButton btnOK = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
        btnOK.addActionListener(e -> {
            double userWidth = 0.0;
            try {
                userWidth = AFieldValidator.getValidatedDouble((JTextField)txtWidth);
            }
            catch (AFieldValidator.AFieldValidationException e1) {
                return;
            }
            long width = u == null ? (long)userWidth : u.fromUser(userWidth);
            this.setRouteWidth(width);
            UIUtil.closeWindow((Window)((Object)d));
        });
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)d), (AbstractButton)btnCancel, (JButton)btnOK);
        d.pack();
        UIUtil.center((Component)((Object)d));
        txtWidth.requestFocus();
        d.setVisible(true);
        return true;
    }

    protected boolean selectRouteAngle(boolean auto) {
        if (auto) {
            this.mRoutingAngle = 0;
            return true;
        }
        Window owner = (Window)UIUtil.getAncestorOfType((Component)this.mView, Window.class);
        AFloatWindow d = new AFloatWindow(owner, "Set Routing Angle", Dialog.ModalityType.DOCUMENT_MODAL);
        GridBagManager l = new GridBagManager(d.getContentPane());
        l.add("Angle:");
        JComboBox cboAngle = (JComboBox)l.add(new JComboBox<RoutingAngle>(RoutingAngle.values()), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        cboAngle.setSelectedItem((Object)RoutingAngle.valueOf(this.mRoutingAngle));
        l.newline();
        l.addFillX();
        JButton btnOK = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
        btnOK.addActionListener(e -> {
            RoutingAngle ra = (RoutingAngle)((Object)((Object)cboAngle.getSelectedItem()));
            if (ra == null) {
                JOptionPane.showMessageDialog((Component)((Object)d), "Invalid routing angle", "Invalid Data", 0);
            } else {
                this.setRouteAngle(ra.angle);
                UIUtil.closeWindow((Window)((Object)d));
            }
        });
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)d), (AbstractButton)btnCancel, (JButton)btnOK);
        d.pack();
        UIUtil.center((Component)((Object)d));
        cboAngle.requestFocus();
        d.setVisible(true);
        return true;
    }

    protected void setCursorLoc(APoint2D worldLoc) {
        if (APoint2D.isEqualPoint((APoint2D)this.mCursorPt, (APoint2D)worldLoc)) {
            return;
        }
        this.mCursorPt = worldLoc;
        this.mOverlay.drawRoutingCursor(null);
    }

    public APoint2D getCursorLoc() {
        return this.mCursorPt;
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (this.mMode != null) {
            this.mMode.mouseClick(e);
        }
    }

    @Override
    public void mouseDragged(DesignView2D.MouseAction e) {
        super.mouseDragged(e);
        if (this.mMode != null) {
            this.mMode.mouseDrag(e);
        }
    }

    @Override
    public void mouseEntered(DesignView2D.MouseAction e) {
        super.mouseEntered(e);
        if (this.mMode != null) {
            this.mMode.mouseEnter(e);
        }
    }

    @Override
    public void mouseExited(DesignView2D.MouseAction e) {
        super.mouseExited(e);
        if (this.mMode != null) {
            this.mMode.mouseExit(e);
        }
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        if (this.mMode != null) {
            this.mMode.mouseMove(e);
        }
    }

    @Override
    public void mousePressed(DesignView2D.MouseAction e) {
        super.mousePressed(e);
        if (this.mMode != null) {
            this.mMode.mousePress(e);
        }
    }

    @Override
    public void mouseReleased(DesignView2D.MouseAction e) {
        super.mouseReleased(e);
        if (this.mMode != null) {
            this.mMode.mouseRelease(e);
        }
    }

    protected boolean autoExitEditing() {
        if (this.mEditEndMode == null) {
            return false;
        }
        Bundle b = this.getEditBundle();
        if (b != null) {
            b.getTemplate().invalidateAll2DIndices();
        }
        DesignView2D.ViewMode m = this.mEditEndMode;
        this.mEditEndMode = null;
        this.mView.setMode(m);
        return true;
    }

    protected void concatMenuItems(JPopupMenu menu, Collection<Component> items) {
        for (Component i : items) {
            menu.add(i);
        }
    }

    protected void removeMenuItems(JPopupMenu menu, Collection<Component> items) {
        for (Component i : items) {
            menu.remove(i);
        }
    }

    public LinkedList<Component> getContextMenu(Point loc) {
        LinkedList<Component> items = new LinkedList<Component>();
        items.add(new JSeparator());
        JCheckBoxMenuItem cbShowOptions = new JCheckBoxMenuItem(new AbstractAction(){
            {
                this.putValue("Name", "Show Route Editing Options");
                this.putValue("SwingSelectedKey", InteractiveRouteEditMode.this.mOptionsUI != null);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InteractiveRouteEditMode.this.mOptionsUI == null) {
                    InteractiveRouteEditMode.this.mOptionsUI = new OptionsUI();
                } else {
                    UIUtil.closeWindow((Window)((Object)InteractiveRouteEditMode.this.mOptionsUI));
                }
            }
        });
        items.add(cbShowOptions);
        items.add(new JSeparator());
        for (Action a : this.mMode.getActions(loc)) {
            items.add(new JMenuItem(a));
        }
        return items;
    }

    @Override
    protected void loadContextMenu(AbstractViewMode.ContextMenu menu, Point loc) {
        LinkedList<Component> modeItems = this.getContextMenu(loc);
        this.concatMenuItems(menu, modeItems);
        menu.setDelayUpdatedEnabled(false);
        OrbitGuiShortcutActionRegistry.ViewConstraint vc = OrbitGuiShortcutActionRegistry.ViewConstraint.createEmpty();
        vc.add(Bundle.class);
        menu.loadMenu(loc, vc);
    }

    @Override
    protected boolean showContextMenu(JPopupMenu menu, Point loc) {
        this.mMode.prepareContexMenu(menu, loc);
        return super.showContextMenu(menu, loc);
    }

    protected LinkedList<HierPortShape> findCandidatesOfCurNet() {
        LinkedList<HierPortShape> candidates = new LinkedList<HierPortShape>();
        if (this.mNet == null) {
            return candidates;
        }
        HashSet<DevicePath> processed = new HashSet<DevicePath>();
        for (DevicePath p : this.mRouteOwner.getDescendants(true)) {
            DeviceTemplate template;
            if (processed.contains(p)) continue;
            processed.add(p);
            Object object = template = p.isEmpty() ? Design.getDesign((Db)this.mView.getDb()) : p.getLast().getTemplate();
            if (template == null) continue;
            for (PinTemplate pinTmplt : template.getPins()) {
                if (this.mNet != pinTmplt.getNet() && !NetMap.isConnected((Net)this.mNet, (DevicePath)this.mRouteOwner, (Net)pinTmplt.getNet(), (DevicePath)p)) continue;
                for (PortTemplate portTmplt : pinTmplt.getPortTemplates()) {
                    for (LayerShape ls : portTmplt.getLayerShapes(this.mLayer)) {
                        candidates.add(new HierPortShape(p, portTmplt, ls));
                    }
                }
            }
        }
        return candidates;
    }

    public static void smoothPathDeg45(APath path, Long minLength) {
        double EPS = 1.0E-6;
        ArrayList<APoint2D> pts = new ArrayList<APoint2D>();
        APoint2D prePt = path.getPoint(0);
        int n = path.getPointCount();
        pts.add(prePt);
        for (int i = 1; i < n - 1; ++i) {
            APoint2D curPt = path.getPoint(i);
            APoint2D nxtPt = path.getPoint(i + 1);
            double angle = Math.abs(curPt.getAngle(prePt) - curPt.getAngle(nxtPt));
            if (Math.abs(angle - 90.0) < 1.0E-6 || Math.abs(angle - 270.0) < 1.0E-6) {
                long bendLength = 0L;
                bendLength = minLength == null || Math.min(prePt.distance(curPt), nxtPt.distance(curPt)) < minLength ? Math.min(prePt.distance(curPt), nxtPt.distance(curPt)) / 2L : minLength;
                long dx = prePt.getX() - curPt.getX();
                long dy = prePt.getY() - curPt.getY();
                double ratio = (double)bendLength / (double)prePt.distance(curPt);
                APoint2D preMidPt = new APoint2D((double)curPt.getX() + (double)dx * ratio, (double)curPt.getY() + (double)dy * ratio);
                dx = nxtPt.getX() - curPt.getX();
                dy = nxtPt.getY() - curPt.getY();
                ratio = (double)bendLength / (double)nxtPt.distance(curPt);
                APoint2D nxtMidPt = new APoint2D((double)curPt.getX() + (double)dx * ratio, (double)curPt.getY() + (double)dy * ratio);
                pts.add(preMidPt);
                pts.add(nxtMidPt);
                curPt = nxtMidPt;
            } else {
                pts.add(curPt);
            }
            prePt = curPt;
        }
        pts.add(path.getPoint(n - 1));
        path.removeAllPoints();
        path.addPoints(pts);
    }

    protected HierPortShape findCandidate(APoint2D worldPt) {
        Db db;
        Db db2 = db = this.mView == null ? null : this.mView.getDb();
        if (db == null) {
            return null;
        }
        if (this.mNet == null) {
            Design design = Design.getDesign((Db)db);
            if (design == null) {
                return null;
            }
            HierPortShape best = null;
            double bestArea = Double.MAX_VALUE;
            DeviceRegionMap.ObjectFilter filter = new DeviceRegionMap.ObjectFilter();
            filter.addDbClass(db.getDbClass(PortTemplate.class));
            for (HierInst hinst : design.getObjectsAt(worldPt, filter)) {
                DbObject dbo;
                if (this.mRouteOwner != null && !this.mRouteOwner.contains(hinst.getPath()) || !((dbo = hinst.getDbObject()) instanceof PortTemplate)) continue;
                PortTemplate pt = (PortTemplate)dbo;
                for (LayerShape ls : pt.getLayerShapes(this.mLayer)) {
                    double curArea;
                    AffineTransform xForm = hinst.getPath().getTransform();
                    xForm.concatenate(pt.getLocalTransform());
                    APoint2D testPt = worldPt.transform(ATransformUtil.inverse((AffineTransform)xForm));
                    AGeom curGeom = ls.getGeom();
                    if (!curGeom.intersects(testPt) || !((curArea = curGeom.getArea()) < bestArea)) continue;
                    best = new HierPortShape(hinst.getPath(), pt, ls);
                    bestArea = curArea;
                }
            }
            return best;
        }
        if (this.mNetShapesOnLayer == null) {
            return null;
        }
        for (HierPortShape hps : this.mNetShapesOnLayer) {
            APoint2D pt = worldPt.transform(ATransformUtil.inverse((AffineTransform)hps.getAggregateShapeTransform()));
            if (!hps.getGeom().intersects(pt)) continue;
            return hps;
        }
        return null;
    }

    protected static APoint2D getWorldLoc(HierInst<DbObject> ho, int vertexIdx) {
        if (ho == null) {
            return null;
        }
        DbObject object = (DbObject)ho.second;
        APath shape = null;
        shape = object instanceof Wire ? ((Wire)object).getPath() : ((Bundle)object).getPath();
        if (vertexIdx < 0 || vertexIdx > shape.getPointCount() - 1) {
            return null;
        }
        APoint2D pt = shape.getPoint(vertexIdx);
        return ((DevicePath)ho.first).transformPt(pt);
    }

    protected void drawWire(Graphics2D g, HierInst<DbObject> hwire, LinkedList<Point> screenPts) {
        APath shape = null;
        DevicePath devPath = null;
        if (this.mUsingWires) {
            Wire wire = (Wire)hwire.getDbObject();
            devPath = hwire.getPath();
            shape = wire.getPath();
        } else {
            Bundle bundle = (Bundle)hwire.getDbObject();
            devPath = hwire.getPath();
            shape = bundle.getPath();
        }
        int screenWidth = this.getScreenLen(shape.getWidth());
        if (screenWidth == 0) {
            screenWidth = 1;
        }
        GeneralPath screenPath = new GeneralPath();
        Point prevPt = null;
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(screenWidth, 1, 1));
        g.setColor(new Color(255, 255, 255, 128));
        for (APoint2D pt : shape.getPoints()) {
            APoint2D worldPoint = devPath.transformPt(pt);
            Point screenPt = this.getScreenPoint(worldPoint);
            if (prevPt != null) {
                screenPath.moveTo(prevPt.x, prevPt.y);
                screenPath.lineTo(screenPt.x, screenPt.y);
                g.draw(screenPath);
                screenPath.reset();
            }
            prevPt = screenPt;
            if (screenPts == null) continue;
            screenPts.add(screenPt);
        }
        g.setStroke(oldStroke);
    }

    protected void drawHandles(Graphics2D g, LinkedList<Point> handlePts, int[] highlightVertices) {
        Color oldColor = g.getColor();
        Composite oldComposite = g.getComposite();
        g.setPaintMode();
        if (highlightVertices != null && highlightVertices.length > 1) {
            APath shape = this.getPath(this.getEditObject());
            int screenWidth = Math.max(1, this.getScreenLen(shape.getWidth()));
            g.setColor(Color.WHITE);
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(screenWidth, 0, 1, 1.0f, DASH_PATTERN, 0.0f));
            for (int curVertex = 1; curVertex < highlightVertices.length; ++curVertex) {
                int i0 = highlightVertices[curVertex - 1];
                int i1 = highlightVertices[curVertex];
                if (i0 < 0 || i1 < 0 || i0 >= handlePts.size() || i1 >= handlePts.size()) continue;
                Point p0 = handlePts.get(i0);
                Point p1 = handlePts.get(i1);
                GeneralPath screenPath = new GeneralPath();
                screenPath.moveTo(p0.x, p0.y);
                screenPath.lineTo(p1.x, p1.y);
                g.draw(screenPath);
            }
            g.setStroke(oldStroke);
        }
        int idx = -1;
        for (Point pt : handlePts) {
            if (highlightVertices != null && ArrayUtils.contains((int[])highlightVertices, (int)(++idx))) {
                g.setColor(HIGHLIGHT_COLOR);
            } else {
                g.setColor(Color.CYAN);
            }
            this.drawHandle(g, pt);
        }
        g.setComposite(oldComposite);
        g.setColor(oldColor);
    }

    protected void drawHandle(Graphics2D g, Point pt) {
        Color oldColor = g.getColor();
        int half = 3;
        g.fillRect(pt.x - half + 1, pt.y - half + 1, 5, 5);
        g.setColor(Color.BLACK);
        g.drawRect(pt.x - half, pt.y - half, 6, 6);
        g.setColor(oldColor);
    }

    protected void drawTarget(Graphics2D g, Color c) {
        if (this.mTargetPt == null) {
            return;
        }
        Color oldColor = g.getColor();
        AffineTransform oldTransform = g.getTransform();
        Object oldAntiAliasing = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point targetPt = this.mView.getCanvas().getXForm().getScreenPt(this.mTargetPt);
        g.setColor(Color.RED);
        g.fillArc(targetPt.x - 9, targetPt.y - 9, 19, 19, 0, 360);
        g.setColor(Color.WHITE);
        g.fillArc(targetPt.x - 6, targetPt.y - 6, 13, 13, 0, 360);
        g.setColor(Color.RED);
        g.fillArc(targetPt.x - 3, targetPt.y - 3, 7, 7, 0, 360);
        g.setColor(Color.WHITE);
        g.drawLine(targetPt.x - 12, targetPt.y, targetPt.x + 12, targetPt.y);
        g.drawLine(targetPt.x, targetPt.y - 12, targetPt.x, targetPt.y + 12);
        if (this.mCursorPt != null) {
            g.setXORMode(Color.WHITE);
            g.setColor(c);
            Point cursorPt = this.mView.getCanvas().getXForm().getScreenPt(this.mCursorPt);
            g.drawLine(cursorPt.x, cursorPt.y, targetPt.x, targetPt.y);
        }
        g.setPaintMode();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAliasing);
        g.setTransform(oldTransform);
        g.setColor(oldColor);
    }

    public boolean sameWire(HierInst<Wire> wa, HierInst<Wire> wb) {
        if (wa == null && wb == null) {
            return true;
        }
        if (wa == null || wb == null) {
            return false;
        }
        return wa.equals(wb);
    }

    public boolean sameBundle(HierInst<Bundle> wa, HierInst<Bundle> wb) {
        if (wa == null && wb == null) {
            return true;
        }
        if (wa == null || wb == null) {
            return false;
        }
        return wa.equals(wb);
    }

    public APoint2D snap(APoint2D pt, APoint2D anchor) {
        ARect devBounds = this.mRouteOwner == null ? null : this.mRouteOwner.getBB();
        AGrid grid = this.mGrid == null ? null : this.mGrid.getGrid();
        return InteractiveRouteEditMode.snap(pt, anchor, grid, devBounds, this.mRoutingAngle);
    }

    protected void resetRouteOptions() {
        this.setTarget(null);
        this.setRouteWidth(0L);
        this.setGrid(null);
        this.setLayer(null);
        this.setDevice(null);
        this.setNet(null);
        this.setEditMode(new EditWireMode());
    }

    protected int drawLinesToNeighborVertices(Graphics2D g, Point anchorPt, APair<Wire, Integer> baseWireVertex, DevicePath dpathContext) {
        APath otherWireShape = ((Wire)baseWireVertex.first).getPath();
        int refPtIdx = (Integer)baseWireVertex.second;
        APoint2D prevPt = otherWireShape.getPointBefore(refPtIdx);
        APoint2D nextPt = otherWireShape.getPointAfter(refPtIdx);
        LinkedList<APoint2D> otherWirePts = new LinkedList<APoint2D>();
        if (prevPt != null) {
            otherWirePts.add(prevPt);
        }
        if (nextPt != null) {
            otherWirePts.add(nextPt);
        }
        for (APoint2D otherWirePt : otherWirePts) {
            Point otherScreenPt = this.getScreenPoint(dpathContext.transformPt(otherWirePt));
            g.drawLine(anchorPt.x, anchorPt.y, otherScreenPt.x, otherScreenPt.y);
        }
        return otherWirePts.size();
    }

    public static boolean isColinearVertex(APath path, int vertexIdx) {
        if (vertexIdx <= 0 || vertexIdx >= path.maxPtIdx()) {
            return false;
        }
        APoint2D before = path.getPoint(vertexIdx - 1);
        APoint2D ref = path.getPoint(vertexIdx);
        APoint2D end = path.getPoint(vertexIdx + 1);
        return InteractiveRouteEditMode.isApproxColinearVertex(before, end, ref);
    }

    public static boolean isColinearVertex(APath path, int vertexIdx, APoint2D ref) {
        if (vertexIdx <= 0 || vertexIdx >= path.maxPtIdx()) {
            return false;
        }
        APoint2D before = path.getPoint(vertexIdx - 1);
        APoint2D end = path.getPoint(vertexIdx + 1);
        return InteractiveRouteEditMode.isApproxColinearVertex(before, end, ref);
    }

    public static boolean isApproxColinearVertex(APoint2D st, APoint2D ed, APoint2D pt) {
        if (APoint2D.isColinear((APoint2D)st, (APoint2D)ed, (APoint2D)pt)) {
            return true;
        }
        ALine seg = new ALine(st, ed);
        APoint2DDouble proj = seg.closestOnLineTo(pt, false);
        double len = seg.getLengthD();
        double v = pt.distance((long)proj.getX(), (long)proj.getY());
        return v < 1.0 || v < len * 0.03;
    }

    protected boolean suitableForSnap(APoint2D pt, APoint2D ptAnchor, float constraintAngleDeg) {
        Point screenPt = this.getScreenPoint(pt);
        Point screenAnchorPt = this.getScreenPoint(ptAnchor);
        ptAnchor = new APoint2D((long)screenAnchorPt.x, (long)screenAnchorPt.y);
        pt = new APoint2D((long)screenPt.x, (long)screenPt.y);
        double a0 = ptAnchor.getAngle(pt);
        double snapAngleDegrees = AGeomUtil.normDeg((double)(Math.floor((a0 + (double)(constraintAngleDeg / 2.0f)) / (double)constraintAngleDeg) * (double)constraintAngleDeg));
        return Math.abs(snapAngleDegrees - a0) < 8.0 || Math.abs(snapAngleDegrees - a0) > 352.0;
    }

    public static APoint2D snap(APoint2D worldPoint, APoint2D anchor, AGrid grid, ARect bounds, float constrainAngle) {
        return InteractiveRouteEditMode.snap(worldPoint, anchor, grid, bounds, constrainAngle, null, 0L);
    }

    public static APoint2D snap(APoint2D worldPoint, APoint2D anchor, AGrid grid, ARect bounds, float constrainAngle, APoint2D tgt, long optSnapDist) {
        if (worldPoint == null) {
            return null;
        }
        if (anchor != null && constrainAngle != 0.0f) {
            if (grid != null) {
                long max = bounds == null ? 0L : bounds.getLL().manhattanDistance(bounds.getUR());
                double a0 = anchor.getAngle(worldPoint);
                double snapAngleDegrees = (float)((int)((a0 + (double)(constrainAngle / 2.0f)) / (double)constrainAngle)) * constrainAngle;
                double snapAngle = Math.toRadians(snapAngleDegrees);
                double snapTan = Math.tan(snapAngle);
                long d = InteractiveRouteEditMode.findAngleDist(grid, snapTan, max);
                if (d != 0L) {
                    long l0 = worldPoint.distance(anchor);
                    long l1 = AGridUtil.getNearestSpacing((long)l0, (long)d);
                    long dy = Math.round((double)l1 * Math.sin(snapAngle));
                    long dx = Math.round((double)l1 * Math.cos(snapAngle));
                    worldPoint.setX(anchor.getX() + dx);
                    worldPoint.setY(anchor.getY() + dy);
                    while (bounds != null && !bounds.contains(worldPoint)) {
                        dy = Math.round((double)(l1 -= d) * Math.sin(snapAngle));
                        dx = Math.round((double)l1 * Math.cos(snapAngle));
                        worldPoint.setX(anchor.getX() + dx);
                        worldPoint.setY(anchor.getY() + dy);
                    }
                } else {
                    worldPoint.setX(anchor.getX());
                    worldPoint.setY(anchor.getY());
                }
            } else {
                worldPoint = InteractiveRouteEditMode.snapToAngle(worldPoint, anchor, constrainAngle);
                if (tgt != null && optSnapDist > 0L) {
                    ALine curSeg = new ALine(anchor, worldPoint);
                    if (curSeg.intersects(tgt)) {
                        if (tgt.distance(worldPoint) <= optSnapDist) {
                            worldPoint.setLoc(tgt);
                        }
                    } else {
                        ALine shortest = curSeg.shortest(tgt, false);
                        APoint2D pt = shortest.getP1();
                        if (pt.distance(worldPoint) <= optSnapDist) {
                            worldPoint.setLoc(pt);
                        }
                    }
                }
                if (bounds != null && !bounds.contains(worldPoint)) {
                    APoint2D p;
                    ALine l = new ALine(anchor, worldPoint);
                    if (worldPoint.getX() < bounds.left()) {
                        p = bounds.leftEdge().getIntersectLines(l);
                        if (p != null) {
                            worldPoint = p;
                        } else {
                            worldPoint.setX(bounds.left());
                        }
                    }
                    if (worldPoint.getX() > bounds.right()) {
                        p = bounds.rightEdge().getIntersectLines(l);
                        if (p != null) {
                            worldPoint = p;
                        } else {
                            worldPoint.setX(bounds.right());
                        }
                    }
                    if (worldPoint.getY() < bounds.bottom()) {
                        p = bounds.bottomEdge().getIntersectLines(l);
                        if (p != null) {
                            worldPoint = p;
                        } else {
                            worldPoint.setY(bounds.bottom());
                        }
                    }
                    if (worldPoint.getY() > bounds.top()) {
                        p = bounds.topEdge().getIntersectLines(l);
                        if (p != null) {
                            worldPoint = p;
                        } else {
                            worldPoint.setY(bounds.top());
                        }
                    }
                }
            }
        } else if (grid != null) {
            worldPoint = grid.snapToGrid(worldPoint, bounds);
        } else if (bounds != null && !bounds.contains(worldPoint)) {
            if (worldPoint.getX() < bounds.left()) {
                worldPoint.setX(bounds.left());
            }
            if (worldPoint.getX() > bounds.right()) {
                worldPoint.setX(bounds.right());
            }
            if (worldPoint.getY() < bounds.bottom()) {
                worldPoint.setY(bounds.bottom());
            }
            if (worldPoint.getY() > bounds.top()) {
                worldPoint.setY(bounds.top());
            }
        }
        return worldPoint;
    }

    protected static APoint2D snapToAngle(APoint2D pt, APoint2D ptAnchor, float snapAngleDeg) {
        double a0 = ptAnchor.getAngle(pt);
        double snapAngleDegrees = Math.floor((a0 + (double)(snapAngleDeg / 2.0f)) / (double)snapAngleDeg) * (double)snapAngleDeg;
        double snapAngle = Math.toRadians(snapAngleDegrees);
        AffineTransform trans = new AffineTransform();
        double[] ptSrc = new double[]{pt.getX(), pt.getY()};
        double[] ptDst = new double[2];
        trans.rotate(snapAngle - Math.toRadians(a0), ptAnchor.getX(), ptAnchor.getY());
        trans.transform(ptSrc, 0, ptDst, 0, 1);
        return new APoint2D(ptDst[0], ptDst[1]);
    }

    protected static long findAngleDist(AGrid grid, double tan, long max) {
        if (tan > 1.0) {
            tan = 1.0 / tan;
        }
        for (long x = grid.getDeltaX(); x < Integer.MAX_VALUE; x += grid.getDeltaX()) {
            long y = Math.round(tan * (double)x);
            if (y % grid.getDeltaY() != 0L) continue;
            return Math.round(Math.hypot(x, y));
        }
        return 0L;
    }

    public void addEditListener(EditListener l) {
        this.mEditListeners.add(l);
    }

    public boolean removeEditListner(EditListener l) {
        return this.mEditListeners.remove(l);
    }

    public boolean hasEditListener(EditListener l) {
        return this.mEditListeners.contains(l);
    }

    protected void fireEditWireChanged() {
        HierInst<Wire> hw = this.getEditHierWire();
        for (EditListener l : this.mEditListeners) {
            l.editWire(hw);
        }
    }

    public static interface EditListener {
        public void editWire(HierInst<Wire> var1);
    }

    protected class Overlay
    extends GridOverlay {
        protected boolean mSpotlight;
        protected Point mDrawnCursorLoc;

        public Overlay(NamedGrid grid) {
            super(InteractiveRouteEditMode.this.mView, null, null);
            this.mSpotlight = (Boolean)Settings.get((String)"UserPreferences", (String)"EnableSpotlights", (Object)false);
            this.mDrawnCursorLoc = null;
        }

        public void setSpotlight(boolean b) {
            this.mSpotlight = b;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (InteractiveRouteEditMode.this.isNavigationInProgress()) {
                return;
            }
            if (!(graphics instanceof Graphics2D)) {
                assert (false);
                return;
            }
            Graphics2D g = (Graphics2D)graphics;
            if (InteractiveRouteEditMode.this.mPrePaint != null) {
                InteractiveRouteEditMode.this.mPrePaint.paintOverlay(g);
            }
            if (this.mSpotlight && InteractiveRouteEditMode.this.mRouteOwner != null) {
                DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
                ARect viewBounds = this.mView.getViewBounds();
                ARect deviceBounds = InteractiveRouteEditMode.this.mRouteOwner.getBB();
                SpotLight.spotlight(g, viewBounds, (AGeom)deviceBounds, xform);
            }
            if (InteractiveRouteEditMode.this.mMode != null) {
                InteractiveRouteEditMode.this.mMode.paintOverlay(g);
            }
            this.mDrawnCursorLoc = null;
            this.drawRoutingCursor(g);
            if (InteractiveRouteEditMode.this.mPostPaint != null) {
                InteractiveRouteEditMode.this.mPostPaint.paintOverlay(g);
            }
        }

        protected void drawRoutingCursor(Graphics2D gIn) {
            Graphics2D g;
            Graphics2D graphics2D = g = gIn != null ? gIn : (Graphics2D)this.getGraphics();
            if (g == null) {
                return;
            }
            APoint2D clw = InteractiveRouteEditMode.this.mCursorPt;
            Point cl = clw == null ? null : this.mView.getCanvas().getXForm().getScreenPt(clw);
            Color oldColor = g.getColor();
            g.setColor(CURSOR_COLOR);
            g.setXORMode(CURSOR_COLOR_XOR);
            if (this.mDrawnCursorLoc != null && !this.mDrawnCursorLoc.equals(cl)) {
                this.drawCursor(g, this.mDrawnCursorLoc);
                this.mDrawnCursorLoc = null;
            }
            if (cl != null && !cl.equals(this.mDrawnCursorLoc)) {
                this.drawCursor(g, cl);
                this.mDrawnCursorLoc = cl;
            }
            g.setColor(oldColor);
            g.setPaintMode();
            if (gIn == null) {
                g.dispose();
            }
        }

        protected void drawCursor(Graphics2D g, Point loc) {
            g.drawLine(loc.x - 7, loc.y, loc.x - 1, loc.y);
            g.drawLine(loc.x + 1, loc.y, loc.x + 7, loc.y);
            g.drawLine(loc.x, loc.y - 7, loc.x, loc.y - 1);
            g.drawLine(loc.x, loc.y + 1, loc.x, loc.y + 7);
        }
    }

    protected class OptionsUI
    extends AFloatWindow {
        protected JTextField mTxtDevice;
        protected JTextField mTxtNet;
        protected JTextField mTxtLayer;
        protected JTextField mTxtGrid;
        protected JTextField mTxtWidth;
        protected JTextField mTxtAngle;
        protected JToggleButton mBtnNewTrace;
        protected JButton mBtnReset;
        protected JButton mBtnChangeDevice;

        public OptionsUI() {
            super((Window)UIUtil.getAncestorOfType((Component)InteractiveRouteEditMode.this.mView.getComponent(), Window.class));
            this.setPinnable(false);
            this.setPinned(true);
            this.setTitle("Route Editing");
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            Insets smallInsets = new Insets(2, 2, 2, 2);
            l.pushFillX();
            if (InteractiveRouteEditMode.this.mUsingWires) {
                l.add("Device:", (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
                this.mTxtDevice = (JTextField)l.add((Component)this.createTextDisplay(), (GridBagConstraints)GridBagManager.FILLX.insets(smallInsets));
                this.mBtnChangeDevice = (JButton)l.add((Component)this.createChangeButton(), (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
                this.mBtnChangeDevice.addActionListener(e -> InteractiveRouteEditMode.this.selectDevice(null));
                l.newline();
                l.add("Net:", (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
                this.mTxtNet = (JTextField)l.add((Component)this.createTextDisplay(), (GridBagConstraints)GridBagManager.FILLX.insets(smallInsets));
                l.newline();
                l.add("Layer:", (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
                this.mTxtLayer = (JTextField)l.add((Component)this.createTextDisplay(), (GridBagConstraints)GridBagManager.FILLX.insets(smallInsets));
                JButton btnChangeLayer = (JButton)l.add((Component)this.createChangeButton(), (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
                btnChangeLayer.addActionListener(e -> InteractiveRouteEditMode.this.selectLayer(false));
                l.newline();
                l.add("Grid:", (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
                this.mTxtGrid = (JTextField)l.add((Component)this.createTextDisplay(), (GridBagConstraints)GridBagManager.FILLX.insets(smallInsets));
                JButton btnChangeGrid = (JButton)l.add((Component)this.createChangeButton(), (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
                btnChangeGrid.addActionListener(e -> InteractiveRouteEditMode.this.selectGrid(false));
                l.newline();
                l.add("Width:", (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
                this.mTxtWidth = (JTextField)l.add((Component)this.createTextDisplay(), (GridBagConstraints)GridBagManager.FILLX.insets(smallInsets));
                JButton btnChangeWidth = (JButton)l.add((Component)this.createChangeButton(), (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
                btnChangeWidth.addActionListener(e -> InteractiveRouteEditMode.this.selectRouteWidth(false));
                l.newline();
            }
            l.add("Angle:", (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
            this.mTxtAngle = (JTextField)l.add((Component)this.createTextDisplay(), (GridBagConstraints)GridBagManager.FILLX.insets(smallInsets));
            JButton btnChangeAngle = (JButton)l.add((Component)this.createChangeButton(), (GridBagConstraints)GridBagManager.LEFT.insets(smallInsets));
            btnChangeAngle.addActionListener(e -> InteractiveRouteEditMode.this.selectRouteAngle(false));
            l.popNl();
            if (InteractiveRouteEditMode.this.mUsingWires) {
                l.pushFillX();
                this.mBtnNewTrace = (JToggleButton)l.add((Component)this.initCmdButton(new JToggleButton("New")));
                this.mBtnNewTrace.addActionListener(e -> InteractiveRouteEditMode.this.setEditMode(this.mBtnNewTrace.isSelected() ? new NewWireMode() : new EditWireMode()));
                l.addFillX();
                this.mBtnReset = (JButton)l.add((Component)this.initCmdButton(new JButton("Reset")));
                this.mBtnReset.addActionListener(e -> InteractiveRouteEditMode.this.resetRouteOptions());
                l.popNl();
            }
            l.addFillAll();
            this.pack();
            Point loc = new Point();
            SwingUtilities.convertPointToScreen(loc, InteractiveRouteEditMode.this.mView);
            loc.x -= this.getWidth();
            this.setLocation(loc);
            UIUtil.verifyWindowOnScreen((Window)((Object)this));
            this.initListener();
            this.updateData();
            this.setVisible(true);
        }

        protected JTextField createTextDisplay() {
            JTextField txt = new JTextField(10);
            txt.setEditable(false);
            return txt;
        }

        protected JButton createChangeButton() {
            JButton btn = new JButton("\u2026");
            btn.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
            btn.setMargin(new Insets(0, 1, 0, 1));
            return btn;
        }

        protected <T extends AbstractButton> T initCmdButton(T btn) {
            Font font = btn.getFont();
            font.deriveFont(font.getSize2D() - 2.0f);
            btn.setFont(font);
            btn.setMargin(new Insets(1, 1, 1, 1));
            return btn;
        }

        protected void initListener() {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    InteractiveRouteEditMode.this.mOptionsUI = null;
                    OptionsUI.this.removeWindowListener(this);
                }
            });
        }

        public void updateData() {
            RoutingAngle ra;
            Design design;
            Db db = InteractiveRouteEditMode.this.mView == null ? null : InteractiveRouteEditMode.this.mView.getDb();
            Design design2 = design = db == null ? null : Design.getDesign((Db)db, (boolean)false);
            if (design == null) {
                return;
            }
            if (InteractiveRouteEditMode.this.mUsingWires) {
                String devName = "";
                if (InteractiveRouteEditMode.this.mRouteOwner != null && !InteractiveRouteEditMode.this.mRouteOwner.isEmpty()) {
                    devName = InteractiveRouteEditMode.this.mRouteOwner.getLast().getName();
                }
                this.updateText(this.mTxtDevice, devName);
                String netName = "";
                if (InteractiveRouteEditMode.this.mNet != null) {
                    netName = InteractiveRouteEditMode.this.mNet.getName();
                }
                this.updateText(this.mTxtNet, netName);
                String layerName = "";
                if (InteractiveRouteEditMode.this.mLayer != null) {
                    layerName = InteractiveRouteEditMode.this.mLayer.getName();
                }
                this.updateText(this.mTxtLayer, layerName);
                String gridName = "";
                if (InteractiveRouteEditMode.this.mGrid != null) {
                    gridName = InteractiveRouteEditMode.this.mGrid.getDesc(InteractiveRouteEditMode.this.mView.getUnit());
                }
                this.updateText(this.mTxtGrid, gridName);
                String width = "";
                if (InteractiveRouteEditMode.this.mRouteWidth > 0L) {
                    width = InteractiveRouteEditMode.this.mView.getUnit().toUserStr(InteractiveRouteEditMode.this.mRouteWidth);
                }
                this.updateText(this.mTxtWidth, width);
                this.mBtnChangeDevice.setEnabled(InteractiveRouteEditMode.this.getEditWire() == null);
                this.mBtnNewTrace.setSelected(InteractiveRouteEditMode.this.mMode instanceof NewWireMode);
            }
            if ((ra = RoutingAngle.valueOf(InteractiveRouteEditMode.this.mRoutingAngle)) != null) {
                this.updateText(this.mTxtAngle, ra.toString());
            }
        }

        protected void updateText(JTextComponent txtComp, String newText) {
            if (newText == null) {
                newText = "";
            }
            if (txtComp.getText().equals(newText)) {
                return;
            }
            txtComp.setText(newText);
            txtComp.setCaretPosition(0);
        }
    }

    protected class VertexSnapper {
        protected ARect mBounds = null;
        protected HierInst<DbObject> mObject = null;
        protected LinkedList<VertexLoc> mVertices = null;
        protected HashMap<Integer, VertexLoc> mVertexIdx2Loc = null;

        public VertexSnapper(ARect worldBounds, HierInst<DbObject> object, int[] vertices) {
            this.mBounds = worldBounds;
            this.mObject = object;
            this.mVertices = new LinkedList();
            this.mVertexIdx2Loc = new HashMap();
            for (int idx : vertices) {
                APoint2D loc = InteractiveRouteEditMode.getWorldLoc(this.mObject, idx);
                VertexLoc vl = new VertexLoc(idx, loc);
                this.mVertices.add(vl);
                this.mVertexIdx2Loc.put(idx, vl);
            }
        }

        public LinkedList<VertexLoc> getVertices() {
            return this.mVertices;
        }

        public void snapAll(AGrid grid, float constrainAngleDeg, long dx, long dy, boolean limitMotion) {
            block58: {
                APath shape;
                long maxY;
                long maxX;
                long minY;
                long minX;
                block56: {
                    APoint2D newLoc1;
                    APoint2D origLoc1;
                    APoint2D origLoc0;
                    VertexLoc v1;
                    VertexLoc v0;
                    block59: {
                        APoint2D newLoc0;
                        block57: {
                            minX = Long.MIN_VALUE;
                            minY = Long.MIN_VALUE;
                            maxX = Long.MAX_VALUE;
                            maxY = Long.MAX_VALUE;
                            shape = null;
                            DbObject o = this.mObject.getDbObject();
                            shape = o instanceof Wire ? ((Wire)o).getPath() : ((Bundle)o).getPath();
                            if (grid != null) {
                                for (VertexLoc vl : this.mVertices) {
                                    APoint2D newLoc = InteractiveRouteEditMode.snap(new APoint2D(vl.getLoc()), null, grid, this.mBounds, 0.0f);
                                    if (newLoc.equals((Object)vl.getLoc())) continue;
                                    vl.setLoc(newLoc);
                                }
                            }
                            if (limitMotion && constrainAngleDeg == 90.0f && this.snappingOneSeg()) {
                                APoint2D nextPt;
                                v0 = this.mVertices.get(0);
                                v1 = this.mVertices.get(1);
                                APoint2D priorPt = v0.getVertexIdx() > 0 ? this.getVertexLoc(v0.getVertexIdx() - 1) : null;
                                APoint2D aPoint2D = nextPt = v1.getVertexIdx() < shape.getPointCount() - 1 ? this.getVertexLoc(v1.getVertexIdx() + 1) : null;
                                if (v0.getLoc().getY() == v1.getLoc().getY()) {
                                    dx = 0L;
                                    long curY = v0.getLoc().getY();
                                    if (priorPt != null) {
                                        if (priorPt.getY() < curY) {
                                            minY = priorPt.getY();
                                        } else if (priorPt.getY() > curY) {
                                            maxY = priorPt.getY();
                                        }
                                    }
                                    if (nextPt != null) {
                                        this.getVertexLoc(v1.getVertexIdx() + 1);
                                        if (nextPt.getY() < curY) {
                                            minY = Math.max(minY, nextPt.getY());
                                        } else if (nextPt.getY() > curY) {
                                            maxY = Math.min(maxY, nextPt.getY());
                                        }
                                    }
                                } else if (v0.getLoc().getX() == v1.getLoc().getX()) {
                                    dy = 0L;
                                    long curX = v0.getLoc().getX();
                                    if (priorPt != null) {
                                        if (priorPt.getX() < curX) {
                                            minX = priorPt.getX();
                                        } else if (priorPt.getX() > curX) {
                                            maxX = priorPt.getX();
                                        }
                                    }
                                    if (nextPt != null) {
                                        if (nextPt.getX() < curX) {
                                            minX = Math.max(minX, nextPt.getX());
                                        } else if (nextPt.getX() > curX) {
                                            maxX = Math.min(maxX, nextPt.getX());
                                        }
                                    }
                                }
                            }
                            if (!this.snappingOneSeg()) break block56;
                            v0 = this.mVertices.get(0);
                            v1 = this.mVertices.get(1);
                            origLoc0 = v0.getLoc();
                            origLoc1 = v1.getLoc();
                            newLoc0 = origLoc0.add(dx, dy);
                            newLoc1 = origLoc1.add(dx, dy);
                            ALine newSeg = new ALine(newLoc0, newLoc1);
                            if (v0.getVertexIdx() - 1 >= 0) {
                                newLoc0 = newSeg.getIntersectLines(new ALine(origLoc0, this.getVertexLoc(v0.getVertexIdx() - 1)));
                            }
                            if (v1.getVertexIdx() + 1 < shape.getPointCount()) {
                                newLoc1 = newSeg.getIntersectLines(new ALine(origLoc1, this.getVertexLoc(v1.getVertexIdx() + 1)));
                            }
                            if (v0.getVertexIdx() - 1 < 0 || v1.getVertexIdx() + 1 >= shape.getPointCount()) break block57;
                            if (newLoc0 == null || newLoc1 == null) break block58;
                            if (!newLoc0.equals((Object)origLoc0)) {
                                v0.setLoc(newLoc0);
                            }
                            if (newLoc1.equals((Object)origLoc1)) break block58;
                            v1.setLoc(newLoc1);
                            break block58;
                        }
                        if (v0.getVertexIdx() - 1 < 0) break block59;
                        if (newLoc0 != null) {
                            v0.setLoc(newLoc0);
                            long mx = newLoc0.getX() + origLoc1.getX() - origLoc0.getX();
                            long my = newLoc0.getY() + origLoc1.getY() - origLoc0.getY();
                            v1.setLoc(new APoint2D(mx, my));
                        }
                        break block58;
                    }
                    if (v1.getVertexIdx() + 1 >= shape.getPointCount() || newLoc1 == null) break block58;
                    v1.setLoc(newLoc1);
                    long mx = newLoc1.getX() + origLoc0.getX() - origLoc1.getX();
                    long my = newLoc1.getY() + origLoc0.getY() - origLoc1.getY();
                    v0.setLoc(new APoint2D(mx, my));
                    break block58;
                }
                for (int dragVIdx = 0; dragVIdx < this.mVertices.size(); ++dragVIdx) {
                    APoint2D ptNext;
                    APoint2D ptPrev;
                    VertexLoc vl;
                    vl = this.mVertices.get(dragVIdx);
                    int vIdx = vl.getVertexIdx();
                    APoint2D origLoc = vl.getLoc();
                    APoint2D newLoc = origLoc.add(dx, dy);
                    if (constrainAngleDeg == 90.0f) {
                        ptPrev = this.getVertexLoc(vl.getVertexIdx() - 1);
                        ptNext = null;
                        if (!this.isInSnapSet(vIdx + 1)) {
                            ptNext = this.getVertexLoc(vl.getVertexIdx() + 1);
                        }
                        if (this.mVertices.size() <= 0 || dragVIdx != 0 && dragVIdx != this.mVertices.size() - 1 || !InteractiveRouteEditMode.isColinearVertex(shape, vIdx)) {
                            if (ptPrev != null && ptNext != null) {
                                if (ptPrev.getY() == ptNext.getY()) {
                                    newLoc.setY(ptPrev.getY());
                                } else if (ptPrev.getX() == ptNext.getX()) {
                                    newLoc.setX(ptPrev.getX());
                                } else {
                                    APoint2D ptOpt1 = new APoint2D(ptPrev.getX(), ptNext.getY());
                                    APoint2D ptOpt2 = new APoint2D(ptNext.getX(), ptPrev.getY());
                                    if (ptOpt1.getX() < minX || ptOpt1.getX() > maxX || ptOpt1.getY() < minY || ptOpt1.getY() > maxY) {
                                        ptOpt1 = null;
                                    }
                                    if (ptOpt2.getX() < minX || ptOpt2.getX() > maxX || ptOpt2.getY() < minY || ptOpt2.getY() > maxY) {
                                        ptOpt2 = null;
                                    }
                                    if (ptOpt1 != null && ptOpt2 != null) {
                                        newLoc.setLoc(newLoc.distance(ptOpt1) <= newLoc.distance(ptOpt2) ? ptOpt1 : ptOpt2);
                                    } else if (ptOpt1 != null) {
                                        newLoc.setLoc(ptOpt1);
                                    } else if (ptOpt2 != null) {
                                        newLoc.setLoc(ptOpt2);
                                    }
                                }
                            } else if (ptPrev != null) {
                                newLoc = this.snap(newLoc, ptPrev, grid, constrainAngleDeg);
                            } else if (ptNext != null) {
                                newLoc = this.snap(newLoc, ptNext, grid, constrainAngleDeg);
                            }
                        }
                        if (newLoc.getX() < minX) {
                            newLoc.setX(minX);
                        }
                        if (newLoc.getX() > maxX) {
                            newLoc.setX(maxX);
                        }
                        if (newLoc.getY() < minY) {
                            newLoc.setY(minY);
                        }
                        if (newLoc.getY() > maxY) {
                            newLoc.setY(maxY);
                        }
                    } else if (constrainAngleDeg == 45.0f) {
                        APoint2D loc;
                        ptPrev = vIdx > 0 ? this.getVertexLoc(vIdx - 1) : null;
                        ptNext = !this.isInSnapSet(vIdx + 1) ? this.getVertexLoc(vIdx + 1) : null;
                        ALine linePrev = null;
                        ALine lineNext = null;
                        if (ptPrev != null && InteractiveRouteEditMode.this.suitableForSnap(newLoc, ptPrev, constrainAngleDeg)) {
                            newLoc = this.snap(newLoc, ptPrev, grid, constrainAngleDeg);
                            linePrev = new ALine(ptPrev, newLoc);
                        }
                        if (ptNext != null && InteractiveRouteEditMode.this.suitableForSnap(newLoc, ptNext, constrainAngleDeg)) {
                            newLoc = this.snap(newLoc, ptNext, grid, constrainAngleDeg);
                            lineNext = new ALine(ptNext, newLoc);
                        }
                        if (linePrev != null && lineNext != null && (loc = linePrev.getIntersectLines(lineNext)) != null) {
                            newLoc = loc;
                        }
                    } else {
                        newLoc = this.snap(newLoc, origLoc, grid, constrainAngleDeg);
                    }
                    if (newLoc.equals((Object)origLoc)) continue;
                    vl.setLoc(newLoc);
                }
            }
        }

        protected APoint2D getVertexLoc(int vertexIdx) {
            VertexLoc vl = this.mVertexIdx2Loc.get(vertexIdx);
            if (vl != null) {
                return vl.getLoc();
            }
            return InteractiveRouteEditMode.getWorldLoc(this.mObject, vertexIdx);
        }

        protected boolean isInSnapSet(int vertexIdx) {
            return this.mVertexIdx2Loc.containsKey(vertexIdx);
        }

        protected boolean snappingOneSeg() {
            return this.mVertices.size() == 2 && this.mVertices.get(0).getVertexIdx() + 1 == this.mVertices.get(1).getVertexIdx();
        }

        public APoint2D snap(APoint2D pt, APoint2D anchor, AGrid grid, float angle) {
            return InteractiveRouteEditMode.snap(pt, anchor, grid, this.mBounds, angle);
        }
    }

    protected static class VertexLoc {
        int mVertexIdx = -1;
        APoint2D mLoc = null;
        boolean mModified = false;

        public VertexLoc(int idx, APoint2D loc) {
            this.mVertexIdx = idx;
            this.mLoc = loc;
        }

        public int getVertexIdx() {
            return this.mVertexIdx;
        }

        public APoint2D getLoc() {
            return this.mLoc;
        }

        public boolean isModified() {
            return this.mModified;
        }

        public void setVertexIdx(int idx) {
            this.mVertexIdx = idx;
            this.mModified = true;
        }

        public void setLoc(APoint2D loc) {
            this.mLoc = loc;
            this.mModified = true;
        }
    }

    protected class EditWireMode
    extends Mode {
        protected boolean mUninstallClearsEditState;
        protected HierInst<Wire> mHighlightWire;
        protected HierInst<Bundle> mHighlightBundle;
        protected int[] mEditVertexIndices;
        protected DragInfo mDragInfo;
        protected JPopupMenu mLastContextMenu;

        protected EditWireMode() {
            this.mUninstallClearsEditState = true;
            this.mHighlightWire = null;
            this.mHighlightBundle = null;
            this.mEditVertexIndices = null;
            this.mDragInfo = null;
            this.mLastContextMenu = null;
        }

        @Override
        public boolean install() {
            if (InteractiveRouteEditMode.this.getEditWire() == null) {
                InteractiveRouteEditMode.this.informUser("Click route to edit or press 'New' button to start route", new Object[0]);
            }
            return super.install();
        }

        @Override
        public boolean uninstall() {
            InteractiveRouteEditMode.this.informUser(null, new Object[0]);
            this.mHighlightWire = null;
            if (this.mUninstallClearsEditState) {
                InteractiveRouteEditMode.this.clearEditObject();
                InteractiveRouteEditMode.this.setCursorLoc(null);
            }
            return super.uninstall();
        }

        @Override
        public void mouseMove(DesignView2D.MouseAction e) {
            if (this.isContextMenuDisplayed()) {
                return;
            }
            if (InteractiveRouteEditMode.this.mUsingWires) {
                if (InteractiveRouteEditMode.this.getEditWire() == null) {
                    this.highlightOrSelectWire(e.getPoint(), false);
                } else if (!this.inDrag()) {
                    this.updateHighlightedVertex(e.getPoint(), InteractiveRouteEditMode.this.getMouseSensitivity(), false, true);
                }
            } else if (InteractiveRouteEditMode.this.getEditBundle() == null) {
                this.highlightOrSelectBundle(e.getPoint(), false);
            } else if (!this.inDrag()) {
                this.updateHighlightedVertex(e.getPoint(), InteractiveRouteEditMode.this.getMouseSensitivity(), false, true);
            }
            if (this.mEditVertexIndices != null) {
                InteractiveRouteEditMode.this.setCursorLoc(InteractiveRouteEditMode.this.getWorldPoint(e));
            } else {
                InteractiveRouteEditMode.this.setCursorLoc(null);
            }
        }

        @Override
        public void mouseDrag(DesignView2D.MouseAction e) {
            if (this.mEditVertexIndices == null) {
                InteractiveRouteEditMode.this.setCursorLoc(null);
            } else {
                this.updateDrag(e.getPoint());
            }
        }

        @Override
        public void mouseClick(DesignView2D.MouseAction e) {
            InteractiveRouteEditMode.this.informUser(null, new Object[0]);
            HierInst<DbObject> ho = InteractiveRouteEditMode.this.getEditHierObject();
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            this.highlightOrSelectObject(e.getPoint(), true);
            if (e.getClickCount() > 1 && ho != null) {
                long distWidth = InteractiveRouteEditMode.this.mUsingWires ? ((Wire)ho.getDbObject()).getWidth() / 2L : ((Bundle)ho.getDbObject()).bundleWidth() / 2L;
                APoint2D worldPt = InteractiveRouteEditMode.this.getWorldPoint(e.getPoint());
                APoint2D devRelLoc = worldPt.transform(ATransformUtil.inverse((AffineTransform)ho.getPath().getTransform()));
                boolean clickInPath = false;
                List pts = InteractiveRouteEditMode.this.getPath(ho).getPointList();
                for (int idx = 1; idx < pts.size(); ++idx) {
                    APoint2D pt1;
                    APoint2D pt0;
                    ALine l;
                    long dist;
                    if (idx <= 0 || (dist = (l = new ALine(pt0 = (APoint2D)pts.get(idx - 1), pt1 = (APoint2D)pts.get(idx))).distance(devRelLoc)) > distWidth) continue;
                    clickInPath = true;
                    break;
                }
                if (!clickInPath) {
                    InteractiveRouteEditMode.this.autoExitEditing();
                }
            }
            InteractiveRouteEditMode.this.repaintOverlay();
        }

        @Override
        public void mousePress(DesignView2D.MouseAction e) {
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            if (!this.inDrag()) {
                this.updateHighlightedVertex(e.getPoint(), InteractiveRouteEditMode.this.getMouseSensitivity(), false, e.isShiftDown());
            }
            if (this.mEditVertexIndices != null && !this.inDrag()) {
                this.startDrag(e.getPoint());
            }
        }

        @Override
        public void mouseRelease(DesignView2D.MouseAction e) {
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            if (this.mEditVertexIndices != null && this.inDrag()) {
                if (this.mDragInfo == null) {
                    InteractiveRouteEditMode.this.repaintOverlay();
                    return;
                }
                if (this.mDragInfo.getStart().equals(e.getPoint())) {
                    if (this.mEditVertexIndices.length == 1) {
                        this.removeDuplicateOrColinearPt(this.mEditVertexIndices[0]);
                    }
                    this.endDrag();
                    return;
                }
                if (this.mEditVertexIndices.length > 1) {
                    String s;
                    String string = s = this.mEditVertexIndices.length == 2 ? "moveSegment" : "moveSegments";
                    if (InteractiveRouteEditMode.this.mUsingWires) {
                        Cp.exec((String)"ireWire.getDb().getHistory().startTransactionCoalesce(\"%s\")", (Object[])new Object[]{s});
                    } else {
                        Cp.exec((String)"ireBundle.getDb().getHistory().startTransactionCoalesce(\"%s\")", (Object[])new Object[]{s});
                    }
                }
                APoint2D ptStart = InteractiveRouteEditMode.this.getWorldPoint(this.mDragInfo.getStart());
                APoint2D ptEnd = InteractiveRouteEditMode.this.getWorldPoint(e);
                long dx = ptEnd.getX() - ptStart.getX();
                long dy = ptEnd.getY() - ptStart.getY();
                LinkedList<VertexLoc> snappedVertices = this.snapEditVertices(dx, dy);
                HierInst<DbObject> ho = InteractiveRouteEditMode.this.getEditHierObject();
                DevicePath dpath = ho.getPath();
                APath shape = InteractiveRouteEditMode.this.getEditObjectPath();
                LinkedList<Integer> movedVertices = new LinkedList<Integer>();
                boolean firstColinear = InteractiveRouteEditMode.isColinearVertex(shape, this.mEditVertexIndices[0]);
                boolean lastColinear = InteractiveRouteEditMode.isColinearVertex(shape, this.mEditVertexIndices[this.mEditVertexIndices.length - 1]);
                int vIdxOffset = 0;
                for (int snappedVIdx = 0; snappedVIdx < snappedVertices.size(); ++snappedVIdx) {
                    VertexLoc vl = snappedVertices.get(snappedVIdx);
                    int vIdx = vl.getVertexIdx() + vIdxOffset;
                    APoint2D newLoc = vl.getLoc().transform(dpath.getInverseTransform());
                    if (newLoc.equals((Object)shape.getPoint(vIdx))) continue;
                    if (this.editOrthoSeg()) {
                        if (vIdx == 0 || snappedVIdx == 0 && firstColinear) {
                            if (InteractiveRouteEditMode.this.mUsingWires) {
                                Cp.exec((String)"WireCommands.duplicateWireVertex(ireWire, %d)", (Object[])new Object[]{vIdx});
                            } else {
                                Cp.exec((String)"BundleCommands.duplicateBundleVertex(ireBundle, %d)", (Object[])new Object[]{vIdx});
                            }
                            ++vIdxOffset;
                            ++vIdx;
                        } else if (vIdx == shape.getPointCount() - 1 || snappedVIdx == this.mEditVertexIndices.length - 1 && lastColinear) {
                            if (InteractiveRouteEditMode.this.mUsingWires) {
                                Cp.exec((String)"WireCommands.duplicateWireVertex(ireWire, %d)", (Object[])new Object[]{vIdx});
                            } else {
                                Cp.exec((String)"BundleCommands.duplicateBundleVertex(ireBundle, %d)", (Object[])new Object[]{vIdx});
                            }
                        }
                    }
                    if (InteractiveRouteEditMode.this.mUsingWires) {
                        Cp.exec((String)"WireCommands.moveWireVertex(ireWire, %d, %dL, %dL)", (Object[])new Object[]{vIdx, newLoc.getX(), newLoc.getY()});
                    } else {
                        Cp.exec((String)"BundleCommands.moveBundleVertex(ireBundle, %d, %dL, %dL)", (Object[])new Object[]{vIdx, newLoc.getX(), newLoc.getY()});
                    }
                    movedVertices.add(vIdx);
                }
                int lastProcessedIdx = -1;
                while (!movedVertices.isEmpty()) {
                    int vIdx = (Integer)movedVertices.pollLast();
                    this.removeDuplicateOrColinearPt(vIdx + 1);
                    lastProcessedIdx = vIdx;
                }
                this.removeDuplicateOrColinearPt(lastProcessedIdx);
                this.removeDuplicateOrColinearPt(lastProcessedIdx - 1);
                if (!InteractiveRouteEditMode.this.mUsingWires) {
                    Bundle bundle = (Bundle)InteractiveRouteEditMode.this.getEditObject();
                    bundle.setFixedRakePtsList(null);
                    bundle.setFreeRakePtsList(null);
                }
                if (InteractiveRouteEditMode.this.mRoutingAngle == 45) {
                    Long minLength = null;
                    if (!InteractiveRouteEditMode.this.mUsingWires) {
                        minLength = ((Bundle)InteractiveRouteEditMode.this.getEditObject()).bundleWidth() * 7L / 10L;
                    }
                    InteractiveRouteEditMode.smoothPathDeg45(InteractiveRouteEditMode.this.getEditObjectPath(), minLength);
                }
                if (this.mEditVertexIndices.length > 1) {
                    if (InteractiveRouteEditMode.this.mUsingWires) {
                        Cp.exec((String)"ireWire.getDb().getHistory().endTransactionCoalesce()", (Object[])new Object[0]);
                    } else {
                        Cp.exec((String)"ireBundle.getDb().getHistory().endTransactionCoalesce()", (Object[])new Object[0]);
                    }
                }
                InteractiveRouteEditMode.this.repaintView();
            }
            this.endDrag();
        }

        protected void removeDuplicateOrColinearPt(int vIdx) {
            APath shape = InteractiveRouteEditMode.this.getEditObjectPath();
            APoint2D curPt = shape.getPoint(vIdx);
            if (curPt == null) {
                return;
            }
            APoint2D prevPt = shape.getPoint(vIdx - 1);
            APoint2D nextPt = shape.getPoint(vIdx + 1);
            if (curPt.equals((Object)prevPt) || curPt.equals((Object)nextPt)) {
                if (InteractiveRouteEditMode.this.mUsingWires) {
                    Cp.exec((String)"WireCommands.deleteWireVertex(ireWire, %d)", (Object[])new Object[]{vIdx});
                } else {
                    Cp.exec((String)"BundleCommands.deleteBundleVertex(ireBundle, %d)", (Object[])new Object[]{vIdx});
                }
                return;
            }
            if (prevPt == null || nextPt == null) {
                return;
            }
            if (InteractiveRouteEditMode.isApproxColinearVertex(prevPt, nextPt, curPt)) {
                if (InteractiveRouteEditMode.this.mUsingWires) {
                    Cp.exec((String)"WireCommands.deleteWireVertex(ireWire, %d)", (Object[])new Object[]{vIdx});
                } else {
                    Cp.exec((String)"BundleCommands.deleteBundleVertex(ireBundle, %d)", (Object[])new Object[]{vIdx});
                }
            }
        }

        @Override
        public void paintOverlay(Graphics2D g) {
            boolean overObject;
            boolean editingObject;
            DesignCanvas2D.prepareGraphics(g);
            InteractiveRouteEditMode.this.drawTarget(g, Color.YELLOW);
            boolean bl = InteractiveRouteEditMode.this.mUsingWires ? InteractiveRouteEditMode.this.getEditWire() != null : (editingObject = InteractiveRouteEditMode.this.getEditBundle() != null);
            boolean bl2 = InteractiveRouteEditMode.this.mUsingWires ? this.mHighlightWire != null : (overObject = this.mHighlightBundle != null);
            if (editingObject) {
                Color colorOld = g.getColor();
                g.setColor(Color.WHITE);
                LinkedList<Point> screenVertices = new LinkedList<Point>();
                HierInst ho = null;
                if (InteractiveRouteEditMode.this.mUsingWires) {
                    HierInst<Wire> hw = InteractiveRouteEditMode.this.getEditHierWire();
                    ho = new HierInst((DevicePath)hw.first, hw.getDbObject());
                } else {
                    HierInst<Bundle> hb = InteractiveRouteEditMode.this.getEditHierBundle();
                    ho = new HierInst((DevicePath)hb.first, hb.getDbObject());
                }
                InteractiveRouteEditMode.this.drawWire(g, (HierInst<DbObject>)ho, screenVertices);
                g.setColor(colorOld);
                InteractiveRouteEditMode.this.drawHandles(g, screenVertices, this.mEditVertexIndices);
            } else if (overObject) {
                Color colorOld = g.getColor();
                g.setColor(HIGHLIGHT_COLOR);
                HierInst ho = null;
                if (InteractiveRouteEditMode.this.mUsingWires) {
                    HierInst<Wire> hw = this.mHighlightWire;
                    ho = new HierInst((DevicePath)hw.first, hw.getDbObject());
                } else {
                    HierInst<Bundle> hb = this.mHighlightBundle;
                    ho = new HierInst((DevicePath)hb.first, hb.getDbObject());
                }
                InteractiveRouteEditMode.this.drawWire(g, (HierInst<DbObject>)ho, null);
                g.setColor(colorOld);
            }
            if (!this.isContextMenuDisplayed()) {
                this.paintDragItems(g);
            }
            if (!this.isContextMenuDisplayed()) {
                this.paintDragItems(g);
            }
        }

        protected void startDrag(Point screenPt) {
            HierInst<DbObject> ho = InteractiveRouteEditMode.this.getEditHierObject();
            if (ho == null) {
                assert (false);
                return;
            }
            this.mDragInfo = new DragInfo(screenPt);
            InteractiveRouteEditMode.this.repaintOverlay();
        }

        protected boolean inDrag() {
            return this.mDragInfo != null;
        }

        protected void endDrag() {
            this.mDragInfo = null;
        }

        protected void updateDrag(Point screenPoint) {
            InteractiveRouteEditMode.this.setCursorLoc(InteractiveRouteEditMode.this.getWorldPoint(screenPoint));
            InteractiveRouteEditMode.this.repaintOverlay();
        }

        protected void highlightOrSelectObject(Point point, boolean select) {
            if (InteractiveRouteEditMode.this.mUsingWires) {
                this.highlightOrSelectWire(point, select);
            } else {
                this.highlightOrSelectBundle(point, select);
            }
        }

        protected void highlightOrSelectWire(Point point, boolean select) {
            APoint2D worldPt = InteractiveRouteEditMode.this.getWorldPoint(point);
            HierInst<Wire> hw = InteractiveRouteEditMode.this.findWire(worldPt, false);
            if (!InteractiveRouteEditMode.this.sameWire(this.mHighlightWire, hw)) {
                this.mHighlightWire = hw;
                if (!select && InteractiveRouteEditMode.this.getEditWire() == null) {
                    InteractiveRouteEditMode.this.repaintOverlay();
                }
            }
            if (select && !InteractiveRouteEditMode.this.sameWire(this.mHighlightWire, InteractiveRouteEditMode.this.getEditHierWire())) {
                hw = InteractiveRouteEditMode.this.findWire(worldPt, true);
                if (hw != null) {
                    InteractiveRouteEditMode.this.setDevice(InteractiveRouteEditMode.this.mRouteOwner);
                    Wire wire = (Wire)hw.getDbObject();
                    InteractiveRouteEditMode.this.setLayer(wire.getLayer());
                    InteractiveRouteEditMode.this.setRouteWidth(wire.getWidth());
                    InteractiveRouteEditMode.this.setNet(wire.getNet());
                    InteractiveRouteEditMode.this.selectGrid(true);
                } else {
                    InteractiveRouteEditMode.this.updateOptionsUI();
                }
                this.mEditVertexIndices = null;
                InteractiveRouteEditMode.this.repaintOverlay();
            }
        }

        protected void highlightOrSelectBundle(Point point, boolean select) {
            this.mEditVertexIndices = null;
            InteractiveRouteEditMode.this.repaintOverlay();
        }

        protected void updateHighlightedVertex(Point point, long searchDist, boolean select, boolean ctrlSegment) {
            APoint2D worldPt = InteractiveRouteEditMode.this.getWorldPoint(point);
            HierInst<DbObject> ho = InteractiveRouteEditMode.this.getEditHierObject();
            if (ho == null) {
                return;
            }
            int[] indices = InteractiveRouteEditMode.this.findVertexOrSegment(ho, worldPt, searchDist);
            if (!Arrays.equals(this.mEditVertexIndices, indices)) {
                this.mEditVertexIndices = indices;
                InteractiveRouteEditMode.this.repaintOverlay();
            }
            if (indices != null && indices.length == 2 && !ctrlSegment) {
                int idx = this.addVertex(ho, worldPt);
                this.mEditVertexIndices = (int[])(idx < 0 ? null : new int[]{idx});
            }
        }

        protected int addVertex(HierInst<DbObject> ho, APoint2D cursorPt) {
            if (ho == null) {
                return -1;
            }
            DevicePath dpath = ho.getPath();
            APath shape = InteractiveRouteEditMode.this.getPath(ho);
            int idx = -1;
            APoint2D loc = cursorPt.transform(dpath.getInverseTransform());
            if (this.mEditVertexIndices.length == 1) {
                idx = this.mEditVertexIndices[0];
                loc = shape.getPoint(idx);
            } else if (this.mEditVertexIndices.length == 2) {
                idx = this.mEditVertexIndices[1];
                ALine seg = new ALine(shape.getPoint(this.mEditVertexIndices[0]), shape.getPoint(this.mEditVertexIndices[1]));
                loc = seg.distanceToPoint(loc).getP1();
            }
            if (idx < 0) {
                ALog.logError((String)"Unable to determine new vertex index.");
                return -1;
            }
            if (InteractiveRouteEditMode.this.mUsingWires) {
                Cp.exec((String)"WireCommands.insertWireVertex(ireWire, %d, %dL, %dL)", (Object[])new Object[]{idx, loc.getX(), loc.getY()});
            } else {
                Cp.exec((String)"BundleCommands.insertBundleVertex(ireBundle, %d, %dL, %dL)", (Object[])new Object[]{idx, loc.getX(), loc.getY()});
            }
            InteractiveRouteEditMode.this.repaintView();
            return idx;
        }

        @Override
        public IterableIterator<Action> getActions(Point loc) {
            DbObject o = InteractiveRouteEditMode.this.getEditObject();
            if (o == null) {
                this.highlightOrSelectObject(loc, true);
            }
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            if (o != null) {
                if (this.mEditVertexIndices != null) {
                    actions.add(new ActionAddVertex());
                    actions.add(new ActionDeleteVertex());
                    APath shape = InteractiveRouteEditMode.this.getPath(o);
                    if (this.mEditVertexIndices.length == 1 && (this.mEditVertexIndices[0] == 0 || this.mEditVertexIndices[0] == shape.getPointCount() - 1)) {
                        actions.add(new ActionExtendWire(this.mEditVertexIndices[0]));
                    }
                }
                if (InteractiveRouteEditMode.this.mUsingWires) {
                    actions.add(new ActionDeleteWire());
                }
            }
            if (InteractiveRouteEditMode.this.mUsingWires) {
                actions.add(new ActionEndRoute());
            } else {
                actions.add(new ActionReverseBundlePath(InteractiveRouteEditMode.this.getEditBundle()));
                actions.add(new ActionEndEditingBundle());
            }
            return new AIterableItr(actions);
        }

        @Override
        public void prepareContexMenu(JPopupMenu menu, Point loc) {
            super.prepareContexMenu(menu, loc);
            this.mLastContextMenu = menu;
            if (this.inDrag()) {
                this.endDrag();
                InteractiveRouteEditMode.this.repaintOverlay();
            }
        }

        protected boolean isContextMenuDisplayed() {
            if (this.mLastContextMenu == null) {
                return false;
            }
            return this.mLastContextMenu.isVisible();
        }

        protected void paintDragItems(Graphics2D g) {
            Point endScreenPt;
            int vEnd;
            Stroke oldStroke;
            Point startScreenPt;
            APoint2D startWorlPt;
            if (InteractiveRouteEditMode.this.mCursorPt == null || this.mEditVertexIndices == null || this.mEditVertexIndices.length == 0 || !this.inDrag()) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(DRAG_COLOR);
            assert (this.mDragInfo != null);
            Point cursorLoc = InteractiveRouteEditMode.this.getScreenPoint(InteractiveRouteEditMode.this.mCursorPt);
            int dx = cursorLoc.x - this.mDragInfo.getStart().x;
            int dy = cursorLoc.y - this.mDragInfo.getStart().y;
            HierInst<DbObject> ho = InteractiveRouteEditMode.this.getEditHierObject();
            DevicePath dpath = ho.getPath();
            APath shape = null;
            DbObject object = (DbObject)ho.second;
            shape = object instanceof Wire ? ((Wire)object).getPath() : ((Bundle)object).getPath();
            LinkedList<VertexLoc> newLocs = this.snapEditVertices(InteractiveRouteEditMode.this.getWorldLen(dx), -InteractiveRouteEditMode.this.getWorldLen(dy));
            int screenWidth = InteractiveRouteEditMode.this.getScreenLen(shape.getWidth());
            boolean hasColinear = false;
            if (this.mEditVertexIndices.length == 1) {
                VertexLoc vl = newLocs.get(0);
                Point screenPt = InteractiveRouteEditMode.this.getScreenPoint(vl.getLoc());
                APoint2D editPt = vl.getLoc().transform(dpath.getInverseTransform());
                hasColinear = InteractiveRouteEditMode.isColinearVertex(shape, this.mEditVertexIndices[0], editPt);
                if (!hasColinear) {
                    InteractiveRouteEditMode.this.drawHandle(g, screenPt);
                }
            } else {
                GeneralPath gp = new GeneralPath();
                for (VertexLoc vl : newLocs) {
                    Point screenPt = InteractiveRouteEditMode.this.getScreenPoint(vl.getLoc());
                    if (gp.getCurrentPoint() == null) {
                        gp.moveTo(screenPt.x, screenPt.y);
                        continue;
                    }
                    gp.lineTo(screenPt.x, screenPt.y);
                }
                Stroke oldStroke2 = g.getStroke();
                g.setStroke(new BasicStroke(screenWidth, 1, 1));
                g.draw(gp);
                g.setStroke(oldStroke2);
            }
            int vStart = this.mEditVertexIndices[0];
            if (vStart > 0 || this.editOrthoSeg() && vStart == 0) {
                APair<Wire, Integer> otherWireVertex;
                int anchorIdx = vStart - 1;
                if (this.editOrthoSeg() && (vStart == 0 || InteractiveRouteEditMode.isColinearVertex(shape, vStart))) {
                    anchorIdx = vStart;
                }
                APoint2D startPt = shape.getPoint(anchorIdx);
                startWorlPt = dpath.transformPt(startPt);
                startScreenPt = InteractiveRouteEditMode.this.getScreenPoint(startWorlPt);
                APoint2D endWorldPt = newLocs.get(0).getLoc();
                Point endScreenPt2 = InteractiveRouteEditMode.this.getScreenPoint(endWorldPt);
                if (!hasColinear) {
                    Stroke oldStroke3 = g.getStroke();
                    g.setStroke(new BasicStroke(screenWidth, 1, 1));
                    g.setColor((Color)AColor.withAlpha((Color)CURSOR_COLOR, (int)64));
                    g.drawLine(startScreenPt.x, startScreenPt.y, endScreenPt2.x, endScreenPt2.y);
                    g.setStroke(oldStroke3);
                }
                if ((otherWireVertex = InteractiveRouteEditMode.this.getViaConnectedWire(vStart)) != null) {
                    oldStroke = g.getStroke();
                    g.setStroke(STROKE_DASH);
                    InteractiveRouteEditMode.this.drawLinesToNeighborVertices(g, endScreenPt2, otherWireVertex, dpath);
                    g.setStroke(oldStroke);
                }
            }
            if ((vEnd = this.mEditVertexIndices[this.mEditVertexIndices.length - 1]) < shape.getPointCount() - 1 || this.editOrthoSeg() && vEnd == shape.getPointCount() - 1) {
                APair<Wire, Integer> otherWireVertex;
                int anchorIdx = vEnd + 1;
                if (this.editOrthoSeg() && (vEnd == shape.maxPtIdx() || InteractiveRouteEditMode.isColinearVertex(shape, vEnd))) {
                    anchorIdx = vEnd;
                }
                APoint2D startPt = shape.getPoint(anchorIdx);
                APoint2D startWorlPt2 = dpath.transformPt(startPt);
                Point startScreenPt2 = InteractiveRouteEditMode.this.getScreenPoint(startWorlPt2);
                APoint2D endWorldPt = newLocs.get(this.mEditVertexIndices.length - 1).getLoc();
                endScreenPt = InteractiveRouteEditMode.this.getScreenPoint(endWorldPt);
                if (!hasColinear) {
                    oldStroke = g.getStroke();
                    g.setStroke(new BasicStroke(screenWidth, 1, 1));
                    g.setColor((Color)AColor.withAlpha((Color)CURSOR_COLOR, (int)64));
                    g.drawLine(startScreenPt2.x, startScreenPt2.y, endScreenPt.x, endScreenPt.y);
                    g.setStroke(oldStroke);
                }
                if ((otherWireVertex = InteractiveRouteEditMode.this.getViaConnectedWire(vEnd)) != null) {
                    Stroke oldStroke4 = g.getStroke();
                    g.setStroke(STROKE_DASH);
                    InteractiveRouteEditMode.this.drawLinesToNeighborVertices(g, endScreenPt, otherWireVertex, dpath);
                    g.setStroke(oldStroke4);
                }
            }
            if (hasColinear && vStart > 0 && vEnd < shape.getPointCount() - 1) {
                APoint2D startPt = shape.getPoint(vStart - 1);
                startWorlPt = dpath.transformPt(startPt);
                startScreenPt = InteractiveRouteEditMode.this.getScreenPoint(startWorlPt);
                APoint2D endPt = shape.getPoint(vEnd + 1);
                APoint2D endWorlPt = dpath.transformPt(endPt);
                endScreenPt = InteractiveRouteEditMode.this.getScreenPoint(endWorlPt);
                oldStroke = g.getStroke();
                g.setStroke(new BasicStroke(screenWidth, 1, 1));
                g.setColor((Color)AColor.withAlpha((Color)CURSOR_COLOR, (int)64));
                g.drawLine(startScreenPt.x, startScreenPt.y, endScreenPt.x, endScreenPt.y);
                g.setStroke(oldStroke);
            }
            g.setColor(oldColor);
        }

        protected LinkedList<VertexLoc> snapEditVertices(long dx, long dy) {
            HierInst<DbObject> ho = InteractiveRouteEditMode.this.getEditHierObject();
            DesignView2D.MouseAction ma = InteractiveRouteEditMode.this.getMouseAction();
            boolean limitMotion = ma == null || !ma.isShiftDown();
            VertexSnapper snapper = new VertexSnapper(InteractiveRouteEditMode.this.mRouteOwner.getBB(), ho, this.mEditVertexIndices);
            snapper.snapAll(InteractiveRouteEditMode.this.getAGrid(), InteractiveRouteEditMode.this.mRoutingAngle, dx, dy, limitMotion);
            return snapper.getVertices();
        }

        protected boolean editOrthoSeg() {
            return this.mEditVertexIndices.length == 2 && this.mEditVertexIndices[0] + 1 == this.mEditVertexIndices[1] && InteractiveRouteEditMode.this.mRoutingAngle == 90;
        }

        protected class ActionReverseBundlePath
        extends AbstractAction {
            Bundle mBundle;

            public ActionReverseBundlePath(Bundle b) {
                super("Reverse Bundle Path");
                this.mBundle = b;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"Bundle.swapSide(curDb(), \"%s\")", (Object[])new Object[]{this.mBundle.getKeyStr()});
                OrbitIO.getApp().refreshCurrentView();
            }
        }

        protected class ActionEndEditingBundle
        extends AbstractAction {
            ActionEndEditingBundle() {
                super("Stop Editing Bundle");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractiveRouteEditMode.this.autoExitEditing();
            }
        }

        protected class ActionEndRoute
        extends AbstractAction {
            ActionEndRoute() {
                super("Done Editing");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!InteractiveRouteEditMode.this.autoExitEditing()) {
                    InteractiveRouteEditMode.this.setEditMode(new EditWireMode());
                }
            }
        }

        protected class ActionDeleteVertex
        extends AbstractAction {
            protected String mDesc = "Vertex";

            ActionDeleteVertex() {
                if (EditWireMode.this.mEditVertexIndices.length == 2) {
                    this.mDesc = "Segment";
                }
                if (EditWireMode.this.mEditVertexIndices.length > 2) {
                    this.mDesc = "Segments";
                }
                this.putValue("Name", "Delete " + this.mDesc);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InteractiveRouteEditMode.this.mUsingWires) {
                    Cp.exec((String)"ireWire.getDb().getHistory().startTransactionCoalesce(\"%s\")", (Object[])new Object[]{"delete" + this.mDesc});
                } else {
                    Cp.exec((String)"ireBundle.getDb().getHistory().startTransactionCoalesce(\"%s\")", (Object[])new Object[]{"delete" + this.mDesc});
                }
                if (EditWireMode.this.mEditVertexIndices[0] == 0 && EditWireMode.this.mEditVertexIndices.length > 1) {
                    EditWireMode.this.mEditVertexIndices[EditWireMode.this.mEditVertexIndices.length - 1] = -1;
                } else if (EditWireMode.this.mEditVertexIndices[EditWireMode.this.mEditVertexIndices.length - 1] == InteractiveRouteEditMode.this.getPath(InteractiveRouteEditMode.this.getEditObject()).getPointCount() - 1 && EditWireMode.this.mEditVertexIndices.length > 1) {
                    EditWireMode.this.mEditVertexIndices[0] = -1;
                }
                for (int i = EditWireMode.this.mEditVertexIndices.length - 1; i >= 0; --i) {
                    int idx = EditWireMode.this.mEditVertexIndices[i];
                    if (idx < 0) continue;
                    if (InteractiveRouteEditMode.this.mUsingWires) {
                        Cp.exec((String)"WireCommands.deleteWireVertex(ireWire, %d)", (Object[])new Object[]{idx});
                        continue;
                    }
                    Cp.exec((String)"BundleCommands.deleteBundleVertex(ireBundle, %d)", (Object[])new Object[]{idx});
                }
                if (InteractiveRouteEditMode.this.mUsingWires) {
                    Cp.exec((String)"ireWire.getDb().getHistory().endTransactionCoalesce()", (Object[])new Object[0]);
                } else {
                    Cp.exec((String)"ireBundle.getDb().getHistory().endTransactionCoalesce()", (Object[])new Object[0]);
                }
                EditWireMode.this.mEditVertexIndices = null;
                EditWireMode.this.endDrag();
                InteractiveRouteEditMode.this.repaintView();
            }
        }

        protected class ActionAddVertex
        extends AbstractAction {
            ActionAddVertex() {
                super("Add Vertex");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                HierInst<DbObject> ho = InteractiveRouteEditMode.this.getEditHierObject();
                if (ho == null) {
                    return;
                }
                EditWireMode.this.addVertex(ho, InteractiveRouteEditMode.this.mCursorPt);
            }
        }

        protected class ActionDeleteWire
        extends AbstractAction {
            ActionDeleteWire() {
                super("Delete Wire");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"WireCommands.deleteWire(ireWire)", (Object[])new Object[0]);
                InteractiveRouteEditMode.this.clearEditObject();
                InteractiveRouteEditMode.this.repaintView();
            }
        }

        protected class ActionExtendWire
        extends AbstractAction {
            protected int mFromVertex;

            public ActionExtendWire(int fromVertex) {
                super("Extend Wire");
                this.mFromVertex = fromVertex;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditWireMode.this.mUninstallClearsEditState = false;
                InteractiveRouteEditMode.this.setEditMode(new ExtendWireMode(this.mFromVertex));
            }
        }

        protected class DragInfo {
            protected Point mStart = null;

            public DragInfo(Point start) {
                this.mStart = start;
            }

            public Point getStart() {
                return this.mStart;
            }
        }
    }

    protected abstract class NewSegmentMode
    extends Mode {
        protected boolean mUninstallClearsEditState;
        protected APoint2D mAnchorPt;
        protected HierPortShape mCandidateShape;

        protected NewSegmentMode() {
            this.mUninstallClearsEditState = true;
            this.mAnchorPt = null;
            this.mCandidateShape = null;
        }

        @Override
        public boolean uninstall() {
            InteractiveRouteEditMode.this.informUser(null, new Object[0]);
            this.mAnchorPt = null;
            if (this.mUninstallClearsEditState) {
                InteractiveRouteEditMode.this.clearEditObject();
                InteractiveRouteEditMode.this.setCursorLoc(null);
            }
            return super.uninstall();
        }

        @Override
        public void mouseMove(DesignView2D.MouseAction e) {
            long snapDist;
            APoint2D tgt;
            ARect devBounds;
            AGrid grid;
            APoint2D worldPt = InteractiveRouteEditMode.this.getWorldPoint(e);
            APoint2D newPt = InteractiveRouteEditMode.snap(worldPt, this.mAnchorPt, grid = InteractiveRouteEditMode.this.mGrid == null ? null : InteractiveRouteEditMode.this.mGrid.getGrid(), devBounds = InteractiveRouteEditMode.this.mRouteOwner == null ? null : InteractiveRouteEditMode.this.mRouteOwner.getBB(), InteractiveRouteEditMode.this.mRoutingAngle, tgt = e.isShiftDown() ? null : InteractiveRouteEditMode.this.mTargetPt, snapDist = e.isShiftDown() ? 0L : InteractiveRouteEditMode.this.getWorldLen(InteractiveRouteEditMode.this.mOptionalSnappingDist));
            if (newPt != null && !newPt.equals((Object)InteractiveRouteEditMode.this.mCursorPt)) {
                this.mCandidateShape = InteractiveRouteEditMode.this.findCandidate(worldPt);
                if (this.mCandidateShape != null) {
                    InteractiveRouteEditMode.this.setCursorLoc(this.mCandidateShape.getCenter());
                } else {
                    InteractiveRouteEditMode.this.setCursorLoc(newPt);
                }
                InteractiveRouteEditMode.this.repaintOverlay();
            }
        }

        @Override
        public void mouseClick(DesignView2D.MouseAction e) {
            boolean newWire;
            Net n;
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            this.mouseMove(e);
            if (InteractiveRouteEditMode.this.mRouteOwner == null) {
                if (this.mCandidateShape != null) {
                    DevicePath selPath;
                    LinkedList<DevicePath> devices = new LinkedList<DevicePath>();
                    DevicePath tp = this.mCandidateShape.getDevicePath();
                    while (!tp.isEmpty()) {
                        devices.add(tp);
                        if (tp.getDevice().getIsSubstrate()) break;
                        tp = tp.getParent();
                    }
                    DevicePath devicePath = selPath = devices.size() == 1 ? (DevicePath)devices.get(0) : SelectFromListDlg.show(InteractiveRouteEditMode.this.mView, "Select Route Owner", devices, new SelectFromListDlg.Initializer<DevicePath>(){

                        @Override
                        public void init(SelectFromListDlg<DevicePath> dlg) {
                            dlg.getList().setCellRenderer(new DeviceListCellRenderer());
                        }
                    });
                    if (selPath == null) {
                        return;
                    }
                    if (!selPath.equals((Object)this.mCandidateShape.getDevicePath())) {
                        if (!selPath.contains(this.mCandidateShape.getDevicePath())) {
                            ALog.logError((String)"Invalid route owner, it does not contain the selected start shape.");
                            assert (false);
                            return;
                        }
                        InteractiveRouteEditMode.this.setDevice(selPath);
                        Net routeNet = null;
                        if (this.mCandidateShape.getNet().isUnused()) {
                            routeNet = selPath.getDeviceTemplate().getNetUnused();
                        } else {
                            routeNet = NetMap.getNetAt((Net)this.mCandidateShape.getNet(), (DevicePath)this.mCandidateShape.getDevicePath(), (DeviceTemplate)selPath.getDeviceTemplate());
                            if (!routeNet.getDeviceTemplate().equals(selPath.getDeviceTemplate())) {
                                DevicePath relPath = selPath.getRelativePath(this.mCandidateShape.getDevicePath());
                                routeNet = NetMap.mapThroughPath((DevicePath)relPath, (Net)routeNet, (String)routeNet.getName());
                            }
                            InteractiveRouteEditMode.this.setNet(routeNet);
                        }
                    }
                    InteractiveRouteEditMode.this.setDevice(selPath);
                } else if (!InteractiveRouteEditMode.this.selectDevice(InteractiveRouteEditMode.this.mCursorPt)) {
                    return;
                }
            }
            if (InteractiveRouteEditMode.this.mLayer == null) {
                if (this.mCandidateShape != null) {
                    InteractiveRouteEditMode.this.setLayer(this.mCandidateShape.getLayer());
                } else if (!InteractiveRouteEditMode.this.selectLayer(true)) {
                    return;
                }
            }
            if (InteractiveRouteEditMode.this.mNet == null && this.mCandidateShape != null && (n = this.mCandidateShape.getNet()) != null && !n.isUnused()) {
                if (this.mCandidateShape.getDevicePath().equals((Object)InteractiveRouteEditMode.this.mRouteOwner)) {
                    InteractiveRouteEditMode.this.setNet(n);
                } else {
                    Net n2 = NetMap.getNetAt((Net)n, (DevicePath)this.mCandidateShape.getDevicePath(), (DeviceTemplate)InteractiveRouteEditMode.this.mRouteOwner.getDeviceTemplate());
                    if (n2 == null) {
                        ALog.logError((String)"The starting net '%s' is not mapped to the device where the route is to be created ('%s'), unable to start the route.", (Object[])new Object[]{n.getName(), InteractiveRouteEditMode.this.mRouteOwner.getDevice().getName()});
                        return;
                    }
                    InteractiveRouteEditMode.this.setNet(n2);
                }
            }
            boolean bl = newWire = InteractiveRouteEditMode.this.getEditWire() == null;
            if (InteractiveRouteEditMode.this.mTarget == null && this.mCandidateShape != null && InteractiveRouteEditMode.this.mNet != null && !InteractiveRouteEditMode.this.mNet.isUnused() && InteractiveRouteEditMode.this.mLayer != null) {
                HierPortShape closest = null;
                long closestDist = Long.MAX_VALUE;
                AGeom startGeom = this.mCandidateShape.getTransformedGeom();
                for (HierInst portT : NetMap.getConnectedHierPorts((DevicePath)InteractiveRouteEditMode.this.mRouteOwner, (Net)InteractiveRouteEditMode.this.mNet)) {
                    if (!InteractiveRouteEditMode.this.mRouteOwner.contains(portT.getPath()) || this.mCandidateShape.getDevicePath().equals((Object)portT.getPath()) && this.mCandidateShape.getPinTemplate().equals(((PortTemplate)portT.getDbObject()).getPinTemplate())) continue;
                    for (LayerShape ls : ((PortTemplate)portT.getDbObject()).getLayerShapesOnLayer(InteractiveRouteEditMode.this.mLayer)) {
                        AGeom g = ls.getGeom().transform(((PortTemplate)portT.getDbObject()).getTransform(portT.getPath()));
                        long dist = g.distance(startGeom, false);
                        if (closest != null && dist >= closestDist) continue;
                        closest = new HierPortShape(portT.getPath(), (PortTemplate)portT.getDbObject(), ls);
                        closestDist = dist;
                    }
                }
                if (closest != null) {
                    InteractiveRouteEditMode.this.setTarget(closest);
                }
            }
            if (newWire && this.mCandidateShape != null) {
                RuleSet rs = RuleSetMgr.getMyRuleSet((DbObject)this.mCandidateShape.getPinInstance());
                if (rs == null && InteractiveRouteEditMode.this.mTarget != null) {
                    rs = RuleSetMgr.getMyRuleSet((DbObject)InteractiveRouteEditMode.this.mTarget.getPinInstance());
                }
                if (rs == null) {
                    HierInst portT;
                    PinInstance pin;
                    Iterator closestDist = NetMap.getConnectedHierPorts((DevicePath)InteractiveRouteEditMode.this.mRouteOwner, (Net)InteractiveRouteEditMode.this.mNet).iterator();
                    while (closestDist.hasNext() && (rs = RuleSetMgr.getMyRuleSet((DbObject)(pin = PinInstance.getPinInstance((Device)(portT = (HierInst)closestDist.next()).getPath().getDevice(), (PinTemplate)((PortTemplate)portT.getDbObject()).getPinTemplate())))) == null) {
                    }
                }
                if (rs != null) {
                    Constraint.RouteAngle angle;
                    Long width;
                    Design design = Design.getDesign((Db)InteractiveRouteEditMode.this.mView.getDb());
                    Unit.Distance unit = design == null ? null : design.getUnit();
                    AExpression expr = (AExpression)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.WIRE_WIDTH, (Layer)InteractiveRouteEditMode.this.mLayer);
                    if (expr != null && unit != null && (width = unit.fromUserString((String)expr.evaluate())) != null) {
                        InteractiveRouteEditMode.this.setRouteWidth(width);
                    }
                    if ((angle = (Constraint.RouteAngle)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.ROUTE_ANGLE, (Layer)InteractiveRouteEditMode.this.mLayer)) == Constraint.RouteAngle.Any) {
                        InteractiveRouteEditMode.this.setRouteAngle(0);
                    } else if (angle == Constraint.RouteAngle.FortyFive) {
                        InteractiveRouteEditMode.this.setRouteAngle(45);
                    } else if (angle == Constraint.RouteAngle.Ninety) {
                        InteractiveRouteEditMode.this.setRouteAngle(90);
                    }
                }
            }
            if (InteractiveRouteEditMode.this.mRouteWidth <= 0L && !InteractiveRouteEditMode.this.selectRouteWidth(true)) {
                return;
            }
            if (InteractiveRouteEditMode.this.mGrid == null && !InteractiveRouteEditMode.this.selectGrid(true)) {
                return;
            }
            if (InteractiveRouteEditMode.this.mRouteWidth <= 0L && !InteractiveRouteEditMode.this.selectRouteWidth(true)) {
                return;
            }
            boolean ptAdded = InteractiveRouteEditMode.this.addWirePt(InteractiveRouteEditMode.this.mCursorPt);
            if (ptAdded) {
                if (this.mCandidateShape != null) {
                    if (newWire && this.mCandidateShape.getDevice() == InteractiveRouteEditMode.this.mRouteOwner.getDevice()) {
                        Cp.exec((String)"ireWire.setPortA(ireWire.getNet().getPortByName(\"%s\"))", (Object[])new Object[]{this.mCandidateShape.getPinTemplate().getName()});
                    }
                    if (InteractiveRouteEditMode.this.mNetShapesOnLayer != null) {
                        InteractiveRouteEditMode.this.mNetShapesOnLayer.add(this.mCandidateShape);
                    }
                    this.mCandidateShape = null;
                }
                this.mAnchorPt = InteractiveRouteEditMode.this.mCursorPt.copy();
            }
            InteractiveRouteEditMode.this.repaintView();
        }

        @Override
        public void paintOverlay(Graphics2D g) {
            Color colorOld = g.getColor();
            g.setColor(CANDIDATE_COLOR);
            if (this.mCandidateShape != null) {
                this.paintLayerShape(g, this.mCandidateShape);
            }
            if (InteractiveRouteEditMode.this.mNetShapesOnLayer != null && !InteractiveRouteEditMode.this.mNetShapesOnLayer.isEmpty()) {
                for (HierPortShape hPortShape : InteractiveRouteEditMode.this.mNetShapesOnLayer) {
                    this.paintLayerShape(g, hPortShape);
                }
            }
            InteractiveRouteEditMode.this.drawTarget(g, Color.YELLOW);
            if (this.mAnchorPt != null && InteractiveRouteEditMode.this.mCursorPt != null) {
                Stroke strokeOld = g.getStroke();
                Point scrAnchorPt = InteractiveRouteEditMode.this.getScreenPoint(this.mAnchorPt);
                Point scrCursorPt = InteractiveRouteEditMode.this.getScreenPoint(InteractiveRouteEditMode.this.mCursorPt);
                g.setXORMode(Color.WHITE);
                if (this.canAutoCompleteRoute()) {
                    Point scrTgtPt = InteractiveRouteEditMode.this.getScreenPoint(InteractiveRouteEditMode.this.mTargetPt);
                    g.setColor(Color.RED);
                    g.setStroke(STROKE_DASH);
                    g.drawLine(scrAnchorPt.x, scrAnchorPt.y, scrTgtPt.x, scrTgtPt.y);
                }
                int screenWidth = InteractiveRouteEditMode.this.getScreenLen(InteractiveRouteEditMode.this.mRouteWidth);
                BasicStroke stroke = new BasicStroke(screenWidth, 1, 1);
                g.setColor(Color.BLACK);
                g.setStroke(stroke);
                Line2D.Float line = new Line2D.Float(scrAnchorPt, scrCursorPt);
                g.draw(line);
                g.setStroke(strokeOld);
                g.setPaintMode();
            }
            g.setColor(colorOld);
        }

        protected void paintLayerShape(Graphics2D g, HierPortShape hPortShape) {
            LayerShape ls = hPortShape.getLayerShape();
            AffineTransform pathXForm = hPortShape.getDevicePath().getTransform();
            pathXForm.concatenate(hPortShape.getPortTemplate().getLocalTransform());
            DesignCanvas2D.drawGeom(g, InteractiveRouteEditMode.this.mView.getCanvas().getXForm(), ls.getGeom(), pathXForm, CANDIDATE_OUTLINE_COLOR);
        }

        @Override
        public IterableIterator<Action> getActions(Point loc) {
            LinkedList<Action> actions = new LinkedList<Action>();
            APoint2D worldLoc = InteractiveRouteEditMode.this.getWorldPoint(loc);
            HierPortShape candidate = InteractiveRouteEditMode.this.findCandidate(worldLoc);
            if (candidate != null) {
                actions.add(new ActionSetTarget(candidate));
            }
            if (InteractiveRouteEditMode.this.mTarget != null) {
                actions.add(new ActionClearTarget());
            }
            if (this.canAutoCompleteRoute()) {
                actions.add(new AbstractAction("Auto-complete Route"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NewSegmentMode.this.autoComplete();
                    }
                });
            }
            actions.add(new ActionAddVia());
            actions.add(this.getActionEndRoute());
            return AIterableItr.itr(actions);
        }

        protected abstract Action getActionEndRoute();

        protected boolean canAutoCompleteRoute() {
            if (this.mAnchorPt == null || InteractiveRouteEditMode.this.mTargetPt == null) {
                return false;
            }
            if (InteractiveRouteEditMode.this.mRoutingAngle == 0) {
                return true;
            }
            ALine toTgt = new ALine(this.mAnchorPt, InteractiveRouteEditMode.this.mTargetPt);
            return toTgt.getAngle() % (double)InteractiveRouteEditMode.this.mRoutingAngle == 0.0;
        }

        protected void autoComplete() {
            InteractiveRouteEditMode.this.addWirePt(InteractiveRouteEditMode.this.mTargetPt);
            if (InteractiveRouteEditMode.this.mTarget.getDevice() == InteractiveRouteEditMode.this.mRouteOwner.getDevice()) {
                Cp.exec((String)"ireWire.setPortB(ireWire.getNet().getPortByName(\"%s\"))", (Object[])new Object[]{InteractiveRouteEditMode.this.mTarget.getPinTemplate().getName()});
            }
            InteractiveRouteEditMode.this.setTarget(null);
            if (!InteractiveRouteEditMode.this.autoExitEditing()) {
                InteractiveRouteEditMode.this.setEditMode(new EditWireMode());
            }
        }

        protected class ViaTemplateSelDlg
        extends ADialog {
            protected boolean mCancelled;
            protected JComboBox<PadTemplate> mCboPadTemplate;
            protected DefaultComboBoxModel<PadTemplate> mPadTemplates;
            protected PadTemplate mLastSelectedPadTemplate;
            protected JComboBox<Layer> mCboLayer;
            protected DefaultComboBoxModel<Layer> mLayers;
            protected Layer mLastSelectedLayer;
            protected JButton mBtnOk;
            protected boolean mUpdating;
            protected ListCellRenderer<Object> mCellRenderer;

            public ViaTemplateSelDlg() {
                super((Component)InteractiveRouteEditMode.this.mView, "Select Via Pad Template");
                this.mCancelled = true;
                this.mPadTemplates = new DefaultComboBoxModel();
                this.mLastSelectedPadTemplate = null;
                this.mLayers = new DefaultComboBoxModel();
                this.mLastSelectedLayer = null;
                this.mUpdating = false;
                this.mCellRenderer = new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean isSelected, boolean hasFocus) {
                        super.getListCellRendererComponent(list, (Object)null, idx, isSelected, hasFocus);
                        if (val instanceof DbObject) {
                            this.setText(((DbObject)val).getStringValue("name"));
                        } else if (val == null) {
                            this.setText(" ");
                        }
                        return this;
                    }
                };
                this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
                l.add("Current Layer:");
                l.add(InteractiveRouteEditMode.this.mLayer.getName());
                l.newline();
                l.add("Pad Template:");
                this.mCboPadTemplate = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
                this.mCboPadTemplate.setModel(this.mPadTemplates);
                this.mCboPadTemplate.setRenderer(this.mCellRenderer);
                l.newline();
                l.add("New Layer:");
                this.mCboLayer = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
                this.mCboLayer.setModel(this.mLayers);
                this.mCboLayer.setRenderer(this.mCellRenderer);
                l.newline();
                l.addFillY();
                l.pushFillXRemainX();
                l.addFillX();
                this.mBtnOk = (JButton)l.add((Component)new JButton("OK"));
                JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
                l.pop();
                this.mBtnOk.addActionListener(e -> {
                    this.mCancelled = false;
                    UIUtil.closeWindow((Window)((Object)this));
                });
                this.mCboLayer.addActionListener(e -> this.selectionChange());
                this.mCboPadTemplate.addActionListener(e -> this.selectionChange());
                this.updateLayers();
                this.updatePadTemplates();
                UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
                this.pack();
                this.setMinimumSize(this.getPreferredSize());
                UIUtil.center((Component)((Object)this));
            }

            public boolean getCancelled() {
                return this.mCancelled;
            }

            public Layer getSelectedLayer() {
                return (Layer)this.mCboLayer.getSelectedItem();
            }

            public void setSelectedLayer(Layer l) {
                this.mCboLayer.setSelectedItem(l);
            }

            public PadTemplate getSelectedPadTemplate() {
                return (PadTemplate)this.mCboPadTemplate.getSelectedItem();
            }

            public void setSelectedPadTemplate(PadTemplate pt) {
                this.mCboPadTemplate.setSelectedItem(pt);
            }

            protected void updatePadTemplates() {
                PadTemplate sel = this.getSelectedPadTemplate();
                this.mPadTemplates.removeAllElements();
                this.mPadTemplates.addElement(null);
                Layer selLayer = this.getSelectedLayer();
                LinkedList pts = AUtil.linkedList(ViaFactory.getViaTemplates(InteractiveRouteEditMode.this.getSubstrate()));
                Collections.sort(pts);
                for (PadTemplate pt : pts) {
                    if (!pt.getLayers().contains(InteractiveRouteEditMode.this.mLayer) || selLayer != null && !pt.getLayers().contains(selLayer)) continue;
                    this.mPadTemplates.addElement(pt);
                }
                this.setSelectedPadTemplate(sel);
            }

            protected void updateLayers() {
                Layer sel = this.getSelectedLayer();
                this.mLayers.removeAllElements();
                this.mLayers.addElement(null);
                PadTemplate selPadTemplate = this.getSelectedPadTemplate();
                for (Layer l : InteractiveRouteEditMode.this.getSubstrate().getLayers(Layer.TopFirstSort)) {
                    if (selPadTemplate != null && !selPadTemplate.getLayers().contains(l)) continue;
                    this.mLayers.addElement(l);
                }
                this.setSelectedLayer(sel);
            }

            protected void selectionChange() {
                if (this.mUpdating) {
                    return;
                }
                this.mUpdating = true;
                if (this.getSelectedLayer() != this.mLastSelectedLayer) {
                    this.mLastSelectedLayer = this.getSelectedLayer();
                    this.updatePadTemplates();
                }
                if (this.getSelectedPadTemplate() != this.mLastSelectedPadTemplate) {
                    this.mLastSelectedPadTemplate = this.getSelectedPadTemplate();
                    this.updateLayers();
                }
                this.mUpdating = false;
                this.mBtnOk.setEnabled(this.getSelectedLayer() != null && this.getSelectedPadTemplate() != null);
            }
        }

        protected class ActionAddVia
        extends AbstractAction {
            ActionAddVia() {
                super("Add Via");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                HierInst<Wire> hw = InteractiveRouteEditMode.this.getEditHierWire();
                if (hw == null) {
                    return;
                }
                DevicePath dpath = hw.getPath();
                Wire wire = (Wire)hw.getDbObject();
                APath shape = wire.getPath();
                ViaTemplateSelDlg dlg = new ViaTemplateSelDlg();
                dlg.setVisible(true);
                PadTemplate padTemplate = dlg.getSelectedPadTemplate();
                Layer tgtLayer = dlg.getSelectedLayer();
                if (padTemplate == null || tgtLayer == null) {
                    return;
                }
                APoint2D loc = InteractiveRouteEditMode.this.mCursorPt.transform(dpath.getInverseTransform());
                int lastVertexIdx = shape.getSize() - 1;
                Cp.exec((String)"ireWire.getDb().getHistory().startTransactionCoalesce(\"AddVia\")", (Object[])new Object[0]);
                try {
                    if (lastVertexIdx < 0 || !shape.getPoint(lastVertexIdx).equals((Object)loc)) {
                        Cp.exec((String)"WireCommands.addWirePoint(ireWire, %dL, %dL)", (Object[])new Object[]{loc.getX(), loc.getY()});
                        shape = wire.getPath();
                        lastVertexIdx = shape.getSize() - 1;
                    }
                    Cp.exec((String)"unset(\"ireVia\")", (Object[])new Object[0]);
                    Cp.exec((String)"ireVia = WireCommands.addVia(ireWire, %d, \"%s\")", (Object[])new Object[]{lastVertexIdx, padTemplate.getKeyStr()});
                    Object ireVia = Cp.getCp().getInterpreterValue("ireVia");
                    if (!(ireVia instanceof PortTemplate)) {
                        ALog.logError((Throwable)new Exception("Via add failed"), (String)"Unknown error adding via.", (Object[])new Object[0]);
                        return;
                    }
                    Cp.exec((String)"ireWire.setPortB(ireVia.getPinTemplate())", (Object[])new Object[0]);
                    if (tgtLayer != InteractiveRouteEditMode.this.mLayer) {
                        InteractiveRouteEditMode.this.mLayer = tgtLayer;
                        DeviceTemplate template = wire.getDeviceTemplate();
                        Net net = wire.getNet();
                        Cp.exec((String)"ireWire = WireCommands.createWire(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{template.getKeyStr(), net.getName(), InteractiveRouteEditMode.this.mLayer.getName()});
                        Object o = Cp.exec((boolean)false, (String)"ireWire", (Object[])new Object[0]);
                        if (!(o instanceof Wire)) {
                            ALog.logError((Throwable)new RuntimeException("Unexpected command result"), (String)"Error creating Wire.", (Object[])new Object[0]);
                            assert (false);
                            Cp.exec((String)"unset(\"ireWire\")", (Object[])new Object[0]);
                            return;
                        }
                        Wire w = (Wire)o;
                        InteractiveRouteEditMode.this.notifyEditWireSet(w);
                        Cp.exec((String)"WireCommands.setWireWidth(ireWire, %dL)", (Object[])new Object[]{InteractiveRouteEditMode.this.mRouteWidth});
                        Cp.exec((String)"WireCommands.addWirePoint(ireWire, %dL, %dL)", (Object[])new Object[]{loc.getX(), loc.getY()});
                        InteractiveRouteEditMode.this.updateOptionsUI();
                        Cp.exec((String)"ireWire.setPortA(ireVia.getPinTemplate())", (Object[])new Object[0]);
                        InteractiveRouteEditMode.this.mNetShapesOnLayer = InteractiveRouteEditMode.this.findCandidatesOfCurNet();
                    }
                    Cp.exec((String)"unset(\"ireVia\")", (Object[])new Object[0]);
                    NewSegmentMode.this.mAnchorPt = InteractiveRouteEditMode.this.mCursorPt.copy();
                    InteractiveRouteEditMode.this.repaintView();
                }
                finally {
                    Cp.exec((String)"ireWire.getDb().getHistory().endTransactionCoalesce()", (Object[])new Object[0]);
                }
            }
        }

        protected class ActionClearTarget
        extends AbstractAction {
            protected HierPortShape mHierPortShape;

            public ActionClearTarget() {
                super("Clear Target");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractiveRouteEditMode.this.setTarget(null);
            }
        }

        protected class ActionSetTarget
        extends AbstractAction {
            protected HierPortShape mHierPortShape;

            public ActionSetTarget(HierPortShape hps) {
                this.mHierPortShape = hps;
                this.putValue("Name", "Set Target");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractiveRouteEditMode.this.setTarget(this.mHierPortShape);
            }
        }
    }

    protected class ExtendWireMode
    extends NewSegmentMode {
        int mFromVertex = -1;

        public ExtendWireMode(int fromVertex) {
            this.mFromVertex = fromVertex;
        }

        @Override
        public boolean install() {
            if (!super.install()) {
                return false;
            }
            HierInst<Wire> hw = InteractiveRouteEditMode.this.getEditHierWire();
            if (hw == null) {
                ALog.logError((String)"Attempt to enter extend wire mode from invalid state.");
                return false;
            }
            APath path = ((Wire)hw.second).getPath();
            APoint2D anchor = path == null ? null : path.getPoint(this.mFromVertex);
            AffineTransform xform = hw.getPath() == null ? null : hw.getPath().getTransform();
            this.mAnchorPt = anchor == null || xform == null ? null : anchor.transform(xform);
            InteractiveRouteEditMode.this.informUser("Click to add new segments", new Object[0]);
            return true;
        }

        @Override
        public void mouseClick(DesignView2D.MouseAction e) {
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            this.mouseMove(e);
            APoint2D pt = InteractiveRouteEditMode.this.getDeviceRelativePt(InteractiveRouteEditMode.this.mCursorPt);
            int idx = this.mFromVertex == 0 ? 0 : InteractiveRouteEditMode.this.getEditWire().getPath().getPointCount();
            Cp.exec((String)"WireCommands.insertWireVertex(ireWire, %d, %dL, %dL)", (Object[])new Object[]{idx, pt.getX(), pt.getY()});
            this.mAnchorPt = InteractiveRouteEditMode.this.mCursorPt.copy();
            InteractiveRouteEditMode.this.repaintView();
        }

        @Override
        protected Action getActionEndRoute() {
            return new AbstractAction("Complete Route"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtendWireMode.this.mUninstallClearsEditState = false;
                    if (!InteractiveRouteEditMode.this.autoExitEditing()) {
                        InteractiveRouteEditMode.this.setEditMode(new EditWireMode());
                    }
                }
            };
        }
    }

    protected class NewWireMode
    extends NewSegmentMode {
        protected NewWireMode() {
        }

        @Override
        public boolean install() {
            InteractiveRouteEditMode.this.informUser("Click location to start new route", new Object[0]);
            return super.install();
        }

        @Override
        public boolean uninstall() {
            Wire w = InteractiveRouteEditMode.this.getEditWire();
            if (w != null) {
                if (w.getPath().getPointCount() < 2) {
                    Cp.exec((String)"WireCommands.deleteWire(ireWire)", (Object[])new Object[0]);
                }
                InteractiveRouteEditMode.this.repaintView();
            }
            return super.uninstall();
        }

        @Override
        protected Action getActionEndRoute() {
            return new AbstractAction(){
                {
                    Wire w = InteractiveRouteEditMode.this.getEditWire();
                    int points = w == null ? 0 : w.getPath().getPointCount();
                    this.putValue("Name", points < 2 ? "Cancel New Route" : "End Route");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewWireMode.this.mUninstallClearsEditState = false;
                    if (!InteractiveRouteEditMode.this.autoExitEditing()) {
                        InteractiveRouteEditMode.this.setEditMode(new EditWireMode());
                    }
                }
            };
        }
    }

    protected abstract class Mode {
        protected Mode() {
        }

        public boolean install() {
            return true;
        }

        public boolean uninstall() {
            return true;
        }

        public void mouseClick(DesignView2D.MouseAction e) {
        }

        public void mouseDrag(DesignView2D.MouseAction e) {
        }

        public void mouseEnter(DesignView2D.MouseAction e) {
        }

        public void mouseExit(DesignView2D.MouseAction e) {
        }

        public void mouseMove(DesignView2D.MouseAction e) {
        }

        public void mousePress(DesignView2D.MouseAction e) {
        }

        public void mouseRelease(DesignView2D.MouseAction e) {
        }

        public void paintOverlay(Graphics2D g) {
        }

        public IterableIterator<Action> getActions(Point loc) {
            return AEmptyItr.create();
        }

        public void prepareContexMenu(JPopupMenu menu, Point loc) {
        }
    }

    public static enum RoutingAngle {
        Any("Any", 0),
        FortyFive("45", 45),
        Ninety("90", 90);

        protected String desc;
        protected int angle;

        private RoutingAngle(String desc, int deg) {
            this.desc = desc;
            this.angle = deg;
        }

        public String toString() {
            return this.desc;
        }

        public static RoutingAngle valueOf(int angle) {
            for (RoutingAngle ra : RoutingAngle.values()) {
                if (ra.angle != angle) continue;
                return ra;
            }
            return null;
        }
    }

    public static interface OverlayPainter {
        public void paintOverlay(Graphics2D var1);
    }
}

