/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.route_edit;

import com.sigrity.acl.AGridUtil;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.route_edit.EditRouteMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class InteractiveWireCreator
implements EditRouteMode.SubMode,
EditRouteMode.SubMode.RawCoords {
    protected EditRouteMode mParent;
    protected LinkedList<Component> mContextMenu = null;
    protected Wire mWire = null;
    protected APoint2D mAnchor = null;
    protected long mWidth = 100L;
    protected int mConstrainAngle = 0;
    static final int SNAP_EPS_DEG = 8;
    protected final DbClass.DbObjectEventType[] WireListenEvents = new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.CHANGED, DbClass.DbObjectEventType.REMOVED};
    protected DbClass.DbObjectListener mWireListener = new DbClass.DbObjectAdapter(){

        public void changedObject(DbClass.ObjectChange change) {
            APoint2D pt;
            if (InteractiveWireCreator.this.mWire != null && change.getDbObject() == InteractiveWireCreator.this.mWire && (pt = InteractiveWireCreator.this.mWire.getPath().getLastPoint()) != null && !pt.equals((Object)InteractiveWireCreator.this.mAnchor)) {
                InteractiveWireCreator.this.mAnchor = pt;
                InteractiveWireCreator.this.mParent.repaintOverlay();
            }
        }

        public void removedObject(DbClass.ObjectRemove remove) {
            if (InteractiveWireCreator.this.mWire != null && remove.getDbObject() == InteractiveWireCreator.this.mWire) {
                InteractiveWireCreator.this.mWire = null;
                InteractiveWireCreator.this.mParent.repaintOverlay();
            }
        }
    };

    @Override
    public boolean install(EditRouteMode erm) {
        this.mParent = erm;
        this.mAnchor = this.mParent.getCursorLoc();
        DbClass dbcWire = this.mParent.getView().getDb().getDbClass(Wire.class);
        dbcWire.addObjectListener(this.mWireListener, this.WireListenEvents);
        return true;
    }

    @Override
    public void uninstall() {
        DbClass dbcWire = this.mParent.getView().getDb().getDbClass(Wire.class);
        if (dbcWire != null) {
            dbcWire.removeObjectListener(this.mWireListener, this.WireListenEvents);
        }
        if (this.mAnchor != null) {
            this.mParent.repaintView();
            this.mAnchor = null;
        }
        if (this.mWire != null) {
            Cp.exec((String)"unset(\"wire\")", (Object[])new Object[0]);
            this.mWire = null;
        }
    }

    @Override
    public APoint2D mouseClicked(int button, APoint2D location) {
        location = this.snap(location);
        if (button == 1) {
            this.createSegment(location);
        }
        return location;
    }

    @Override
    public APoint2D mouseMoved(APoint2D oldLoc, APoint2D newLoc) {
        newLoc = this.snap(newLoc);
        this.mParent.repaintOverlay();
        return newLoc;
    }

    protected boolean suitableForSnap(APoint2D pt, APoint2D ptAnchor, float constrainAngleDeg) {
        double a0 = ptAnchor.getAngle(pt);
        double snapAngleDegrees = AGeomUtil.normDeg((double)(Math.floor((a0 + (double)(constrainAngleDeg / 2.0f)) / (double)constrainAngleDeg) * (double)constrainAngleDeg));
        return Math.abs(snapAngleDegrees - a0) < 8.0 || Math.abs(snapAngleDegrees - a0) > 352.0;
    }

    public APoint2D snap(APoint2D worldPoint) {
        ARect bounds;
        if (worldPoint == null) {
            return null;
        }
        if (this.mAnchor == null) {
            return worldPoint;
        }
        NamedGrid curNamedGrid = this.mParent.getGrid();
        AGrid grid = curNamedGrid == null ? null : curNamedGrid.getGrid();
        ARect aRect = bounds = this.mParent.mConstrainToDevice ? this.mParent.mDevicePath.getBB() : null;
        if (this.mConstrainAngle != 0) {
            double a0 = this.mAnchor.getAngle(worldPoint);
            int snapAngleDegrees = (int)((a0 + (double)this.mConstrainAngle / 2.0) / (double)this.mConstrainAngle) * this.mConstrainAngle;
            double snapAngle = Math.toRadians(snapAngleDegrees);
            double snapTan = Math.tan(snapAngle);
            if (grid != null) {
                long max = bounds == null ? 0L : bounds.getLL().manhattanDistance(bounds.getUR());
                long d = InteractiveWireCreator.findAngleDist(grid, snapTan, max);
                if (d != 0L) {
                    long l0 = worldPoint.distance(this.mAnchor);
                    long l1 = AGridUtil.getNearestSpacing((long)l0, (long)d);
                    long dy = Math.round((double)l1 * Math.sin(snapAngle));
                    long dx = Math.round((double)l1 * Math.cos(snapAngle));
                    worldPoint.setX(this.mAnchor.getX() + dx);
                    worldPoint.setY(this.mAnchor.getY() + dy);
                    while (bounds != null && !bounds.contains(worldPoint)) {
                        dy = Math.round((double)(l1 -= d) * Math.sin(snapAngle));
                        dx = Math.round((double)l1 * Math.cos(snapAngle));
                        worldPoint.setX(this.mAnchor.getX() + dx);
                        worldPoint.setY(this.mAnchor.getY() + dy);
                    }
                } else {
                    worldPoint.setX(this.mAnchor.getX());
                    worldPoint.setY(this.mAnchor.getY());
                }
            } else {
                if (!this.suitableForSnap(worldPoint, this.mAnchor, this.mConstrainAngle)) {
                    return worldPoint;
                }
                if (worldPoint.getQuadrant(this.mAnchor) % 2 == 0) {
                    long y = Math.round(snapTan * (double)(worldPoint.getX() - this.mAnchor.getX()) + (double)this.mAnchor.getY());
                    worldPoint.setY(y);
                } else {
                    long x = Math.round((double)(worldPoint.getY() - this.mAnchor.getY()) / snapTan) + this.mAnchor.getX();
                    worldPoint.setX(x);
                }
                if (bounds != null && !bounds.contains(worldPoint)) {
                    APoint2D p;
                    ALine l = new ALine(this.mAnchor, worldPoint);
                    if (worldPoint.getX() < bounds.left()) {
                        p = bounds.leftEdge().getIntersectLines(l);
                        if (p != null) {
                            worldPoint = p;
                        } else {
                            worldPoint.setX(bounds.left());
                        }
                    }
                    if (worldPoint.getX() > bounds.right()) {
                        p = bounds.rightEdge().getIntersectLines(l);
                        if (p != null) {
                            worldPoint = p;
                        } else {
                            worldPoint.setX(bounds.right());
                        }
                    }
                    if (worldPoint.getY() < bounds.bottom()) {
                        p = bounds.bottomEdge().getIntersectLines(l);
                        if (p != null) {
                            worldPoint = p;
                        } else {
                            worldPoint.setY(bounds.bottom());
                        }
                    }
                    if (worldPoint.getY() > bounds.top()) {
                        p = bounds.topEdge().getIntersectLines(l);
                        if (p != null) {
                            worldPoint = p;
                        } else {
                            worldPoint.setY(bounds.top());
                        }
                    }
                }
            }
        } else if (grid != null) {
            worldPoint = grid.snapToGrid(worldPoint, bounds);
        } else if (bounds != null && !bounds.contains(worldPoint)) {
            if (worldPoint.getX() < bounds.left()) {
                worldPoint.setX(bounds.left());
            }
            if (worldPoint.getX() > bounds.right()) {
                worldPoint.setX(bounds.right());
            }
            if (worldPoint.getY() < bounds.bottom()) {
                worldPoint.setY(bounds.bottom());
            }
            if (worldPoint.getY() > bounds.top()) {
                worldPoint.setY(bounds.top());
            }
        }
        return worldPoint;
    }

    protected static long findAngleDist(AGrid grid, double tan, long max) {
        if (tan > 1.0) {
            tan = 1.0 / tan;
        }
        for (long x = grid.getDeltaX(); x < Integer.MAX_VALUE; x += grid.getDeltaX()) {
            long y = Math.round(tan * (double)x);
            if (y % grid.getDeltaY() != 0L) continue;
            return Math.round(Math.hypot(x, y));
        }
        return 0L;
    }

    @Override
    public LinkedList<Component> getContextMenu(Point loc) {
        if (this.mContextMenu == null) {
            this.mContextMenu = new LinkedList();
            this.mContextMenu.add(new JSeparator());
            this.mContextMenu.add(new JMenuItem(new AbstractAction("End Trace"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InteractiveWireCreator.this.mParent.endSubmode();
                }
            }));
            this.mContextMenu.add(new JMenuItem(new AbstractAction("Set Width..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InteractiveWireCreator.this.queryUserTraceWidth();
                }
            }));
            ButtonGroup bgAngle = new ButtonGroup();
            bgAngle.add(new JRadioButtonMenuItem(new AbstractAction("Any angle"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InteractiveWireCreator.this.constrainAngleAny();
                }
            }){

                @Override
                public void addNotify() {
                    super.addNotify();
                    this.setSelected(InteractiveWireCreator.this.mConstrainAngle == 0);
                }
            });
            bgAngle.add(new JRadioButtonMenuItem(new AbstractAction("Constrain to 45"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InteractiveWireCreator.this.constrainAngle45();
                }
            }){

                @Override
                public void addNotify() {
                    super.addNotify();
                    this.setSelected(InteractiveWireCreator.this.mConstrainAngle == 45);
                }
            });
            bgAngle.add(new JRadioButtonMenuItem(new AbstractAction("Constrain to 90"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InteractiveWireCreator.this.constrainAngle90();
                }
            }){

                @Override
                public void addNotify() {
                    super.addNotify();
                    this.setSelected(InteractiveWireCreator.this.mConstrainAngle == 90);
                }
            });
            for (AbstractButton b : AUtil.getIterable(bgAngle.getElements())) {
                this.mContextMenu.add(b);
            }
        }
        return this.mContextMenu;
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
        if (this.mAnchor == null) {
            return;
        }
        APoint2D curLoc = this.mParent.getCursorLoc();
        Color colorOld = g.getColor();
        Stroke strokeOld = g.getStroke();
        int screenWidth = this.mParent.getScreenLen(this.mWidth);
        BasicStroke stroke = new BasicStroke(screenWidth, 2, 1);
        g.setColor(Color.WHITE);
        g.setXORMode(Color.BLACK);
        g.setStroke(stroke);
        Point p1 = this.mParent.getScreenPoint(this.mAnchor);
        Point p2 = this.mParent.getScreenPoint(curLoc);
        Line2D.Float line = new Line2D.Float(p1, p2);
        g.draw(line);
        g.setStroke(strokeOld);
        g.setPaintMode();
        g.setColor(colorOld);
    }

    public void setWidth(long width) {
        this.mWidth = width;
        if (this.mWire != null) {
            APath path = this.mWire.getPath().copy();
            path.setWidth(width);
            this.mWire.setPath(path);
            this.mParent.repaintView();
            Cp.exec((String)"WireCommands.setWireWidth(wire, %dL)", (Object[])new Object[]{this.mWidth});
        }
    }

    public boolean createSegment(APoint2D loc) {
        if (this.mWire == null) {
            DeviceTemplate template = this.mParent.mDevicePath.getLast().getTemplate();
            Cp.exec((String)"import com.sigrity.orbit.cmd.*", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"wire\")", (Object[])new Object[0]);
            Cp.exec((String)"Wire wire = WireCommands.createWire(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{template.getName(), template.getNetUnused().getName(), this.mParent.mLayer.getName()});
            Object o = Cp.exec((boolean)false, (String)"wire", (Object[])new Object[0]);
            if (!(o instanceof Wire)) {
                ALog.logError((Throwable)new RuntimeException("Unexpected command result"), (String)"Error creating Wire.", (Object[])new Object[0]);
                assert (false);
                Cp.exec((String)"unset(\"wire\")", (Object[])new Object[0]);
                return false;
            }
            this.mWire = (Wire)o;
            Cp.exec((String)"WireCommands.setWireWidth(wire, %dL)", (Object[])new Object[]{this.mWidth});
            APoint2D tpt = this.toTemplatePoint(this.mAnchor);
            Cp.exec((String)"WireCommands.addWirePoint(wire, %dL, %dL)", (Object[])new Object[]{tpt.getX(), tpt.getY()});
        }
        APoint2D tpt = this.toTemplatePoint(loc);
        Cp.exec((String)"WireCommands.addWirePoint(wire, %dL, %dL)", (Object[])new Object[]{tpt.getX(), tpt.getY()});
        this.mAnchor = new APoint2D(loc);
        this.mParent.repaintView();
        return true;
    }

    public APoint2D toTemplatePoint(APoint2D p) {
        AffineTransform x = ATransformUtil.inverse((AffineTransform)this.mParent.mDevicePath.getTransform());
        return p.transform(x);
    }

    public void constrainAngleAny() {
        this.mConstrainAngle = 0;
    }

    public void constrainAngle45() {
        this.mConstrainAngle = 45;
    }

    public void constrainAngle90() {
        this.mConstrainAngle = 90;
    }

    public void queryUserTraceWidth() {
        Unit u = this.mParent.getView().getUnit();
        String strCurWidth = u.toUserStr(this.mWidth);
        AFloatWindow d = new AFloatWindow(this.mParent.getParentWindow(), "Set Trace Width", Dialog.ModalityType.DOCUMENT_MODAL);
        GridBagManager l = new GridBagManager(d.getContentPane());
        l.add("Width:");
        JTextField txtWidth = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        txtWidth.setText(strCurWidth);
        l.newline();
        l.addFillX();
        JButton btnOK = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
        btnOK.addActionListener(e -> {
            double userWidth = 0.0;
            try {
                userWidth = AFieldValidator.getValidatedDouble((JTextField)txtWidth);
            }
            catch (AFieldValidator.AFieldValidationException e1) {
                return;
            }
            long width = u == null ? (long)userWidth : u.fromUser(userWidth);
            this.setWidth(width);
            UIUtil.closeWindow((Window)((Object)d));
            this.mParent.repaintOverlay();
        });
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)d), (AbstractButton)btnCancel, (JButton)btnOK);
        d.pack();
        UIUtil.center((Component)((Object)d));
        txtWidth.requestFocus();
        d.setVisible(true);
    }
}

