/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.route_edit;

import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.ui.GridOverlay;
import com.sigrity.orbit.ui.canvas_modes.SpotLight;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.route_edit.EditRouteMode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class RoutingOverlay
extends GridOverlay {
    public static final Color CURSOR_COLOR = Color.RED;
    public static final Color CURSOR_COLOR_XOR = Color.WHITE;
    public static final int CURSOR_LEG_SIZE = 7;
    protected EditRouteMode mRouteMode;
    protected boolean mSpotlight = (Boolean)Settings.get((String)"UserPreferences", (String)"EnableSpotlights", (Object)false);
    protected Point mDrawnCursorLoc = null;
    protected MouseAdapter mMouseListener = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            Graphics2D g = (Graphics2D)RoutingOverlay.this.getGraphics();
            if (g == null) {
                return;
            }
            RoutingOverlay.this.drawRoutingCursor(g);
            g.dispose();
        }
    };

    public RoutingOverlay(EditRouteMode erm, NamedGrid grid) {
        super(erm.getView(), erm.getDevicePath(), grid);
        this.mRouteMode = erm;
    }

    public void setSpotlight(boolean b) {
        this.mSpotlight = b;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mView.getCanvas().addMouseListener(this.getMouseListener());
        this.mView.getCanvas().addMouseMotionListener(this.getMouseMotionListener());
    }

    @Override
    public void removeNotify() {
        this.mView.getCanvas().removeMouseMotionListener(this.getMouseMotionListener());
        this.mView.getCanvas().removeMouseListener(this.getMouseListener());
        super.removeNotify();
    }

    protected MouseListener getMouseListener() {
        return this.mMouseListener;
    }

    protected MouseMotionListener getMouseMotionListener() {
        return this.mMouseListener;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!(graphics instanceof Graphics2D)) {
            assert (false);
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        if (this.mSpotlight && this.mDevicePath != null) {
            DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
            ARect viewBounds = this.mView.getViewBounds();
            ARect deviceBounds = this.mDevicePath.getBB();
            SpotLight.spotlight(g, viewBounds, (AGeom)deviceBounds, xform);
        }
        this.mDrawnCursorLoc = null;
        this.drawRoutingCursor(g);
    }

    protected void drawRoutingCursor(Graphics2D g) {
        APoint2D clw = this.mRouteMode.getCursorLoc();
        Point cl = clw == null ? null : this.mView.getCanvas().getXForm().getScreenPt(clw);
        Color oldColor = g.getColor();
        g.setColor(CURSOR_COLOR);
        g.setXORMode(CURSOR_COLOR_XOR);
        if (this.mDrawnCursorLoc != null && !this.mDrawnCursorLoc.equals(cl)) {
            this.drawCursor(g, this.mDrawnCursorLoc);
            this.mDrawnCursorLoc = null;
        }
        if (cl != null && !cl.equals(this.mDrawnCursorLoc)) {
            this.drawCursor(g, cl);
            this.mDrawnCursorLoc = cl;
        }
        g.setColor(oldColor);
        g.setPaintMode();
    }

    protected void drawCursor(Graphics2D g, Point loc) {
        g.drawLine(loc.x - 7, loc.y, loc.x - 1, loc.y);
        g.drawLine(loc.x + 1, loc.y, loc.x + 7, loc.y);
        g.drawLine(loc.x, loc.y - 7, loc.x, loc.y - 1);
        g.drawLine(loc.x, loc.y + 1, loc.x, loc.y + 7);
    }
}

