/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.settings;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AServiceLoader;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitAddIn;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOInitializer;
import com.sigrity.orbit.ui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AddInsPanel
implements SettingsPanel {
    public static final Pattern PATTERN_AI_ENABLED = Pattern.compile("(.*)\\.Enabled");
    public static final Pattern PATTERN_AI_VISIBLE = Pattern.compile("(.*)\\.Visible");
    protected JPanel mPanel = null;
    protected JTable mTblAddIns;
    protected OITableModel mTblAddInsModel;
    protected JTextArea mTxtNote;
    protected HashMap<String, Boolean> mAddInsEnabled = new HashMap();
    protected HashMap<String, Boolean> mAddInsVisible = new HashMap();

    @Override
    public Component getComponent() {
        if (this.mPanel != null) {
            return this.mPanel;
        }
        this.mPanel = new JPanel();
        GridBagManager l = GridBagManager.layout((Container)this.mPanel);
        l.add("Available Add Ins:").setToolTipText("Registered OrbitIOInitializer service implementations");
        l.newline();
        this.mTblAddInsModel = new OITableModel();
        this.mTblAddIns = new JTable(this.mTblAddInsModel){

            @Override
            public boolean isCellEditable(int row, int col) {
                OrbitIOInitializer val = AddInsPanel.this.mTblAddInsModel.getRow(row);
                return AddInsPanel.this.mTblAddInsModel.getColumn(col).getIsEditable(val);
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                int row = this.rowAtPoint(event.getPoint());
                int col = this.columnAtPoint(event.getPoint());
                if (row < 0 || col < 0) {
                    return null;
                }
                OrbitIOInitializer val = AddInsPanel.this.mTblAddInsModel.getRow(row);
                return AddInsPanel.this.mTblAddInsModel.getColumn(col).getTip(val);
            }
        };
        this.mTblAddIns.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AddInsPanel.this.showContextMenu(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        TableCellRenderer hdrRenderer = new JTableHeader().getDefaultRenderer();
        if (hdrRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)hdrRenderer).setHorizontalAlignment(2);
        }
        for (int i = 0; i < this.mTblAddInsModel.getColumnCount(); ++i) {
            TableColumn col = this.mTblAddIns.getColumnModel().getColumn(i);
            col.setHeaderValue(this.mTblAddInsModel.getColumn(i).getName());
            col.setHeaderRenderer(hdrRenderer);
            this.mTblAddInsModel.getColumn(i).initialize(this.mTblAddIns, col);
        }
        l.add((Component)new JScrollPane(this.mTblAddIns), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        this.mTxtNote = (JTextArea)l.add((Component)new JTextArea(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mTxtNote.setOpaque(false);
        this.mTxtNote.setFont(this.mTxtNote.getFont().deriveFont(2));
        this.mTxtNote.setLineWrap(true);
        this.mTxtNote.setWrapStyleWord(true);
        return this.mPanel;
    }

    protected void showContextMenu(Component component, int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new ActionSelectAll());
        menu.add(new ActionDeselectAll());
        OrbitIO.getApp().getWorkspace().beautify(menu);
        menu.show(component, x, y);
    }

    protected boolean isVisible(OrbitIOInitializer oi) {
        return this.mAddInsVisible.getOrDefault(oi.getClass().getName(), true);
    }

    @Override
    public void load() {
        Graphics2D g2d;
        Settings addInPrefs = Settings.getSettings((String)"AddIn");
        for (String settingName : addInPrefs.getSettingNames(null)) {
            Matcher matcherEnabled;
            Matcher matcherVisible = PATTERN_AI_VISIBLE.matcher(settingName);
            if (matcherVisible.matches()) {
                boolean visible = (Boolean)addInPrefs.getSetting(settingName, (Object)true);
                String className = matcherVisible.group(1);
                this.mAddInsVisible.put(className, visible);
            }
            if (!(matcherEnabled = PATTERN_AI_ENABLED.matcher(settingName)).matches()) continue;
            boolean enabled = (Boolean)addInPrefs.getSetting(settingName, (Object)false);
            String className = matcherEnabled.group(1);
            this.mAddInsEnabled.put(className, enabled);
        }
        for (OrbitIOInitializer oi : AServiceLoader.load(OrbitIOInitializer.class)) {
            if (this.isVisible(oi)) {
                this.mTblAddInsModel.addRow(oi);
            } else {
                ALog.flogDebug((String)"Discovered add in '%s' is not visible.", (Object[])new Object[]{oi.getClass().getName()});
            }
            if (this.mAddInsEnabled.containsKey(oi.getClass().getName())) continue;
            this.mAddInsEnabled.put(oi.getClass().getName(), Boolean.FALSE);
        }
        Graphics g = this.getComponent().getGraphics();
        Graphics2D graphics2D = g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (g2d != null) {
            int[] colWidths = new int[this.mTblAddIns.getColumnCount()];
            Arrays.fill(colWidths, 10);
            for (int row = 0; row < this.mTblAddIns.getModel().getRowCount(); ++row) {
                for (int col = 0; col < colWidths.length; ++col) {
                    Object o = this.mTblAddInsModel.getValueAt(row, col);
                    if (!(o instanceof String)) continue;
                    String s = (String)o;
                    int sw = (int)(UIUtil.getTextBounds((Graphics2D)g2d, (String)s).getWidth() + 0.5);
                    colWidths[col] = Math.max(colWidths[col], sw);
                }
            }
            for (int col = 0; col < colWidths.length; ++col) {
                String s = this.mTblAddInsModel.getColumn(col).getName();
                int sw = s == null || s.isEmpty() ? 0 : (int)(UIUtil.getTextBounds((Graphics2D)g2d, (String)s).getWidth() + 0.5);
                colWidths[col] = Math.max(colWidths[col], sw);
                this.mTblAddIns.getColumnModel().getColumn(col).setPreferredWidth(colWidths[col]);
            }
        }
        this.mTxtNote.setText("Checked add ins are enabled, others are disabled. Changes will take effect the next time the application is launched.");
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public boolean save() {
        Settings addInPrefs = Settings.getSettings((String)"AddIn");
        AServiceLoader.load(OrbitIOInitializer.class).forEach(oi -> {
            String addInName = oi.getClass().getName();
            String settingName = String.format(OrbitAddIn.FMT_AI_ENABLED, addInName);
            Boolean enabled = this.mAddInsEnabled.getOrDefault(addInName, false);
            Boolean appVal = (Boolean)addInPrefs.getSettingOfClass(settingName, Settings.Type.App, Boolean.class);
            if (appVal == null) {
                if (AUtil.equals((Object)enabled, (Object)false)) {
                    addInPrefs.removeSetting(settingName, Settings.Type.User);
                } else {
                    addInPrefs.putSetting(settingName, (Object)enabled);
                }
            } else if (appVal.equals(enabled)) {
                addInPrefs.removeSetting(settingName, Settings.Type.User);
            } else {
                addInPrefs.putSetting(settingName, (Object)enabled);
            }
        });
        addInPrefs.save();
        return true;
    }

    protected static class Column {
        protected String name;

        public Column(String name) {
            this.name = name;
        }

        public void initialize(JTable tbl, TableColumn tc) {
        }

        public String getName() {
            return this.name;
        }

        public void setVal(OrbitIOInitializer oi, Object newVal) {
        }

        public Object getVal(OrbitIOInitializer oi) {
            return null;
        }

        public String getTip(OrbitIOInitializer val) {
            return null;
        }

        public boolean getIsEditable(OrbitIOInitializer oi) {
            return false;
        }
    }

    protected class OITableModel
    extends AbstractTableModel {
        final ArrayList<OrbitIOInitializer> rows = new ArrayList();
        final Column[] columns = new Column[]{new Column(""){

            @Override
            public void initialize(JTable tbl, TableColumn tc) {
                TableCellRenderer renderer = tbl.getDefaultRenderer(Boolean.class);
                tc.setCellRenderer(renderer);
                TableCellEditor editor = tbl.getDefaultEditor(Boolean.class);
                tc.setCellEditor(editor);
                Component c = renderer.getTableCellRendererComponent(tbl, true, false, false, 0, 0);
                tc.setPreferredWidth(c.getPreferredSize().width + 2);
                tc.setMaxWidth(c.getPreferredSize().width + 2);
                tc.setMinWidth(c.getPreferredSize().width + 2);
            }

            @Override
            public Boolean getVal(OrbitIOInitializer oi) {
                String name = oi.getClass().getName();
                return AddInsPanel.this.mAddInsEnabled.getOrDefault(name, false);
            }

            @Override
            public void setVal(OrbitIOInitializer oi, Object newVal) {
                if (!(newVal instanceof Boolean)) {
                    return;
                }
                Boolean b = (Boolean)newVal;
                String name = oi.getClass().getName();
                AddInsPanel.this.mAddInsEnabled.put(name, b);
            }

            @Override
            public boolean getIsEditable(OrbitIOInitializer oi) {
                return true;
            }
        }, new Column("Class"){

            @Override
            public String getVal(OrbitIOInitializer oi) {
                return oi.getClass().getSimpleName();
            }

            @Override
            public String getTip(OrbitIOInitializer oi) {
                return oi.getClass().getName();
            }
        }, new Column("Plugin Name"){

            @Override
            public String getVal(OrbitIOInitializer oi) {
                return oi instanceof OrbitApp.Plugin ? ((OrbitApp.Plugin)oi).getName() : "-";
            }
        }, new Column("Version"){

            @Override
            public String getVal(OrbitIOInitializer oi) {
                return oi instanceof OrbitApp.Plugin ? ((OrbitApp.Plugin)oi).getVersion() : "-";
            }
        }, new Column("Provider"){

            @Override
            public String getVal(OrbitIOInitializer oi) {
                return oi instanceof OrbitApp.Plugin ? ((OrbitApp.Plugin)oi).getProvider() : "-";
            }
        }};

        protected OITableModel() {
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.columns[columnIndex].getVal(this.rows.get(rowIndex));
        }

        @Override
        public void setValueAt(Object v, int rowIndex, int columnIndex) {
            this.columns[columnIndex].setVal(this.rows.get(rowIndex), v);
        }

        public void addRow(OrbitIOInitializer oi) {
            this.rows.add(oi);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }

        public OrbitIOInitializer getRow(int idx) {
            return this.rows.get(idx);
        }

        public Column getColumn(int idx) {
            return this.columns[idx];
        }
    }

    protected class ActionDeselectAll
    extends AbstractAction {
        public ActionDeselectAll() {
            super("Deselect All");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddInsPanel.this.mAddInsEnabled.keySet().stream().forEach(key -> AddInsPanel.this.mAddInsEnabled.put((String)key, false));
            AddInsPanel.this.mTblAddIns.repaint();
        }
    }

    protected class ActionSelectAll
    extends AbstractAction {
        public ActionSelectAll() {
            super("Select All");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddInsPanel.this.mAddInsEnabled.keySet().stream().forEach(key -> AddInsPanel.this.mAddInsEnabled.put((String)key, true));
            AddInsPanel.this.mTblAddIns.repaint();
        }
    }

    public static class Factory
    implements SettingsPanel.Factory {
        @Override
        public String getName() {
            return "Add Ins";
        }

        @Override
        public SettingsPanel createPanel() {
            return new AddInsPanel();
        }
    }
}

