/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.settings;

import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.SelectionCriteria;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.ui.ACheckBoxList;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.ASeparator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIOSettings;
import com.sigrity.orbit.UnitDef;
import com.sigrity.orbit.ui.settings.InterfacesPanel;
import com.sigrity.orbit.ui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;

public class DesignPanel
implements SettingsPanel {
    private static ViewModeDesc[] DEFAULT_VIEWMODES = new ViewModeDesc[]{ViewModeDesc.create("InspectMode", "Inspect"), ViewModeDesc.create("RulerMode", "Ruler"), ViewModeDesc.create("NavigateMode", "Navigate"), ViewModeDesc.create("ZoomRegionMode", "Zoom Region"), ViewModeDesc.create("InteractiveSelectMode", "Interactive Select")};
    public static final String DEFAULT_DEFAULT_VIEW_MODE = "InspectMode";
    protected static UnitDef.Distance CustomDistanceUnit = new UnitDef.Distance("<Custom>", "<Custom>", 0L, 0, 0L);
    protected JPanel mPanel;
    protected JComboBox<ViewModeDesc> mCboDefaultViewMode;
    protected DefaultComboBoxModel<SelectionCriteria> mSelectionCriteria = new DefaultComboBoxModel();
    protected JComboBox<SelectionCriteria> mCboSelectionCriteria;
    protected JCheckBox mCbGuessDevice;
    protected JCheckBox mCbAssumeMST;
    protected JCheckBox mCbChangeHierarchyWhenMoving;
    protected JCheckBox mCbRatsOnClosestEndPoints;
    protected JComboBox<PinTemplate.Use> mCboPinUse;
    protected JComboBox<PinTemplate.Direction> mCboPinDir;
    protected JTextField mTxtIgnoreLayerPattern;
    protected JTextArea mTxtDefSelIgnorePinTypes;
    protected PinTemplate.Type[] mDefSelIgnorePinTypes = new PinTemplate.Type[0];
    protected InterfacesPanel mInterfacesPanel;
    protected JComboBox<UnitDef.Distance> mCboDistUnit;
    protected JTextField mTxtDfltUnitDistName;
    protected JTextField mTxtDfltUnitDistDbuCount;
    protected JTextField mTxtDfltUnitDistDecimalPlaces;
    protected JTextField mTxtDfltUnitDistDbuPerMicron;
    protected ActionListener mEditSelIgnorePinTypesAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel<PinTemplate.Type> lmPinTypes = new DefaultListModel<PinTemplate.Type>();
            for (PinTemplate.Type pt : PinTemplate.Type.values()) {
                lmPinTypes.addElement(pt);
            }
            final JDialog dlg = new JDialog(UIUtil.getParentWindow((Component)DesignPanel.this.mPanel), "Default Selection Ignore Pin Types");
            dlg.setModalityType(JDialog.DEFAULT_MODALITY_TYPE);
            GridBagManager l = GridBagManager.layout((JDialog)dlg);
            l.add("Ignore pins of type:");
            l.newline();
            final ACheckBoxList<PinTemplate.Type> lstPinTypes = new ACheckBoxList<PinTemplate.Type>((ListModel<PinTemplate.Type>)lmPinTypes);
            l.add((Component)new JScrollPane(lstPinTypes), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            l.addFillX();
            JButton btnYup = (JButton)l.add((Component)new JButton("OK"));
            JButton btnNope = (JButton)l.add((Component)new JButton("Cancel"));
            for (PinTemplate.Type pt : DesignPanel.this.mDefSelIgnorePinTypes) {
                lstPinTypes.setChecked(lmPinTypes.indexOf(pt), true);
            }
            lstPinTypes.setCellRenderer(new ACheckBoxList.CheckBoxListCellRenderer<PinTemplate.Type>(){

                @Override
                public Boolean isChecked(int idx) {
                    return lstPinTypes.isChecked(idx);
                }

                @Override
                public Component getListCellRendererComponent(JList<? extends PinTemplate.Type> list, PinTemplate.Type value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, false, cellHasFocus);
                    return this;
                }
            });
            btnYup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPanel.this.mDefSelIgnorePinTypes = AUtil.linkedList(lstPinTypes.getCheckedItems()).toArray(new PinTemplate.Type[0]);
                    DesignPanel.this.updateDefSelIgnorePinTypesDisplay();
                    UIUtil.closeWindow((Window)dlg);
                }
            });
            UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnNope, (JButton)btnYup);
            dlg.pack();
            UIUtil.center((Component)dlg);
            dlg.setVisible(true);
        }
    };

    public static UnitDef.Distance getDfltDistSettings(Settings appSettings) {
        String name = (String)appSettings.getSetting("DefaultDistanceUnitName", (Object)Design.getDefaultUnitDistName());
        long internalPer = (Long)appSettings.getSetting("DefaultDistanceUnitDbuCount", (Object)Design.getDefaultUnitDistDbuCount());
        int displayDecimals = (Integer)appSettings.getSetting("DefaultDistanceUnitDecimals", (Object)Design.getDefaultUnitDistDecimalPlaces());
        long internalPerMicron = (Long)appSettings.getSetting("DefaultDistanceUnitDbuPerMicron", (Object)Design.getDefaultUnitDistDbuPerMicron());
        return new UnitDef.Distance(null, name, internalPer, displayDecimals, internalPerMicron);
    }

    @Override
    public Component getComponent() {
        if (this.mPanel != null) {
            return this.mPanel;
        }
        this.mPanel = new JPanel();
        GridBagManager l = GridBagManager.layout((Container)this.mPanel);
        l.push((GridBagConstraints)GridBagManager.FILLX.anchor(11).width(2));
        l.addNl((Component)new ASeparator("Canvas View"), (GridBagConstraints)GridBagManager.FILLALL.width(4));
        l.add("Default View Mode:");
        this.mCboDefaultViewMode = (JComboBox)l.add(new JComboBox<ViewModeDesc>(DEFAULT_VIEWMODES));
        this.mCboDefaultViewMode.setToolTipText("The default mode for newly created design views.");
        final JLabel lblSelCriteria = l.add("Criteria:");
        this.mCboSelectionCriteria = (JComboBox)l.add(new JComboBox<SelectionCriteria>(this.mSelectionCriteria));
        this.mCboDefaultViewMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ism = "InteractiveSelectMode".equals(((ViewModeDesc)((Object)DesignPanel.this.mCboDefaultViewMode.getSelectedItem())).first);
                lblSelCriteria.setVisible(ism);
                DesignPanel.this.mCboSelectionCriteria.setVisible(ism);
            }
        });
        this.mCboSelectionCriteria.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setText("<NONE>");
                    this.setToolTipText("No selection criteria, use standard interactive selection mode");
                } else {
                    SelectionCriteria sc = (SelectionCriteria)value;
                    this.setText(sc.getName());
                    this.setToolTipText(sc.getName());
                }
                return this;
            }
        });
        l.pop();
        l.newline();
        l.push((GridBagConstraints)GridBagManager.FILLX.anchor(11));
        l.addNl((Component)new ASeparator("Algorithm"), (GridBagConstraints)GridBagManager.FILLALL);
        this.mCbGuessDevice = new JCheckBox("Guess best device on click");
        l.add((Component)this.mCbGuessDevice, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCbGuessDevice.setToolTipText("Guess the device to choose when clicking in the design, override with shift-click.");
        l.newline();
        this.mCbChangeHierarchyWhenMoving = new JCheckBox("Change hierarchy when moving device");
        l.add((Component)this.mCbChangeHierarchyWhenMoving, (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0));
        this.mCbChangeHierarchyWhenMoving.setToolTipText("When moving a device on the cursor, it will also move in the heirarchy if enabled; negate during drag by using the shift key.");
        l.newline();
        this.mCbAssumeMST = new JCheckBox("Schedule to the closest pin");
        l.add((Component)this.mCbAssumeMST, (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0));
        this.mCbAssumeMST.setToolTipText("<html>Always schedule to the closest pin, independent of substrate junction or pin type.<br/>Connection engine will use minimum spanning tree with Educlidean distance.</html>");
        l.newline();
        this.mCbRatsOnClosestEndPoints = new JCheckBox("Draw connections on closest endpoints");
        l.add((Component)this.mCbRatsOnClosestEndPoints, (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0));
        this.mCbRatsOnClosestEndPoints.setToolTipText("Draw connections on the closest endpoints if any exist, or draw from pin to pin");
        l.newline();
        l.pop();
        l.push((GridBagConstraints)GridBagManager.FILLX.anchor(11));
        l.addNl((Component)new ASeparator("Other"), (GridBagConstraints)GridBagManager.FILLALL.width(2));
        l.add("Ignore Layer Pattern for .LEFs:");
        l.newline();
        this.mTxtIgnoreLayerPattern = new JTextField(10);
        this.mTxtIgnoreLayerPattern.setToolTipText("Any layer whose name matches this regular expression will be ignored on .lef reads. Useful for make reads faster");
        l.add((Component)this.mTxtIgnoreLayerPattern, (GridBagConstraints)GridBagManager.FILLX.noInsets().insetLeft(12));
        l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        l.newline();
        l.add("Default selection ignore pin types:", (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets().insetLeft(12));
        this.mTxtDefSelIgnorePinTypes = new JTextArea(4, 10);
        this.mTxtDefSelIgnorePinTypes.setEditable(false);
        this.mTxtDefSelIgnorePinTypes.setOpaque(false);
        this.mTxtDefSelIgnorePinTypes.setLineWrap(true);
        this.mTxtDefSelIgnorePinTypes.setWrapStyleWord(true);
        this.mTxtDefSelIgnorePinTypes.setFont(this.mTxtDefSelIgnorePinTypes.getFont().deriveFont(2));
        l.add((Component)new JScrollPane(this.mTxtDefSelIgnorePinTypes), (GridBagConstraints)GridBagManager.FILLX.insetTop(0));
        JButton btnEditSelIgnorePinTypes = (JButton)l.add((Component)new JButton("Edit..."), (GridBagConstraints)GridBagManager.TOPLEFT.insetTop(0));
        Font f = btnEditSelIgnorePinTypes.getFont();
        f = f.deriveFont(f.getSize2D() - 2.0f);
        btnEditSelIgnorePinTypes.setFont(f);
        btnEditSelIgnorePinTypes.setMargin(new Insets(0, 0, 0, 0));
        btnEditSelIgnorePinTypes.addActionListener(this.mEditSelIgnorePinTypesAction);
        l.pop();
        l.pop();
        l.newline();
        this.mInterfacesPanel = (InterfacesPanel)l.add((Component)new InterfacesPanel(), (GridBagConstraints)GridBagManager.FILLALL);
        l.pushFillAllRemainX("New Pin Defaults");
        l.add("Use:", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboPinUse = (JComboBox)l.add(new JComboBox<PinTemplate.Use>(PinTemplate.Use.values()), (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add("Direction:", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboPinDir = (JComboBox)l.add(new JComboBox<PinTemplate.Direction>(PinTemplate.Direction.values()), (GridBagConstraints)GridBagManager.FILLX);
        l.addFillX();
        l.pop();
        l.newline();
        l.push("New Design Defaults", (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        l.add("Distance unit:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetTop(0));
        this.mCboDistUnit = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCboDistUnit.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean selected, boolean hasFocus) {
                super.getListCellRendererComponent(list, val, idx, selected, hasFocus);
                if (val instanceof UnitDef.Distance) {
                    this.setText(((UnitDef.Distance)val).getDesc());
                }
                return this;
            }
        });
        this.mCboDistUnit.addItem(CustomDistanceUnit);
        for (UnitDef.Distance unitDef : UnitDef.getRegistry().get(UnitDef.Distance.class)) {
            this.mCboDistUnit.addItem(unitDef);
        }
        this.mCboDistUnit.setToolTipText("Select a predfined distance unit or select '" + CustomDistanceUnit.getDesc() + "' to enter other values");
        l.pop();
        l.newline();
        l.indent();
        l.add("Unit name:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetTop(0));
        this.mTxtDfltUnitDistName = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetTop(0));
        this.mTxtDfltUnitDistName.setToolTipText("The name of the distance unit for new designs (for example, 'micron')");
        l.newline();
        l.indent();
        l.add("Internal per unit:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetTop(0));
        this.mTxtDfltUnitDistDbuCount = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetTop(0));
        this.mTxtDfltUnitDistDbuCount.setToolTipText("The number of internal units per design distance unit (for example, 1000)");
        l.newline();
        l.indent();
        l.add("Internal per micron:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetTop(0));
        this.mTxtDfltUnitDistDbuPerMicron = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetTop(0));
        this.mTxtDfltUnitDistDbuPerMicron.setToolTipText("The number of internal units per micron");
        l.newline();
        l.indent();
        l.add("Display decimal places:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetTop(0));
        this.mTxtDfltUnitDistDecimalPlaces = (JTextField)l.add((Component)new JTextField(5), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetTop(0));
        this.mTxtDfltUnitDistDecimalPlaces.setToolTipText("The default number of decimal places to use when displaying design distance units");
        this.mCboDistUnit.addItemListener(new ItemListener(){
            boolean processing = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent e) {
                if (this.processing) {
                    return;
                }
                this.processing = true;
                try {
                    boolean custom;
                    UnitDef.Distance sel = (UnitDef.Distance)DesignPanel.this.mCboDistUnit.getModel().getElementAt(DesignPanel.this.mCboDistUnit.getSelectedIndex());
                    JTextField[] fields = new JTextField[]{DesignPanel.this.mTxtDfltUnitDistName, DesignPanel.this.mTxtDfltUnitDistDbuCount, DesignPanel.this.mTxtDfltUnitDistDecimalPlaces, DesignPanel.this.mTxtDfltUnitDistDbuPerMicron};
                    boolean bl = custom = sel == CustomDistanceUnit;
                    if (!custom) {
                        DesignPanel.this.setDistUnitEditFields(sel);
                    }
                    for (JTextField f : fields) {
                        f.setEnabled(custom);
                    }
                }
                finally {
                    this.processing = false;
                }
            }
        });
        l.addFillX();
        l.pop();
        return this.mPanel;
    }

    @Override
    public void load() {
        Settings appSettings = Settings.getSettings((String)"App");
        UnitDef.Distance distUnitSettings = DesignPanel.getDfltDistSettings(appSettings);
        this.setDistUnitEditFields(distUnitSettings);
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        this.mCbGuessDevice.setSelected((Boolean)userPrefs.getSetting("DevicePickGuessBestDevice", (Object)false));
        this.mCbAssumeMST.setSelected((Boolean)userPrefs.getSetting("AssumeMSPTopology", (Object)false));
        this.mCbRatsOnClosestEndPoints.setSelected((Boolean)userPrefs.getSetting("DrawRatsOnEndPoints", (Object)true));
        this.mCbChangeHierarchyWhenMoving.setSelected((Boolean)userPrefs.getSetting("ChangeHeirarchyDuringMove", (Object)false));
        String defViewModeKey = (String)userPrefs.getSetting("DefaultViewMode", (Object)DEFAULT_DEFAULT_VIEW_MODE);
        for (ViewModeDesc vmd : DEFAULT_VIEWMODES) {
            if (!((String)vmd.first).equals(defViewModeKey)) continue;
            this.mCboDefaultViewMode.setSelectedItem((Object)vmd);
            break;
        }
        String selCriteriaId = (String)userPrefs.getSetting("DefaultViewModeSelCriteria", (Object)"");
        this.mSelectionCriteria.removeAllElements();
        this.mSelectionCriteria.addElement(null);
        for (SelectionCriteria sc : SelectionCriteria.getSavedCriteria()) {
            this.mSelectionCriteria.addElement(sc);
            if (!sc.getId().toString().equals(selCriteriaId)) continue;
            this.mCboSelectionCriteria.setSelectedItem(sc);
        }
        String ignoreLayerLefPattern = (String)userPrefs.getSetting("LefIgnoreLayerPattern", (Object)"VIA.*");
        this.mTxtIgnoreLayerPattern.setText(ignoreLayerLefPattern);
        this.mDefSelIgnorePinTypes = (PinTemplate.Type[])userPrefs.getSetting("DefaultSelectIgnorePinTypes", (Object)OrbitIOSettings.DEFAULT_SELECT_IGNORE_PIN_TYPES_DEFAULT);
        this.updateDefSelIgnorePinTypesDisplay();
        this.mCboPinUse.setSelectedItem(Settings.get((String)PinTemplate.SettingSection, (String)"DefaultUse", (Object)PinTemplate.DfltUse));
        this.mCboPinDir.setSelectedItem(Settings.get((String)PinTemplate.SettingSection, (String)"DefaultDirection", (Object)PinTemplate.DfltDir));
        this.mInterfacesPanel.load();
    }

    @Override
    public boolean validateInput() {
        try {
            if (!this.mTxtIgnoreLayerPattern.getText().isEmpty()) {
                AFieldValidator.validateRegex((JTextComponent)this.mTxtIgnoreLayerPattern);
            }
            AFieldValidator.validateText((JTextComponent)this.mTxtDfltUnitDistName);
            AFieldValidator.validateLong((JTextField)this.mTxtDfltUnitDistDbuCount, (long)1L, (long)Integer.MAX_VALUE);
            AFieldValidator.validateInt((JTextField)this.mTxtDfltUnitDistDecimalPlaces, (int)0, (int)Integer.MAX_VALUE);
            AFieldValidator.validateLong((JTextField)this.mTxtDfltUnitDistDbuPerMicron, (long)1L, (long)Integer.MAX_VALUE);
        }
        catch (AFieldValidator.AFieldValidationException e) {
            return false;
        }
        return this.mInterfacesPanel.validateInput();
    }

    @Override
    public boolean save() {
        Settings appSettings = Settings.getSettings((String)"App");
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        appSettings.putSetting("DefaultDistanceUnitName", (Object)this.mTxtDfltUnitDistName.getText());
        appSettings.putSetting("DefaultDistanceUnitDbuCount", (Object)AFieldValidator.getLong((JTextField)this.mTxtDfltUnitDistDbuCount, (long)Design.getDefaultUnitDistDbuCount()));
        appSettings.putSetting("DefaultDistanceUnitDecimals", (Object)AFieldValidator.getInt((JTextField)this.mTxtDfltUnitDistDecimalPlaces, (int)Design.getDefaultUnitDistDecimalPlaces()));
        appSettings.putSetting("DefaultDistanceUnitDbuPerMicron", (Object)AFieldValidator.getLong((JTextField)this.mTxtDfltUnitDistDbuPerMicron, (long)Design.getDefaultUnitDistDbuPerMicron()));
        userPrefs.putSetting("DevicePickGuessBestDevice", (Object)this.mCbGuessDevice.isSelected());
        userPrefs.putSetting("DefaultViewMode", (Object)((String)((ViewModeDesc)((Object)this.mCboDefaultViewMode.getSelectedItem())).first));
        SelectionCriteria selCriteria = (SelectionCriteria)this.mCboSelectionCriteria.getSelectedItem();
        userPrefs.putSetting("DefaultViewModeSelCriteria", (Object)(selCriteria == null ? "" : selCriteria.getId().toString()));
        userPrefs.putSetting("AssumeMSPTopology", (Object)this.mCbAssumeMST.isSelected());
        userPrefs.putSetting("DrawRatsOnEndPoints", (Object)this.mCbRatsOnClosestEndPoints.isSelected());
        userPrefs.putSetting("ChangeHeirarchyDuringMove", (Object)this.mCbChangeHierarchyWhenMoving.isSelected());
        userPrefs.putSetting("LefIgnoreLayerPattern", (Object)this.mTxtIgnoreLayerPattern.getText());
        userPrefs.putSetting("DefaultSelectIgnorePinTypes", (Object)this.mDefSelIgnorePinTypes);
        appSettings.save();
        userPrefs.save();
        Settings pinSettings = Settings.getSettings((String)PinTemplate.SettingSection);
        pinSettings.putSetting("DefaultUse", this.mCboPinUse.getSelectedItem());
        pinSettings.putSetting("DefaultDirection", this.mCboPinDir.getSelectedItem());
        pinSettings.save();
        PinTemplate.updatePreferenceSettings();
        return this.mInterfacesPanel.save();
    }

    protected void updateDefSelIgnorePinTypesDisplay() {
        Object pinTypes = "";
        for (PinTemplate.Type pt : this.mDefSelIgnorePinTypes) {
            if (!((String)pinTypes).isEmpty()) {
                pinTypes = (String)pinTypes + ", ";
            }
            pinTypes = (String)pinTypes + pt.getUserName();
        }
        this.mTxtDefSelIgnorePinTypes.setText((String)pinTypes);
    }

    protected void setDistUnitEditFields(UnitDef distUnitSettings) {
        this.mTxtDfltUnitDistName.setText(distUnitSettings.getName());
        this.mTxtDfltUnitDistDbuCount.setText(Long.toString(distUnitSettings.getInternalPer()));
        this.mTxtDfltUnitDistDecimalPlaces.setText(Integer.toString(distUnitSettings.getDisplayDecimalPlaces()));
        this.mTxtDfltUnitDistDbuPerMicron.setText(Long.toString(distUnitSettings.getInternalPerKnown()));
        UnitDef distUnitRegistered = UnitDef.getRegistry().lookup(distUnitSettings);
        if (distUnitRegistered != null) {
            this.mCboDistUnit.setSelectedItem(distUnitRegistered);
        } else {
            this.mCboDistUnit.setSelectedIndex(0);
        }
    }

    protected UnitDef.Distance getDistUnitEditFields() {
        String name = this.mTxtDfltUnitDistName.getText();
        long internalPer = AFieldValidator.getLong((JTextField)this.mTxtDfltUnitDistDbuCount, (long)Design.getDefaultUnitDistDbuCount());
        int displayDecimals = AFieldValidator.getInt((JTextField)this.mTxtDfltUnitDistDecimalPlaces, (int)Design.getDefaultUnitDistDecimalPlaces());
        long internalPerMicron = AFieldValidator.getLong((JTextField)this.mTxtDfltUnitDistDbuPerMicron, (long)Design.getDefaultUnitDistDbuPerMicron());
        return new UnitDef.Distance(null, name, internalPer, displayDecimals, internalPerMicron);
    }

    public static class ViewModeDesc
    extends APair<String, String> {
        public static ViewModeDesc create(String key, String name) {
            return new ViewModeDesc(key, name);
        }

        public ViewModeDesc(String key, String name) {
            super((Object)key, (Object)name);
        }

        public String toString() {
            return (String)this.second;
        }
    }

    public static class Factory
    implements SettingsPanel.Factory {
        @Override
        public String getName() {
            return "Design";
        }

        @Override
        public SettingsPanel createPanel() {
            return new DesignPanel();
        }
    }
}

