/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.settings;

import com.sigrity.acl.AColor;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.AFont;
import com.sigrity.acl.ui.AFontChooser;
import com.sigrity.acl.ui.AHorizDivider;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIOSettings;
import com.sigrity.orbit.ui.settings.SettingsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DisplayPanel
implements SettingsPanel {
    protected JPanel mPanel = null;
    protected NetDisplayOptionPanel mNetDisplayOptionPanel = null;
    protected ObjectSizeFilterPanel mObjectSizeFilterPanel = null;

    @Override
    public Component getComponent() {
        if (this.mPanel != null) {
            return this.mPanel;
        }
        this.mPanel = new JPanel();
        GridBagManager l = GridBagManager.layout((Container)this.mPanel);
        l.pushFillX("Net Display Options");
        this.mNetDisplayOptionPanel = new NetDisplayOptionPanel();
        l.add((Component)this.mNetDisplayOptionPanel, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.addFillX();
        l.popNl();
        this.mObjectSizeFilterPanel = new ObjectSizeFilterPanel();
        l.add((Component)this.mObjectSizeFilterPanel, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.addFillAll();
        this.mPanel.setMinimumSize(this.mPanel.getPreferredSize());
        return this.mPanel;
    }

    @Override
    public void load() {
        this.loadNetDisplaySettings();
        this.loadObjectSizeFilterSetting();
    }

    private void loadNetDisplaySettings() {
        Color color2;
        Font font;
        Settings s = Settings.getSettings((String)"NetDisplay");
        this.mNetDisplayOptionPanel.getTextAndAppearNetUnused().mCboTextOpt.setSelectedItem(s.getSetting("NetUnusedTextOpt", (Object)OrbitIOSettings.NetDisplayTextOpt.StaticText));
        this.mNetDisplayOptionPanel.getTextAndAppearNetUnused().mTxtStaticText.setText((String)s.getSetting("NetUnusedText", (Object)"NetUnused"));
        String f = (String)s.getSetting("NetUnusedFont", (Object)"");
        if (f != null && !f.isEmpty() && (font = Font.decode(f)) != null) {
            this.mNetDisplayOptionPanel.getTextAndAppearNetUnused().mLblSampleNameText.setFont(font);
        }
        try {
            color2 = AColor.decode((String)((String)Settings.get((String)"NetDisplay", (String)"NetUnusedColor", (Object)"")), (Color)OrbitIOSettings.ND_NETUNUSED_COLOR_DFLT);
            this.mNetDisplayOptionPanel.getTextAndAppearNetUnused().mLblSampleNameText.setForeground(color2);
        }
        catch (Exception color2) {
            // empty catch block
        }
        this.mNetDisplayOptionPanel.getTextAndAppearUnconnected().mCboTextOpt.setSelectedItem(s.getSetting("NetUnconnectedTextOpt", (Object)OrbitIOSettings.NetDisplayTextOpt.StaticText));
        this.mNetDisplayOptionPanel.getTextAndAppearUnconnected().mTxtStaticText.setText((String)s.getSetting("NetUnconnectedText", (Object)"- NC -"));
        f = (String)s.getSetting("NetUnconnectedFont", (Object)"");
        if (f != null && !f.isEmpty() && (font = Font.decode(f)) != null) {
            this.mNetDisplayOptionPanel.getTextAndAppearUnconnected().mLblSampleNameText.setFont(font);
        }
        try {
            color2 = AColor.decode((String)((String)Settings.get((String)"NetDisplay", (String)"NetUnconnectedColor", (Object)"")), (Color)OrbitIOSettings.ND_UNCONNECTED_COLOR_DFLT);
            this.mNetDisplayOptionPanel.getTextAndAppearUnconnected().mLblSampleNameText.setForeground(color2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadObjectSizeFilterSetting() {
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        int minDrawSize = (Integer)userPrefs.getSetting("MinDrawSize", (Object)3);
        this.mObjectSizeFilterPanel.setMinDrawSize(minDrawSize);
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public boolean save() {
        boolean result = true;
        result = result && this.saveNetDisplaySettings() && this.saveObjectSizeFilterSetting();
        return result;
    }

    private boolean saveNetDisplaySettings() {
        Settings s = Settings.getSettings((String)"NetDisplay");
        s.putSetting("NetUnusedTextOpt", this.mNetDisplayOptionPanel.getTextAndAppearNetUnused().mCboTextOpt.getSelectedItem());
        s.putSetting("NetUnusedText", (Object)this.mNetDisplayOptionPanel.getTextAndAppearNetUnused().mTxtStaticText.getText());
        Font font = this.mNetDisplayOptionPanel.getTextAndAppearNetUnused().mLblSampleNameText.getFont();
        s.putSetting("NetUnusedFont", (Object)AFont.encodeNameStyle((Font)font));
        Color c = this.mNetDisplayOptionPanel.getTextAndAppearNetUnused().mLblSampleNameText.getForeground();
        s.putSetting("NetUnusedColor", (Object)AColor.formatColor((Color)c));
        s.putSetting("NetUnconnectedTextOpt", this.mNetDisplayOptionPanel.getTextAndAppearUnconnected().mCboTextOpt.getSelectedItem());
        s.putSetting("NetUnconnectedText", (Object)this.mNetDisplayOptionPanel.getTextAndAppearUnconnected().mTxtStaticText.getText());
        font = this.mNetDisplayOptionPanel.getTextAndAppearUnconnected().mLblSampleNameText.getFont();
        s.putSetting("NetUnconnectedFont", (Object)AFont.encodeNameStyle((Font)font));
        c = this.mNetDisplayOptionPanel.getTextAndAppearUnconnected().mLblSampleNameText.getForeground();
        s.putSetting("NetUnconnectedColor", (Object)AColor.formatColor((Color)c));
        s.save();
        return true;
    }

    private boolean saveObjectSizeFilterSetting() {
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        int minDrawSize = this.mObjectSizeFilterPanel.getMinDrawSize();
        userPrefs.putSetting("MinDrawSize", (Object)minDrawSize);
        return true;
    }

    protected static class ObjectSizeFilterPanel
    extends JPanel {
        protected JSlider mSlideMinDrawSize;
        protected JLabel mMLblMinDrawSizeVal;

        public ObjectSizeFilterPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Object Size Filter"));
            this.setToolTipText("<html>Objects below the specified size will not be displayed in the 2D design canvas.<br>Can be overridden for a design in view settings.");
            GridBagManager l = new GridBagManager((Container)this);
            this.mSlideMinDrawSize = new JSlider(0, 100);
            this.mSlideMinDrawSize.setMajorTickSpacing(10);
            this.mSlideMinDrawSize.setMinorTickSpacing(1);
            this.mSlideMinDrawSize.setPaintTicks(true);
            this.mSlideMinDrawSize.setToolTipText(this.getToolTipText());
            l.add((Component)this.mSlideMinDrawSize, (GridBagConstraints)GridBagManager.FILLX);
            this.mMLblMinDrawSizeVal = l.add("");
            this.mSlideMinDrawSize.addChangeListener(e -> this.mMLblMinDrawSizeVal.setText(String.format("%dpx", this.mSlideMinDrawSize.getValue())));
            this.setMinimumSize(this.getPreferredSize());
        }

        public int getMinDrawSize() {
            return this.mSlideMinDrawSize.getValue();
        }

        public void setMinDrawSize(int size) {
            this.mSlideMinDrawSize.setValue(size);
        }
    }

    protected static class NetDisplayOptionPanel
    extends JPanel {
        protected TextAndAppearancePanel mTextAndAppearUnconnected;
        protected TextAndAppearancePanel mTextAndAppearNetUnused;

        public NetDisplayOptionPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new AHorizDivider("NetUnused"), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            this.mTextAndAppearNetUnused = (TextAndAppearancePanel)l.add((Component)new TextAndAppearancePanel("NetUnused", false), (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add((Component)new AHorizDivider("Unconnected"), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            this.mTextAndAppearUnconnected = (TextAndAppearancePanel)l.add((Component)new TextAndAppearancePanel("- NC -", true), (GridBagConstraints)GridBagManager.FILLX);
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public TextAndAppearancePanel getTextAndAppearUnconnected() {
            return this.mTextAndAppearUnconnected;
        }

        public TextAndAppearancePanel getTextAndAppearNetUnused() {
            return this.mTextAndAppearNetUnused;
        }
    }

    protected static class TextAndAppearancePanel
    extends JPanel {
        protected String mSampleText = "SampleNameText";
        protected JComboBox<OrbitIOSettings.NetDisplayTextOpt> mCboTextOpt;
        protected JTextField mTxtStaticText;
        protected JLabel mLblSampleNameText;
        protected ActionListener mChangeAppearanceListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = mLblSampleNameText.getFont();
                AFontChooser.Dialog fc = new AFontChooser.Dialog(this, Optional.of(font)){

                    public void addNotify() {
                        this.mLblSize.setVisible(false);
                        this.mPnlSize.setVisible(false);
                        super.addNotify();
                    }
                };
                fc.setShowColor(Optional.of(mLblSampleNameText.getForeground()));
                fc.setVisible(true);
                if (fc.getOk()) {
                    mLblSampleNameText.setFont(fc.getSelectedFont());
                    mLblSampleNameText.setForeground(fc.getSelectedColor().orElse(Color.BLACK));
                    this.updateSampleText();
                }
            }
        };

        public TextAndAppearancePanel(String dfltStaticText, boolean allowTopMostOpt) {
            GridBagManager l = GridBagManager.layout((Container)this);
            l.add("Text to display:");
            this.mCboTextOpt = (JComboBox)l.add(new JComboBox<OrbitIOSettings.NetDisplayTextOpt>(OrbitIOSettings.NetDisplayTextOpt.values()));
            if (!allowTopMostOpt) {
                this.mCboTextOpt.removeItem(OrbitIOSettings.NetDisplayTextOpt.TopmostNetName);
            }
            l.newline();
            l.indent();
            final JPanel pnlAppearance = l.pushFillXRemainX();
            final JLabel lblStaticText = l.add("Static text:");
            this.mTxtStaticText = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.FILLX);
            this.mTxtStaticText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateSampleText();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateSampleText();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateSampleText();
                }
            });
            l.newline();
            l.add("Appearance: ");
            this.mLblSampleNameText = l.add(this.mSampleText);
            this.mLblSampleNameText.setVerticalTextPosition(0);
            this.mLblSampleNameText.setBackground(Color.BLACK);
            this.mLblSampleNameText.setOpaque(true);
            this.mLblSampleNameText.setBorder(BorderFactory.createLineBorder(this.mLblSampleNameText.getBackground(), 3));
            JButton btnChangeAppearance = (JButton)l.add((Component)UIUtil.makeSmallButton((JButton)new JButton("Change...")));
            btnChangeAppearance.addActionListener(this.mChangeAppearanceListener);
            l.addFillX();
            l.pop();
            this.mCboTextOpt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean useStatic = mCboTextOpt.getSelectedItem() == OrbitIOSettings.NetDisplayTextOpt.StaticText;
                    lblStaticText.setEnabled(useStatic);
                    mTxtStaticText.setEditable(useStatic);
                    boolean hide = mCboTextOpt.getSelectedItem() == OrbitIOSettings.NetDisplayTextOpt.Hide;
                    UIUtil.setEnabled((Container)pnlAppearance, (!hide ? 1 : 0) != 0);
                    this.updateSampleText();
                }
            });
            this.mCboTextOpt.setSelectedIndex(0);
        }

        protected void updateSampleText() {
            if (this.mCboTextOpt.getSelectedItem() == OrbitIOSettings.NetDisplayTextOpt.StaticText && !this.mTxtStaticText.getText().isEmpty()) {
                this.mLblSampleNameText.setText(this.mTxtStaticText.getText());
            } else {
                this.mLblSampleNameText.setText(this.mSampleText);
            }
        }
    }

    public static class Factory
    implements SettingsPanel.Factory {
        @Override
        public String getName() {
            return "Display";
        }

        @Override
        public DisplayPanel createPanel() {
            return new DisplayPanel();
        }
    }
}

