/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.settings;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AclInfo;
import com.sigrity.acl.app.AAppEnv;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOEnv;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javax.swing.Icon;

public class EnvEditorDialog
extends AJFXDialog {
    public static void main(String[] args) {
        EnvEditorDialog.showMe(null);
    }

    public static EnvEditorDialog showMe(Window owner) {
        EnvEditorDialog dialog = new EnvEditorDialog(owner);
        dialog.setVisible(true);
        dialog.setResizable(false);
        return dialog;
    }

    public EnvEditorDialog(Window owner) {
        super(owner, "Env Editor");
        this.init();
        this.setModal(true);
    }

    protected AJFXPanel createJfxPanel() {
        return new EnvEditorPanel();
    }

    private class EnvEditorPanel
    extends AJFXPanel {
        protected TreeView<String> mEnvTree;
        protected VBox mWorkspace;
        protected Map<AAppEnv.Env, Object> mChange = new HashMap<AAppEnv.Env, Object>();
        EventHandler<ActionEvent> mOkHandler = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                EnvEditorPanel.this.saveEnvChange(OrbitIO.getApp(), EnvEditorPanel.this.mChange);
                UIUtil.closeWindow((Window)((Object)EnvEditorDialog.this));
            }
        };

        public EnvEditorPanel() {
            this.setPreferredSize(new Dimension(800, 600));
        }

        protected Parent initSceneGraph() {
            VBox root = new VBox(5.0);
            SplitPane splitPane = new SplitPane();
            this.mEnvTree = new TreeView((TreeItem)new EnvTreeRoot());
            this.mEnvTree.setEditable(false);
            this.mEnvTree.setShowRoot(false);
            this.mEnvTree.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<String>>(){

                public void changed(ObservableValue<? extends TreeItem<String>> observable, TreeItem<String> oldValue, TreeItem<String> newValue) {
                    if (newValue instanceof EnvCatNode) {
                        EnvCatNode catNode = (EnvCatNode)newValue;
                        EnvEditorPanel.this.loadWorkspace(catNode.getCategory());
                    }
                }
            });
            this.mWorkspace = new VBox(5.0);
            splitPane.setPrefSize(800.0, 600.0);
            splitPane.getItems().addAll((Object[])new Node[]{this.mEnvTree, this.mWorkspace});
            splitPane.setDividerPositions(new double[]{0.2});
            root.getChildren().addAll((Object[])new Node[]{splitPane});
            AJFXButton configButton = new AJFXButton(OrbitIcons.COG, "Open Containing Folder (file 'env')");
            configButton.setBorder(null);
            configButton.setAlignment(Pos.BOTTOM_LEFT);
            configButton.setOnAction(e -> {
                try {
                    Desktop.getDesktop().open(OrbitIO.getUserEnvFile().getParentFile());
                }
                catch (IOException err) {
                    ALog.logError((Throwable)err, (String)"Cannot open env directory.", (Object[])new Object[0]);
                }
            });
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)EnvEditorDialog.this), this.mOkHandler);
            HBox bottomHBox = new HBox(5.0);
            HBox center = new HBox(5.0);
            bottomHBox.getChildren().addAll((Object[])new Node[]{configButton, center, okCancelHBox});
            HBox.setHgrow((Node)center, (Priority)Priority.ALWAYS);
            root.getChildren().add((Object)bottomHBox);
            this.loadWorkspace(AAppEnv.CATEGORY.UI);
            return root;
        }

        public void saveEnvChange(OrbitApp app, Map<AAppEnv.Env, Object> change) {
            File envFile = OrbitApp.getUserEnvFile();
            if (!envFile.exists()) {
                OrbitApp.createDefaultEnv();
                return;
            }
            OrbitIOEnv.saveChange((File)envFile, change);
            OrbitApp.setupEnv((OrbitApp)app);
        }

        private void loadWorkspace(AAppEnv.CATEGORY cat) {
            if (cat == null) {
                return;
            }
            this.mWorkspace.getChildren().clear();
            List vars = (List)OrbitIOEnv.getScheme().get(cat);
            vars = vars.stream().filter(var -> AclInfo.getDebugMode() || !var.getDebug()).collect(Collectors.toList());
            TableView table = new TableView();
            TableColumn namCol = new TableColumn("Name");
            TableColumn valCol = new TableColumn("Value");
            TableColumn effCol = new TableColumn("Effective");
            namCol.setPrefWidth(30.0);
            namCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(((AAppEnv.Env)param.getValue()).getName()));
            namCol.setCellFactory(column -> this.getVarCellFactory());
            table.getColumns().add((Object)namCol);
            valCol.setPrefWidth(20.0);
            valCol.setCellValueFactory(param -> new SimpleObjectProperty((Object)((AAppEnv.Env)param.getValue())));
            valCol.setCellFactory(column -> this.getValCellFactory());
            valCol.setEditable(true);
            table.getColumns().add((Object)valCol);
            effCol.setPrefWidth(10.0);
            effCol.setCellValueFactory(param -> new SimpleObjectProperty((Object)((AAppEnv.Env)param.getValue()).getEffective()));
            effCol.setCellFactory(column -> this.getEffectiveCellFactory());
            table.getColumns().add((Object)effCol);
            table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
            table.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            table.getSelectionModel().setCellSelectionEnabled(true);
            final Text descText = new Text();
            VBox textBox = new VBox(5.0);
            TitledPane infoPane = new TitledPane("Detail", (Node)textBox);
            textBox.getChildren().add((Object)descText);
            infoPane.setCollapsible(false);
            descText.setTextAlignment(TextAlignment.LEFT);
            table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<AAppEnv.Env>(){

                public void changed(ObservableValue<? extends AAppEnv.Env> ov, AAppEnv.Env oldEnv, AAppEnv.Env newEnv) {
                    if (newEnv != null) {
                        descText.setText(newEnv.getDesc());
                    }
                }
            });
            ObservableList infos = FXCollections.observableArrayList(vars);
            table.setItems(infos);
            table.setEditable(true);
            this.mWorkspace.getChildren().addAll((Object[])new Node[]{table, infoPane});
            HBox.setHgrow((Node)table, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)table, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)infoPane, (Priority)Priority.ALWAYS);
        }

        private TableCell<AAppEnv.Env, String> getVarCellFactory() {
            return new TableCell<AAppEnv.Env, String>(){

                protected void updateItem(String name, boolean empty) {
                    super.updateItem((Object)name, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(name);
                    }
                    this.setAlignment(Pos.BOTTOM_RIGHT);
                    this.setFont(new Font("Monospaced", 14.0));
                    this.setPadding(new Insets(0.0, 10.0, 0.0, 5.0));
                }
            };
        }

        private TableCell<AAppEnv.Env, AAppEnv.Env> getValCellFactory() {
            return new ValCell();
        }

        private TableCell<AAppEnv.Env, AAppEnv.EFFECTIVE> getEffectiveCellFactory() {
            return new TableCell<AAppEnv.Env, AAppEnv.EFFECTIVE>(){

                protected void updateItem(AAppEnv.EFFECTIVE eff, boolean empty) {
                    super.updateItem((Object)eff, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(eff.getDesc());
                    }
                    this.setFont(new Font("Monospaced", 14.0));
                    this.setAlignment(Pos.CENTER);
                }
            };
        }

        public class EnvCatNode
        extends TreeItem<String> {
            protected AAppEnv.CATEGORY mCat;

            EnvCatNode(AAppEnv.CATEGORY cat) {
                super((Object)cat.getDesc(), (Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)14, (int)14))));
                this.mCat = cat;
                this.setExpanded(false);
            }

            public AAppEnv.CATEGORY getCategory() {
                return this.mCat;
            }
        }

        public class EnvTreeRoot
        extends TreeItem<String> {
            EnvTreeRoot() {
                super((Object)"", (Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)14, (int)14))));
                for (AAppEnv.CATEGORY cat : OrbitIOEnv.getScheme().keySet()) {
                    this.getChildren().add((Object)new EnvCatNode(cat));
                }
                this.setExpanded(false);
            }
        }

        private class ValCell
        extends TableCell<AAppEnv.Env, AAppEnv.Env> {
            CheckBox checkbox = new CheckBox();
            TextField textfield = new TextField();
            ComboBox<String> combobox = new ComboBox();
            AAppEnv.Env env;

            public ValCell() {
                this.checkbox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        EnvEditorPanel.this.mChange.put(ValCell.this.env, newValue);
                    }
                });
                this.textfield.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                        EnvEditorPanel.this.mChange.put(ValCell.this.env, newValue);
                    }
                });
                this.combobox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                        EnvEditorPanel.this.mChange.put(ValCell.this.env, newValue);
                    }
                });
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setEditable(true);
            }

            protected void updateItem(AAppEnv.Env e, boolean empty) {
                this.env = e;
                super.updateItem((Object)e, empty);
                if (e == null) {
                    this.setText(null);
                } else if (e.getType() == AAppEnv.TYPE.BOOLEAN) {
                    this.checkbox.setSelected(OrbitIO.getApp().hasEnv(e));
                    this.setAlignment(Pos.CENTER);
                    this.setGraphic((Node)this.checkbox);
                } else if (e.getType() == AAppEnv.TYPE.STRING) {
                    this.textfield.setText("");
                    if (OrbitIO.getApp().hasEnv(e)) {
                        this.textfield.setText(OrbitIO.getApp().getEnv(e));
                    }
                    this.setGraphic((Node)this.textfield);
                } else if (e.getType() == AAppEnv.TYPE.OPTION) {
                    this.combobox.getItems().add(null);
                    this.combobox.getItems().addAll((Object[])e.getOptions());
                    if (OrbitIO.getApp().hasEnv(e)) {
                        this.combobox.getSelectionModel().select((Object)OrbitIO.getApp().getEnv(e));
                    }
                    this.setGraphic((Node)this.combobox);
                    this.combobox.setMaxWidth(Double.MAX_VALUE);
                }
            }

            public void startEdit() {
                super.startEdit();
                if (this.isEmpty()) {
                    return;
                }
                this.checkbox.setDisable(false);
                this.checkbox.requestFocus();
            }

            public void cancelEdit() {
                super.cancelEdit();
                this.checkbox.setDisable(true);
            }

            public void commitEdit(AAppEnv.Env value) {
                super.commitEdit((Object)value);
                this.checkbox.setDisable(true);
            }
        }
    }
}

