/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.settings;

import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.ADropDownAction;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.ALinkLabel;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.ui.settings.JvmArgumentsPanel;
import com.sigrity.orbit.ui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class GeneralPanel
implements SettingsPanel {
    protected JPanel mPanel = null;
    protected JCheckBox mCbSessionLogs;
    protected JCheckBox mCbConfirmExit;
    protected AFileChooserControl mFcConfDir;
    protected AFileChooserControl mFcEditCsv;
    protected AFileChooserControl mFcEditXml;
    protected AFileChooserControl mFcWebBrowser;
    protected SettingsPanel mJvmArgsPnl;
    protected LinkedList<String> mRecentConfs = (LinkedList)Settings.get((String)"App", (String)"AppConfigDirRecent", new LinkedList());

    private JButton createRecentButton(JButton refButton) {
        JPopupMenu recentConfMenu = new JPopupMenu();
        String defaultVal = new File(AApp.getInstallDir(), "conf").getPath();
        if (this.mRecentConfs.indexOf(defaultVal) >= 0) {
            this.mRecentConfs.remove(defaultVal);
        }
        this.mRecentConfs.addFirst(defaultVal);
        for (String filePath : this.mRecentConfs) {
            recentConfMenu.add(new ChooseConfigDirAction(filePath));
        }
        return ADropDownAction.makeButton((JPopupMenu)recentConfMenu, (AbstractButton)refButton);
    }

    @Override
    public Component getComponent() {
        if (this.mPanel != null) {
            return this.mPanel;
        }
        this.mPanel = new JPanel();
        GridBagManager l = GridBagManager.layout((Container)this.mPanel);
        l.pushFillX("Configuration File");
        this.mFcConfDir = new AFileChooserControl();
        this.mFcConfDir.setChoosableFileFilter(AFileFilter.DIRECTORY);
        this.mFcConfDir.setFileSelectionMode(1);
        l.add("Application Conf Directory:").setLabelFor((Component)this.mFcConfDir);
        l.add((Component)this.mFcConfDir, (GridBagConstraints)GridBagManager.LEFT);
        l.add((Component)this.createRecentButton(this.mFcConfDir.getBrowseButton()));
        l.addFillX();
        l.popNl();
        l.pushFillXRemainX("Open Files with...");
        this.mFcEditCsv = new AFileChooserControl();
        l.add("CSV editor:").setLabelFor((Component)this.mFcEditCsv);
        l.addNl((Component)this.mFcEditCsv, (GridBagConstraints)GridBagManager.FILLX);
        this.mFcEditCsv.setToolTipText("<html>The command to use for editing CSV files. The file path can be inserted with \"{0}\".<br>Leave blank to use the system default.");
        this.mFcEditCsv.setMinimumSize(this.mFcEditCsv.getPreferredSize());
        this.mFcEditXml = new AFileChooserControl();
        l.add("XML editor:").setLabelFor((Component)this.mFcEditXml);
        l.addNl((Component)this.mFcEditXml, (GridBagConstraints)GridBagManager.FILLX);
        this.mFcEditXml.setToolTipText("<html>The command to use for editing XML files. The file path can be inserted with \"{0}\".<br>Leave blank to use the system default.");
        this.mFcEditXml.setMinimumSize(this.mFcEditXml.getPreferredSize());
        this.mFcWebBrowser = new AFileChooserControl();
        ALinkLabel lblWebBrowser = new ALinkLabel("Web browser:", () -> this.testWebBrowser());
        ((ALinkLabel)l.add((Component)lblWebBrowser)).setLabelFor((Component)this.mFcWebBrowser);
        lblWebBrowser.setToolTipText("Click to test browser");
        l.addNl((Component)this.mFcWebBrowser, (GridBagConstraints)GridBagManager.FILLX);
        this.mFcWebBrowser.setToolTipText("<html>The command to use for opening URLs in a web browser. The URL can be inserted in the command with \"{0}\".<br>Leave blank to use the system default.");
        this.mFcWebBrowser.setMinimumSize(this.mFcWebBrowser.getPreferredSize());
        l.popNl();
        l.pushFillX("Application");
        this.mCbSessionLogs = (JCheckBox)l.add((Component)new JCheckBox("Session-unique log files"), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCbSessionLogs.setToolTipText("<html>If selected, log file names will contain time stamps and will not be overwritten. Otherwise, log files will be overwritten at starup. <i>(Takes effect at next appliction start.)</i>");
        l.newline();
        this.mCbConfirmExit = new JCheckBox("Confirm exit when closing application");
        l.add((Component)this.mCbConfirmExit, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCbConfirmExit.setToolTipText("Should a confirmation prompt be displayed when thethe application is being closed.");
        l.addFillX();
        l.popNl();
        JvmArgumentsPanel.Factory jvmArgsFactory = new JvmArgumentsPanel.Factory();
        this.mJvmArgsPnl = jvmArgsFactory.createPanel();
        l.pushFillX(jvmArgsFactory.getName());
        l.newline();
        l.add(this.mJvmArgsPnl.getComponent(), (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.pop();
        l.addFillY();
        return this.mPanel;
    }

    public void testWebBrowser() {
        String oldSetting = (String)Settings.get((String)ABrowserControl.SettingSection, (String)"BrowserCmd", (Object)"");
        try {
            this.saveWebBrowser(this.mFcWebBrowser.getPath());
            ABrowserControl.displayURL((String)"http://www.cadence.com");
        }
        finally {
            this.saveWebBrowser(oldSetting);
        }
    }

    @Override
    public void load() {
        Settings appSettings = Settings.getSettings((String)"App");
        this.mFcConfDir.setPath((String)appSettings.getSetting("AppConfigDir", (Object)Settings.getConfDir().getPath()));
        this.mFcEditCsv.setPath((String)appSettings.getSetting("EditorCSV", (Object)""));
        this.mFcEditXml.setPath((String)appSettings.getSetting("EditorXML", (Object)""));
        this.mFcWebBrowser.setPath((String)Settings.get((String)ABrowserControl.SettingSection, (String)"BrowserCmd", (Object)""));
        this.mCbSessionLogs.setSelected((Boolean)appSettings.getSetting("SessionUniqueLogFiles", (Object)false));
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        this.mCbConfirmExit.setSelected((Boolean)userPrefs.getSetting("ConfirmAppClose", (Object)true));
        this.mJvmArgsPnl.load();
    }

    @Override
    public boolean save() {
        if (!this.mJvmArgsPnl.save()) {
            return false;
        }
        Settings appSettings = Settings.getSettings((String)"App");
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        String configPath = this.mFcConfDir.getPath();
        if (configPath.isBlank() || AUtil.equals((Object)new File(configPath), (Object)new File(AApp.getInstallDir(), "conf"))) {
            appSettings.removeSetting("AppConfigDir");
        } else {
            appSettings.putSetting("AppConfigDir", (Object)configPath);
            this.mRecentConfs = this.mRecentConfs.stream().filter(f -> new File((String)f).canRead()).collect(Collectors.toCollection(LinkedList::new));
            this.mRecentConfs.remove(configPath);
            this.mRecentConfs.addFirst(configPath);
            while (this.mRecentConfs.size() > 10) {
                this.mRecentConfs.pollLast();
            }
            appSettings.putSetting("AppConfigDirRecent", this.mRecentConfs);
        }
        appSettings.putSetting("EditorCSV", (Object)this.mFcEditCsv.getPath());
        appSettings.putSetting("EditorXML", (Object)this.mFcEditXml.getPath());
        this.saveWebBrowser(this.mFcWebBrowser.getPath());
        appSettings.putSetting("SessionUniqueLogFiles", (Object)this.mCbSessionLogs.isSelected());
        userPrefs.putSetting("ConfirmAppClose", (Object)this.mCbConfirmExit.isSelected());
        appSettings.save();
        userPrefs.save();
        Settings.save((String)ABrowserControl.SettingSection);
        return true;
    }

    public void saveWebBrowser(String browserCmd) {
        if (browserCmd == null || browserCmd.trim().isEmpty()) {
            Settings.remove((String)ABrowserControl.SettingSection, (String)"BrowserCmd", (Settings.Type)Settings.Type.User);
        } else {
            Settings.set((String)ABrowserControl.SettingSection, (String)"BrowserCmd", (Object)browserCmd);
        }
    }

    @Override
    public boolean validateInput() {
        String configPath = this.mFcConfDir.getPath();
        if (!(configPath.isBlank() || new File(configPath).canRead() && new File(configPath).isDirectory())) {
            return false;
        }
        return this.mJvmArgsPnl.validateInput();
    }

    private class ChooseConfigDirAction
    extends AbstractAction {
        private final String mFilePath;

        public ChooseConfigDirAction(String filePath) {
            super(filePath);
            this.mFilePath = filePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneralPanel.this.mFcConfDir.setPath(this.mFilePath);
        }
    }

    public static class Factory
    implements SettingsPanel.Factory {
        @Override
        public String getName() {
            return "General";
        }

        @Override
        public SettingsPanel createPanel() {
            return new GeneralPanel();
        }
    }
}

